<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

        <db:form name="alertsForm" method="post" destination="/console/rac/cluster/racClusterSitemap"
            copyParams="target,type,pageNum">

        <uix:header textBinding="header@racClusterBean@servletRequest"
                    icon="<%= request.getContextPath() + \"/images/database/rac/hostcluster.gif\" %>" >

            <!-- ============== show update time =========== -->
            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                  <%@ include file="../refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:tableLayout>


          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="2">
                <uix:link textBinding="HOME@DBMsgBundle@servletRequest" 
                          destinationBinding="overviewDest@servletRequest"/>
                <oem:license>
                <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"
                          destinationBinding="performDest@servletRequest"/>
                </oem:license>
                <uix:link textBinding="TARGETS_TAB@racMsgBundle@servletRequest"/>
						    <uix:link textBinding="ADMINISTRATION@racMsgBundle@servletRequest"
                          destinationBinding="adminDest@servletRequest" />
                <oem:license>
                <uix:link textBinding="IC_INTERCONNECTS@racMsgBundle@servletRequest"
                          destinationBinding="interconnsDest@servletRequest"
                          renderedBinding="agentVersion10104OrHiger@racClusterBean@servletRequest"/>  
                </oem:license>
                <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                          destinationBinding="topologyDest@servletRequest"/>  
              </uix:subTabBar>
            </uix:subTabs>

              <oem:table name="racClusterTargetsDataSource" width="100%"  
                         summaryBinding="TARGETS_TAB@racMsgBundle@servletRequest"
                         partialRenderMode="self"
                         formSubmitted="true"                           
                         beanKey="racClusterBean"                           
                         dataSourceProp="racClusterTargetsDataSource"
                         blockSize="25"                           
                         alternateText="No targets found.">
              </oem:table>            

            <uix:tip textBinding="MASTER_HOST_TIP@racMsgBundle@servletRequest"/>
            <uix:tip textBinding="DELETED_TARGET_TIP@racMsgBundle@servletRequest"/>
          </uix:subTabLayout>
          <uix:spacer height="5"/>

        </uix:header>

          <%@ include file="comp.jspf" %>
            <oem:relatedLinks/> 

        </db:form>
      </uix:pageLayout>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 

