<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
                            
<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/>   

  <uix:switcher childNameBinding="manualSelected@servletRequest">
    <uix:case name="false">
      <uix:rawText>
        <meta http-equiv="Refresh" 
              content="<%=request.getAttribute("refreshChoice")%>; URL=<%=request.getAttribute("ClusterTopoRefreshURL") %>" >
        </uix:rawText>
      </uix:case>
    </uix:switcher>

  <uix:document> 

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>

      <%@ include file="/oemGlobal.jspf" %>

        <db:form name="topoForm" method="post" destination="/console/rac/cluster/racClusterSitemap"
                   copyParams="target,type">
          <uix:formValue name="pageNum" value="5" />

        <uix:header textBinding="header@racClusterBean@servletRequest"
                    icon="<%= request.getContextPath() + \"/images/database/rac/hostcluster.gif\" %>" >

            <!-- ============== show update time =========== -->
            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                  <%@ include file="../refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:tableLayout>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="5">
                <uix:link textBinding="HOME@DBMsgBundle@servletRequest"
                          destinationBinding="overviewDest@servletRequest"/>
                <oem:license>
                <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"
                          destinationBinding="performDest@servletRequest"/>
                </oem:license>
                <uix:link textBinding="TARGETS_TAB@racMsgBundle@servletRequest"
                          destinationBinding="targetsDest@servletRequest"/>
						    <uix:link textBinding="ADMINISTRATION@racMsgBundle@servletRequest"
                          destinationBinding="adminDest@servletRequest" />

                <oem:license>
                <uix:link textBinding="IC_INTERCONNECTS@racMsgBundle@servletRequest"
                          destinationBinding="interconnsDest@servletRequest"
                          renderedBinding="agentVersion10104OrHiger@racClusterBean@servletRequest"/>  
                </oem:license>
                <uix:link textBinding="TOPOLOGY@racMsgBundle@servletRequest"/>
              </uix:subTabBar>
            </uix:subTabs>

            <jsp:include page="cluster_topo.jsp" /> 
            <uix:ref refID="clusterTopo" />        
            
          </uix:subTabLayout>
        </uix:header>

      <uix:rawText>
          <a name="instances">
       </uix:rawText>

          <%@ include file="comp.jspf" %>
            <oem:relatedLinks/> 

        </db:form>
      </uix:pageLayout>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 

