<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>     
    
    <uix:body>
    <db:form name="confirmForm"  method="post" destination="configHost" copyParams="target,type">
      
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
  
          <uix:header messageType="confirmation" textBinding="CONFIRMATION@sdkUIBundle">
            <uix:stackLayout>
              <uix:rowLayout>
                <uix:spacer width="10"/>
                
                <uix:styledText styleClass="OraDataText" 
                                textBinding="questionText@servletRequest" /> 
              </uix:rowLayout>     
              <uix:spacer height="5"/>             
              <uix:switcher childNameBinding="postQuestionText@servletRequest">
                <uix:case name="" >
                </uix:case>
                
                <uix:default>
                  <uix:rowLayout> 
                    <uix:spacer width="10"/>
                    <uix:cellFormat hAlign="left">
                    <uix:formattedText styleClass="OraInstructionText"
                                    textBinding="postQuestionText@servletRequest" />
                     </uix:cellFormat>               
                  </uix:rowLayout>                     
                </uix:default>                  
              </uix:switcher>
            </uix:stackLayout>    
          </uix:header>
  
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="NO@sdkUIBundle"
                                name="event"
                                value="confirmationNo"/>
              <uix:submitButton textBinding="YES@sdkUIBundle" 
                                name="event"
                                value="confirmationYes"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
  
      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
