<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"> 
<oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 
    
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
       <db:form name="credentials" method="POST" destinationBinding="credsDest@servletRequest" copyParams="target,type">  

        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>
          
          <uix:switcher childNameBinding="messageType@servletRequest">
            <uix:case name="error">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
          </uix:switcher>
          
		  
          <uix:stackLayout>
        	<uix:contents>

              <uix:header textBinding="credsPageHeader@servletRequest">

	      <uix:tableLayout width="100%">
	      <uix:rowLayout>
	        <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraInstructionText" textBinding="credsPageDesc@servletRequest" />
	        </uix:cellFormat>

		  
		  </uix:rowLayout>
	      </uix:tableLayout>

                <uix:header textBinding="specifyClusterCredentials@servletRequest" >
                  <uix:styledText styleClass="OraInstructionText" textBinding="specifyClusterCredentialsDesc@servletRequest" />   
                  <uix:spacer height="8"/>

		  <!-- Use preferred credentials -->
                  <uix:switcher childNameBinding="needDBCredentials@servletRequest">
	          <uix:case name="true">
                    <%@ include file="/dbhostcreds.jspf" %>	
                  </uix:case>
	          <uix:case name="false">
                    <%@ include file="/credentials.jspf" %>	
                  </uix:case>
                  </uix:switcher>
  
                </uix:header>

                <uix:switcher childNameBinding="needDBCredentials@servletRequest">
	        <uix:case name="true">
                  <uix:header textBinding="SPECIFY_DATABASE_CREDENTIALS@racCommonMsgBundle@servletRequest" >

                    <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_SYSDBA_CREDENTIALS_DESC@racCommonMsgBundle@servletRequest" />   
                    <%@ include file="/credentials.jspf" %>	                    
                  </uix:header>
                </uix:case>
                </uix:switcher>

                <!-- link to single instance startup/shutdown -->
		<uix:switcher childNameBinding="showSingleInstURL@servletRequest">
		<uix:case name="true">
		  <uix:flowLayout>
    		    <uix:spacer height="10"/>
		    <uix:tip>
		     <uix:styledText styleClass="OraInstructionText" textBinding="SINGLE_INST_STARTSHUT_TEXT@racCommonMsgBundle@servletRequest" />
		    </uix:tip>
		    <uix:link textBinding="SINGLE_INST_STARTSHUT_LINK@racCommonMsgBundle@servletRequest" destinationBinding="singleInstURL@servletRequest" styleClass="OraInstructionText"/>  
         	   </uix:flowLayout>
		</uix:case>
	        </uix:switcher>

              </uix:header>
            </uix:contents>              
          </uix:stackLayout> 

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL_BUTTON@racCommonMsgBundle@servletRequest" shortDescBinding="CANCEL_BUTTON@racCommonMsgBundle@servletRequest" name="event" valueBinding="credsCancelEvent@servletRequest" />
                <uix:submitButton textBinding="CONTINUE_BUTTON@racCommonMsgBundle@servletRequest" shortDescBinding="CONTINUE_BUTTON@racCommonMsgBundle@servletRequest"   name="event" valueBinding="credsOKEvent@servletRequest" /> 
			 </uix:pageButtonBar>
          </uix:pageButtons>
		  
		
        </uix:pageLayout>  
      </db:form>

    </uix:body>
  </uix:document> 
</uix:renderingContext> 
