<%-- 
 * Copyright (c) 2006, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *        customizeDetails.jsp 
 *
 *      NOTES
 *        tbd
 *       
 * MODIFIED
 *    kmckeen    02/23/07 - Additional copyparams
 *    kmckeen    01/17/07 - Let user customize top n value
 *    kmckeen    12/28/06 - UI review - remove Prev/Next table navigation info
 *    kmckeen    12/21/06 - Comments from UI review
 *    rsamaved   12/18/06 - onClick radio event for cluster
 *    pboopath   12/11/06 - 
 *    kmckeen    12/04/06 - Fix various ui issues - move instruction text, remove header
 *    kmckeen    11/30/06 - Fix oac/ui issues
 *    kmckeen    04/25/06 - Initialize creation of module.
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rac.RacConstants" %>
<%@ page import="oracle.sysman.db.rac.util.RacCustomization" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>

        <db:form
            name="customizeDetails"
            method="post"
            destinationBinding="customizeDetailsController@servletRequest"
            copyParams="target,type,instNum,drillDown,wait,waitEvent,waitClass,throughPut,ioMetric,ioRateType,refreshChoice">

          <uix:formValue
              name="pageName"
              value="/rac/customizeDetails"/>

          <uix:pageLayout titleBinding="CUSTOMIZE_HEADER@racMsgBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:messages>
              <uix:switcher childNameBinding="showWarning@servletRequest">
                <uix:case name="true">
                  <oem:messageBox
                      messageTypeBinding="messageType@servletRequest"
                      errorTableBinding="msgBox@servletRequest"
                      destTableBinding="msgUrls@servletRequest"
                      titleTextKey="titleText"
                      mainTextKey="mainText"/>
                </uix:case>
              </uix:switcher>
            </uix:messages>

            <uix:pageStatus>
              <uix:switcher childNameBinding="chartType@servletRequest">
                <uix:case name="topChart">
                </uix:case>
                <uix:case name="tileChart">
              <uix:styledText
                  styleClass="OraInstructionText"
                      textBinding="tileChartCustomizeTip@servletRequest"/>
                </uix:case>
              </uix:switcher>
            </uix:pageStatus>

            <uix:switcher childNameBinding="chartType@servletRequest">

              <uix:case name="topChart">
                <uix:stackLayout>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:radioButton
                          name="topChartSelectionOption"
                          value="<%= RacCustomization.SELECTION_AUTOMATIC %>"
                          selectedValueBinding="topChartSelectionOption@servletRequest"
                          textBinding="topChartNumItemsMsg@servletRequest"/>
                      <uix:spacer width="10"/>
                      <uix:textInput
                          id="topChartNumItemsInChart"
                          name="topChartNumItemsInChart"
                          textBinding="topChartNumItemsInChart@servletRequest"
                          shortDescBinding="VALUE@DBMsgBundle@servletRequest"
                          columns="3">
                        <uix:onSubmitValidater>
                          <uix:decimal/>
                        </uix:onSubmitValidater>
                      </uix:textInput>
                    </uix:flowLayout>
                    <uix:rowLayout renderedBinding="topChartNumItemsTipRender@servletRequest">
                      <uix:spacer width="20"/>
                      <uix:styledText
                          textBinding="topChartNumItemsTip@servletRequest"
                          styleClass="OraInlineInfoText"/>
                    </uix:rowLayout>
                  </uix:stackLayout>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:radioButton
                          name="topChartSelectionOption"
                          value="<%= RacCustomization.SELECTION_MANUAL %>"
                          selectedValueBinding="topChartSelectionOption@servletRequest"
                          textBinding="topChartSelItemsMsg@servletRequest"/>
                    </uix:flowLayout>
                    <uix:rowLayout renderedBinding="topChartSelectTipRender@servletRequest">
                      <uix:spacer width="20"/>
                      <uix:styledText
                          textBinding="topChartSelectTip@servletRequest"
                          styleClass="OraInlineInfoText"/>
                    </uix:rowLayout>
                  </uix:stackLayout>
                  <uix:stackLayout>
                    <uix:tableLayout width="100%">
                      <uix:rowLayout>
                        <oem:table
                            name="racTopChartInstsDSWork"
                            width="100%"
                            beanKey="customizeDetailsBean"
                            dataSourceProp="racTopChartInstsDSWork"
                            partialRenderMode="self"
                            id="racTopChartInstsTableWork"
                            formSubmitted="true"
                            blockSize="<%= RacConstants.BLOCKSIZE_UNLIMITED %>"
                            summaryBinding="CHART_CONTENTS@racMsgBundle@servletRequest"
                            alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest">
                          <uix:tableSelection>
                            <uix:multipleSelection 
                                shortDescBinding="TOP_CHART_CSTMZ_TIP@racMsgBundle@servletRequest"
                                selectedBinding="selected"
                                selectionBinding="topChartSelectionWork@customizeDetailsBean@servletRequest">
                            </uix:multipleSelection>
                          </uix:tableSelection>
                        </oem:table>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:stackLayout>
                </uix:stackLayout>
              </uix:case>

<%--
<uix:styledText 
styleClass="OraInstructionText"
text="The Number Of Instances In Summary Charts value is the number of instances displayed in each summary chart. Instances are chosen for each chart based on the chart's metric, from highest to lowest."/>
--%>

              <uix:case name="tileChart">
                <uix:stackLayout>
                  <%--
                  <uix:header
                      textBinding="CHART_LAYOUT@racMsgBundle@servletRequest">
                  --%>
                    <uix:tableLayout>
                      <uix:rowLayout>
                        <uix:labeledFieldLayout labelWidth="25%">
                          <uix:messageTextInput
                              id="tileChartNumChartsPerRow"
                              name="tileChartNumChartsPerRow"
                              textBinding="tileChartNumChartsPerRow@servletRequest"
                              columns="3"
                              promptBinding="NUM_CHARTS_PER_ROW@racMsgBundle@servletRequest"
                              message=""
                              messageType="">
                            <uix:onSubmitValidater>
                              <uix:decimal/>
                            </uix:onSubmitValidater>
                            <%--
                            <uix:end>
                              <uix:flowLayout>
                              <uix:spacer width="20"/>
                              <uix:styledText 
                                  styleClass="OraPromptText"
                                  textBinding="MAX_NUMBER_CHARTS@racMsgBundle@servletRequest"/>
                              <uix:textInput
                                  id="tileChartMaxNumCharts"
                                  name="tileChartMaxNumCharts"
                                  textBinding="tileChartMaxNumCharts@servletRequest"
                                  columns="3">
                                <uix:onSubmitValidater>
                                  <uix:decimal/>
                                </uix:onSubmitValidater>
                              </uix:textInput>
                              </uix:flowLayout>
                            </uix:end>
                            --%>
                          </uix:messageTextInput>
                          <uix:switcher childNameBinding="targetType@customizeDetailsBean@servletRequest">
                            <uix:case name="rac_database">
                          <uix:messageRadioSet
                              promptBinding="TILE_CHART_ORDER_LABEL@racMsgBundle@servletRequest">
                            <uix:radioButton
                                name="tileChartOrderOption"
                                value="orderByAverageValue"
                                selectedValueBinding="tileChartOrderOption@servletRequest"
                                textBinding="TILE_CHART_ORDER_BY_AVERAGE_VALUE@racMsgBundle@servletRequest"
                                onClick="submitForm('customizeDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderByAverageValue'})"/>
                            <uix:radioButton
                                name="tileChartOrderOption"
                                value="orderByMaximumValue"
                                selectedValueBinding="tileChartOrderOption@servletRequest"
                                textBinding="TILE_CHART_ORDER_BY_MAXIMUM_VALUE@racMsgBundle@servletRequest"
                                onClick="submitForm('customizeDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderByMaximumValue'})"/>
                            <uix:radioButton
                                name="tileChartOrderOption"
                                value="orderByInstanceName"
                                selectedValueBinding="tileChartOrderOption@servletRequest"
                                textBinding="tileChartOrderByNameText@servletRequest"
                                onClick="submitForm('customizeDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderByInstanceName'})"/>
                            <uix:radioButton
                                name="tileChartOrderOption"
                                value="orderUsingTable"
                                selectedValueBinding="tileChartOrderOption@servletRequest"
                                textBinding="TILE_CHART_ORDER_USING_TABLE@racMsgBundle@servletRequest"
                                onClick="submitForm('customizeDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderUsingTable'})"/>
                          </uix:messageRadioSet>
                            </uix:case>
                            <uix:case name="cluster">
                          <uix:messageRadioSet
                              promptBinding="TILE_CHART_ORDER_LABEL@racMsgBundle@servletRequest">
                            <uix:radioButton
                                name="tileChartOrderOption"
                                value="orderByAverageValue"
                                selectedValueBinding="tileChartOrderOption@servletRequest"
                                textBinding="TILE_CHART_ORDER_BY_AVGHALF_VALUE@racMsgBundle@servletRequest"
                                onClick="submitForm('customizeDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderByAverageValue'})"/>
                            <uix:radioButton
                                name="tileChartOrderOption"
                                value="orderByMaximumValue"
                                selectedValueBinding="tileChartOrderOption@servletRequest"
                                textBinding="TILE_CHART_ORDER_BY_MAXHALF_VALUE@racMsgBundle@servletRequest"
                                onClick="submitForm('customizeDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderByMaximumValue'})"/>
                            <uix:radioButton
                                name="tileChartOrderOption"
                                value="orderByInstanceName"
                                selectedValueBinding="tileChartOrderOption@servletRequest"
                                textBinding="tileChartOrderByNameText@servletRequest"
                                onClick="submitForm('customizeDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderByInstanceName'})"/>
                            <uix:radioButton
                                name="tileChartOrderOption"
                                value="orderUsingTable"
                                selectedValueBinding="tileChartOrderOption@servletRequest"
                                textBinding="TILE_CHART_ORDER_USING_TABLE@racMsgBundle@servletRequest"
                                onClick="submitForm('customizeDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderUsingTable'})"/>
                          </uix:messageRadioSet>
                            </uix:case>
                          </uix:switcher>
                        </uix:labeledFieldLayout>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  <%--
                  </uix:header>
                  --%>
                  <uix:header textBinding="CHART_CONTENTS@racMsgBundle@servletRequest">
                    <uix:tableLayout width="100%">
                      <uix:rowLayout>
                        <uix:switcher childNameBinding ="tileChartOrderOption@servletRequest" defaultCase="defCase">

                        <uix:case name="orderUsingTable">		
                        <oem:table
                            name="racTileChartInstsDSWork"
                            width="100%"
                            beanKey="customizeDetailsBean"
                            dataSourceProp="racTileChartInstsDSWork"
                            partialRenderMode="self"
                            id="racTileChartInstsTableWork"
                            formSubmitted="true"
                            blockSize="<%= RacConstants.BLOCKSIZE_UNLIMITED %>"
                            summaryBinding="CHART_CONTENTS@racMsgBundle@servletRequest"
                            alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest">
                          <uix:tableSelection>
                            <uix:multipleSelection 
                                shortDescBinding="tileChartCustomizeTip@servletRequest"
                                selectedBinding="selected"
                                selectionBinding="tileChartSelectionWork@customizeDetailsBean@servletRequest">
                            </uix:multipleSelection>
                          </uix:tableSelection>
                        </oem:table>
                        </uix:case>

                        <uix:case name="defCase">
                        <oem:table
                            name="racTileChartInstsDSWorkWoMove"
                            width="100%"
                            beanKey="customizeDetailsBean"
                            dataSourceProp="racTileChartInstsDSWorkWoMove"
                            partialRenderMode="self"
                            id="racTileChartInstsTableWorkWoMove"
                            formSubmitted="true"
                            blockSize="<%= RacConstants.BLOCKSIZE_UNLIMITED %>"
                            summaryBinding="CHART_CONTENTS@racMsgBundle@servletRequest"
                            alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest">
                          <uix:tableSelection>
                            <uix:multipleSelection 
                                shortDescBinding="tileChartCustomizeTip@servletRequest"
                                selectedBinding="selected"
                                selectionBinding="tileChartSelectionWorkWoMove@customizeDetailsBean@servletRequest">
                            </uix:multipleSelection>
                          </uix:tableSelection>
                        </oem:table>
                      </uix:case>

                      </uix:switcher>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:header>
                </uix:stackLayout>
              </uix:case>

            </uix:switcher>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancelCustomizeDetails"
                    textBinding="CANCEL@DBMsgBundle@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="updateCustomizeDetails"
                    textBinding="OK@DBMsgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
