<%-- 
 * Copyright (c) 2008, 2009, Oracle and/or its affiliates. 
 * All rights reserved. 
 *
 *      NAME
 *        customizeHistDetails.jsp 
 *
 *      NOTES
 *        tbd
 *       
 * MODIFIED
 *    kmckeen    03/19/08 - Initialize creation of module.
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rac.RacConstants" %>
<%@ page import="oracle.sysman.db.rac.util.RacCustomization" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>

        <db:form
            name="customizeHistDetails"
            method="post"
            destinationBinding="customizeHistDetailsController@servletRequest"
            copyParams="target,type,instNum,drillDown,wait,waitEvent,waitClass,
            throughPut,ioMetric,ioRateType,refreshChoice,customizeDetailsMetric,startLong,endLong">

          <uix:formValue
              name="pageName"
              value="/rac/customizeHistDetails"/>
          <uix:formValue
              name="refreshChoice"
              valueBinding="refreshChoice@servletRequest"/>

          <uix:pageLayout titleBinding="CUSTOMIZE_HEADER@racMsgBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

<%-- for debugging
<uix:messageStyledText styleClass="OraInstructionText" prompt="instds:" textBinding="instancesDSClone@racHistDetailsBean@servletRequest"/>
--%>

            <uix:messages>
              <uix:switcher childNameBinding="showWarning@servletRequest">
                <uix:case name="true">
                  <oem:messageBox
                      messageTypeBinding="messageType@servletRequest"
                      errorTableBinding="msgBox@servletRequest"
                      destTableBinding="msgUrls@servletRequest"
                      titleTextKey="titleText"
                      mainTextKey="mainText"/>
                </uix:case>
              </uix:switcher>
            </uix:messages>

            <uix:pageStatus>
              <uix:switcher childNameBinding="chartType@servletRequest">
                <uix:case name="topChart">
         
                </uix:case>
                
                <uix:case name="tileChart">
                  <uix:styledText
                        styleClass="OraInstructionText"
                      textBinding="tileChartCustomizeTip@servletRequest"
                   />   
                </uix:case>
                
              </uix:switcher>
            </uix:pageStatus>

            <uix:stackLayout>
            <uix:switcher childNameBinding="chartType@servletRequest">
              <uix:case name="topChart">
                <uix:stackLayout>
                  <uix:stackLayout>
                    <uix:flowLayout>
                    <uix:radioButton
                          name="topChartSelectionOption"
                          value="<%= RacCustomization.SELECTION_AUTOMATIC %>"
                          selectedValueBinding="topChartSelectionOption@servletRequest"
                          textBinding="topChartNumItemsMsg@servletRequest"/>
                     <uix:spacer width="10"/>
                      
                    <uix:textInput
                        id="topChartNumItemsInChart"
                        name="topChartNumItemsInChart"
                        textBinding="topChartNumItemsInChart@servletRequest"
                        shortDescBinding="VALUE@DBMsgBundle@servletRequest"
                        columns="3"
                      >
                      <uix:onSubmitValidater>
                        <uix:decimal/>
                      </uix:onSubmitValidater>
                    </uix:textInput>
                    </uix:flowLayout>
                    <uix:rowLayout renderedBinding="topChartNumItemsTipRender@servletRequest">
                      <uix:spacer width="20"/>
                      <uix:styledText
                          textBinding="topChartNumItemsTip@servletRequest"
                          styleClass="OraInlineInfoText"/>
                    </uix:rowLayout>                    
                    <uix:flowLayout>
                      <uix:radioButton
                          name="topChartSelectionOption"
                          value="<%= RacCustomization.SELECTION_MANUAL %>"
                          selectedValueBinding="topChartSelectionOption@servletRequest"
                          textBinding="topChartSelItemsMsg@servletRequest"/>
                    </uix:flowLayout>
                  </uix:stackLayout>
                </uix:stackLayout>
              </uix:case>
              <uix:case name="tileChart">
                <uix:stackLayout>
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:labeledFieldLayout labelWidth="25%">
                        <uix:messageTextInput
                            id="tileChartNumChartsPerRow"
                            name="tileChartNumChartsPerRow"
                            textBinding="tileChartNumChartsPerRow@servletRequest"
                            columns="3"
                            promptBinding="NUM_CHARTS_PER_ROW@racMsgBundle@servletRequest"
                            message=""
                            messageType="">
                          <uix:onSubmitValidater>
                            <uix:decimal/>
                          </uix:onSubmitValidater>
                        </uix:messageTextInput>
                        <uix:messageRadioSet
                            promptBinding="TILE_CHART_ORDER_LABEL@racMsgBundle@servletRequest">
                          <uix:radioButton
                              name="tileChartOrderOption"
                              value="orderByAverageValue"
                              selectedValueBinding="tileChartOrderOption@servletRequest"
                              textBinding="HIST_AVG_VALUE@racMsgBundle@servletRequest"
                              onClick="submitForm('customizeHistDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderByAverageValue'})"/>
                          <uix:radioButton
                              name="tileChartOrderOption"
                              value="orderByMaximumValue"
                              selectedValueBinding="tileChartOrderOption@servletRequest"
                              textBinding="HIST_MAX_VALUE@racMsgBundle@servletRequest"
                              onClick="submitForm('customizeHistDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderByMaximumValue'})"/>
                          <uix:radioButton
                              name="tileChartOrderOption"
                              value="orderByInstanceName"
                              selectedValueBinding="tileChartOrderOption@servletRequest"
                              textBinding="tileChartOrderByNameText@servletRequest"
                              onClick="submitForm('customizeHistDetails',true,{'event':'switchChartOrderMechanism','custChartOrder':'orderByInstanceName'})"/>
                        </uix:messageRadioSet>
                      </uix:labeledFieldLayout>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:stackLayout>
              </uix:case>
            </uix:switcher>

            <uix:stackLayout>
            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="left"> 
                  <oem:table
                    id="instancesTableClone"
                    name="instancesDSClone"
                    beanKey="racHistDetailsBean"
                    dataSourceProp="instancesDSClone"
                    width="100%"
                    partialRenderMode="self"
                    formSubmitted="true"
                    blockSize="<%= RacConstants.BLOCKSIZE_UNLIMITED %>"
                    summaryBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest"
                    alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest">
                  <uix:tableSelection>
                    <uix:multipleSelection 
                        shortDescBinding="TILE_CHART_CSTMZ_TIP_INSTANCES@racMsgBundle@servletRequest"
                        selectedBinding="selected"
                        selectionBinding="selTableInstance@racHistDetailsBean@servletRequest">
                    </uix:multipleSelection>
                  </uix:tableSelection>  
                  </oem:table>
                
              </uix:rowLayout>
            </uix:tableLayout>
            </uix:stackLayout>
            </uix:stackLayout>
            
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancelCustomizeDetails"
                    textBinding="CANCEL@DBMsgBundle@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="updateCustomizeDetails"
                    textBinding="OK@DBMsgBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
