<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="racMsgBundle" class="oracle.sysman.db.rsc.rac.RacCommonMsg"/>
      
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>      
    <uix:body>  
     <db:form name="dbsrvpoolchange" method="POST" destination="racDBServerPools" copyParams="target,type,returnUrl">

     <uix:pageLayout>
      <%@ include file="/oemGlobal.jspf" %>     

      <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                      errorTableBinding="msgBox@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:header textBinding="CHANGE_DATABASE_SRVPOOL_HEADER@racMsgBundle">        
       <uix:stackLayout>
       <uix:spacer height="5"/>
        <uix:tableLayout>
         <uix:rowLayout>
          <uix:cellFormat>
           <uix:messagePrompt promptBinding="DATABASE_NAME@racMsgBundle"/>
          </uix:cellFormat>     
          <uix:cellFormat/>
          <uix:spacer width="5"/>        
          <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"  textBinding="databaseName@SRVPOOLSBEAN@servletRequest"/>
          </uix:cellFormat>     
         </uix:rowLayout> 
        </uix:tableLayout>
        
        <uix:spacer height="10"/>
          
       <uix:tableLayout cellSpacing="5">
       <uix:rowLayout>
     
         <uix:cellFormat columnSpan="2" hAlign="left">
            <uix:styledText styleClass="OraFieldText" 
                    textBinding="SEL_SRV_POOLS_MSG@racMsgBundle"/>
         </uix:cellFormat>
       </uix:rowLayout>

       <uix:rowLayout> 
       <uix:cellFormat columnSpan="2">
        <oem:shuttle name="srvPoolList" reorderable="false"
            leadingHeaderBinding="AVAIL_SRV_POOLS@racMsgBundle"
            trailingHeaderBinding="SEL_SRV_POOLS@racMsgBundle">
            <uix:leading>
                <oem:list name="notMatter" optionsBinding="leftSrvPools@SRVPOOLSBEAN@servletRequest"
                        shortDescBinding="AVAIL_SRV_POOLS@racMsgBundle"/>
            </uix:leading>
            <uix:trailing> 
                <oem:list name="notMatterToo" optionsBinding="databaseSrvPools@SRVPOOLSBEAN@servletRequest"
                        shortDescBinding="SEL_SRV_POOLS@racMsgBundle"/>
            </uix:trailing>
        </oem:shuttle>
       </uix:cellFormat>
       </uix:rowLayout>
                 
       </uix:tableLayout>
        
       </uix:stackLayout>
      </uix:header>
     
      <uix:pageButtons>
       <uix:pageButtonBar>
        <uix:submitButton textBinding="CANCEL_BUTTON@racMsgBundle" name="event" value="cancel"/>
        <uix:submitButton textBinding="OK_BUTTON@racMsgBundle" name="event" value="apply"/>
       </uix:pageButtonBar>
      </uix:pageButtons>
    </uix:pageLayout>
    </db:form>
  </uix:body>      
  </uix:document> 
</uix:renderingContext> 
