<%-- 
 * Copyright (c) 2007, 2008, Oracle. All rights reserved.  
 *
 *      NAME
 *        histDetails.jsp 
 *
 *      NOTES
 *       
 * MODIFIED
 *    gapadman   05/14/08 - 
 *    gapadman   05/13/08 - 
 *    pboopath   05/05/08 - swf path change from database/flex to rac/flex
 *    gapadman   04/16/08 - remove viewchoice
 *    pboopath   04/09/08 - Flex tilechart changes
 *    pboopath   03/20/08 - Flex changes
 *    kmckeen    03/19/08 - Implement Customize button
 *    pboopath   03/18/08 - Flex conversion
 *    kmckeen    02/18/08 - Implement historical tile chart
 *    kmckeen    01/27/08 - legendVisible external so page does not indent
 *    kmckeen    01/15/08 - Update chart colors, use render instead of switcher
 *    kmckeen    12/10/07 - Support breadcrumbs
 *    kmckeen    08/03/07 - Initial creation
--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.rac.RacConstants" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <db:form 
          name="histDetails" 
          method="post" 
          destination="/console/rac/racHistDetails"
          copyParams="target,type,instNum,drillDown,wait,waitEvent,waitClass,throughPut,rateType,ioMetric,ioRateType,pq,refreshChoice,service,module,action,client,pageNum,pageKey,startLong,endLong">

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>

          <uix:header textBinding="detailsTitle@servletRequest">

<%-- ---------------------------------------------------------------------- --%>
<%-- Metric options on the left, View Data options on the right. --%>

<uix:tableLayout width="100%">
  <uix:rowLayout hAlign="left"> 
    <uix:cellFormat
        hAlign="left" vAlign="top" wrappingDisabled="true"
        renderedBinding="renderDetailsMetricsDropdown@servletRequest">
      <uix:rowLayout>
        <uix:messageChoice
            promptBinding="detailsMetricsLabel@servletRequest"
            name="detailsMetric"
            id="detailsMetric"
            shortDescBinding="detailsMetricsLabel@servletRequest"
            selectedValueBinding="detailsMetric@servletRequest"
            onChange="submitForm(document.forms[0], true, {'event':'switchDetailsMetric'})">
          <uix:contents
              childDataBinding="detailsMetrics@servletRequest">
            <uix:option 
                textBinding="text"
                valueBinding="value"/>
          </uix:contents>
        </uix:messageChoice>
      </uix:rowLayout>
    </uix:cellFormat>
    <uix:cellFormat 
        hAlign="right" vAlign="top" wrappingDisabled="true">
      <uix:rowLayout>
        <uix:messageChoice
            promptBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
            name="refreshOption" 
            id="refreshOption"
            shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
            selectedValueBinding="refreshChoiceSelected@servletRequest" 
            onChange="submitForm(document.forms[0], true, {'event':'switchRefreshOption'})">
          <uix:option 
              textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
              value="RT_15"/>
          <uix:option 
              textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest"
              value="RT_60"/> 
          <uix:option 
              textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
              value="RT_MAN"/>
          <uix:option 
              textBinding="HISTORICAL@DBMsgBundle@servletRequest"
              value="HIST_CUST" 
              selected="true"/>
        </uix:messageChoice>
      </uix:rowLayout>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>

<%-- ---------------------------------------------------------------------- --%>
<%-- Summary Chart/Tile Chart radio buttons on the left.  --%>
<%-- Customize button on the right.                       --%>

<uix:tableLayout width="100%">
  <uix:rowLayout>
    <uix:spacer height="5"/>
  </uix:rowLayout>
  <uix:rowLayout>
    <uix:cellFormat 
        hAlign="left" vAlign="top" wrappingDisabled="true"
        renderedBinding="renderChartTypeRadioButtons@servletRequest">
      <uix:flowLayout>
        <uix:radioSet>
          <uix:radioButton
              name="chartType"
              value="topChart"
              selectedValueBinding="chartType@servletRequest"
              textBinding="TOP_CHART_VIEW@racMsgBundle@servletRequest"
              onClick="submitForm(document.forms[0], true, {'event':'doLoad', 'chartType':'topChart'})"/>
          <uix:radioButton
              name="chartType"
              value="tileChart"
              selectedValueBinding="chartType@servletRequest"
              textBinding="TILE_CHART_VIEW@racMsgBundle@servletRequest"
              onClick="submitForm(document.forms[0], true, {'event':'switchChartType', 'chartType':'tileChart'})"/>
        </uix:radioSet>
      </uix:flowLayout>
    </uix:cellFormat>
    <uix:cellFormat 
        hAlign="right" vAlign="top" wrappingDisabled="true"
        renderedBinding="renderCustomizeButton@servletRequest">
      <uix:flowLayout>
        <uix:submitButton 
            textBinding="CUSTOMIZE_BUTTON@racMsgBundle@servletRequest"
            name="event" 
            value="customizeDetails"/>
      </uix:flowLayout>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>

<%-- -------------------------------------------------- --%>
<%-- Instance breakdown page - 1 chart. --%>
     <uix:tableLayout width="100%" renderedBinding="renderGenericPage@servletRequest"> 
      <uix:rowLayout hAlign="left">
        <uix:switcher childNameBinding="chartType@servletRequest">
          <uix:case name="tileChart">
          <uix:switcher childNameBinding="useSVG@servletRequest">
            <uix:case name="true">
            <db:flexRegion
                            swfName="/rac/flex/racHistDetailsTileChart.swf"
                            dataSrcKeyBinding="flexKey@racHistDetailsBean@servletRequest"
                            optionsBinding="flexRacHisDetailsOptions@servletRequest"
                            windowHeightBinding="flexWindowHeightForTileChart@racHistDetailsBean@servletRequest"
                            windowWidth="100%"
                            idBase="flexRacHistDetailsTileChart"/>
            </uix:case>
            <uix:case name="false">
            <%@ include file="tileChart.jspf" %>
            </uix:case>
            </uix:switcher>
          </uix:case>
          <uix:case name="topChart">
           <uix:switcher childNameBinding="useSVG@servletRequest">
            <uix:case name="true">
               <db:flexRegion
                            swfName="/rac/flex/racHistDetails.swf"
                            dataSrcKeyBinding="flexKey@racHistDetailsBean@servletRequest"
                            optionsBinding="flexRacHisDetailsOptions@servletRequest"
                            windowHeight="150"
                            windowWidth="100%"
                            idBase="flexRacHistDetailsChart"/>
            </uix:case>
            <uix:case name="false">
            <oem:chart
                chartType="timeSeriesChart"
                width="750" 
                height="225"
                timeGranularity="SECOND"
                fill="cumulative"  
                orientation="vertical"
                legendPosition="east" 
                legendVisible="external"
                titleBinding="chartHeader@servletRequest"
                titleVisible="false"                       
                yAxisLabelBinding="yAxisLabel@servletRequest" 
                yAxisWidth="40"
                format="svg"
                seriesColorsAutomatic="true"
                colorPaletteBinding="waitsColor@racHistDetailsBean@servletRequest"
                svgHighlightLegend="true"
                noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
                >   
              <uix:contents>
                <oem:boundChartDataSource chartDataSourceBinding="chartDataSource@servletRequest"/>
                <oem:imageMap imageMapDataSourceBinding="chartImageMap@servletRequest"/>
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>
              </uix:contents>
            </oem:chart>
            </uix:case>
            </uix:switcher>
          </uix:case>
        </uix:switcher>
      </uix:rowLayout>
      <uix:rowLayout hAlign="left" renderedBinding="renderInstancesTable@servletRequest"> 
        <uix:header textBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest">
          <oem:table
            id="instancesTable"
            name="instancesDS"
            beanKey="racHistDetailsBean"
            dataSourceProp="instancesDS"
            width="100%"
            partialRenderMode="self"
            formSubmitted="true"
            blockSize="<%= RacConstants.BLOCKSIZE_UNLIMITED %>"
            summaryBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest"
            alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest"/>
        </uix:header>
      </uix:rowLayout>
    </uix:tableLayout>

<%-- -------------------------------------------------- --%>
<%-- CCC page - 3 charts. --%>

    <uix:tableLayout width="100%" renderedBinding="renderCCCPage@servletRequest"> 
      <uix:switcher childNameBinding="useSVG@servletRequest">
       <uix:case name="true">
               <db:flexRegion
                    swfName="/rac/flex/cccTop3Charts.swf"
                    dataSrcKeyBinding="flexKey@racHistDetailsBean@servletRequest"
                    optionsBinding="flexRacHisDetailsOptions@servletRequest"
                    windowHeight="500"
                    windowWidth="100%"
                    idBase="flexRacHistDetailsChart"/>
      </uix:case>
      </uix:switcher>
      <uix:switcher childNameBinding="useSVG@servletRequest">
      <uix:case name="false">
      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart" 
            width="750" 
            height="110" 
            orientation="vertical" 
            timeGranularity="SECOND" 
            legendPosition="east" 
            yAxisLabelBinding="MS_UNIT@racMsgBundle@servletRequest" 
            yAxisWidth="40" 
            fill="cumulative" 
            legendVisible="external" 
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            format="svg" 
            titleBinding="TIME_HEADER@racMsgBundle@servletRequest" 
            titleVisible="true">
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="chartDataSource1@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="chartImageMap1@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="Target" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Date" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>            
      </uix:rowLayout>
      </uix:case>
      </uix:switcher>
      
    <uix:switcher childNameBinding="useSVG@servletRequest">
      <uix:case name="false">
      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart" 
            width="750" 
            height="110" 
            orientation="vertical" 
            timeGranularity="SECOND" 
            legendPosition="east" 
            yAxisLabelBinding="BLOCKS_UNIT@racMsgBundle@servletRequest" 
            yAxisWidth="40" 
            fill="cumulative" 
            legendVisible="external" 
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            format="svg" 
            titleBinding="TRANSFER_HEADER@racMsgBundle@servletRequest" 
            titleVisible="true">
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="chartDataSource2@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="chartImageMap2@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="Target" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Date" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>
      </uix:case>
      </uix:switcher>

      <uix:switcher childNameBinding="useSVG@servletRequest">
      <uix:case name="false">
      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart" 
            width="750" 
            height="110" 
            orientation="vertical" 
            timeGranularity="SECOND" 
            legendPosition="east" 
            yAxisLabelBinding="PERC_UNIT@racMsgBundle@servletRequest" 
            yAxisWidth="40" 
            fill="cumulative" 
            legendVisible="external"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest" 
            format="svg" 
            titleBinding="RATIO_HEADER@racMsgBundle@servletRequest" 
            titleVisible="true">
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="chartDataSource3@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="chartImageMap3@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="Target" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Date" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>                  
      </uix:rowLayout>
     </uix:case>
     </uix:switcher>
     
    </uix:tableLayout>

          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
