<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <uix:switcher childNameBinding="changed@servletRequest">
          <uix:case name="true"> 
            <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                        errorTableBinding="msgBox@servletRequest"
                        destTableBinding="msgUrls@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:case>
        </uix:switcher>

        <uix:form name="home" method="post" destination="/em/console/rac/racSitemap">

          <uix:header textBinding="header@racDBBean@servletRequest">

          <!-- ============== show update time =========== -->
          <uix:tableLayout width="100%" >
            <uix:rowLayout hAlign="right">
              <%@ include file="refreshTime.jspf" %>
            </uix:rowLayout>
          </uix:tableLayout>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndex="0">
                  <uix:link textBinding="HOME@DBMsgBundle@servletRequest"/>
                  <uix:link textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"
                            destinationBinding="healthDest@servletRequest"/>
                  <uix:link textBinding="ADMINISTRATION@DBMsgBundle@servletRequest"
                            destinationBinding="adminDest@servletRequest"/>
                </uix:subTabBar>
              </uix:subTabs>

                  <!-- ...................  General Section .................. -->
                    <uix:header textBinding="GENERAL@DBMsgBundle@servletRequest">
                      <uix:borderLayout>
                          <uix:stackLayout>
                            <uix:tableLayout hAlign="left">
                              <uix:rowLayout>
                                <uix:cellFormat>
                                </uix:cellFormat>
                                <uix:spacer width="8"/>
                                <uix:cellFormat>
                                <uix:switcher childNameBinding="embeddedDBMode@servletRequest">
                                  <uix:case name="true">
                                    <uix:button textBinding="CHANGE_STATE@DBMsgBundle@servletRequest"
                                          destinationBinding="changeStateUrl@racDBBean@servletRequest"/>
                                  </uix:case>
                                </uix:switcher>
                                </uix:cellFormat>
                                <uix:spacer width="8"/>
                              </uix:rowLayout>
                            
                              <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="STATUS_HDR@DBMsgBundle@servletRequest"/>

                                </uix:cellFormat>
                                <uix:spacer width="8"/>
                                <uix:cellFormat>
                                  <uix:styledText styleClass="OraDataText"
                                                  textBinding="trafficStatusStr@racDBBean@servletRequest"/>
                                </uix:cellFormat>
                                <uix:spacer width="8"/>
                              </uix:rowLayout>

                              <uix:rowLayout renderedBinding="startedOrHigher@racDBBean@servletRequest">
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="UP_SINCE@racMsgBundle@servletRequest"/>
                                </uix:cellFormat>
                                <uix:spacer width="8"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="startupTime@racDBBean@servletRequest"/>
                              </uix:rowLayout>

                              <uix:rowLayout>
                              <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="DATABASE_NAME@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                                <uix:cellFormat>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="dbName@racDBBean@servletRequest"/>
                                </uix:cellFormat>
                              </uix:rowLayout>
                              <uix:rowLayout renderedBinding="startedOrHigher@racDBBean@servletRequest">
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                  textBinding="CONNECTION_DESCRIPTOR@racMsgBundle@servletRequest"/>

                                </uix:cellFormat>
                                <uix:spacer width="8"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="descriptor@servletRequest"/>
                              </uix:rowLayout>
                              
                              <%--
                              <uix:rowLayout renderedBinding="startedOrHigher@racDBBean@servletRequest">
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  text="Current Connection"/>
                                </uix:cellFormat>
                                <uix:spacer width="8"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="instanceName@racDBBean@servletRequest"/>
                              </uix:rowLayout>
                                --%>

                              <uix:rowLayout renderedBinding="startedOrHigher@racDBBean@servletRequest" >

                                <uix:cellFormat hAlign="right">

                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="VERSION@DBMsgBundle@servletRequest"/>

                                </uix:cellFormat>
                                <uix:spacer width="8"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="dbVersion@racDBBean@servletRequest"/>
                              </uix:rowLayout>

                              <uix:rowLayout renderedBinding="mountedOrHigher@racDBBean@servletRequest">
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraPromptText"
                                                  textBinding="LOG_MODE@DBMsgBundle@servletRequest" />
                                </uix:cellFormat>
                                <uix:spacer width="8"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="logMode@racDBBean@servletRequest" />
                              </uix:rowLayout> 


                            </uix:tableLayout>
                          </uix:stackLayout>

                        <!--  end of table of General info  -->


                        <!--  Traffic Light... -->
                        <uix:left>
                          <uix:image sourceBinding="trafficImage@racDBBean@servletRequest"/>
                        </uix:left> 

                      </uix:borderLayout>

                    </uix:header>

            </uix:subTabLayout>

          </uix:header>

          <uix:spacer height="5"/>

          <%@ include file="comp.jspf" %>


        </uix:form>
      </uix:pageLayout>
    </uix:body>


  </uix:document>
</uix:renderingContext>

