<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext> 

  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

      <uix:switcher childNameBinding="showWarning@servletRequest">
        <uix:case name="true">
          <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                          errorTableBinding="msgBox@servletRequest"
                          destTableBinding="msgUrls@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:case>
      </uix:switcher>

      <db:form name="racList" method="POST" destination="/em/console/rac/racPerfDetails"
               copyParams="target,type,instNum,drillDown">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %> 
          
          <uix:stackLayout>
            <uix:contents>

              <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              destTableBinding="msgUrls@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>  
              <uix:header textBinding="CUSTOMIZE_BUTTON@racMsgBundle@servletRequest">

                <uix:stackLayout>

                  <uix:tableLayout width="100%">
                    <uix:cellFormat hAlign="right">
                      <uix:pageButtonBar>
                        <uix:spacer width="10"/>
                        <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest"
                                    destinationBinding="customizeCancelUrl@racDBBean@servletRequest" />
                        <uix:spacer width="10"/>
                        <uix:submitButton textBinding="UPDATE_BUTTON@racMsgBundle@servletRequest"
                                          name="event"
                                          value="customizeInstsFromShuttle"/>
                      </uix:pageButtonBar>
                    </uix:cellFormat>
                  </uix:tableLayout>
  
                  <uix:styledText styleClass="OraPromptText" textBinding="customizeIntroText@servletRequest"/>
                  <uix:spacer height="10"/>
                
                <!-- ========== Nodes/Instances selection =========== -->
                <oem:shuttle 
                  name="instances" 
                  size="15"
                  reorderable="true"
                  leadingHeaderBinding="AVAILABLE_LIST@racMsgBundle@servletRequest"
                  trailingHeaderBinding="SELECTED_LIST@racMsgBundle@servletRequest">

                  <uix:leading>
                    <oem:list
                      name="availInstances"
                      multiple="true"
                      optionsBinding="availInsts@racDBBean@servletRequest"/>
                  </uix:leading>

                  <uix:trailing>
                    <oem:list
                      name="selInstances"
                      multiple="true"
                      optionsBinding="selInsts@racDBBean@servletRequest"/>
                  </uix:trailing>

                </oem:shuttle>
                </uix:stackLayout>

              </uix:header>
          </uix:contents>              
        </uix:stackLayout> 
        
        <uix:contentFooter>
          
          <uix:pageButtonBar>
            <uix:spacer width="10"/>
            <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest"
                        destinationBinding="customizeCancelUrl@racDBBean@servletRequest" />
            <uix:spacer width="10"/>
            <uix:submitButton textBinding="UPDATE_BUTTON@racMsgBundle@servletRequest" 
                              name="event" value="customizeInstsFromShuttle" />
          </uix:pageButtonBar>

        </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document> 
</uix:renderingContext> 
