<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.sysman.emo.dist.streams.StreamsStatusInfo" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 
 <%-- ......... Job rollups .........--%>
  <uix:bundle name="JobsResourceBundle"
              class="oracle.sysman.resources.emSDK.job.JobSDKMsg"/>
 <%-- ......... CPF .........--%>
  <uix:bundle name="mntrResourceBundle"
      class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="HDMMsg"
	    class="oracle.sysman.db.rsc.inst.HDMMsg"/>
<uix:bundle name="dvMsgs"
              class="oracle.sysman.db.rsc.sec.dv.DVMsg"/>

  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
          <uix:case name="true">
            <uix:rawText>
              <meta http-equiv="Refresh"
                    content="<%=request.getAttribute("refreshChoiceValue")%>; URL=<%=request.getAttribute("RacHomeRefreshURL") %>" ></meta>
            </uix:rawText> 
          </uix:case> 
  </uix:switcher>
  
  <uix:document> 
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body > 

    <uix:switcher childNameBinding="spEditMsg@servletRequest">
      <uix:case name="true">
        <oem:messageBox messageTypeBinding="spEditMessageType@servletRequest" 
                        errorTableBinding="spEditMsgBox@servletRequest"
                        destTableBinding="spEditMsgUrls@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>

    <uix:switcher childNameBinding="changed@servletRequest">
      <uix:case name="true"> 
        <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                        errorTableBinding="msgBox@servletRequest"
                        destTableBinding="msgUrls@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>

          <uix:switcher childNameBinding="dbmsJobNotReady@servletRequest">
            <uix:case name="true">
              <oem:messageBox messageTypeBinding="DBMSJOBmessageType@servletRequest" 
                              errorTableBinding="DBMSJOBmsgBox@servletRequest"
                              destTableBinding="DBMSJOBmsgUrls@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
          </uix:switcher>

          <db:form name="alertsForm" method="post" destination="/console/rac/racSitemap"
               copyParams="target,type">

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>

        <uix:header textBinding="header@racDBBean@servletRequest" 
                   iconBinding="dbImgPath@servletRequest" >

          <uix:contextSwitcher>
            <uix:switcher childNameBinding="showContextSwitcher@servletRequest">
              <uix:case name="true">
              <uix:flowLayout>
                  <uix:styledText styleClass="OraPromptText" 
                        textBinding="SWITCH_TOPOLOGY@racMsgBundle@servletRequest"/>  
                <oem:choice name="racdbChoice" id="racdbChoice"
                            shortDescBinding="SWITCH_TOPOLOGY@racMsgBundle@servletRequest"  
                            selectedValueBinding="racdb@servletRequest" 
                            optionsBinding="racdbList@servletRequest"
                            onChange="submitForm('alertsForm', true, {'event':'switchRacDB','pageNum':'1'})"> 
                        </oem:choice>  
              </uix:flowLayout>        
              </uix:case>
            </uix:switcher>
          </uix:contextSwitcher>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <%@ include file="racTabs.jspf" %>
              </uix:subTabBar>
            </uix:subTabs>

          <%-- refresh on the home page -------%>
          <uix:tableLayout width="100%" cellSpacing="5">
            <uix:rowLayout >

               <uix:cellFormat hAlign="right" >
                <uix:flowLayout>
                    <uix:styledText styleClass="OraTipText" 
                      textBinding="LATEST_FROM_TARGET@SDKBundle@servletRequest"/>
                    <uix:spacer width="5" />  
                    <uix:styledText styleClass="OraTipLabel" 
                      textBinding="refreshTime@servletRequest"/>
                    <uix:spacer width="10" />

                      <uix:button textBinding="REFRESH@SDKBundle@servletRequest" 
                                  shortDescBinding="REFRESH@SDKBundle@servletRequest" 
                        destinationBinding="refreshDest@servletRequest" />

                    <uix:spacer width="10" />

                      <uix:styledText styleClass="OraFieldText" 
                        textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                        labeledNodeId="refreshHome"/>
    
                      <uix:choice name="refreshHome" id="refreshHome" 
                                  shortDescBinding="REFRESH@SDKBundle@servletRequest" 
                                  onChange="submitForm('alertsForm', true, {'event':'doLoad','pageNum':'1'})"
                                  selectedValueBinding="refreshHomeSelected@servletRequest">
                        <uix:option textBinding="MANUALLY_REFRESH@DBMsgBundle@servletRequest"
                          value="RT_MAN"/>
                         <uix:option textBinding="AUTOMATICALLY_REFRESH@DBMsgBundle@servletRequest"
                          value="RT_15"/>
                         <uix:option textBinding="AUTOMATICALLY_REFRESH_1MIN@DBMsgBundle@servletRequest"
                          value="RT_60"/>   
                      </uix:choice>          
    
                   </uix:flowLayout>
                </uix:cellFormat>
             </uix:rowLayout>        
          </uix:tableLayout>
          <%-- END refresh on the home page -------%>

            <uix:tableLayout width="100%" cellSpacing="3">
              <uix:rowLayout vAlign="top" >
                <uix:cellFormat width="33%">
                <!-- ==================  General Section ============= -->

                    <uix:header textBinding="GENERAL@DBMsgBundle@servletRequest">
                    <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:stackLayout>
                        <uix:flowLayout>
                        <uix:tableLayout width="100%">
                          <uix:rowLayout>
                             <uix:cellFormat hAlign="left" >
                            <uix:image sourceBinding="trafficImage@racDBBean@servletRequest" 
                                       shortDescBinding="trafficStatusStr@racDBBean@servletRequest" />
                            </uix:cellFormat>
                               <uix:cellFormat hAlign="right" vAlign="top">
                                <uix:button textBinding="changeStateButtonLabel@servletRequest"
                                            shortDescBinding="changeStateButtonLabel@servletRequest"
                                  destinationBinding="changeStateUrl@racDBBean@servletRequest"/>
                              <uix:spacer width="2" />
                              <oem:license>
                               <uix:button textBinding="END_BLACKOUT@SDKBundle@servletRequest"
                                shortDescBinding="END_BLACKOUT@SDKBundle@servletRequest"
                                destinationBinding="blackoutsLinkDest@servletRequest"
                                renderedBinding="isStopBlackout@servletRequest"/>
                              </oem:license>
                              <oem:license>
                              <uix:button textBinding="CREATE_BLACKOUT@SDKBundle@servletRequest"
                                shortDescBinding="CREATE_BLACKOUT@SDKBundle@servletRequest"
                                destinationBinding="blackoutsLinkDest@servletRequest"
                                renderedBinding="isCreateBlackout@servletRequest" />
                              </oem:license>

                            </uix:cellFormat>  
                          </uix:rowLayout>
                          </uix:tableLayout>
                          </uix:flowLayout>

                    <uix:tableLayout>
                      <uix:rowLayout>
                          <uix:cellFormat vAlign="top">
                          <uix:tableLayout hAlign="left">

                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" textBinding="CURRENT_STATUS@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat>
                                <oem:license>
                                <uix:link destinationBinding="availDest@servletRequest"
                                          textBinding="trafficStatusStr@racDBBean@servletRequest"/>
                                </oem:license>
                                <uix:spacer width="8"/>
                              </uix:cellFormat>                           
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="INST_COMPONENTS@racMsgBundle@servletRequest" />
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat hAlign="left">
                              <uix:link  renderedBinding="isDbCentric@racDBBean@servletRequest" 
                                         textBinding="totalInstanceCount@racDBBean@servletRequest"
                                         destination="#instances"/>
                              
                              <uix:spacer width="5" renderedBinding="isDbCentric@racDBBean@servletRequest" />
                              <uix:styledText styleClass="OraDataText" text="( " renderedBinding="isDbCentric@racDBBean@servletRequest" />
                                    
                              <uix:flowLayout renderedBinding="showUpInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="upInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="upStatusShortDesc@racDBBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="upInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showDownInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="downInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="downStatusShortDesc@racDBBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="downInstCount@racDBBean@servletRequest"/>
                                </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnreachableInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="unreachableInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="unreachableStatusShortDesc@racDBBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unreachableInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showErrorInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="errorInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="errorStatusShortDesc@racDBBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="errorInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showBlackoutInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="blackoutInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="blackoutStatusShortDesc@racDBBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="blackoutInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout>

                              
                              <uix:flowLayout renderedBinding="showAgentDownInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="agentDownInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="agentDownStatusShortDesc@racDBBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="agentDownInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnknownInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="unknownInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="unknownStatusShortDesc@racDBBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unknownInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout> 
                              <uix:styledText  styleClass="OraDataText" text=" )" renderedBinding="isDbCentric@racDBBean@servletRequest" />
                              </uix:cellFormat>  
                            </uix:rowLayout>


                            <uix:rowLayout >
                              <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraPromptText"
                                  textBinding="AVAILABILITY@@DBMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                                <uix:rowLayout>
                                  <oem:license>
                                  <uix:link textBinding="trafficAvailStr@racDBBean@servletRequest"
                                            destinationBinding="availDest@servletRequest"/>
                                  </oem:license>
                                </uix:rowLayout>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText"
                                  text=""/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                                <uix:rowLayout>
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    text="(" />
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="LAST_DAY@SDKBundle@servletRequest" />
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    text=")" />
                                </uix:rowLayout>
                            </uix:rowLayout>


                            <uix:rowLayout >
                              <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="CLUSTER_TYPE@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:link textBinding="clusterName@racDBBean@servletRequest" 
                                        destinationBinding="clusterDest@racDBBean@servletRequest" />
                            </uix:rowLayout>

                            <uix:rowLayout renderedBinding="isServiceCentric@racDBBean@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText"
                                                textBinding="SERVER_POOLS@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                                <uix:rowLayout>
                                  <uix:link textBinding="serverPools@dbNPoolInfo@racDBBean@servletRequest"
                                            destinationBinding="serverPoolURL@racDBBean@servletRequest"
                                            shortDescBinding="SERVER_POOL_TOOL_TIP@racMsgBundle@servletRequest"/>
                                </uix:rowLayout>
                            </uix:rowLayout>

                            <uix:rowLayout >
                              <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="DATABASE_NAME@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="dbName@racDBBean@servletRequest"/>
                            </uix:rowLayout>

                            <uix:rowLayout >
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="VERSION@DBMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraDataText" 
                                              textBinding="dbVersion@racDBBean@servletRequest"/>
                            </uix:rowLayout>
			  <uix:switcher childNameBinding="isDisplayWLM@servletRequest">
          		  <uix:case name="true">
			  <uix:rowLayout 
           			renderedBinding="instanceVersion_gte11gR2@defaultBean@servletRequest">
        		  <uix:cellFormat hAlign="right">
           		  <uix:styledText styleClass="OraPromptText"
              	 	  textBinding="QOS_STATUS@racMsgBundle@servletRequest"/>
         		  </uix:cellFormat>
         		  <uix:spacer width="8"/>
	 		  <uix:link textBinding="wlmQosStatus@defaultBean@servletRequest" 
			  destinationBinding="qosStatusPage@servletRequest"/>
        		  </uix:rowLayout>
			  </uix:case>
			  </uix:switcher>
			  	
     <jsp:include page="dvStatusIncl.jsp" />
             <uix:ref refID="dvStatusIncl" />

                      <!-- SAGE -->
              <uix:rowLayout renderedBinding="cellTgtFound@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:styledText styleClass="OraPromptText"
                                    textBinding="EXADATA_LIST@DBMsgBundle@servletRequest" />
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:cellFormat hAlign="left">
                              <uix:link destinationBinding="cellTableDest@servletRequest"
                                textBinding="cellCount@defaultBean@servletRequest"/>

                              <uix:spacer  width="5"/>
                              <uix:styledText styleClass="OraDataText" text="( "/>                               
                           <uix:flowLayout renderedBinding="showUpCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="upCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="upStatusShortDesc@defaultBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="upCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showDownCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="downCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="downStatusShortDesc@defaultBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="downCellCount@defaultBean@servletRequest"/>
                                </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnreachableCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="unreachableCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="unreachableStatusShortDesc@defaultBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unreachableCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showErrorCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="errorCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="errorStatusShortDesc@defaultBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="errorCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showBlackoutCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="blackoutCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="blackoutStatusShortDesc@defaultBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="blackoutCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout>

                              
                              <uix:flowLayout renderedBinding="showAgentDownCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="agentDownCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="agentDownStatusShortDesc@defaultBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="agentDownCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnknownCellCount@defaultBean@servletRequest">
                                <uix:image sourceBinding="unknownCellIconSource@defaultBean@servletRequest"
                                           shortDescBinding="unknownStatusShortDesc@defaultBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unknownCellCount@defaultBean@servletRequest"/>
                              </uix:flowLayout> 
                              <uix:styledText styleClass="OraDataText" text=" )"/>
                              </uix:cellFormat>
                            </uix:rowLayout>

                            
  <%--
  <uix:rowLayout >
     <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
       <uix:styledText styleClass="OraPromptText"
                       textBinding="APPQOS_PROP@racMsgBundle@servletRequest"
		        />
     </uix:cellFormat>
        <uix:spacer width="8"/>
                                                                        
     <uix:cellFormat wrappingDisabled="true" hAlign="left"  >
       <db:link destination="/console/wlm/wlmRecommendation?event=doLoad"
                 copyParams="target,type"
                 textBinding="ARCHIVE_ENABLED@DBMsgBundle@servletRequest"
		  />
     </uix:cellFormat>
   </uix:rowLayout>                            

   --%>
                            <uix:rowLayout renderedBinding="showSvcsImpacted@svcImpBean@servletRequest">         		      
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" textBinding="label@svcImpBean@servletRequest" />
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                              <uix:link textBinding="value@svcImpBean@servletRequest" 
                                        destinationBinding="destination@svcImpBean@servletRequest" />
                            </uix:rowLayout>
                            
                            <!-- Link Reconfiguration  activity Info -->
                            <uix:rowLayout renderedBinding="reconfigActivityExist@servletRequest">
                              <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraPromptText"
                                  textBinding="reconfigActivityPage@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                                <uix:rowLayout >

                                  <uix:link textBinding="reconfigActivityCount@servletRequest"
                                            destinationBinding="reconfigActivityPageURL@servletRequest"/>
                                  
                                </uix:rowLayout>
                           </uix:rowLayout>  
<%--
                            <uix:rowLayout renderedBinding="reconfigActivityExist@servletRequest">
                              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText"
                                  text=""/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>
                                <uix:rowLayout>
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    text="(" />
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="LAST_DAY@SDKBundle@servletRequest" />
                                  <uix:styledText styleClass="OraInlineInfoText"
                                    text=")" />
                                </uix:rowLayout>
                            </uix:rowLayout> --%>
                            
                           <!--END  Reconfiguration  activity Info -->
                          <%-- hide View All Properties link if the target is not monitored --%>
                          <uix:spacer height="8"/>
                           <uix:rowLayout >
                           <uix:cellFormat hAlign="right"  vAlign="top"  />
                           <uix:spacer width="8"/>
                           <db:link copyParams="target,type"
                            textBinding="VIEW_ALL_PROPERTIES@DBMsgBundle@servletRequest"
                            destination="/console/rac/racSitemap?event=viewProperties"
                             />
                           </uix:rowLayout>
                       

                        </uix:tableLayout>
                        </uix:cellFormat>

                      </uix:rowLayout>
                     </uix:tableLayout>
                    </uix:stackLayout>
                    </uix:rowLayout>
                    </uix:tableLayout>
                    </uix:header>                                        
                </uix:cellFormat>                

                <uix:include node="/rac/overview_perf.jsp" />

                </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout width="100%" cellSpacing="3">
              <uix:rowLayout vAlign="top">
              
                <%-- Diagnostic Summary --%>
                <uix:cellFormat vAlign="top" width="33%" renderedBinding="showDiagnosticSummarySec@racDBBean@servletRequest">
                <uix:header textBinding="DIAGNOSTIC_SUMMARY@DBMsgBundle@servletRequest">
                  <uix:stackLayout>
                    <uix:tableLayout>

                    <uix:rowLayout renderedBinding="instanceVersion_gte10gR2@racDBBean@servletRequest">
                      <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
                        <uix:styledText styleClass="OraPromptText" 
                                        textBinding="IC_FINDINGS@racMsgBundle@servletRequest"/>
                      </uix:cellFormat>

                         <uix:cellFormat>
                         <uix:spacer width="10"/>
                         </uix:cellFormat>
                         <uix:cellFormat>
                         <uix:image 
                           sourceBinding="intrconnFlag@servletRequest" 
                           renderedBinding="showRacIntrconnStatus@defaultBean@servletRequest"
                           shortDescBinding="racIntrconnSeverityShortDesc@defaultBean@servletRequest" />
                         </uix:cellFormat>
                         <uix:cellFormat>
                         <uix:spacer width="10"/>
                         </uix:cellFormat>
                      
                      <uix:cellFormat>
                       <oem:license>
                        <uix:link textBinding="racInterconnectAlerts@racDBBean@servletRequest" 
                                destinationBinding="interconnDest@racDBBean@servletRequest" />
                       </oem:license>
                      </uix:cellFormat>          
                    </uix:rowLayout>
		             <uix:rowLayout renderedBinding="hdmSupported@servletRequest">
	    <uix:cellFormat hAlign="right">
		  <uix:styledText 
            styleClass="OraPromptText"
            textBinding="ADDM_FINDINGS@DBMsgBundle@servletRequest" />
  		</uix:cellFormat>
        <uix:spacer width="10"/>
        <uix:image 
          sourceBinding="nothing@servletRequest" />
	  	<uix:spacer width="10"/>
       <oem:license>   
        <uix:link 
          textBinding="lastestHDMFindingCount@racDBBean@servletRequest"
          destinationBinding="latestHDMTaskUrl@servletRequest" />
	 </oem:license>
       </uix:rowLayout>    
      <uix:rowLayout renderedBinding="hdmRunAvailable@servletRequest">
        <uix:cellFormat hAlign="right">	     
           <uix:styledText styleClass="OraPromptText"
               textBinding="START_TIME@HDMMsg"/>
         </uix:cellFormat>
         <uix:spacer width="10"/>
         <uix:image sourceBinding="nothing@servletRequest" />
         <uix:spacer width="10"/>
         <uix:cellFormat wrappingDisabled="true">
          <uix:styledText styleClass="OraDataText"
			       textBinding="HDMStartPeriod@racDBBean@servletRequest"/>
        </uix:cellFormat>     
      </uix:rowLayout>
      <uix:rowLayout 
           renderedBinding="instanceVersion_gte11@defaultBean@servletRequest">
        <uix:cellFormat hAlign="right">
           <uix:styledText styleClass="OraPromptText"
               textBinding="ACTIVE_INCIDENTS@DBMsgBundle@servletRequest"/>
         </uix:cellFormat>
         <uix:spacer width="10"/>
         <uix:image sourceBinding="incidentSeverity@defaultBean@servletRequest"
                    shortDescBinding= "incidentSeverityDesc@defaultBean@servletRequest" />
         <uix:spacer width="10"/>
         <uix:cellFormat wrappingDisabled="true">
          <uix:link textBinding="incidentCount@defaultBean@servletRequest"
                    destinationBinding="SWBPage@servletRequest" />
        </uix:cellFormat>
      </uix:rowLayout>
      

<%--  Database Health page disabled; not supported for the RAC database
      <uix:rowLayout 
           renderedBinding="instanceVersion_gte11@defaultBean@servletRequest">
        <uix:spacer height="10"/>
      </uix:rowLayout>
 
      <uix:rowLayout 
           renderedBinding="instanceVersion_gte11@defaultBean@servletRequest">
        <uix:cellFormat hAlign="center" columnSpan="5">   
          <uix:link textBinding="TITLE_DB_HEALTH_PAGE@racMsgBundle@servletRequest"
                    destinationBinding="DBHealthPage@servletRequest" />
        </uix:cellFormat>
      </uix:rowLayout>
--%>

  <%-- Key Sql Profile --%>
  
   <uix:rowLayout renderedBinding="instanceVersion_gte11gR2@racDBBean@servletRequest">
        <uix:cellFormat hAlign="right">
          <uix:styledText styleClass="OraPromptText" 
                               textBinding="KEY_SQL_PROFILES@DBMsgBundle@servletRequest"/>
        </uix:cellFormat>
        <uix:spacer width="10"/>
        <uix:image sourceBinding="nothing@servletRequest" />
        <uix:spacer width="10"/>
       <uix:switcher childNameBinding="racShowAutoSqlTuneUrl@racDBBean@servletRequest">
        <uix:case name="true">
          <uix:switcher childNameBinding="racHasKeyProfile@racDBBean@servletRequest">
          <uix:case name="true">
            <uix:switcher childNameBinding="racAutoImplEnable@racDBBean@servletRequest">
              <uix:case name="true">
            <oem:license>
               <uix:link 
                  textBinding="racKeyProfileCount@racDBBean@servletRequest"
                  destinationBinding="keySqlProfileUrl@servletRequest"  
                  shortDescBinding="AUTO_IMPL_TOOLTIP@DBMsgBundle@servletRequest" />
            </oem:license>
              </uix:case>
              <uix:case name="false">
             <oem:license>
               <uix:link 
                  textBinding="racKeyProfileCount@racDBBean@servletRequest"
                  destinationBinding="keySqlProfileUrl@servletRequest"  
                  shortDescBinding="KEY_PROFILES_TOOLTIP@DBMsgBundle@servletRequest" />
             </oem:license>
              </uix:case>
              </uix:switcher>
          </uix:case>
           <uix:case name="false">
             <uix:switcher childNameBinding="racKeyProfileEnable@racDBBean@servletRequest">
             <uix:case name="true">
               <oem:license>
                  <uix:link 
                    textBinding="racKeyProfileCount@racDBBean@servletRequest"
                    destinationBinding="keySqlProfileUrl@servletRequest"  
                    shortDescBinding="KEY_PROFILES_ENABLE_TOOLTIP@DBMsgBundle@servletRequest" />
                </oem:license>
               </uix:case>
               <uix:case name="false">
                  <oem:license>
                    <uix:link 
                      textBinding="racKeyProfileCount@racDBBean@servletRequest"
                      destinationBinding="keySqlProfileUrl@servletRequest"  
                      shortDescBinding="KEY_PROFILES_DISABLE_TOOLTIP@DBMsgBundle@servletRequest" />
                  </oem:license>
               </uix:case>
               </uix:switcher>
           </uix:case>
          </uix:switcher>
       </uix:case>
        <uix:case name="false">
          <uix:styledText styleClass="OraDataText"
            textBinding="unAvailableMsg@racDBBean@servletRequest" />
       </uix:case>
     </uix:switcher>
   </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:stackLayout>
                </uix:header>

                </uix:cellFormat>




                <%-- space usage --%>
                <uix:cellFormat vAlign="top" width="33%">
                <uix:stackLayout>
                  <uix:header textBinding="SPACE_SUMMARY@DBMsgBundle@servletRequest">
                    <uix:stackLayout>

                        <%@ include file="/database/instance/sitemap/stgInclude.jspf" %>

                    </uix:stackLayout>
                  </uix:header>
                </uix:stackLayout>
                </uix:cellFormat>
  
                <!--  High Availability -->
                <uix:cellFormat vAlign="top" width="34%">
                  <uix:header textBinding="HIGHAVAIL@DBMsgBundle@servletRequest" 
                        renderedBinding="showHA@racDBBean@servletRequest">
                    <uix:stackLayout>
                      <uix:tableLayout>

           <%-- Always show HA Console link --%>
           <uix:rowLayout>
             <uix:cellFormat hAlign="right" wrappingDisabled="true">
               <uix:styledText styleClass="OraPromptText"
                                textBinding="HA_CONSOLE_SM@DBMsgBundle@servletRequest" />
             </uix:cellFormat>
                                                                                
             <uix:spacer width="10"/>
             <uix:image sourceBinding="nothing@servletRequest"/>
             <uix:spacer width="10"/>
                                                                                
             <uix:cellFormat wrappingDisabled="true" hAlign="left">
               <db:link destination="/console/database/haConsole?event=doLoad"
                         copyParams="target,type"
                         textBinding="HA_DETAILS@DBMsgBundle@servletRequest" />
             </uix:cellFormat>
           </uix:rowLayout>

                        <!--  Data Guard Role -->
                        <uix:rowLayout renderedBinding="showDG@racDBBean@servletRequest">

                          <uix:cellFormat hAlign="right">
                            <uix:styledText styleClass="OraPromptText"
                              textBinding="DATAGUARD@DBMsgBundle@servletRequest" />
                          </uix:cellFormat>

                          <uix:spacer width="10"/>
                            <uix:switcher childNameBinding="showDGStatus@racDBBean@servletRequest">
                            <uix:case name="true">
                               <uix:image sourceBinding="dgStatusFlag@servletRequest"
                                          shortDescBinding="DGStatusShortDesc@defaultBean@servletRequest"/>
                            </uix:case>
                            <uix:case name="false">
                               <uix:image sourceBinding="nothing@servletRequest"/>
                            </uix:case>
                            </uix:switcher>
                          <uix:spacer width="10"/>

                          <uix:cellFormat wrappingDisabled="true" hAlign="left">
                            <db:link destination="/console/database/dataguard?event=doLoad"
                              copyParams="target,type"
                              textBinding="DGRole@racDBBean@servletRequest" />
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <!--  Data Guard Primary DB Name  -->
                        <uix:rowLayout renderedBinding="showPrmy@racDBBean@servletRequest">
                          <uix:cellFormat hAlign="right">
                           <uix:styledText styleClass="OraPromptText"
                                textBinding="DG_PRIMARY_DB@DBMsgBundle@servletRequest"/>
                          </uix:cellFormat>

                          <uix:spacer width="10"/>
                          <uix:image sourceBinding="nothing@servletRequest"/>
                          <uix:spacer width="10"/>

                          <uix:cellFormat wrappingDisabled="true" hAlign="left">
                           <uix:styledText styleClass="OraDataText"
                                textBinding="prmyEMName@racDBBean@servletRequest" />
                          </uix:cellFormat>
                       </uix:rowLayout>


                       <!--  RMAN Backup -->
                        <uix:rowLayout renderedBinding="showBackup@racDBBean@servletRequest">
                          <uix:cellFormat hAlign="right">
                            <uix:styledText styleClass="OraPromptText"
                              textBinding="backupMsg@racDBBean@servletRequest" />
                          </uix:cellFormat>

                          <uix:spacer width="10"/>
                          <uix:switcher childNameBinding="showBackupStatus@racDBBean@servletRequest">
                            <uix:case name="true">
                              <uix:image sourceBinding="backupStatusFlag@servletRequest"
                                         shortDescBinding="backupStatusShortDesc@racDBBean@servletRequest" />
                            </uix:case>
                            <uix:case name="false">
                             <uix:image sourceBinding="nothing@servletRequest"/>
                            </uix:case>
                          </uix:switcher>
                          <uix:spacer width="10"/>

                          <uix:cellFormat wrappingDisabled="true" hAlign="left">
                            <uix:switcher childNameBinding="showBackupTimeAsLink@racDBBean@servletRequest">
                              <uix:case name="true">
                                 <db:link textBinding="backupTime@racDBBean@servletRequest"
                                        destinationBinding="backupTimeLink@defaultBean@servletRequest"
                                        copyParams="target,type"/>
                              </uix:case>
                              <uix:case name="false">
                                <uix:styledText styleClass="OraDataText"
                                  textBinding="backupTime@racDBBean@servletRequest" />
                              </uix:case>
                            </uix:switcher>
                          </uix:cellFormat>
                      </uix:rowLayout>

                       <%-- Usable Flash Recovery Area --%>
                       <uix:rowLayout renderedBinding="showReusableRecoveryArea@racDBBean@servletRequest">
                         <uix:cellFormat hAlign="right" wrappingDisabled="true">
                           <uix:styledText styleClass="OraPromptText"
                                           textBinding="REUSABLE_RECOVERY_AREA@DBMsgBundle@servletRequest" />
                         </uix:cellFormat>
                                                                                            
                         <uix:spacer width="10"/>
			 <uix:image sourceBinding="nothing@servletRequest"/>
                         <uix:spacer width="10"/>
                                                                                            
                         <uix:cellFormat wrappingDisabled="true" hAlign="left">
                           <db:link destination="/console/rac/racRecovery?setFocus=FRA"
                                     copyParams="target,type"
                                     textBinding="reusableRecoveryArea@racDBBean@servletRequest" />
                         </uix:cellFormat>
                       </uix:rowLayout>

                       <%-- Flashback Logging --%>
                       <uix:rowLayout renderedBinding="showFlashbackLogging@racDBBean@servletRequest">
                         <uix:cellFormat hAlign="right" wrappingDisabled="true">
                           <uix:styledText styleClass="OraPromptText"
                                           textBinding="FLASHBACK_LOGGING@DBMsgBundle@servletRequest" />
                         </uix:cellFormat>
                                                                                            
                         <uix:spacer width="10"/>
			 <uix:image sourceBinding="nothing@servletRequest"/>
                         <uix:spacer width="10"/>
                                                                                            
                         <uix:cellFormat wrappingDisabled="true" hAlign="left">
                           <db:link destination="/console/rac/racRecovery?setFocus=FRA"
                                     copyParams="target,type"
                                     textBinding="flashbackLogging@racDBBean@servletRequest" />
                         </uix:cellFormat>
                       </uix:rowLayout>
            
                       <%-- Flashback Time --%>
                       <uix:rowLayout renderedBinding="showFlashbackTime@racDBBean@servletRequest">
                         <uix:cellFormat hAlign="right" wrappingDisabled="true">
                           <uix:styledText styleClass="OraPromptText"
                                           textBinding="FLASHBACK_TIME@DBMsgBundle@servletRequest" />
                         </uix:cellFormat>
                                                                                            
                         <uix:spacer width="10"/>
			 <uix:image sourceBinding="nothing@servletRequest"/>
                         <uix:spacer width="10"/>
                                                                                            
                         <uix:cellFormat wrappingDisabled="true" hAlign="left">
                           <db:link destination="/console/rac/racRecovery?setFocus=FRA"
                                     copyParams="target,type"
                                     textBinding="flashbackTime@racDBBean@servletRequest" />
                         </uix:cellFormat>
                       </uix:rowLayout>

			<%-- Streams Status --%>
<%--    <%@ include file="/database/dist/streams/streamsHomeInclude.jspf" --%>

     <uix:rowLayout renderedBinding="showStreamsPathStatus@defaultBean@servletRequest">             <uix:cellFormat hAlign="right" wrappingDisabled="true">
               <uix:styledText styleClass="OraPromptText"
                               textBinding="STREAMS_PATH_STATUS@DBMsgBundle@servletRequest" />
             </uix:cellFormat>

             <uix:spacer width="10"/>
             <uix:spacer width="10"/>
             <uix:spacer width="10"/>

             <uix:cellFormat wrappingDisabled="true" hAlign="left">
             <uix:include nodeBinding="streamsPathStatus@servletRequest"/>
             </uix:cellFormat>

    </uix:rowLayout>
<%
StreamsStatusInfo infoBean= (StreamsStatusInfo) request.getAttribute("streamsStatus");
if (infoBean != null)
{
%>
    <uix:rowLayout renderedBinding="showStreamsStatus@defaultBean@servletRequest">

             <uix:cellFormat hAlign="right" wrappingDisabled="true">
                 <uix:styledText styleClass="OraPromptText"
                      textBinding="STREAMS_STATUS@DBMsgBundle@servletRequest" />
             </uix:cellFormat>

             <uix:spacer width="10"/>
             <uix:spacer width="10"/>
             <uix:spacer width="10"/>

             <uix:cellFormat wrappingDisabled="true" hAlign="left">
                <uix:rowLayout>
                   <uix:contents>
<%
if (infoBean.getCritCompCount() > 0)
{
%>
                          <uix:image source="/em/images/criticalind_status.gif" shortDescBinding="CRITICAL_STREAMS_COMPS@streamsMsgBundle@servletRequest" />
                          <uix:spacer width="2"/>
                          <db:link destination="/console/database/dist/streams/streamsOverview"
                                   copyParams="type,target"
                                   shortDescBinding="CRITICAL_STREAMS_COMPS@streamsMsgBundle@servletRequest"
                                   textBinding="critCompCount@streamsStatus@servletRequest"/>
                          <uix:spacer width="7"/>
<%
}
if (infoBean.getWarnCompCount() > 0)
{
%>
                          <uix:image source="/em/images/warningind_status.gif" shortDescBinding="WARNING_STREAMS_COMPS@streamsMsgBundle@servletRequest"/>
                          <uix:spacer width="2"/>
                          <db:link destination="/console/database/dist/streams/streamsOverview"
                              copyParams="type,target"
                              shortDescBinding="WARNING_STREAMS_COMPS@streamsMsgBundle@servletRequest"
                              textBinding="warnCompCount@streamsStatus@servletRequest"/>
                          <uix:spacer width="7"/>
<%
}
if (infoBean.getHealthyCompCount() > 0)
{
%>
                          <uix:image source="/em/images/okind_status.gif" shortDescBinding="HEALTHY_STREAMS_COMPS@streamsMsgBundle@servletRequest" />
                          <uix:spacer width="2"/>
                          <db:link destination="/console/database/dist/streams/streamsOverview"
                              copyParams="type,target"
                              shortDescBinding="HEALTHY_STREAMS_COMPS@streamsMsgBundle@servletRequest"
                              textBinding="healthyCompCount@streamsStatus@servletRequest"/>
                          <uix:spacer width="7"/>
<%
}
%>
                 </uix:contents>
              </uix:rowLayout>
           </uix:cellFormat>

    </uix:rowLayout>
<%
}
%>
    <uix:rowLayout renderedBinding="showStreamsMonitor@defaultBean@servletRequest"> 
             <uix:cellFormat hAlign="right" wrappingDisabled="true">
               <uix:styledText styleClass="OraPromptText"
                               textBinding="STREAMS_MONITOR@DBMsgBundle@servletRequest" />
                </uix:cellFormat>

             <uix:spacer width="10"/>
             <uix:image sourceBinding="nothing@servletRequest" shortDescBinding="STREAMS_MONITOR@DBMsgBundle@servletRequest" />
             <uix:spacer width="10"/>

             <uix:cellFormat wrappingDisabled="true" hAlign="left">
               <uix:styledText styleClass="OraPromptText"
                               textBinding="streamsMonitor@defaultBean@servletRequest" />
             </uix:cellFormat>
   </uix:rowLayout>

      <%-- End Streams Status --%>

                       <%-- Problem Services --%>            
                        <uix:rowLayout renderedBinding="showProblemServices@racDBBean@servletRequest">
                          <uix:cellFormat hAlign="right">
                           <uix:styledText styleClass="OraPromptText"
                                textBinding="PROBLEM_SERVICES@racMsgBundle@servletRequest"/>
                          </uix:cellFormat>

                          <uix:spacer width="10"/>
                          <uix:image sourceBinding="problemServicesFlag@servletRequest" shortDescBinding="problemServicesShortDesc@racDBBean@servletRequest"/>
                          <uix:spacer width="10"/>

                          <uix:cellFormat wrappingDisabled="true" hAlign="left">
<uix:include nodeBinding="problemServicesData@servletRequest"/>
                           <%-- db:link destination="/console/rac/racServices"
                                     copyParams="target,type"
                                     textBinding="problemServices@racDBBean@servletRequest" / --%>

                          </uix:cellFormat>
                       </uix:rowLayout>

                                             

                      </uix:tableLayout>
                    </uix:stackLayout>
                  </uix:header>
                 </uix:cellFormat>
                
              </uix:rowLayout>
            </uix:tableLayout>
             

            <!-- Alerts table -->
            <uix:hideShowHeader textBinding="ALERTS_HEADER@DBMsgBundle@servletRequest" 
                                id="RAChideShowAlertsTableHeader" 
                                partialRenderMode="self"
                                formSubmitted="true"
                                disclosedBinding="RACdiscloseHideShowAlertsTableHeader@httpSession" >
         <uix:tableLayout width="100%">
              <uix:rowLayout >
                <uix:cellFormat hAlign ="left">
                   <uix:flowLayout>
                     <uix:messagePrompt promptBinding="CATEGORY@DBMsgBundle@servletRequest" 
                                        labeledNodeId="alersFilterID" />
          
                     <uix:choice name="alertsFilter" id="alersFilterID"
                                 shortDescBinding="CATEGORY@DBMsgBundle@servletRequest"
                                 selectedValueBinding="alertsFilter@racDBBean@servletRequest" 
                                 onChange="submitForm('alertsForm', true, {'event':'filterAlerts','pageNum':'1'})">
                       <uix:contents childDataBinding="alertsFilterList@racDBBean@servletRequest">
                         <uix:option textBinding="text" valueBinding="value" />
                       </uix:contents>
                     </uix:choice>  

                     <uix:spacer width="10"/>

                  <%-- Critical Alert Count --%>
                      <uix:styledText 
                        styleClass="OraPromptText"
                        textBinding="ALERT_CRITICAL@DBMsgBundle@servletRequest" />
           
                     <uix:spacer width="10"/>
            
                     <uix:switcher childNameBinding="hasAlertCritical@servletRequest">
                       <uix:case name="true">
                         <uix:image 
                           sourceBinding="criticalImage@servletRequest"
                           shortDescBinding="ALERT_CRITICAL@DBMsgBundle@servletRequest" />
                       </uix:case>
                       <uix:case name="false">
                         <uix:image sourceBinding="nothing@servletRequest"/>
                       </uix:case>
                     </uix:switcher>
            
                     <uix:spacer width="10"/>

                     <uix:link 
                       textBinding="alertCriticalCount@servletRequest"
                       destinationBinding="alertCriticalLink@servletRequest" />

                     <uix:spacer width="10"/>

                   <%-- Warning Alert Count --%>
                     <uix:styledText 
                         styleClass="OraPromptText"
                         textBinding="ALERT_WARNINGS@DBMsgBundle@servletRequest" />
            
                     <uix:spacer width="10"/>
            
                     <uix:switcher childNameBinding="hasAlertWarning@servletRequest">
                       <uix:case name="true">
                         <uix:image 
                           sourceBinding="warningImage@servletRequest" 
                           shortDescBinding="ALERT_WARNINGS@DBMsgBundle@servletRequest" />
                       </uix:case>
                       <uix:case name="false">
                         <uix:image sourceBinding="nothing@servletRequest"/>
                       </uix:case>
                     </uix:switcher>
            
                     <uix:spacer width="10"/>

                     <uix:link 
                       textBinding="alertWarningCount@servletRequest"
                       destinationBinding="alertWarningLink@servletRequest" />
                   </uix:flowLayout>    
                </uix:cellFormat>
                <uix:cellFormat hAlign="right">
                </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>
          
              <uix:tableLayout width="100%" >       
                <uix:rowLayout>              
                  <oem:table name="racAlertsDataSource" width="100%"                           
                             summaryBinding="ALERTS_HEADER@DBMsgBundle@servletRequest" 
                             formSubmitted="true"                           
                             partialRenderMode="self"
                             id="racAlertsTable"
                             beanKey="racDBBean"                           
                             dataSourceProp="racAlertsDataSource"
			     blockSize="10"                           
                             alternateTextBinding="NO_ALERTS_ALT@racMsgBundle@servletRequest">
                  </oem:table>            
                  </uix:rowLayout>               
                </uix:tableLayout>           
            </uix:hideShowHeader>     

            <uix:hideShowHeader textBinding="RELATED_ALERTS@SDKBundle@servletRequest" 
                                id="RAChideShowRelatedAlertsTableHeader" 
                                partialRenderMode="none"
                                formSubmitted="true"
                                disclosedBinding="RACdiscloseHideShowRelatedAlertsTableHeader@httpSession">
              <uix:tableLayout width="100%" >       
                <uix:rowLayout vAlign="top">              
                  <oem:table name="racRelatedAlertsDataSource"
                             summaryBinding="RELATED_ALERTS@SDKBundle@servletRequest" 
                             partialRenderMode="none"
                             id="racReAlertsTable"
                           width="100%" 
                           dataSourceProp="racRelatedAlertsDataSource"
                           beanKey="racDBBean"                       
                           formSubmitted="true"
			   blockSize="10"
                          alternateTextBinding="NO_ALERTS_ALT@racMsgBundle@servletRequest"> 
                  </oem:table> 
              </uix:rowLayout>               
            </uix:tableLayout>           
            </uix:hideShowHeader>    

            <uix:switcher  childNameBinding="RACdiscloseHideShowRelatedAlertsTableHeader@httpSession">
              <uix:case name="false">
                <uix:tableLayout>           
                <uix:rowLayout>               
                  <uix:spacer width="20"/>
                  <uix:cellFormat hAlign ="left">
                  <%-- Critical Alert Count --%>
                      <uix:styledText 
                        styleClass="OraPromptText"
                        textBinding="ALERT_CRITICAL@DBMsgBundle@servletRequest" />
           
                     <uix:spacer width="10"/>
            
                     <uix:switcher childNameBinding="hasRelatedAlertCritical@servletRequest">
                       <uix:case name="true">
                         <uix:image 
                           sourceBinding="criticalImage@servletRequest"
                           shortDescBinding="ALERT_CRITICAL@DBMsgBundle@servletRequest" />
                       </uix:case>
                       <uix:case name="false">
                         <uix:image sourceBinding="nothing@servletRequest"/>
                       </uix:case>
                     </uix:switcher>
            
                     <uix:spacer width="10"/>

                     <uix:link 
                       textBinding="relatedAlertCriticalCount@servletRequest"
                       destinationBinding="relatedAlertCriticalLink@servletRequest" />

                     <uix:spacer width="10"/>

                   <%-- Warning Alert Count --%>
                     <uix:styledText 
                         styleClass="OraPromptText"
                         textBinding="ALERT_WARNINGS@DBMsgBundle@servletRequest" />
            
                     <uix:spacer width="10"/>
            
                     <uix:switcher childNameBinding="hasRelatedAlertWarning@servletRequest">
                       <uix:case name="true">
                         <uix:image 
                           sourceBinding="warningImage@servletRequest" 
                           shortDescBinding="ALERT_WARNINGS@DBMsgBundle@servletRequest" />
                       </uix:case>
                       <uix:case name="false">
                         <uix:image sourceBinding="nothing@servletRequest"/>
                       </uix:case>
                     </uix:switcher>
            
                     <uix:spacer width="10"/>

                     <uix:link 
                       textBinding="relatedAlertWarningCount@servletRequest"
                       destinationBinding="relatedAlertWarningLink@servletRequest" />
                  </uix:cellFormat>
	            </uix:rowLayout>
                </uix:tableLayout>           
              </uix:case>
            </uix:switcher>

                               <uix:header textBinding="TASK_DETAIL_HEADER@HDMMsg"  renderedBinding="hdmRunAvailable@servletRequest">
	 <uix:tableLayout>
	   <uix:rowLayout>
	     
	     
	     
	     <uix:cellFormat  wrappingDisabled="true">
	       <uix:styledText styleClass="OraPromptText"
			       textBinding="START_TIME@HDMMsg"/>

	     </uix:cellFormat>
	     <uix:spacer width="4"/>
	     <uix:cellFormat wrappingDisabled="true">
	       <uix:styledText styleClass="OraDataText"
			       textBinding="HDMStartPeriod@defaultBean@servletRequest"/>
	     </uix:cellFormat>
	     <uix:spacer width="20"/>
	     <uix:cellFormat wrappingDisabled="true">
	       <uix:styledText styleClass="OraPromptText"
			       textBinding="DURATION@HDMMsg"/>

	     </uix:cellFormat>
	     <uix:spacer width="4"/>
	     <uix:cellFormat wrappingDisabled="true">
	       <uix:styledText styleClass="OraDataText"
			       textBinding="HDMDuration@defaultBean@servletRequest"/>
	     </uix:cellFormat>
	     <uix:spacer width="20"/>
	     <uix:cellFormat wrappingDisabled="true">
	       <uix:styledText styleClass="OraPromptText"
			       textBinding="INSTANCE_INFO@HDMMsg"/>

	     </uix:cellFormat>
	     <uix:spacer width="4"/>
	     <uix:cellFormat wrappingDisabled="true">
	       <uix:styledText styleClass="OraDataText"
			       textBinding="HDMRequestedAnalysis@racDBBean@servletRequest"/>
	     </uix:cellFormat>
	     
	   </uix:rowLayout>
	 </uix:tableLayout>
	 <oem:table name="findingsTableUI"
		    partialRenderMode="self"
                    id="findingsTableUI"
		    width="100%"
		    formSubmitted="true"
                    summaryBinding="TASK_DETAIL_HEADER@HDMMsg"
		    dataSourceProp="findingsTableUI"
		    beanKey="defaultBean" 
		    blockSize="5" alternateTextBinding="NO_FINDING_MESSAGE@HDMMsg" copyParams="target,type,task_id"> 
	 </oem:table> 
       </uix:header> 

            <%-- Grid Control policies section --%>
            <uix:include nodeBinding="policyNode@servletRequest"/>

            <%-- Security section --%>
            <uix:include nodeBinding="secNode@servletRequest"/> 
			
            <uix:tableLayout width="100%" cellSpacing="2">
                <uix:rowLayout vAlign="top">
                
                <!-- Job Activity Table --> 
                <uix:cellFormat>
                  <uix:tableLayout width="50%" >
                    <uix:rowLayout>
                      <uix:ref refID="JOB_ACTIVITY_SEGMENT" />
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>

                 <!--  CPF ONLY in DB Console Mode -->
                 <uix:cellFormat>
                   <uix:switcher childNameBinding="enterpriseMode@servletRequest">
                      <uix:case name="false">
           		    	     <uix:header textBinding="CRITICAL_PATCH@mntrResourceBundle">
        		   		         <uix:contents>
        				  	         <uix:include nodeBinding="EcmPatch@servletRequest"/>
                				   </uix:contents>
        		    	       </uix:header>
                      </uix:case>
                   </uix:switcher>
                 </uix:cellFormat>
                
               </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="15"/>
          </uix:subTabLayout>
            
          <uix:spacer height="5"/>

        </uix:header>
        
        <uix:rawText>
          <a name="instances" />
       </uix:rawText>


          <%@ include file="comp.jspf" %>

          <oem:relatedLinks />

      </uix:pageLayout>

        </db:form>

    </uix:body>

  </uix:document> 
</uix:renderingContext> 

