<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        overview_perf.jsp 
 *
 *      NOTES
 *        tbd
 *       
 * MODIFIED
 *    shasingh    12/16/08 - bug 7321196: performence improvement
 *    rsamaved    08/11/08 - 
 *    gapadman    07/17/08 - 
 *    rsamaved    05/31/08 - 
 *    pboopath    04/27/08 - change cpu count text
 *    rsamaved    03/13/08 - change max cpu to cpu cores
 *    rsamaved    02/17/07 - remove health meter
 *    pboopath    01/17/07 - removing Paging link
 *    pboopath    12/27/06 - 
 *    ezeng       09/14/06 - 
 *    rsamaved    08/20/06 - rac perf enhancements
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:cellFormat vAlign="top" renderedBinding="showRacPerfChart@servletRequest">
  <uix:header textBinding="HOST_CPU@DBMsgBundle@servletRequest" 
              iconBinding="allClearIcon@servletRequest">
    <uix:stackLayout>
      <uix:tableLayout>
        <uix:rowLayout> 
          <oem:chart 
            chartType="barChart"
            widthBinding="hostChartWidth@perfChart@servletRequest"
            height="150"
            shadowEffect="3d"
            orientation="vertical"
            stacked="true"
            legendPosition="east"
            legendVisible="external"
            axisMax="100"
            showXAxisLabels="false"
            yAxisSuffix="%"
            barLabelling="false"
            titleBinding="HOST_CPU@DBMsgBundle@servletRequest"
            titleVisible="false"  
            yAxisWidth="30"
            noDataMessageBinding="noResponseDataMessage@perfChart@servletRequest">
            <oem:boundChartDataSource chartDataSourceBinding="hostCPUDataSource@perfChart@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="hostCPUImageMap@perfChart@servletRequest"/>

            <oem:chartColumn isKey="true"
                             displayLabel="Label 1"
                             sourceIndex="0" />
            <oem:chartColumn displayLabelBinding="dbName@perfChart@servletRequest" 
                             itemColorBinding="cpuColor@perfChart@servletRequest"          
                             sourceIndex="1" />            
            
            <oem:chartColumn displayLabelBinding="OTHER@DBMsgBundle@servletRequest" 
                             itemColorBinding="secondaryCpuColor@perfChart@servletRequest"
                             sourceIndex="2" />            
          </oem:chart>
          
        </uix:rowLayout>
      </uix:tableLayout>

      <%--<uix:rowLayout hAlign="center">
      <uix:rowLayout hAlign="center" renderedBinding="hasLoad@racDBBean@servletRequest">--%>
        <uix:rowLayout hAlign="left" renderedBinding="hasLoad@racDBBean@servletRequest">
        <uix:cellFormat hAlign="right">
          <uix:styledText styleClass="OraPromptText"
                          textBinding="LOAD@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
        <uix:spacer width="5"/>
        <oem:license>
          <uix:link textBinding="runQueue@racDBBean@servletRequest"
                    destinationBinding="runQueueLink@perfChart@servletRequest"
                    shortDescBinding="RUN_QUEUE_TOOLTIP@DBMsgBundle@servletRequest" />
        </oem:license>
     </uix:rowLayout>   
        
    <%--<uix:spacer width="15" />
        
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
              <uix:styledText styleClass="OraPromptText"
                textBinding="PAGING@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="5"/>
          <uix:image shortDescBinding="SEVERITY@DBMsgBundle@servletRequest"
                     sourceBinding="pagingSeverity@servletRequest" />
          <uix:spacer width="5"/>
          <oem:license>
          <uix:link textBinding="pageOutRate@racDBBean@servletRequest"
                    destinationBinding="pageOutRateLink@perfChart@servletRequest"
                    shortDescBinding="PAGING_TOOLTIP@DBMsgBundle@servletRequest" />
         </oem:license>
        </uix:rowLayout>
        
      </uix:rowLayout>--%>    
	  </uix:stackLayout>
	</uix:header> 
  
</uix:cellFormat>


<uix:cellFormat vAlign="top" renderedBinding="showRacPerfChart@servletRequest">
  <uix:header textBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest" 
              iconBinding="allClearIcon@servletRequest">
    <uix:stackLayout>
      <uix:tableLayout>
        <uix:rowLayout> 
          <oem:chart 
            chartType="barChart"
            stacked="true"
            widthBinding="waitsChartWidth@perfChart@servletRequest"
            height="150"
            shadowEffect="3d"
            orientation="vertical"
            legendPosition="east"
            legendVisible="external"
            titleBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
            titleVisible="false"  
            barLabelling="false"
            showXAxisLabels="false"
            axisMaxBinding="activeSessMaxValue@perfChart@servletRequest"
            yAxisWidth="30"
            noDataMessageBinding="noResponseDataMessage@perfChart@servletRequest">
            <oem:boundChartDataSource chartDataSourceBinding="actSessDataSource@perfChart@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="actSessImageMap@perfChart@servletRequest"/>
            
            <oem:chartColumn isKey="true"
                             displayLabel="Label 1"
                             sourceIndex="0" />
            <oem:chartColumn displayLabelBinding="USING_CPU@DBMsgBundle@servletRequest" 
                             itemColorBinding="cpuColor@perfChart@servletRequest"
                             sourceIndex="1" />            
            <oem:chartColumn displayLabelBinding="IO_HDR@DBMsgBundle@servletRequest" 
                             itemColorBinding="userIOColor@perfChart@servletRequest"
                             sourceIndex="2" />            
            <oem:chartColumn displayLabelBinding="WAIT_HDR@DBMsgBundle@servletRequest" 
                             itemColorBinding="waitColor@perfChart@servletRequest"
                             sourceIndex="3" />        
          </oem:chart>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:rowLayout hAlign="left">
        <uix:rowLayout hAlign="center">
          <uix:cellFormat hAlign="right">
               <uix:styledText styleClass="OraPromptText"
                textBinding="MAX_CPU@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="10"/>
          <uix:styledText styleClass="OraDataText"
            textBinding="maximumCpu@racDBBean@servletRequest"/>
        </uix:rowLayout>
      </uix:rowLayout>
                                                                                                 
       <%--
      <uix:rowLayout hAlign="left">
        <uix:rowLayout hAlign="center">
          <uix:cellFormat hAlign="right">
            <uix:styledText styleClass="OraPromptText"
                            textBinding="USING_CPU@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="5"/>
          <oem:license>
            <uix:link textBinding="cpuTime@racDBBean@servletRequest"
                      destinationBinding="activeSessLink@perfChart@servletRequest" />
          </oem:license>
        </uix:rowLayout>   
        
        <uix:spacer width="15" />
        
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:styledText styleClass="OraPromptText"
                            textBinding="IO_HDR@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="5"/>
          <oem:license>
            <uix:link textBinding="userIO@racDBBean@servletRequest"
                      destinationBinding="userIOLink@perfChart@servletRequest" />
          </oem:license>
        </uix:rowLayout>
        
      </uix:rowLayout>
       --%>
      
    </uix:stackLayout>
  </uix:header> 
</uix:cellFormat>

<%-- COMMENT OUT SQL RESPONSE TIME
<uix:cellFormat vAlign="top" width="25%" renderedBinding="responseConfigured@defaultBean@servletRequest" >
  <uix:header textBinding="SQL_RESPONSE_TIME@DBMsgBundle@servletRequest"
              renderedBinding="instanceVersion_gte9@defaultBean@servletRequest"
              iconBinding="avgRespFlag@servletRequest">
	  <uix:stackLayout>
     <uix:tableLayout>
	      <uix:rowLayout> 
      <oem:chart 
        chartType="barChart"
        widthBinding="responseChartWidth@perfChart@servletRequest" 
        height="150"
        shadowEffect="3d"
        orientation="vertical"
        legendPosition="east"
        legendVisible="external"
        titleBinding="SQL_RESPONSE_TIME@DBMsgBundle@servletRequest"
        titleVisible="false"  
        barLabelling="false"
        showXAxisLabels="false"
        axisMaxBinding="responseMaxValue@perfChart@servletRequest"
        axisMin="0"
        yAxisWidth="30"
        yAxisSuffixBinding="responseChartYAxisSuffix@perfChart@servletRequest"
	noDataMessageBinding="noResponseDataMessage@perfChart@servletRequest"
         >
        <oem:boundChartDataSource chartDataSourceBinding="responseDataSource@perfChart@servletRequest"/>
        <oem:imageMap imageMapDataSourceBinding="responseImageMap@perfChart@servletRequest"/>
        
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabelBinding="RESPONSE_PERCENT@DBMsgBundle@servletRequest" 
            renderedBinding="showResponseRelativePctOnly@perfChart@servletRequest"
            itemColor="#529FED"            
            sourceIndex="1" />
        <oem:chartColumn displayLabelBinding="LATEST_COLLECTION@DBMsgBundle@servletRequest" 
            renderedBinding="responseVersionGTE10_2_0_1@perfChart@servletRequest"
            itemColor="#E46800"            
            sourceIndex="1" />            
        <oem:chartColumn displayLabelBinding="BASELINE@DBMsgBundle@servletRequest" 
            renderedBinding="responseVersionGTE10_2_0_1@perfChart@servletRequest"
            itemColor="#529FED"
            sourceIndex="2" />



      </oem:chart>
        </uix:rowLayout>
        <uix:rowLayout hAlign="center">
	  <uix:rowLayout hAlign="center">
	    <uix:cellFormat>
              <uix:styledText styleClass="OraPromptText"
               	textBinding="RESPONSE_PERCENT@DBMsgBundle@servletRequest" />
	    </uix:cellFormat>
	    <uix:spacer width="5"/>
            <uix:cellFormat vAlign="top">
        <uix:switcher childNameBinding="SQLRespAvailable@perfChart@servletRequest">
          <uix:case name="true">
  	    <uix:link textBinding="SQLRespPct@perfChart@servletRequest"
                      destinationBinding="aveRespLink@servletRequest"/>
          </uix:case>
          <uix:default>
            <uix:styledText styleClass="OraPromptText"
                            textBinding="SQLRespPct@perfChart@servletRequest"/>
          </uix:default>
        </uix:switcher>
            </uix:cellFormat>
	  </uix:rowLayout>
        </uix:rowLayout> 
	<uix:rowLayout>
	  <uix:spacer height="5"/>
        </uix:rowLayout>
        <uix:rowLayout hAlign="right">
	  <uix:switcher childNameBinding="showResetBaseline@perfChart@servletRequest">
	    <uix:case name="true">
	      <uix:button textBinding="RESET_BASELINE@DBMsgBundle@servletRequest"
	                  destinationBinding="resetSQLBaselineLink@servletRequest"/>
	    </uix:case>
            <uix:case name="false">
              <uix:button textBinding="EDIT_BASELINE@DBMsgBundle@servletRequest"
                          destinationBinding="editSQLBaselineLink@servletRequest"/>
            </uix:case>
	  </uix:switcher>
        </uix:rowLayout>
      </uix:tableLayout>   
          </uix:stackLayout> 
	</uix:header> 
</uix:cellFormat>

COMMENT OUT SQL RESPONSE TIME --%>


