<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        SQLTraceDisable.jsp 
 *
 *      NOTES
 *        Page for top consumers Disable SQL Trace button click.
 *       
 * MODIFIED
 *    pboopath   02/15/07 - Bug 5684210 Disable text changed
 *    kmckeen    11/30/06 - Fix oac/ui issues
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>

<!-- ================  SQL Trace Disable Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>  
  <uix:document>    
    <%@ include file="/enablePPR.jspf" %>    
	<%@ include file="/oemTitle.jspf" %>    

	<uix:body>    
	  <db:form name="SQLTraceEnableForm" destinationBinding="topDest@servletRequest" copyParams="target,type,pageKey">
	    <uix:formValue name="refreshChoice" valueBinding="refreshChoice@servletRequest"/>    

		<uix:pageLayout>      
		  <%@ include file="/database/global.jspf" %>        
		  
		  <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"                             
				msgBundleBinding="DBMsgBundle"                             
				titleTextKey="titleText" mainTextKey="mainText"/>        
		  <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"                             
				msgBundleBinding="DBMsgBundle"                             
				titleTextKey="titleText" mainTextKey="mainText"/>        

		  <uix:tableLayout width="100%">          
		    <uix:rowLayout>            
			  <uix:stackLayout>              
			    <uix:spacer height="10"/>                  
				<uix:header textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest" >

   		             <uix:switcher childNameBinding="isRac@servletRequest">
   		               <uix:case name="true">
				  <uix:styledText styleClass="OraInstructionText" textBinding="DISABLE_SQL_TRACE_CLIENT_INST@TopConsumersMsgBundle@servletRequest" />		                     </uix:case>
			     </uix:switcher>

				  <uix:tableLayout width="100%">        
				    <uix:rowLayout hAlign="right">
				    </uix:rowLayout>
				    <uix:rowLayout>
				      <uix:spacer height="5"/>
				    </uix:rowLayout>
				    <uix:rowLayout width="100%">                          
					  <oem:table name="SQLTraceDisableDataSource" beanKey="SQLTraceDataSourceBean"                            
							formSubmitted="true"                            
							dataSourceProp="twoDUIDataSource" width="100%"                            
							alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"                            
                                                        summaryBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
							partialRenderMode="self">                       
					  </oem:table>                  
					</uix:rowLayout>                
				  </uix:tableLayout>                
				</uix:header>            
			  </uix:stackLayout>          
			</uix:rowLayout>        
		  </uix:tableLayout>                  
		  
		  <uix:pageButtons>		  
		    <uix:pageButtonBar>			
			  <uix:submitButton textBinding="CANCEL@DBObjectMsgBundle@servletRequest" name="event" value="cancelDisableSQLTrace"/>		  
			  <uix:submitButton textBinding="OK@DBObjectMsgBundle@servletRequest" name="event" value="doDisableSQLTrace"/>			
			</uix:pageButtonBar>        
		  </uix:pageButtons>      
		</uix:pageLayout>     
	  </db:form>    
	</uix:body>  
  </uix:document>
</uix:renderingContext> 



