<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        consDetailActivity.jsp 
 *
 *      NOTES
 *        Consumer Detail Activity tab.  The form name must be 'foo'
 *        because waitDetailsDropdown.jspf which is used by each of
 *        the waitDetails*.jspf include files calls submitForm with
 *        'foo' as the form name.  This could be made generic by
 *        changing the waitDetailsDropdown.jspf use of submitForm to:
 *        submitForm(this.form, true, {'event':'changeTab'})
 *       
 * MODIFIED
 *    pboopath   05/05/08 - swf path change from rac/flex to rac/flex
 *    kmckeen    04/07/08 - Bug 6801637 - more performance fixes
 *    gapadman   03/22/08 - enable historical 
 *    pboopath   02/26/08 - removing ASH report
 *    kmckeen    02/13/08 - Implement historical option
 *    pboopath   01/18/08 - flex chart height change
 *    kmckeen    11/13/07 - Bug 6499189 - fix breadcrumbs
 *    pboopath   10/26/07 - flex chart changes
 *    kmckeen    09/21/07 - Bug 6442558 - tables should appear side-by-side,
 *                          not stacked
 *    kmckeen    05/31/07 - Non-SVG Refresh meta tag needs params: seconds, url
 *    kmckeen    05/30/07 - Change legendVisible option from external to true
 *    kmckeen    05/25/07 - Bug 6061702 - fix double refresh in SVG mode for
 *    kmckeen    01/16/07 - Add uix:bundle tags for enhanced waitDetailsSql
 *    kmckeen    12/27/06 - Render inst list only if available
 *    kmckeen    12/22/06 - UI review - reduce chart width
 *    kmckeen    10/12/06 - Bug 5557350 - top activity metric
 *    kmckeen    09/19/06 - Make legend external so no entries are truncated
 *    kmckeen    07/07/06 - Initialize creation of module.
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rac.util.RacCustomization" %>

<uix:styleSheet/>

<script>
function scroll_timechart(direction)
{
  if (direction == 'prev'){
    document.foo.direction.value = '1';
  }
  else{
    document.foo.direction.value = '2';
  }
  submitForm('foo', true, {'event':'scrollChart'});
}
function my_goto_band(selIdx, startMS, endMS)
{
  submitForm('foo', true, {'event':'moveSlider','leftEdge':startMS,'rightEdge':endMS,'selectedBand':selIdx});
}
function switchsql()
{
  submitForm('foo', true, {'event':'doLoad','pageNum':'2', 'datasource':'SQL'});
}
function sliderOffLeft(param)
{
  location.href = param;
}
</script>

<%
response.setHeader("Pragma", "No-cache");
response.setHeader("Cache-Control", "no-cache");
%>

<uix:renderingContext id="renderingContext">

  <%-- For bundles used by waitDetailsSql.jspf --%>
  <uix:bundle name="DBObjectMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsg" class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <uix:switcher childNameBinding="autoRefresh@servletRequest">
    <uix:case name="true">
      <uix:rawText rendered="true">
        <meta http-equiv="Cache-Control" content="max-age=0" >
        <meta http-equiv="Refresh" content="15; URL=<%=request.getAttribute("refreshDest") %>" >
      </uix:rawText> 
    </uix:case>  
  </uix:switcher>

  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form 
          name="foo"
          destinationBinding="consDetailDest@servletRequest"
          copyParams="target,type,pageKey">

        <uix:formValue
            name="service"
            valueBinding="service@consDetailBean@servletRequest"/>
        <uix:formValue
            name="module"
            valueBinding="module@consDetailBean@servletRequest"/>
        <uix:formValue
            name="action"
            valueBinding="action@consDetailBean@servletRequest"/>
        <uix:formValue
            name="client"
            valueBinding="client@consDetailBean@servletRequest"/>
        <uix:formValue
            name="waitClass"
            valueBinding="waitClass@waitDetailsBean@servletRequest"/>
        <uix:formValue
            name="pageNum"
            value="2"/>
        <uix:formValue
            name="leftEdge"/>
        <uix:formValue
            name="rightEdge"/>
        <uix:formValue
            name="event"/>
        <uix:formValue
            name="direction"
            value=""/>
        <uix:formValue
            name="selectedBand"
            value=""/>      

        <uix:pageLayout>

          <%@ include file="/database/global.jspf" %>

          <oem:messageBox
              messageType="info"
              errorTableBinding="info@servletRequest"
              msgBundleBinding="DBMsgBundle"
              titleTextKey="titleText"
              mainTextKey="mainText"/>
          <oem:messageBox
              messageType="error"
              errorTableBinding="errors@servletRequest"
              msgBundleBinding="DBMsgBundle"
              titleTextKey="titleText"
              mainTextKey="mainText"/>

          <uix:tableLayout width="100%">          

            <uix:rowLayout hAlign="right">
           
              <uix:cellFormat>
                 <uix:styledText
                    styleClass="OraInstructionText"
                    textBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                    labeledNodeId="refreshChoice"/>
                <uix:spacer width="5"/>
                <uix:choice
                    name="refreshChoice"
                    id="refreshChoice"
                    onChange="submitForm('foo', true, {'event':'changeRefreshChoice'})"
                    selectedValueBinding="refreshChoice@consDetailBean@servletRequest">
                  <uix:option
                      textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                      value="15"/>
                  <uix:option
                      textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                      value="-1" />
                  <uix:option 
                      textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                      value="HIST_CUST"
                      renderedBinding="renderHistoricalOption@waitDetailsBean@servletRequest"/>  
                </uix:choice>
                            
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:stackLayout>
                <uix:header textBinding="header@consDetailBean@servletRequest">

                  <uix:tableLayout width="100%">
                    <uix:rowLayout hAlign="right">
                      <uix:switcher childNameBinding="showTime@consDetailBean@servletRequest">
                        <uix:case name="true">
                          <uix:rowLayout hAlign="right">
                            <%@ include file="/database/instance/refreshTime.jspf" %>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <uix:subTabLayout>
                    <uix:subTabs>
                      <uix:subTabBar selectedIndex="1">
                        <uix:link
                            textBinding="generalTabHeader@consDetailBean@servletRequest"
                            destinationBinding="genDest@servletRequest"/>
                        <uix:link
                            textBinding="ACTIVITY@DBMsgBundle@servletRequest"
                            destinationBinding="actDest@servletRequest"
                            renderedBinding="renderActivityTab@servletRequest"/>
                        <uix:link
                            textBinding="ALL_SESS_LINK@DBMsgBundle@servletRequest"
                            destinationBinding="statDest@servletRequest"/>
                      </uix:subTabBar>
                    </uix:subTabs>

                    <uix:tableLayout >
                    <uix:rowLayout>
                    <uix:flowLayout>
                      <%-- 
                        -- The following causes jsp processing errors because 
                        -- serviceLabel and prettyService are not available on
                        -- the bean. Not displayed for service Activity tab
                        -- anyway, so comment this out to eliminate the jsp 
                        -- error processing time.
                        --
                      <uix:messageStyledText
                          promptBinding="serviceLabel@consDetailBean@servletRequest"
                          textBinding="prettyService@consDetailBean@servletRequest"
                          styleClass="OraDataText"/>
                      --%>
                      <uix:messageStyledText
                          promptBinding="instListLabel@consDetailBean@servletRequest"
                          textBinding="instList@consDetailBean@servletRequest"
                          styleClass="OraDataText"
                          renderedBinding="renderInstList@consDetailBean@servletRequest"/>
                    </uix:flowLayout>
                    </uix:rowLayout>
                    
                    <uix:flowLayout>
                  <uix:styledText
                      styleClass="OraInstructionText"
                      labeledNodeId="activityAggregationId"
                      textBinding="ACTIVITY_AGGREGATION@racMsgBundle@servletRequest"/>
                  <uix:choice
                      id="activityAggregationId"
                      name="aggregationChoice"
                      onChange="submitForm('foo', true, {'event':'updateAggregationChoice'})"
                      selectedValueBinding="aggregationChoiceSelected@servletRequest">
                    <uix:option
                        textBinding="WAITS@DBMsgBundle@servletRequest"
                        value="<%= RacCustomization.AGGREGATION_BY_WAITS %>"/>                      
                    <uix:option
                        textBinding="INSTANCES@racMsgBundle@servletRequest"
                        value="<%= RacCustomization.AGGREGATION_BY_INSTANCES %>"/>
                  </uix:choice>
                    </uix:flowLayout>
                    
                    </uix:tableLayout>
                    
<%--
                    <uix:tableLayout width="100%">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" vAlign="top" wrappingDisabled="true">
                          <uix:messagePrompt
                              promptBinding="activityChartTip@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                          <uix:messagePrompt
                              promptBinding="detailsMetricsLabel@servletRequest"
                              labeledNodeId="detailsMetric"/>
                          <uix:choice
                              id="detailsMetric"
                              name="detailsMetric"
                              selectedValueBinding="detailsMetric@consDetailBean@servletRequest"
                              shortDescBinding="detailsMetricsLabel@servletRequest"
                              onChange="submitForm(document.forms[0], true, {'event':'switchDetailsMetric'})">
                            <uix:contents
                                childDataBinding="detailsMetrics@servletRequest">
                              <uix:option 
                                  textBinding="text"
                                  valueBinding="value"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
--%>

<%-- For the wait class dropdown list - need to re-enable serviceActivityBean.
<uix:switcher childNameBinding="useSVG@serviceActivityBean@servletRequest">
  <uix:case name="true">
    <uix:tableLayout renderedBinding="showChart@serviceActivityBean@servletRequest">
      <uix:rowLayout hAlign="left">
        <uix:messagePrompt promptBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest"/>
        <%@ include file ="/database/instance/consumer/srvActClassDropdown.jspf" %>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:case>
  <uix:case name="false">
    <uix:tableLayout renderedBinding="showChart@serviceActivityBean@servletRequest">
      <uix:rowLayout hAlign="left">
        <uix:messagePrompt promptBinding="WAIT_DETAIL_GIF_TIP@DBMsgBundle@servletRequest"/>
        <%@ include file ="/database/instance/consumer/srvActClassDropdown.jspf" %>
      </uix:rowLayout>
    </uix:tableLayout> 
  </uix:case>
</uix:switcher>
--%>

<uix:stackLayout>
<uix:switcher childNameBinding="showChart@waitDetailsBean@servletRequest">
  <uix:case name="true">
  <uix:switcher childNameBinding="useSVG@waitDetailsBean@servletRequest">
        <uix:case name="true">
         <db:flexRegion
                   swfName="/rac/flex/consActivity.swf"
                   dataSrcKeyBinding="flexKey@servletRequest"
                   optionsBinding="aggregationAndServiceName@servletRequest"
                   windowHeight="270"
                   windowWidth="100%"
                   idBase="flexRacConsumerActivity"/>
                    </uix:case>
        <uix:case name="false">
    <oem:chart
        chartType="timeSeriesChart" 
        width="800" height="250" timeGranularity="SECOND"
        orientation="vertical" fill="cumulative"
        yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest" 
        legendPosition="east" legendVisible="external"
        titleBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
        titleVisible="false"
        seriesColorsAutomatic="true"
        format="svg" svgUpdateFrequencyBinding="svgUpdateRate@servletRequest"
        xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest"
        xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest"
        yAxisWidth="30" yAxisNumberFormatBinding="waitChartYAxisFormat@servletRequest"
        axisMin="0" axisMaxBinding="actualMaxValue@waitAreaChart@waitDetailsBean@servletRequest"
        svgHighlightLegend="true"
        svgTimebandTipBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest"
        colorPaletteBinding="waitColorsTable@waitAreaChart@waitDetailsBean@servletRequest">
      <uix:contents>
        <oem:timeSelector 
            xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest" 
            xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest" 
            intervalTimeSecBinding="intervalTimeSec@servletRequest" 
            height="20" 
            selectedMaxDateBinding="selectedMaxDate@servletRequest" 
            selectedMinDateBinding="selectedMinDate@servletRequest" 
            numBandsSelectedBinding="numBandsSelected@servletRequest" 
            selectionDest="my_goto_band" 
            selectionDestType="JavaScript" 
            selectionAltTextBinding="SELECT_PERIOD_RANGE@DBMsgBundle@servletRequest" 
            position="south" 
            dynamicTimeSelector="true" 
            xAxisScrollDest="scroll_timechart" 
            xAxisScrollDestType="JavaScript" 
            xAxisScrollPrevBinding="scrollButtonsAvailable@waitAreaChart@waitDetailsBean@servletRequest" 
            xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsgBundle@servletRequest" 
            xAxisScrollNextBinding="scrollButtonsAvailable@waitAreaChart@waitDetailsBean@servletRequest" 
            xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsgBundle@servletRequest" 
            selectionIndicator="shading" 
            dynamicTimeSelectorColorBinding="sliderColor@waitAreaChart@waitDetailsBean@servletRequest" 
            dynamicTimeSelectorEdgeColorBinding="sliderEdgeColor@waitAreaChart@waitDetailsBean@servletRequest"/>
        <oem:boundChartDataSource dataClass="oracle.sysman.db.rac.RacConsumerDetailsController" dataMethod="updateChartData"/>
        <oem:imageMap imageMapDataSourceBinding="legendLinks@waitAreaChart@waitDetailsBean@servletRequest"/>
        <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
        <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
        <oem:chartColumn displayLabel="" sourceIndex="2"/>
      </uix:contents>
    </oem:chart>
    </uix:case>
    </uix:switcher>
  </uix:case>
  <uix:case name="false">
    <uix:rowLayout>
      <uix:text textBinding="5001@ChartMsgBundle@servletRequest"/>
    </uix:rowLayout>
  </uix:case>
</uix:switcher>
</uix:stackLayout>

<uix:switcher childNameBinding="showDetails@servletRequest">
  <uix:case name="true">
    <uix:header size="1"
        textBinding="detailIntervalHeader@waitDetailsBean@servletRequest"
        renderedBinding="showChart@waitDetailsBean@servletRequest">

      <uix:tableLayout width="100%">
        <uix:rowLayout vAlign="top">
          <uix:cellFormat hAlign="left">
            <uix:messageStyledText
                promptBinding="SPOT_SQL_DETAIL_TEXT@DBMsgBundle@servletRequest"
                styleClass="OraDataText"
                textBinding="detailStartTime@waitDetailsBean@servletRequest"/>
           <%-- <uix:cellFormat hAlign="right">
              <uix:button
                  textBinding="ASH_REPORT@DBMsgBundle@servletRequest"
                  renderedBinding="showAshReportLink@servletRequest"
                  destinationBinding="ashReportLink@servletRequest"/>
            </uix:cellFormat>--%>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:tableLayout width="100%">
        <uix:rowLayout>
          <uix:cellFormat vAlign="top" wrappingDisabled="true">
            <uix:borderLayout>
              <uix:left>
                <uix:rowLayout>
                  <%@ include file="/database/instance/waitevent/waitDetailsSql.jspf" %>
                </uix:rowLayout>
              </uix:left>
              <uix:right>
                <uix:rowLayout>
                  <uix:switcher childNameBinding="tabIndex@servletRequest" >
              <uix:case name="0">
                <%@ include file="/database/instance/waitevent/waitDetailsSession.jspf" %>
              </uix:case>
              <uix:case name="3">
                <%@ include file="/database/instance/waitevent/waitDetailsFileTab.jspf" %>
              </uix:case>
              <uix:case name="4">
                <%@ include file="/database/instance/waitevent/waitDetailsIOObjTab.jspf" %>
              </uix:case>
              <uix:case name="5">
                <%@ include file="/database/instance/waitevent/waitDetailsModuleTab.jspf" %>
              </uix:case>
              <uix:case name="6">
                <%@ include file="/database/instance/waitevent/waitDetailsActionTab.jspf" %>
              </uix:case>
              <uix:case name="7">
                <%@ include file="/database/instance/waitevent/waitDetailsServiceTab.jspf" %>
              </uix:case>
              <uix:case name="8">
                <%@ include file="/database/instance/waitevent/waitDetailsClientTab.jspf" %>
              </uix:case>
              <uix:case name="9">
                <%@ include file="/database/instance/waitevent/waitDetailsPlsqlTab.jspf" %>
              </uix:case>
              <uix:case name="10">
                <%@ include file="/database/instance/waitevent/clusterDetailsInstanceHGrid.jspf" %>
              </uix:case>
            </uix:switcher>
                </uix:rowLayout>
              </uix:right>
            </uix:borderLayout>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>

    </uix:header>
  </uix:case>
</uix:switcher>

                  </uix:subTabLayout>
                </uix:header>
              </uix:stackLayout>
            </uix:rowLayout>

          </uix:tableLayout>      

      <uix:header textBinding="ADDITIONAL_LINKS@racMsgBundle@servletRequest">
       <uix:rowLayout>
       <uix:link textBinding="TOP_SEGMENTS@racMsgBundle@servletRequest"
                 destinationBinding="topSegmentDest@servletRequest"/>
       </uix:rowLayout>
       <uix:spacer height="3"/>
       <uix:rowLayout>
       <uix:link textBinding="CCC_PAGE_TITLE@racMsgBundle@servletRequest"
                 destinationBinding="cccDest@servletRequest"/>
       </uix:rowLayout>       
       <uix:spacer height="3"/>      
       <uix:rowLayout>
       <uix:link textBinding="IC_INTERCONNECTS@racMsgBundle@servletRequest"
                 destinationBinding="interConnectLink@servletRequest" 
                 renderedBinding = "isNotHistorical@consDetailBean@servletRequest" />
       </uix:rowLayout>

      </uix:header>

        </uix:pageLayout> 
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
