<%-- 
 * Copyright (c) 2006, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *        consDetailGeneral.jsp 
 *
 *      NOTES
 *        Consumer Detail General tab
 *       
 * MODIFIED
 *    rsamaved   01/11/07 - XbranchMerge rsamaved_ui_review from main
 *    kmckeen    12/27/06 - Render inst list only if available
 *    kmckeen    11/30/06 - Fix oac/ui issues
 *    gapadman   09/04/06 - 
 *    kmckeen    07/07/06 - Update to include Activity tab.
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>

<!-- ================  Service Detail General tab =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>  

<uix:document>    

 <%@ include file="/enablePPR.jspf" %>    
 <%@ include file="/oemTitle.jspf" %>    

   <uix:body>    
     <uix:pageLayout>      
      <%@ include file="/database/global.jspf" %>

      <!-- set html refresh -->    
      <uix:switcher childNameBinding="refreshChoice@servletRequest">
        <uix:case name="15">
          <uix:rawText>
            <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoice") %>" >
          </uix:rawText>
        </uix:case>
      </uix:switcher>

      <db:form name="detailForm" method="POST" destinationBinding="consDetailDest@servletRequest" copyParams="target,type,pageKey"> 
        <uix:formValue name="service" valueBinding="service@consDetailBean@servletRequest"/>      
        <uix:formValue name="module" valueBinding="module@consDetailBean@servletRequest"/>      
        <uix:formValue name="action" valueBinding="action@consDetailBean@servletRequest"/>      
        <uix:formValue name="client" valueBinding="client@consDetailBean@servletRequest"/>      
	<uix:formValue name="pageNum" value="1"/>        

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      
      <uix:tableLayout width="100%">

        <!-- Refresh Choice drop-down -->
        <uix:rowLayout hAlign="right">
          <uix:cellFormat>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
			    labeledNodeId="refreshChoice"/>
            <uix:spacer width="5"/>
            <uix:choice name="refreshChoice" id="refreshChoice" onChange="submitForm('detailForm', true, {'event':'changeRefreshChoice'})"
                  selectedValueBinding="refreshChoice@servletRequest">
              <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest" value="15"/>
              <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest" value="-1"/>
            </uix:choice>
          </uix:cellFormat>
        </uix:rowLayout>
        
	<uix:rowLayout>
          <uix:stackLayout>
            <uix:header textBinding="header@consDetailBean@servletRequest" >

	        <!-- refresh time and button -->
                <uix:tableLayout width="100%">
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat>
                      <uix:switcher childNameBinding="showTime@consDetailBean@servletRequest">
                        <uix:case name="true">
                          <uix:rowLayout hAlign="right">
                            <uix:cellFormat>
                              <%@ include file="/database/instance/refreshTime.jspf" %>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
	
                <uix:subTabLayout>

		  <!-- General/Activity/Statistics tabs -->
                  <uix:subTabs>
                    <uix:subTabBar selectedIndex="0">
                      <uix:link textBinding="generalTabHeader@consDetailBean@servletRequest"
                        destinationBinding="genDest@servletRequest"/>
                      <uix:link textBinding="ACTIVITY@DBMsgBundle@servletRequest"
                        destinationBinding="actDest@servletRequest"
                        renderedBinding="renderActivityTab@servletRequest"/>
                      <uix:link textBinding="ALL_SESS_LINK@DBMsgBundle@servletRequest"
                        destinationBinding="statDest@servletRequest"/>
                    </uix:subTabBar>
                  </uix:subTabs>

		  <!-- Running Instance List -->
                  <uix:labeledFieldLayout labelWidth="15%">
                    <uix:messageStyledText
                        promptBinding="serviceLabel@consDetailBean@servletRequest"
                        textBinding="prettyService@consDetailBean@servletRequest"
                        styleClass="OraDataText"/>
                    <uix:messageStyledText
                        promptBinding="instListLabel@consDetailBean@servletRequest"
                        textBinding="instList@consDetailBean@servletRequest"
                        styleClass="OraDataText"
                        renderedBinding="renderInstList@consDetailBean@servletRequest"/>
                  </uix:labeledFieldLayout>

		  <!-- Pie Chart -->
		  <oem:chart titleBinding="pieHeaderText@consDetailBean@servletRequest"
		             chartType="pieChart"
			     width="200"
			     height="150"
			     pieValuesInLegend="percent"
			     legendPosition="east"
			     showSlicePercentLabels="true"
			     hideZeroSlices="true"
			     legendVisible="external"
			     externalLegendOrientation="vertical">
			<oem:boundChartDataSource chartDataSourceBinding="pieDataSource@pieChart@consDetailBean@servletRequest"/>
			<oem:imageMap imageMapDataSourceBinding="imageMap@pieChart@consDetailBean@servletRequest"/>
			<oem:chartColumn isKey="true"
			     displayLabel="Label 1"
			     sourceIndex="0" />
			<oem:chartColumn displayLabel="Label 2"
			     itemColor="blue"
			     sourceIndex="1"/>
		  </oem:chart>

		  <uix:header textBinding="generalTabHeader@consDetailBean@servletRequest">

                  <uix:tableLayout width="100%">

		  <!-- View choice dropdown -->
                  <uix:rowLayout hAlign="left">
                    <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraInstructionText"
                        textBinding="VIEW_DETAIL@DBMsgBundle@servletRequest" 
			labeledNodeId="viewChoice"/>
                    <uix:choice name="viewChoice" id="viewChoice" onChange="submitForm('detailForm', true, {'event':'changeViewChoice'})"
                        selectedValueBinding="viewChoice@dataSourceBean@servletRequest">
                      <uix:option textBinding="activeLabel@dataSourceBean@servletRequest"
                        value="1"/>
                      <uix:option textBinding="enabledLabel@dataSourceBean@servletRequest"
                        value="2"/>
                    </uix:choice>
                    </uix:cellFormat>
                  </uix:rowLayout>

		  <!-- Add consumer button -->
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat hAlign="right">
       		    <uix:submitButton textBinding="statAggrLabel@dataSourceBean@servletRequest" name="event" value="statAggrAdmin"/>
                    </uix:cellFormat>
                  </uix:rowLayout>

		  <!-- Hgrid Table -->
                  <uix:rowLayout>
		        <%@ include file="hgrid_table.jspf" %>	
		   </uix:rowLayout>

		  </uix:tableLayout>
		 </uix:header>

                 <uix:header textBinding="RELATED_LINKS@DBMsgBundle@servletRequest">
                   <uix:link textBinding="SERVICE_ADMIN_LINKTEXT@TopConsumersMsgBundle@servletRequest"
                             destinationBinding="serviceAdminURL@servletRequest"/>
                 </uix:header>
		</uix:subTabLayout>
	       </uix:header>
            </uix:stackLayout>
          </uix:rowLayout>
        </uix:tableLayout>

     </db:form>
    </uix:pageLayout>
   </uix:body>
  </uix:document>
</uix:renderingContext> 
