<%-- 
 * Copyright (c) 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *        consDetailStats.jsp 
 *
 *      NOTES
 *        Consumer Detail Statistics tab
 *       
 * MODIFIED
 *    kmckeen    11/30/06 - Fix oac/ui issues
 *    kmckeen    10/10/06 - Fix pageNum value - should be 3
 *    kmckeen    07/07/06 - Update to include Activity tab.
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>

<!-- ================  Consumer Detail Statistics tab =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>  

<uix:document>    
  <%@ include file="/enablePPR.jspf" %>    
  <%@ include file="/oemTitle.jspf" %>    

    <uix:body>    
      <uix:pageLayout>      
       <%@ include file="/database/global.jspf" %>      

       <!-- set html refresh -->
      <uix:switcher childNameBinding="refreshChoice@servletRequest">        
        <uix:case name="15">          
	  <uix:rawText>            
	    <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoice") %>" >          
	  </uix:rawText>        
	</uix:case>      
      </uix:switcher>      

      <db:form name="consStatForm" destinationBinding="consDetailDest@servletRequest" copyParams="target,type,pageKey">      
        <uix:formValue name="service" valueBinding="service@consDetailBean@servletRequest"/>      
        <uix:formValue name="module" valueBinding="module@consDetailBean@servletRequest"/>      
        <uix:formValue name="action" valueBinding="action@consDetailBean@servletRequest"/>      
        <uix:formValue name="client" valueBinding="client@consDetailBean@servletRequest"/>      
	<uix:formValue name="pageNum" value="3"/>        

	<oem:messageBox messageType="info" errorTableBinding="info@servletRequest"                             msgBundleBinding="DBMsgBundle"                             titleTextKey="titleText" mainTextKey="mainText"/>        
	<oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"                             msgBundleBinding="DBMsgBundle"                             titleTextKey="titleText" mainTextKey="mainText"/>        

	<uix:tableLayout width="100%">          

	  <!-- refresh choice dropdown -->
	  <uix:rowLayout hAlign="right">            
	    <uix:cellFormat>              
	      <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
	      labeledNodeId="refreshChoice"/>              
	      <uix:spacer width="5"/>              
	      <uix:choice name="refreshChoice" id="refreshChoice" onChange="submitForm('consStatForm', true, {'event':'changeRefreshChoice'})" selectedValueBinding="refreshChoice@consDetailBean@servletRequest">                
	        <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest" value="15"/>                
	        <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest" value="-1" />              
	       </uix:choice>            
	    </uix:cellFormat>          
	  </uix:rowLayout>          

	  <uix:rowLayout>            
	   <uix:stackLayout>                  
	     <uix:header textBinding="header@consDetailBean@servletRequest" >                
	      <uix:tableLayout width="100%">                  

	      <!-- refresh time and button -->
	      <uix:rowLayout hAlign="right">                    
	        <uix:cellFormat>                      
		  <uix:switcher childNameBinding="showTime@consDetailBean@servletRequest">                        
		   <uix:case name="true">                          
		     <uix:rowLayout hAlign="right">                            
		      <uix:cellFormat>                              
		      <%@ include file="/database/instance/refreshTime.jspf" %>                             
		      </uix:cellFormat>                          
		      </uix:rowLayout>                        
		   </uix:case>                      
		 </uix:switcher>                    
		 </uix:cellFormat>                  
	      </uix:rowLayout>                  

	      
	      </uix:tableLayout>                

	      <uix:switcher childNameBinding="hasGeneralTab@servletRequest">		  
	      <uix:case name="true">
	      <!-- General/Activity/Statistics tabs -->
	      <uix:subTabLayout>                  
	        <uix:subTabs>                    
		<uix:subTabBar selectedIndex="2">                      
		  <uix:link textBinding="generalTabHeader@consDetailBean@servletRequest" destinationBinding="genDest@servletRequest"/>                      
          <uix:link textBinding="ACTIVITY@DBMsgBundle@servletRequest" destinationBinding="actDest@servletRequest" renderedBinding="renderActivityTab@servletRequest"/>
		  <uix:link textBinding="ALL_SESS_LINK@DBMsgBundle@servletRequest" destinationBinding="statDest@servletRequest"/>                    
		 </uix:subTabBar>                  
		</uix:subTabs>                                  

	        <uix:tableLayout width="100%">                  

		<!-- stat data table -->
		<uix:rowLayout width="100%">                    
		  <uix:switcher childNameBinding="node@consDetailBean@servletRequest">                      
		    <uix:case name="okNode">                        
		      <oem:table name="statisticsTable" beanKey="dataSourceBean" 
		              formSubmitted="true"                            
			      dataSourceProp="twoDUIDataSource" 
			      width="100%"                            
			      alternateTextBinding="noStatText@consDetailBean@servletRequest"                            
			      blockSize="25" 
                              summaryBinding="header@consDetailBean@servletRequest" 
			      partialRenderMode="self">                        
		      </oem:table>                      
		    </uix:case>                      
		   </uix:switcher>                  
		 </uix:rowLayout>                
	         </uix:tableLayout>                  

		 </uix:subTabLayout>              
		</uix:case>

		<!-- Stat only page -->
		<uix:case name="false">
	        <uix:tableLayout width="100%">                  

		<!-- stat data table -->
		<uix:rowLayout width="100%">                    
		  <uix:switcher childNameBinding="node@consDetailBean@servletRequest">                      
		    <uix:case name="okNode">                        
		      <oem:table name="statisticsTable" beanKey="dataSourceBean" 
		              formSubmitted="true"                            
			      dataSourceProp="twoDUIDataSource" 
			      width="100%"                            
			      alternateTextBinding="noStatText@consDetailBean@servletRequest"                            
			      blockSize="25" 
			      summaryBinding="header@consDetailBean@servletRequest" 
			      partialRenderMode="self">                        
		      </oem:table>                      
		    </uix:case>                      
		   </uix:switcher>                  
		 </uix:rowLayout>                
	         </uix:tableLayout>                  

		</uix:case>
           </uix:switcher>

	  </uix:header>            
	 </uix:stackLayout>          
	</uix:rowLayout>        
      </uix:tableLayout>               
     </db:form>      
    </uix:pageLayout>    
   </uix:body>  
  </uix:document>
</uix:renderingContext> 




