<%-- 
 * Copyright (c) 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *        overview.jsp 
 *
 *      NOTES
 *        Top consumers Overview tab page. The other top consumers tabs pages
 *        are defined in other files (topConsumers.jsp and topSessions10i.jsp).
 *       
 * MODIFIED
 *    kmckeen    11/30/06 - Fix oac/ui issues
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>

<!-- ================  Top Consumers Overview Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
      <%@ include file="/oemGlobal.jspf" %>

      <uix:switcher childNameBinding="refreshChoice@servletRequest">
        <uix:case name="15">
          <uix:rawText>
            <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoice") %>" >
          </uix:rawText>
        </uix:case>
      </uix:switcher>

      <db:form name="overviewForm" destinationBinding="overviewDest@servletRequest" copyParams="target,type">

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout width="100%">
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>

          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:styledText styleClass="OraInstructionText"
                            textBinding="VIEW_DATA@DBMsgBundle@servletRequest"
			    labeledNodeId="refreshChoice" />
              <uix:spacer width="5"/>
              <uix:choice name="refreshChoice" id="refreshChoice" onChange="submitForm('overviewForm', true, {'event':'changeRefreshChoice'})"
                selectedValueBinding="refreshChoice@racOverviewBean@servletRequest">
                <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                        value="15"/>
                <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                        value="-1"/>
              </uix:choice>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:stackLayout>
            </uix:stackLayout>
          </uix:rowLayout>
        </uix:tableLayout>
    
             <uix:header textBinding="header@racOverviewBean@servletRequest" > 

                <uix:tableLayout width="100%">

                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat>
                      <uix:switcher childNameBinding="showTime@racOverviewBean@servletRequest">
                        <uix:case name="true">
                          <uix:rowLayout hAlign="right">
                            <uix:cellFormat>
                              <%@ include file="/database/instance/refreshTime.jspf" %>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>


             <uix:subTabLayout>
                  <uix:subTabs>
                    <uix:subTabBar selectedIndex="0">
                      <uix:link textBinding="OVERVIEW@DBMsgBundle@servletRequest"
                        destinationBinding="overviewDest@servletRequest"/>
                      <uix:link textBinding="TOP_SERVICES@DBMsgBundle@servletRequest"
                        destinationBinding="topServicesDest@servletRequest"/>
                      <uix:link textBinding="TOP_SM@DBMsgBundle@servletRequest"
                        destinationBinding="topSMDest@servletRequest"/>
                      <uix:link textBinding="TOP_SMA@DBMsgBundle@servletRequest"
                        destinationBinding="topSMADest@servletRequest"/>
                      <uix:link textBinding="TOP_CLIENTS@DBMsgBundle@servletRequest"
                        destinationBinding="topClientsDest@servletRequest"/>
                      <uix:link textBinding="TOP_SESSIONS_HEADER@DBMsgBundle@servletRequest"
                        destinationBinding="topSessionsDest@servletRequest"/>
                    </uix:subTabBar>
                  </uix:subTabs>
            
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:cellFormat vAlign="top" hAlign="left">

    <oem:chart titleBinding="TOP_SERVICES@DBMsgBundle@servletRequest"
        chartType="pieChart"
        width="150"
        height="150"
        pieValuesInLegend="percent"
        legendPosition="south"
        showSlicePercentLabels="true"
        hideZeroSlices="true"
	legendVisible="external"
        externalLegendOrientation="vertical">
        <oem:boundChartDataSource
            chartDataSourceBinding="pieDataSource@racTopServicesPie@racOverviewBean@servletRequest"/>
        <oem:imageMap
                imageMapDataSourceBinding="imageMap@racTopServicesPie@racOverviewBean@servletRequest"/>
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabel="Label 2"
            itemColor="blue"
            sourceIndex="1"/>
    </oem:chart>
    </uix:cellFormat>

    <uix:cellFormat vAlign="top" hAlign="left">
    <oem:chart titleBinding="TOP_MODULES_BY_SERVICE@TopConsumersMsgBundle@servletRequest"
        chartType="pieChart"
        width="300"
        height="150"
        pieValuesInLegend="percent"
        legendPosition="south"
        showSlicePercentLabels="true"
        hideZeroSlices="true"
	legendVisible="external"
        externalLegendOrientation="vertical">
        <oem:boundChartDataSource
            chartDataSourceBinding="pieDataSource@racTopSMPie@racOverviewBean@servletRequest"/>
        <oem:imageMap
                imageMapDataSourceBinding="imageMap@racTopSMPie@racOverviewBean@servletRequest"/>
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabel="Label 2"
            itemColor="blue"
            sourceIndex="1"/>
    </oem:chart>
    </uix:cellFormat>
   </uix:rowLayout>
   <uix:rowLayout>
    <uix:cellFormat vAlign="top" hAlign="left">

   <oem:chart titleBinding="TOP_CLIENTS@DBMsgBundle@servletRequest"
        chartType="pieChart"
        width="150"
        height="150"
        pieValuesInLegend="percent"
        legendPosition="south"
        showSlicePercentLabels="true"
        hideZeroSlices="true"
        legendVisible="external"
        externalLegendOrientation="vertical">
        <oem:boundChartDataSource
            chartDataSourceBinding="pieDataSource@racTopClientsPie@racOverviewBean@servletRequest"/>
        <oem:imageMap
                imageMapDataSourceBinding="imageMap@racTopClientsPie@racOverviewBean@servletRequest"/>
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabel="Label 2"
            itemColor="blue"
            sourceIndex="1"/>
    </oem:chart>
   </uix:cellFormat>
   <uix:cellFormat vAlign="top" hAlign="left">
   <oem:chart titleBinding="TOP_ACTIONS_BY_MODULE_BY_SERVICE@TopConsumersMsgBundle@servletRequest"
        chartType="pieChart"
        width="300"
        height="150"
        pieValuesInLegend="percent"
        legendPosition="south"
        showSlicePercentLabels="true"
        hideZeroSlices="true"
        legendVisible="external"
        externalLegendOrientation="vertical">
        <oem:boundChartDataSource
            chartDataSourceBinding="pieDataSource@racTopSMAPie@racOverviewBean@servletRequest"/>
        <oem:imageMap
                imageMapDataSourceBinding="imageMap@racTopSMAPie@racOverviewBean@servletRequest"/>
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabel="Label 2"
            itemColor="blue"
            sourceIndex="1"/>
    </oem:chart>
   </uix:cellFormat>
   </uix:rowLayout>
  </uix:tableLayout>
  <uix:spacer height="10"/>
  </uix:subTabLayout>
  </uix:header>
        
       </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
  
