<%-- 
 * Copyright (c) 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *        topConsumer.jsp 
 *
 *      NOTES
 *        Top consumers tabs page - contains tabs for these top consumers types: 
 *        Top Services, Top Modules, Top Actions, and Top Clients.  Note that
 *        the Overview and the Top Sessions tab pages are defined in other jsp 
 *        files (overview.jsp and topSessions10i.jsp respectively).
 *       
 * MODIFIED
 *    kmckeen    11/30/06 - Fix oac/ui issues
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>

<!-- ================  Generic Top Consumers Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
  
 <uix:document> 
  <%@ include file="/enablePPR.jspf" %>
  <%@ include file="/oemTitle.jspf" %>

  <uix:body>
   <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

      <!-- set page refresh -->
      <uix:switcher childNameBinding="refreshChoice@servletRequest">
        <uix:case name="15">
          <uix:rawText>
            <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoice") %>" >
          </uix:rawText>
        </uix:case>
      </uix:switcher>

    <db:form name="topConsForm" method="POST" destinationBinding="topConsDest@servletRequest" copyParams="target,type,pageKey"> 

        <!-- message boxes -->
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>


      <uix:tableLayout width="100%">

        <!-- Refresh Choice drop-down -->
        <uix:rowLayout hAlign="right">
          <uix:cellFormat>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="VIEW_DATA@DBMsgBundle@servletRequest"
			    labeledNodeId="refreshChoice" />
            <uix:spacer width="5"/>
            <uix:choice name="refreshChoice" id="refreshChoice" onChange="submitForm('topConsForm', true, {'event':'changeRefreshChoice'})"
                  selectedValueBinding="refreshChoice@dataSourceBean@servletRequest">
              <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest" value="15"/>
              <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest" value="-1"/>
            </uix:choice>
          </uix:cellFormat>
        </uix:rowLayout>

	<uix:rowLayout>
          <uix:stackLayout>

             <uix:header textBinding="header@dataSourceBean@servletRequest" > 

	        <!-- refresh time label/button -->
                <uix:tableLayout width="100%">
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat>
                      <uix:switcher childNameBinding="showTime@dataSourceBean@servletRequest">
                        <uix:case name="true">
                          <uix:rowLayout hAlign="right">
                            <uix:cellFormat>
                              <%@ include file="/database/instance/refreshTime.jspf" %>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>
                </uix:tableLayout>


                <!-- Tabs -->
                <uix:subTabLayout>
                  <uix:subTabs>
                    <uix:subTabBar selectedIndexBinding="selectedTab@servletRequest">
                      <uix:link textBinding="OVERVIEW@DBMsgBundle@servletRequest"
                        destinationBinding="overviewDest@servletRequest"/>
                      <uix:link textBinding="TOP_SERVICES@DBMsgBundle@servletRequest"
                        destinationBinding="topServicesDest@servletRequest"/>
                      <uix:link textBinding="TOP_SM@DBMsgBundle@servletRequest"
                        destinationBinding="topSMDest@servletRequest"/>
                      <uix:link textBinding="TOP_SMA@DBMsgBundle@servletRequest"
                        destinationBinding="topSMADest@servletRequest"/>
                      <uix:link textBinding="TOP_CLIENTS@DBMsgBundle@servletRequest"
                        destinationBinding="topClientsDest@servletRequest"/>
                      <uix:link textBinding="TOP_SESSIONS_HEADER@DBMsgBundle@servletRequest"
                        destinationBinding="topSessionsDest@servletRequest"/>
                    </uix:subTabBar>
                  </uix:subTabs>



                  <uix:tableLayout width="100%">

                    <uix:rowLayout>
                     <uix:spacer height="10"/>
                    </uix:rowLayout>

		  <!-- View choice dropdown -->
                  <uix:rowLayout hAlign="left">
                    <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraInstructionText"
                        textBinding="VIEW_DETAIL@DBMsgBundle@servletRequest" 
			labeledNodeId="viewChoice"/>
                    <uix:choice name="viewChoice" id="viewChoice" onChange="submitForm('topConsForm', true, {'event':'changeViewChoice'})"
                        selectedValueBinding="viewChoice@dataSourceBean@servletRequest">
                      <uix:option textBinding="activeLabel@dataSourceBean@servletRequest" value="1"/>
                      <uix:option textBinding="enabledLabel@dataSourceBean@servletRequest" value="2"/>
                    </uix:choice>
                    </uix:cellFormat>
                  </uix:rowLayout>

		  <!-- add consumer button -->
	          <uix:switcher childNameBinding="showStatAggrButtons@dataSourceBean@servletRequest">
                    <uix:case name="true">
		      <uix:rowLayout hAlign="right">
		        <uix:cellFormat hAlign="right">
			  <uix:submitButton textBinding="statAggrLabel@dataSourceBean@servletRequest" name="event" value="statAggrAdmin"/>
			</uix:cellFormat>
		      </uix:rowLayout>
        	    </uix:case>
		  </uix:switcher>

		  <!-- Hgrid Table -->
                     <uix:rowLayout>
		        <%@ include file="hgrid_table.jspf" %>		      
		     </uix:rowLayout>
		   </uix:tableLayout>
                   <uix:spacer height="10"/>
		 </uix:subTabLayout>

	       </uix:header>
            </uix:stackLayout>
          </uix:rowLayout>
        </uix:tableLayout>

     </db:form>
    </uix:pageLayout>
   </uix:body>
  </uix:document>
</uix:renderingContext> 
