<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        drillDown.jsp 
 *
 *      NOTES
 *        tbd
 *       
 * MODIFIED
 *    pboopath   02/28/08 - fix refresh issues
 *    pboopath   11/21/06 - SVG in IE(5663821)
 *    pboopath   11/16/06 - Bug 5663821
 *    ezeng      09/14/06 - 
 *    kmckeen    05/17/06 - Change refresh attribute
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

      <uix:switcher childNameBinding="manualSelected@servletRequest">
        <uix:case name="false">
          <uix:rawText rendered="true">
             <meta http-equiv="Cache-Control" content="max-age=0" >
              <meta http-equiv="Refresh" content="15"/>
          </uix:rawText>
        </uix:case>
      </uix:switcher>

  <uix:document> 
    <!--    <%@ include file="/enablePPR.jspf" %> -->
    <%@ include file="/oemTitle.jspf" %>  

    <uix:body>
      <uix:switcher childNameBinding="showWarning@servletRequest">
        <uix:case name="true">
          <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                          errorTableBinding="msgBox@servletRequest"
                          destTableBinding="msgUrls@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:case>
      </uix:switcher>

          <db:form name="racDrilldowns" method="post" destination="/em/console/rac/racDrillDowns"
                   copyParams="target,type,transferType">
            <uix:formValue name="drillDown" valueBinding="drillDown@racHealthBean@servletRequest"/>
            <uix:formValue name="viewChoice" valueBinding="viewChoice@racHealthBean@servletRequest" />
            <uix:formValue name="excludeSys" valueBinding="excludeSys@servletRequest" />

            <uix:pageLayout>
              <%@ include file="/database/global.jspf" %>

              <uix:header textBinding="drillDownTitle@servletRequest">

                <!-- ============== show update time =========== -->
                <uix:switcher childNameBinding="isChart@servletRequest">
                  <uix:case name="false">
                    <uix:tableLayout width="100%" >
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left">
                          <uix:rowLayout>
                            <uix:switcher childNameBinding="drillDown@racHealthBean@servletRequest">
                              <uix:case name="libraryCache">
                                <uix:styledText styleClass="OraTipText"
                                                textBinding="GES_HEADER@racMsgBundle@servletRequest"/>
                              </uix:case>
                              <uix:case name="rowCache">
                                <uix:styledText styleClass="OraTipText"
                                                textBinding="GES_HEADER@racMsgBundle@servletRequest"/>
                              </uix:case>
                            </uix:switcher>
                          </uix:rowLayout>
                        </uix:cellFormat>
                        <%@ include file="../refreshTime.jspf" %>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:case>
                </uix:switcher>

                <uix:switcher childNameBinding="drillDown@racHealthBean@servletRequest">
                  <uix:case name="segStats">
                    <uix:stackLayout>
                    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="SEGMENT_STATS_INTRO_TEXT@racMsgBundle@servletRequest" />
                      <uix:spacer height="5" />
                    <uix:tableLayout width="100%" >
                      <uix:rowLayout>
                        <!-- top by -->
                        <uix:cellFormat hAlign="left">
                          <uix:flowLayout>
                            <uix:styledText styleClass="OraInstructionText"
                                            labeledNodeId="topById"
                                            textBinding="TOP_BY@racMsgBundle@servletRequest" />
                            <uix:choice name="topBy" id="topById"
                                        shortDescBinding="TOP_BY@racMsgBundle@servletRequest" 
                                        onChange="submitForm('racDrilldowns', true, {'event':'topBy'})" 
                                        selectedValueBinding="topBy@racHealthBean@servletRequest">
                              <uix:option textBinding="CURRATIO@racMsgBundle@servletRequest"
                                          value="curBlkReq"/>
                              <uix:option textBinding="CRRATIO@racMsgBundle@servletRequest"
                                          value="crBlkReq" />
                              <uix:option textBinding="BUFBUSY@racMsgBundle@servletRequest"
                                          value="bufBusy" />
                              <uix:option textBinding="PHYSICAL@racMsgBundle@servletRequest"
                                          value="phyReads" />
                              <uix:option textBinding="LOGICAL@racMsgBundle@servletRequest"
                                          value="logReads" />
                              <uix:option textBinding="ROWLCKWAITS@racMsgBundle@servletRequest"
                                          value="rowLckWaits" />
                            </uix:choice>
                          </uix:flowLayout>
                        </uix:cellFormat>
                        <!-- view instance -->
                        <uix:cellFormat>
                          <uix:flowLayout>
                            <uix:messagePrompt promptBinding="VIEW_INSTANCE@racMsgBundle@servletRequest" 
                                               labeledNodeId="instanceFilterID" />
                            <uix:choice name="instanceFilter" id="instanceFilterID"
                                        selectedValueBinding="instanceFilter@racHealthBean@servletRequest" 
                                        onChange="submitForm('racDrilldowns', true, {'event':'filterInstance'})">
                              <uix:contents childDataBinding="instanceFilterList@racHealthBean@servletRequest">
                                <uix:option textBinding="text" valueBinding="value" />
                              </uix:contents>
                            </uix:choice>  
                          </uix:flowLayout>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right">
                          <uix:flowLayout>
                            <uix:styledText styleClass="OraFieldText" 
                                            textBinding="VIEW_DATA@DBMsgBundle@servletRequest" labeledNodeId="refreshChoice"/>
                            <uix:choice name="refreshChoice" id="refreshChoice"
                                        shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                                        onChange="submitForm('racDrilldowns', true, {'event':'doLoad'})"> 
                              <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                          value="15"/>
                              <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                          value="-1" selectedBinding="manualSelected@servletRequest"/>
                            </uix:choice>
                          </uix:flowLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>

                      <uix:spacer height="5" />

                    <uix:checkBox
                      name="excludeSys"
                      checkedBinding="excludeSys@racHealthBean@servletRequest"
                      textBinding="EXCLUDE_SYS@racMsgBundle@servletRequest"
                      shortDescBinding="EXCLUDE_SYS@racMsgBundle@servletRequest"
                    onClick="submitForm('racDrilldowns', true, {'event':'excludeSys'})" />
                    </uix:stackLayout>
                  </uix:case>
                  <uix:case name="cacheTransfer">
                    <uix:stackLayout>
                    <uix:spacer height="5" />
                      <uix:styledText styleClass="OraPromptText" 
                                      textBinding="CACHE_TRANSFER_INTRO_TEXT@racMsgBundle@servletRequest" />

                      <uix:spacer height="5" />

                    <uix:tableLayout width="100%" >
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left">
                          <uix:flowLayout>
                            <uix:messagePrompt promptBinding="VIEW_LOCAL_INSTANCE@racMsgBundle@servletRequest" 
                                               labeledNodeId="localInstanceFilterID" />
                            <uix:choice name="localInstance" id="localInstanceFilterID"
                                        shortDescBinding="VIEW_LOCAL_INSTANCE@racMsgBundle@servletRequest"
                                        selectedValueBinding="localInstanceFilter@racHealthBean@servletRequest" 
                                        onChange="submitForm('racDrilldowns', true, {'event':'filterLocalInstance'})">
                              <uix:contents childDataBinding="localInstanceFilterList@racHealthBean@servletRequest">
                                <uix:option textBinding="text" valueBinding="value" />
                              </uix:contents>
                            </uix:choice>  
                          </uix:flowLayout>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right">
                          <uix:flowLayout>
                            <uix:styledText styleClass="OraFieldText" 
                                            textBinding="VIEW_DATA@DBMsgBundle@servletRequest" labeledNodeId="refreshChoice"/>
                            <uix:choice name="refreshChoice" id="refreshChoice"
                                        shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                                        onChange="submitForm('racDrilldowns', true, {'event':'doLoad'})"> 
                              <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                          value="15"/>
                              <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                          value="-1" selectedBinding="manualSelected@servletRequest"/>
                            </uix:choice>
                          </uix:flowLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                    </uix:stackLayout>
                  </uix:case>
                  <uix:default>
                    <uix:tableLayout width="100%">
                      <uix:rowLayout hAlign="right">
                      <uix:cellFormat>
                          <uix:flowLayout>
                            <uix:styledText styleClass="OraFieldText" 
                                            textBinding="VIEW_DATA@DBMsgBundle@servletRequest" labeledNodeId="refreshChoice"/>
                            <uix:choice name="refreshChoice" id="refreshChoice"
                                        shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                                        onChange="submitForm('racDrilldowns', true, {'event':'doLoad'})"> 
                              <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                          value="15"/>
                              <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                          value="-1" selectedBinding="manualSelected@servletRequest"/>
                            </uix:choice>
                          </uix:flowLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:default>
                </uix:switcher>

                <uix:spacer height="5" />

                <uix:switcher childNameBinding="drillDown@racHealthBean@servletRequest">
                  <uix:case name="libraryCache">
                    <%@ include file="libraryCacheByInst.jspf" %>
                  </uix:case>
                  <uix:case name="rowCache">
                    <%@ include file="rowCacheByInst.jspf" %>
                  </uix:case>
                  <uix:case name="totalTransfer">
                    <%@ include file="totalTransferByInst.jspf" %>
                  </uix:case>
                  <uix:case name="cacheConvert">
                    <%@ include file="cacheConvertByInst.jspf" %>
                  </uix:case>
                  <uix:case name="curBlkRequest">
                    <%@ include file="curBlkRequestByInst.jspf" %>
                  </uix:case>
                  <uix:case name="CRBlkRequest">
                    <%@ include file="CRBlkRequestByInst.jspf" %>
                  </uix:case>
                  <uix:case name="segStats">
                    <%@ include file="segStatsByInst.jspf" %>
                  </uix:case>
                  <uix:case name="cacheTransfer">
                    <%@ include file="cacheTransferByInst.jspf" %>
                  </uix:case>
                  <uix:default>
                    <uix:stackLayout>
                      <uix:switcher childNameBinding ="useSVG@servletRequest">
                        <uix:case name="false">
                          <oem:chart 
                            chartType="timeSeriesChart"
                            width="800" 
                            height="120"
                            orientation="vertical"
                            fill="cumulative"  
                            timeGranularity="SECOND"
                            legendPosition="south" 
                            yAxisLabelBinding="detailsYAxisLabel@servletRequest">
                            <uix:contents>
                              <oem:boundChartDataSource 
                                chartDataSourceBinding="coherencyDetailChart@servletRequest"/>
                              <oem:chartColumn 
                                isKey="true" 
                                displayLabel="Target" 
                                sourceIndex="0"/> 
                              <oem:chartColumn
                                isTimeColumn="true"
                                displayLabel="Date" 
                                sourceIndex="1"  />
                              <oem:chartColumn
                                displayLabel=""
                                sourceIndex="2" />    
                              <oem:imageMap imageMapDataSourceBinding="instImageMap@servletRequest"/>                       
                            </uix:contents>
                          </oem:chart>
                        </uix:case>
                        <uix:case name="true">
                          <db:lineGraph dataSrcKeyBinding="coherencyDetailChart@servletRequest" 
                                         windowWidth="900"
                                         windowHeight="130" viewportWidth="100%" viewportHeight="130"
                                         stacked="true"  
                                         hideXLabels="false"
                                         preserveAspectRatio="false"  
                                         updateIntervalBinding="refreshChoice@servletRequest"
                                         legendPos="south"/>  
                        </uix:case>
                      </uix:switcher>
                      <!-- scalability -->
                      <uix:switcher childNameBinding ="showCustomize@servletRequest">
                        <uix:case name="true">
                          <uix:header textBinding="CUSTOMIZATION_HEADER@racMsgBundle@servletRequest"> 
                            <uix:flowLayout>
                              <uix:styledText styleClass="OraPromptText" 
                                              textBinding="introText@servletRequest" />

                            </uix:flowLayout>
                            <%@ include file="instList.jspf" %>  
                          </uix:header>
                        </uix:case>
                      </uix:switcher>
                    </uix:stackLayout>

                  </uix:default>
                </uix:switcher>
              </uix:header>
              
              <!-- ===== OK Button ====== -->
              <%--
                <uix:contentFooter>
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="OK_BUTTON@racMsgBundle@servletRequest" name="event" value="cancel" />
                  </uix:pageButtonBar>
                </uix:contentFooter>
                --%>

            </uix:pageLayout>
          </db:form>
        </uix:body>

    </uix:document> 
  </uix:renderingContext> 





  
