<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 


  <uix:switcher childNameBinding="needRefresh@servletRequest">
    <uix:case name="true">
      <uix:rawText>
        <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoice") %>; URL=<%=request.getAttribute("HORefreshURL") %>"        
        </uix:rawText>
      </uix:case>
    </uix:switcher>

    <uix:document> 
      <%@ include file="/oemTitle.jspf" %>  

      <uix:body>
            <uix:form name="perfForm" method="get" destination="/em/console/rac/racHealth">
              
              <uix:formValue name="target" valueBinding="targetName@racHealthBean@servletRequest"/>
              <uix:formValue name="type" valueBinding="targetType@racHealthBean@servletRequest"/>
              <uix:formValue name="excludeSys" valueBinding="excludeSys@servletRequest"/>

              <uix:pageLayout>
                <%@ include file="/database/global.jspf" %>

                <uix:header textBinding="header@racHealthBean@servletRequest">

                  <!-- ============== show update time =========== -->
                  <uix:tableLayout width="100%" >
                    <uix:rowLayout>
                      <%@ include file="../refreshTime.jspf" %>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <uix:spacer height="5" />

                <uix:tableLayout width="100%" >
                  <uix:rowLayout>
                  <uix:switcher childNameBinding="advanced@servletRequest">
                    <uix:case name="false">
                    <uix:cellFormat hAlign="left">
                        <uix:flowLayout>
                          <uix:contents childDataBinding="viewChoices@racHealthBean@servletRequest">
                            <uix:radioButton name="viewChoice"
                                             textBinding="text"
                                             valueBinding="val"
                                             onClick="submitForm('perfForm', true, {'event':'doLoad'})"
                                             selectedValueBinding="viewChoice@racHealthBean@servletRequest" />
                          </uix:contents>
                        </uix:flowLayout>
                    </uix:cellFormat>
                    </uix:case>
                  </uix:switcher>
                    <uix:cellFormat hAlign="right">
                      <uix:flowLayout>
                        <uix:styledText styleClass="OraFieldText" 
                                        textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                                        labeledNodeId="refreshChoice"/>
                        <uix:choice name="refreshChoice" id="refreshChoice"
                                    shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                                    onChange="submitForm('perfForm', true, {'event':'doLoad'})"> 

                          <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                      value="15"/>
                          <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                      value="-1" selectedBinding="manualSelected@servletRequest"/>
                        </uix:choice>
                      </uix:flowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

                  <uix:switcher childNameBinding="advanced@servletRequest">
                    <uix:case name="false">
                      <uix:stackLayout>
                        <uix:switcher childNameBinding="viewChoice@racHealthBean@servletRequest">
                          <uix:case name="TABLE">
                  <uix:switcher childNameBinding ="isGt10@servletRequest">
                    <uix:case name="true">
                      <uix:stackLayout>
                      <uix:tableLayout width="100%" cellSpacing="5">
                        <!-- ================ Cache current block request --============ -->
                        <uix:cellFormat vAlign="top" >
                          <%@ include file="curBlk.jspf" %>                        
                        </uix:cellFormat>
                        <!-- ================ Cache cr block request --============ -->
                        <uix:cellFormat vAlign="top">
                          <%@ include file="crBlk.jspf" %>                        
                        <!-- ================ Total Transfer --============ -->
                        <uix:cellFormat vAlign="top">
                          <%@ include file="blkStats.jspf" %>                        
                        </uix:cellFormat>
                        </uix:cellFormat>
        	 		</uix:tableLayout>

                            <%--
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraInstructionText"
                                      labeledNodeId="topById"
                                      textBinding="TOP_BY@racMsgBundle@servletRequest" />
                      <uix:choice name="topBy" id="topById"
                                  shortDescBinding="TOP_BY@racMsgBundle@servletRequest" 
                                  onChange="submitForm('perfForm', true, {'event':'topBy'})" 
                                  selectedValueBinding="segStatsTopBy@servletRequest">
                        <uix:option textBinding="CURRATIO@racMsgBundle@servletRequest"
                                    value="cureBlkReq"/>
                        <uix:option textBinding="CRRATIO@racMsgBundle@servletRequest"
                                    value="crBlkReq" />
                        <uix:option textBinding="BUFBUSY@racMsgBundle@servletRequest"
                                    value="bufBusy" />
                        <uix:option textBinding="PHYSICAL@racMsgBundle@servletRequest"
                                    value="phyReads" />
                        <uix:option textBinding="LOGICAL@racMsgBundle@servletRequest"
                                    value="logReads" />
                       <uix:option textBinding="ROWLCKWAITS@racMsgBundle@servletRequest"
                                    value="rowLckWaits" />
                      </uix:choice>
                    </uix:flowLayout>
                              --%>

                     </uix:stackLayout>
                    </uix:case>
                    <uix:case name="false">
                      <uix:stackLayout>
                      <uix:tableLayout width="100%" cellSpacing="5">
                        <!-- ================ Cache current block request --============ -->
                        <uix:cellFormat vAlign="top" width="50%">
                          <%@ include file="curBlk.jspf" %>                        
                        </uix:cellFormat>

                        <!-- ================ Cache cr block request --============ -->
                        <uix:cellFormat vAlign="top" width="50%">
                          <%@ include file="crBlk.jspf" %>                        
                        </uix:cellFormat>
                      </uix:tableLayout>
                      <uix:tableLayout width="100%" cellSpacing="5">
                        <!-- ================ Total Transfer --============ -->
                        <uix:cellFormat vAlign="top" width="50%">
                          <%@ include file="blkStats.jspf" %>                        
                        </uix:cellFormat>
                        <!-- ================ Cache Convert --============ -->
                        <uix:cellFormat vAlign="top" width="50%">
                          <%@ include file="getsCnvts.jspf" %>                        
                        </uix:cellFormat>
                      </uix:tableLayout>
                      </uix:stackLayout>
                    </uix:case>
                  </uix:switcher>
                          </uix:case>
                          <uix:case name="CHART">
                            <uix:stackLayout>
                              <uix:spacer height="5"/>
                            <uix:styledText styleClass="OraPromptText" 
                                            textBinding="CCC_INTRO_TEXT@racMsgBundle@servletRequest" />
                              <uix:spacer height="10"/>

                  <uix:switcher childNameBinding ="useSVG@servletRequest">
                    <uix:case name="false">
                      <uix:stackLayout>

                    <uix:header textBinding="chart3_header@servletRequest"> 
                      <oem:chart 
                        chartType="timeSeriesChart"
                        width="800" 
                        height="120"
                        orientation="vertical"
                        fill="cumulative"  
                        timeGranularity="SECOND"
                        legendPosition="east" 
                        yAxisLabelBinding="chart3_ylabel@servletRequest"   
                        yAxisWidth="50"
                        legendVisible="external"
                        criticalThreshold="20"
                        noDataMessage="No data">
                        <uix:contents>
                          <oem:boundChartDataSource 
                            chartDataSourceBinding="coherencyChart3@servletRequest"/>
                          <oem:chartColumn 
                            isKey="true" 
                            displayLabel="Target" 
                            sourceIndex="0"/> 
                          <oem:chartColumn
                            isTimeColumn="true"
                            displayLabel="Date" 
                            sourceIndex="1"  />
                          <oem:chartColumn
                            displayLabel=""
                            sourceIndex="2" />                          
                          <oem:imageMap imageMapDataSourceBinding="chart3ImageMap@servletRequest"/> 
                        </uix:contents>
                      </oem:chart>
                    </uix:header>
                    <uix:header textBinding="chart2_header@servletRequest"> 
                      <oem:chart 
                        chartType="timeSeriesChart"
                        width="800" 
                        height="120"
                        orientation="vertical"
                        timeGranularity="SECOND"
                        legendPosition="east" 
                        fill="cumulative"  
                        yAxisLabelBinding="chart2_ylabel@servletRequest"   
                        yAxisWidth="50"
                        legendVisible="external"
                        noDataMessage="No data">
                        <uix:contents>
                          <oem:boundChartDataSource 
                            chartDataSourceBinding="coherencyChart2@servletRequest"/>
                          <oem:chartColumn 
                            isKey="true" 
                            displayLabel="Target" 
                            sourceIndex="0"/> 
                          <oem:chartColumn
                            isTimeColumn="true"
                            displayLabel="Date" 
                            sourceIndex="1"  />
                          <oem:chartColumn
                            displayLabel=""
                            sourceIndex="2" />                          
                          <oem:imageMap imageMapDataSourceBinding="chart2ImageMap@servletRequest"/> 
                        </uix:contents>
                      </oem:chart>
                    </uix:header>
                    <uix:header textBinding="chart1_header@servletRequest"> 
                      <oem:chart 
                        chartType="timeSeriesChart"
                        width="800" 
                        height="120"
                        orientation="vertical"
                        timeGranularity="SECOND"
                        legendPosition="east" 
                        yAxisLabelBinding="chart1_ylabel@servletRequest"   
                        yAxisWidth="50"
                        fill="cumulative"  
                        legendVisible="external"
                        noDataMessage="No data">
                        <uix:contents>
                          <oem:boundChartDataSource 
                            chartDataSourceBinding="coherencyChart1@servletRequest"/>
                          <oem:chartColumn 
                            isKey="true" 
                            displayLabel="Target" 
                            sourceIndex="0"/> 
                          <oem:chartColumn
                            isTimeColumn="true"
                            displayLabel="Date" 
                            sourceIndex="1"  />
                          <oem:chartColumn
                            displayLabel=""
                            sourceIndex="2" />                          
                          <oem:imageMap imageMapDataSourceBinding="chart1ImageMap@servletRequest"/> 
                        </uix:contents>
                      </oem:chart>
                    </uix:header>

                      </uix:stackLayout>
                    </uix:case>
                    <uix:case name="true">
                      <db:lineGraph dataSrcKeyBinding="svgcoherencyChart@servletRequest" 
                                     windowWidth="900"
                                     windowHeight="130,130,130" viewportWidth="100%" viewportHeight="390"
                                     stacked="true,true,true"  
                                     hideXLabels="false,false,false"
                                     preserveAspectRatio="false"  
                                     updateIntervalBinding="refreshChoice@servletRequest"
                                     legendPos="east"/>  
                    </uix:case>
                  </uix:switcher>
                            </uix:stackLayout>
                          </uix:case>
                        </uix:switcher>

                      <uix:tip textBinding="CCC_TIP_TEXT@racMsgBundle@servletRequest"/>

                      </uix:stackLayout>
                    </uix:case>
                    <uix:case name="true">

                  <!-- ================library cache lock tables -->
                  <uix:tableLayout width ="100%" >
                    <uix:rowLayout vAlign="top">              
                      <uix:cellFormat vAlign = "top" width="80%">                           
                        <uix:header 
                          textBinding="TOP_5_LIBRARY_CACHE_LOCK_HEADER@racMsgBundle@servletRequest">
                          <uix:stackLayout>
                            <oem:table name="topLibCacheLockDS" 
                                       summaryBinding="TOP_5_LIBRARY_CACHE_LOCK_HEADER@racMsgBundle@servletRequest"
                                       formSubmitted="true"                           
                                       destination="/em/console/rac/racHealth"                            
                                       beanKey="racHealthBean"                           
                                       dataSourceProp="topLibCacheLockDS"                           
                                       alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest" >
                            </oem:table>     
                            <uix:spacer height="5" />
                            <uix:flowLayout>
                              <uix:styledText styleClass="OraFieldText" 
                                              textBinding="VIEW_DATA@DBMsgBundle@servletRequest" />
                              <uix:spacer width="5" />
                              <uix:link textBinding="BY_INSTANCE@racMsgBundle@servletRequest"
                                        destinationBinding="libCacheLockByInstURL@racHealthBean@servletRequest"/>
                            </uix:flowLayout>

                          </uix:stackLayout>
                        </uix:header>
                      </uix:cellFormat>
                    </uix:rowLayout>

                      <!-- ================row cache lock tables -->
                     <uix:rowLayout>
                      <uix:cellFormat vAlign = "top" width="80%">                           
                        <uix:header 
                          textBinding="TOP_5_ROW_CACHE_LOCK_HEADER@racMsgBundle@servletRequest">
                          <uix:stackLayout>
                            <oem:table name="topRowCacheLockDS" 
                           summaryBinding="TOP_5_ROW_CACHE_LOCK_HEADER@racMsgBundle@servletRequest"
                                       formSubmitted="true"                           
                                       destination="/em/console/rac/racHealth"                            
                                       beanKey="racHealthBean"                           
                                       dataSourceProp="topRowCacheLockDS"                           
                                       alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest" >
                            </oem:table>            
                            <uix:spacer height="5" />
                            <uix:flowLayout>
                              <uix:styledText styleClass="OraFieldText" 
                                              textBinding="VIEW_DATA@DBMsgBundle@servletRequest" />
                              <uix:spacer width="5" />
                              <uix:link textBinding="BY_INSTANCE@racMsgBundle@servletRequest"
                                        destinationBinding="rowCacheLockByInstURL@racHealthBean@servletRequest"/>
                            </uix:flowLayout>

                          </uix:stackLayout>
                        </uix:header>
                      </uix:cellFormat>
                    </uix:rowLayout> 
                  </uix:tableLayout>      
                    </uix:case>
                  </uix:switcher>

            <uix:header textBinding = "ADDITIONAL_LINKS@racMsgBundle@servletRequest">       
             <uix:link textBinding="RAC_INTRCONN_IP@DBMsgBundle@servletRequest"
                       destinationBinding="interconnDest@servletRequest" />
            </uix:header>
                  <%--
                  <uix:header textBinding="RELATED_LINKS@racMsgBundle@servletRequest">           
                    <uix:stackLayout>
                      <uix:link textBinding="TOP_SESSIONS@racMsgBundle@servletRequest" 
                                destinationBinding="topSessionsDest@racHealthBean@servletRequest" />
                      <uix:link textBinding="DATABASE_LOCKS@racMsgBundle@servletRequest" 
                                destinationBinding="locksDest@racHealthBean@servletRequest" />

                    </uix:stackLayout>
                  </uix:header>
                    --%>

                </uix:header>
                <uix:spacer height="5"/>

              </uix:pageLayout>

            </uix:form>
          </uix:body>
      </uix:document> 

    </uix:renderingContext> 





    
