<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        histActivity.jsp - Historical mode for Top Activity page.
 *
 *      NOTES
 *        The form name must be 'foo' because waitDetailsDropdown.jspf 
 *        which is used by each of the waitDetails*.jspf include files 
 *        calls submitForm with 'foo' as the form name.  This could be 
 *        made generic by changing the waitDetailsDropdown.jspf use of 
 *        submitForm to: submitForm(this.form, true, {'event':'changeTab'})
 *       
 * MODIFIED
 *    pboopath   05/05/08 - swf path change from database/flex to rac/flex
 *    kmckeen    04/22/08 - 
 *    gapadman   03/14/08 - enable historical 
 *    pboopath   02/24/08 - Top instances enabling
 *    pboopath   02/13/08 - Flex topactivity historical changes
 *    kmckeen    12/28/06 - Initial creation of module.
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rac.util.RacCustomization" %>

<uix:styleSheet/>

<script>
function scroll_timechart(direction)
{
  if (direction == 'prev'){
    document.foo.direction.value = '1';
  }
  else{
    document.foo.direction.value = '2';
  }
  submitForm('foo', true, {'event':'scrollChart'});
}
function my_goto_band(selIdx, startMS, endMS)
{
  submitForm('foo', true, {'event':'moveSlider','leftEdge':startMS,'rightEdge':endMS,'selectedBand':selIdx});
}  
function switchsql()
{
  submitForm('foo', true, {'event':'doLoad','pageNum':'2', 'datasource':'SQL'});
}  
function sliderOffLeft(param)
{
  location.href = param;
}
</script>

<%
response.setHeader("Pragma", "No-cache");
response.setHeader("Cache-Control", "no-cache");
%>

<uix:renderingContext id="renderingContext">

  <%-- For bundles used by waitDetailsSql.jspf --%>
  <uix:bundle name="DBObjectMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsg" class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form 
          name="foo" 
          method="get"
          destination="/em/console/rac/racHistActivity"
          copyParams="target,type,tabName,userIOTabName,datasource">

        <uix:formValue 
            name="waitClass"
            valueBinding="waitClass@waitDetailsBean@servletRequest"/>
        <uix:formValue name="leftEdge" />
        <uix:formValue name="rightEdge" />
        <uix:formValue name="event" />
        <uix:formValue name="direction" value=""/>
        <uix:formValue name="selectedBand" value=""/>

        <uix:pageLayout titleBinding="header@waitDetailsBean@servletRequest">

          <%@ include file="/database/global.jspf" %>

          <uix:messageBox 
              messageTypeBinding="exceptionType@errors@waitAreaChart@waitDetailsBean@servletRequest"
              messageBinding="exceptionText@errors@waitAreaChart@waitDetailsBean@servletRequest"
              renderedBinding="showErrors@waitAreaChart@waitDetailsBean@servletRequest"/>

          <oem:messageBox 
              messageType="error"
              errorTableBinding="errors@servletRequest"
              titleTextKey="titleText" 
              mainTextKey="mainText"/>

          <uix:tableLayout width="100%">
            <uix:rowLayout>

              <uix:cellFormat hAlign="left" vAlign="top" wrappingDisabled="true">
                <uix:flowLayout>
                <uix:styledText
                    styleClass="OraInstructionText"
                    labeledNodeId="activityAggregationId"
                    textBinding="ACTIVITY_AGGREGATION@racMsgBundle@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:choice
                    id="activityAggregationId"
                    name="aggregationChoice"
                    onChange="submitForm('foo', true, {'event':'updateAggregationChoice'})"
                    selectedValueBinding="aggregationChoiceSelected@servletRequest">
                  <uix:option
                      textBinding="INSTANCES@racMsgBundle@servletRequest"
                      value="<%= RacCustomization.AGGREGATION_BY_INSTANCES %>"/>
                  <uix:option
                      textBinding="SERVICES@DBMsgBundle@servletRequest"
                      value="<%= RacCustomization.AGGREGATION_BY_SERVICES %>"/>
                  <uix:option
                      textBinding="WAITS@DBMsgBundle@servletRequest"
                      value="<%= RacCustomization.AGGREGATION_BY_WAITS %>"/>
                </uix:choice>
                </uix:flowLayout>
              </uix:cellFormat>

              <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                <uix:messageChoice
                    promptBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                    name="refreshOption" 
                    id="refreshOption"
                    shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                    selectedValueBinding="refreshChoiceSelected@servletRequest" 
                    onChange="submitForm(document.forms[0], true, {'event':'switchRefreshOption'})">
                  <uix:option 
                      textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                      value="RT_15"/>
<%--
                  <uix:option 
                      textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest"
                      value="RT_60"/> 
--%>
                  <uix:option 
                      textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                      value="RT_MAN"/>
                  <uix:option 
                      textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                      value="HIST_CUST" 
                      selected="true"/>
                </uix:messageChoice>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:switcher childNameBinding="useSVG@waitDetailsBean@servletRequest">
            <uix:case name="true">
              <uix:tableLayout renderedBinding="showChart@waitDetailsBean@servletRequest">
                <uix:rowLayout hAlign="left">
                  <uix:messagePrompt promptBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="false">
              <uix:tableLayout renderedBinding="showChart@waitDetailsBean@servletRequest">
                <uix:rowLayout hAlign="left">
                  <uix:messagePrompt promptBinding="WAIT_DETAIL_GIF_TIP@DBMsgBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout> 
            </uix:case>
          </uix:switcher>

          <uix:stackLayout>
            <uix:switcher childNameBinding="showChart@waitDetailsBean@servletRequest">
              <uix:case name="true">
                
                <uix:switcher childNameBinding="useSVG@waitDetailsBean@servletRequest">
                  <uix:case name="true">
                    <db:flexRegion
                        swfName="/rac/flex/topActivity.swf"
                        optionsBinding="aggregationChoice@servletRequest"
                        dataSrcKeyBinding="flexKey@servletRequest"
                        windowHeight="250"
                        windowWidth="100%"
                        idBase="flexTopActivityHistChart"/>
                  </uix:case>
                  <uix:case name="false">
                    <oem:chart
                        chartType="timeSeriesChart"
                        width="850"
                        height="225"
                        timeGranularity="SECOND"
                        orientation="vertical"
                        fill="cumulative"
                        yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                        legendPosition="east"
                        legendVisible="external"
                        titleBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                        titleVisible="false"
                        seriesColorsAutomatic="true"
                        format="svg"
                        xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest"
                        xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest"
                        yAxisNumberFormatBinding="waitChartYAxisFormat@servletRequest"
                        axisMin="0"
                        axisMaxBinding="actualMaxValue@waitAreaChart@waitDetailsBean@servletRequest"
                        svgHighlightLegend="true"
                        svgTimebandTipBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest"
                        colorPaletteBinding="waitColorsTable@waitAreaChart@waitDetailsBean@servletRequest">
                      <uix:contents>
                        <oem:timeSelector
                            xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest"
                            xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest"
                            intervalTimeSecBinding="intervalTimeSec@servletRequest"
                            height="20"
                            selectedMaxDateBinding="selectedMaxDate@servletRequest"
                            selectedMinDateBinding="selectedMinDate@servletRequest"
                            numBandsSelectedBinding="numBandsSelected@servletRequest"
                            selectionDest="my_goto_band"
                            selectionDestType="JavaScript"
                            selectionAltTextBinding="SELECT_PERIOD_RANGE@DBMsgBundle@servletRequest"
                            position="south"
                            dynamicTimeSelector="true"
                            xAxisScrollDest="scroll_timechart"
                            xAxisScrollDestType="JavaScript"
                            xAxisScrollPrevBinding="scrollButtonsAvailable@waitAreaChart@waitDetailsBean@servletRequest"
                            xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsgBundle@servletRequest"
                            xAxisScrollNextBinding="scrollButtonsAvailable@waitAreaChart@waitDetailsBean@servletRequest"
                            xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsgBundle@servletRequest"
                            selectionIndicator="shading"
                            dynamicTimeSelectorColorBinding="sliderColor@waitAreaChart@waitDetailsBean@servletRequest"
                            dynamicTimeSelectorEdgeColorBinding="sliderEdgeColor@waitAreaChart@waitDetailsBean@servletRequest">
                        </oem:timeSelector>
                        <oem:boundChartDataSource 
                            dataClass="oracle.sysman.db.rac.RacHistActivityController"
                            dataMethod="updateChartData"/>
                        <oem:imageMap imageMapDataSourceBinding="legendLinks@waitAreaChart@waitDetailsBean@servletRequest"/>
                        <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                        <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                        <oem:chartColumn displayLabel="" sourceIndex="2"/>
                      </uix:contents>
                    </oem:chart>
                  </uix:case>
                </uix:switcher>
              </uix:case>
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:text textBinding="5001@ChartMsgBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>
          </uix:stackLayout>

          <uix:switcher childNameBinding="showDetails@servletRequest">
            <uix:case name="true">
              <uix:header size="1"
                  textBinding="detailIntervalHeader@waitDetailsBean@servletRequest"
                  renderedBinding="showChart@waitDetailsBean@servletRequest">
    
                <uix:tableLayout width="100%">
                  <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="left">
                      <uix:messageStyledText
                          promptBinding="SPOT_SQL_DETAIL_TEXT@DBMsgBundle@servletRequest"
                          styleClass="OraDataText"
                          textBinding="detailStartTime@waitDetailsBean@servletRequest"/>
                      <uix:cellFormat hAlign="right">
                        <uix:button
                            textBinding="ASH_REPORT@DBMsgBundle@servletRequest"
                            renderedBinding="showAshReportLink@servletRequest"
                            destinationBinding="ashReportLink@servletRequest"/>
                      </uix:cellFormat>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

                <uix:tableLayout width="100%">
                  <uix:rowLayout vAlign="top">
                    <%-- Top SQL table --%>
                    <uix:cellFormat hAlign="right" vAlign="top">
                      <%@ include file="/database/instance/waitevent/waitDetailsSql.jspf" %>
                    </uix:cellFormat>
                    <%-- Top others table --%>
                    <uix:cellFormat hAlign="left" vAlign="top">
                      <uix:switcher childNameBinding="tabIndex@servletRequest" >
                        <uix:case name="0">
                          <%@ include file="/database/instance/waitevent/waitDetailsSession.jspf" %>
                        </uix:case>
                        <uix:case name="3">
                          <%@ include file="/database/instance/waitevent/waitDetailsFileTab.jspf" %>
                        </uix:case>
                        <uix:case name="4">
                          <%@ include file="/database/instance/waitevent/waitDetailsIOObjTab.jspf" %>
                        </uix:case>
                        <uix:case name="5">
                          <%@ include file="/database/instance/waitevent/waitDetailsModuleTab.jspf" %>
                        </uix:case>
                        <uix:case name="6">
                          <%@ include file="/database/instance/waitevent/waitDetailsActionTab.jspf" %>
                        </uix:case>
                        <uix:case name="7">
                          <%@ include file="/database/instance/waitevent/waitDetailsServiceTab.jspf" %>
                        </uix:case>
                        <uix:case name="8">
                          <%@ include file="/database/instance/waitevent/waitDetailsClientTab.jspf" %>
                        </uix:case>
                        <uix:case name="9">
                          <%@ include file="/database/instance/waitevent/waitDetailsPlsqlTab.jspf" %>
                        </uix:case>

                        <uix:case name="10">
                          <%@ include file="/database/instance/waitevent/clusterDetailsInstanceHGrid.jspf" %>
                        </uix:case>

                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

              </uix:header>
            </uix:case>
          </uix:switcher>
          
      <uix:header textBinding="ADDITIONAL_LINKS@racMsgBundle@servletRequest">
       <uix:rowLayout>
       <uix:link textBinding="CCC_PAGE_TITLE@racMsgBundle@servletRequest"
                 destinationBinding="cccDest@servletRequest"/>
       </uix:rowLayout>
      </uix:header>          
          
        </uix:pageLayout> 
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
