<%-- 
 * Copyright (c) 2007, 2008, Oracle and/or its affiliates. All rights reserved.
 *
 * NAME
 *    segStatsHgrid.jsp 
 *
 * NOTES
 *    tbd
 *       
 * MODIFIED
 *    gapadman   09/22/08 - 
 *    rsamaved   08/11/08 - 
 *    gapadman   07/17/08 - 
 *    pboopath   02/28/08 - fix refresh issue 
--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

        <uix:switcher childNameBinding="manualSelected@servletRequest">
          <uix:case name="false">
              <uix:rawText rendered="true">
             <meta http-equiv="Cache-Control" content="max-age=0" >
             <meta http-equiv="Refresh" content="15">
              </uix:rawText>
            </uix:case>
         </uix:switcher>

    <uix:document> 
      <%@ include file="/oemTitle.jspf" %>  

      <uix:body>
        <db:form name="segForm" method="post" destination="/em/console/rac/racSegStats"
                 copyParams="target,type" >
          <uix:formValue name="target" valueBinding="targetName@racSegStatsBean@servletRequest"/>
          <uix:formValue name="type" valueBinding="targetType@racSegStatsBean@servletRequest"/>
          <uix:formValue name="excludeSys" valueBinding="excludeSys@servletRequest"/>

          <uix:pageLayout>
            <%@ include file="/database/global.jspf" %>

            <uix:header textBinding="TOP_SEGMENTS@racMsgBundle@servletRequest"/>

              <!-- ============== show update time =========== -->
              <uix:tableLayout width="100%" >
                <uix:rowLayout>
                  <%@ include file="../refreshTime.jspf" %>
                </uix:rowLayout>
              </uix:tableLayout>


              <uix:spacer height="5" />
            <uix:styledText styleClass="OraPromptText" 
                            textBinding="SEGMENT_STATS_INTRO_TEXT@racMsgBundle@servletRequest" />


              <uix:spacer height="5" />
                <uix:tableLayout width="100%" >
                  <uix:rowLayout>
                    <!-- top by -->
                    <uix:cellFormat hAlign="left">
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraInstructionText"
                                      labeledNodeId="topById"
                                      textBinding="TOP_BY@racMsgBundle@servletRequest" />
                      <uix:choice name="topBy" id="topById"
                                  onChange="submitForm('segForm', true, {'event':'topBy'})" 
                                  shortDescBinding="TOP_BY@racMsgBundle@servletRequest" 
                                  selectedValueBinding="topBy@racSegStatsBean@servletRequest">
                        <uix:option textBinding="CURRATIO@racMsgBundle@servletRequest"
                                    value="curBlkReq"/>
                        <uix:option textBinding="CRRATIO@racMsgBundle@servletRequest"
                                    value="crBlkReq" />
                        <uix:option textBinding="BUFBUSY@racMsgBundle@servletRequest"
                                    value="bufBusy" />
                        <uix:option textBinding="PHYSICAL@racMsgBundle@servletRequest"
                                    value="phyReads" />
                        <uix:option textBinding="LOGICAL@racMsgBundle@servletRequest"
                                    value="logReads" />
                       <uix:option textBinding="ROWLCKWAITS@racMsgBundle@servletRequest"
                                    value="rowLckWaits" />
                      </uix:choice>
                    </uix:flowLayout>
                    </uix:cellFormat>

                    <!-- view instance -->
                    <uix:cellFormat>
                      <uix:flowLayout>
                        <uix:messagePrompt promptBinding="VIEW_INSTANCE@racMsgBundle@servletRequest" 
                                 labeledNodeId="instanceFilterID" />
                        <uix:choice name="instanceFilter" id="instanceFilterID"
                                    shortDescBinding="VIEW_INSTANCE@racMsgBundle@servletRequest"
                                    selectedValueBinding="instanceFilter@racSegStatsBean@servletRequest" 
                                    onChange="submitForm('segForm', true, {'event':'filterInstance'})">
                          <uix:contents childDataBinding="instanceFilterList@racSegStatsBean@servletRequest">
                            <uix:option textBinding="text" valueBinding="value" />
                          </uix:contents>
                        </uix:choice>  
                      </uix:flowLayout>
                    </uix:cellFormat>

                    <uix:cellFormat hAlign="right">
                      <uix:flowLayout>
                        <uix:styledText styleClass="OraFieldText" 
                                        textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                                        labeledNodeId="refreshChoice"/>
                        <uix:choice name="refreshChoice" id="refreshChoice"
                                    shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                                    onChange="submitForm('segForm', true, {'event':'reload'})"> 
                          <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                      value="15"/>
                          <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                      value="-1" selectedBinding="manualSelected@servletRequest"/>
                        </uix:choice>
                      </uix:flowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

              <uix:spacer height="5" />
               <uix:checkBox
                    name="excludeSys"
                    checkedBinding="excludeSys@racSegStatsBean@servletRequest"
                    textBinding="EXCLUDE_SYS@racMsgBundle@servletRequest"
                    shortDescBinding="EXCLUDE_SYS@racMsgBundle@servletRequest"
                    onClick="submitForm('segForm', true, {'event':'excludeSys'})" />

              <uix:hGrid id="topSegHgrid"
                         width="100%"
                         alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
                         destinationBinding="destURI@servletRequest"
                         columnHeaderDataBinding="columnHeaderData@racSegStatsBean@servletRequest"
                         columnFormatsBinding="columnFormatData@racSegStatsBean@servletRequest"
                         treeDataBinding="treeData@racSegStatsBean@servletRequest"
                         formSubmitted="true"
                         proxyBinding="proxy@racSegStatsBean@servletRequest">

                <uix:nodeStamp>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="OBJNAME@racMsgBundle@servletRequest"/>
                    </uix:columnHeader>
                    <uix:styledText textBinding="objName" 
                                    destinationBinding="objectUrl"/> 
                  </uix:column>
                </uix:nodeStamp>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="headerName"
                                      sortableBinding="sort"
                                      valueBinding="sortIndex"/>
                </uix:columnHeaderStamp>

                <!-- set hgrid column data -->
                <uix:styledText textBinding="objType" />
                <uix:styledText textBinding="instName" destinationBinding="instUrl" />
                <uix:styledText textBinding="curBlkReq"/>
                <uix:styledText textBinding="crBlkReq" />
                <uix:styledText textBinding="bufBusy"/>
                <uix:styledText textBinding="phyReads"/>
                <uix:styledText textBinding="logReads"/>
                <uix:styledText textBinding="rowLckWaits"/>

                <uix:formValue name="uniqueID" valueBinding="uid" />
              </uix:hGrid>

    <uix:header textBinding="ADDITIONAL_LINKS@racMsgBundle@servletRequest">
       <uix:link textBinding="ACTIVITY_DETAILS@DBMsgBundle@servletRequest"
                 destinationBinding="topActivityDest@servletRequest"/>
      </uix:header>
      
            </uix:pageLayout>

        </db:form>
        </uix:body>
      </uix:document> 

    </uix:renderingContext> 

