<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>

      <uix:switcher childNameBinding="manualSelected@servletRequest">
        <uix:case name="false">
      <uix:rawText>
        <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoice") %>" >
        </uix:rawText>
        </uix:case>
      </uix:switcher>

    <uix:document> 
      <%@ include file="/oemTitle.jspf" %>  

      <uix:body>
            <uix:form name="perfForm" method="get" destinationBinding="refreshDest@servletRequest">
              <uix:formValue name="target" valueBinding="targetName@racSqlObjectBean@servletRequest"/>
              <uix:formValue name="type" valueBinding="targetType@racSqlObjectBean@servletRequest"/>

              <uix:pageLayout>
                <%@ include file="/database/global.jspf" %>

                <uix:header textBinding="header@racSqlObjectBean@servletRequest">

                  <!-- ============== show update time =========== -->
                  <uix:tableLayout width="100%" >
                    <uix:rowLayout>
                      <%@ include file="../../refreshTime.jspf" %>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <uix:spacer height="5" />

                <uix:tableLayout width="100%" >
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:flowLayout>
                        <uix:styledText styleClass="OraFieldText" 
                                        textBinding="VIEW_DATA@DBMsgBundle@servletRequest" labeledNodeId="refreshChoice"/>
                        <uix:choice name="refreshChoice" id="refreshChoice"
                                    onChange="submitForm('perfForm', true, {'event':'reload'})"> 

                          <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                      value="15"/>
                          <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                      value="-1" selectedBinding="manualSelected@servletRequest"/>
                        </uix:choice>
                      </uix:flowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

                  <uix:switcher childNameBinding="showSqlText@servletRequest">
                    <uix:case name="true">
                      <uix:header textBinding="TEXT@sqlMsg" >                  
                        <uix:tableLayout width="100%" cellSpacing="3">
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:spacer width="15" />
                            </uix:cellFormat > 
                            <uix:cellFormat hAlign="left">
                              <db:sqlDisplay sqlListBinding="sqlTexts@racSqlObjectBean@servletRequest"/>
                            </uix:cellFormat>
                          </uix:rowLayout>              
                        </uix:tableLayout>
                        <uix:spacer height="10"/>
                        <!-- ================sql list table -->
                        <uix:tableLayout width ="100%" >
                          <uix:rowLayout vAlign="top">              
                            <uix:cellFormat vAlign = "top" width="80%">                           
                                <oem:table name="sqlByInstDS" 
                                           formSubmitted="true"                           
                                           destination="/em/console/rac/racSqlObject"                            
                                           beanKey="racSqlObjectBean"                           
                                           dataSourceProp="sqlByInstDS"    
                                           blockSize="25"                        
                                           alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest" >
                                </oem:table>     
                          </uix:cellFormat>
                        </uix:rowLayout>

                      </uix:tableLayout>      
                    </uix:header>
                  </uix:case>
                  <uix:case name="false">
                    <oem:table name="sqlByInstDS" 
                               formSubmitted="true"                           
                               destination="/em/console/rac/racSqlObject"                            
                               beanKey="racSqlObjectBean"                           
                               dataSourceProp="sqlByInstDS"    
                               blockSize="25"                        
                               alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest" >
                    </oem:table>     
                  </uix:case>
                </uix:switcher>

                </uix:header>
                <uix:spacer height="5"/>

              </uix:pageLayout>

            </uix:form>
          </uix:body>
      </uix:document> 

    </uix:renderingContext> 





    
