<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        topActivity.jsp - Top Activity page.
 *
 *      NOTES
 *        The form name must be 'foo' because waitDetailsDropdown.jspf 
 *        which is used by each of the waitDetails*.jspf include files 
 *        calls submitForm with 'foo' as the form name.  This could be 
 *        made generic by changing the waitDetailsDropdown.jspf use of 
 *        submitForm to: submitForm(this.form, true, {'event':'changeTab'})
 *       
 * MODIFIED
 *    gapadman   09/22/08 - 
 *    rsamaved   08/11/08 - 
 *    gapadman   07/17/08 - 
 *    pboopath   05/05/08 - swf path change from database/flex to rac/flex
 *    pboopath   02/26/08 - removing ASH Report
 *    kmckeen    12/19/07 - Implmement Historical option
 *    kmckeen    11/13/07 - Bug 6499189 - fix breadcrumbs
 *    pboopath   10/12/07 - flex chart changes
 *    kmckeen    05/31/07 - Non-SVG Refresh meta tag needs params: seconds, url
 *    kmckeen    05/30/07 - Change legendVisible option from external to true
 *    gapadman   05/22/07 - comment out wc legends code
 *    gapadman   05/20/07 - Added additional oem table for wc legends
 *    kmckeen    01/16/07 - Add uix:bundle tags for enhanced waitDetailsSql
 *    kmckeen    12/22/06 - UI review - reduce chart width, fix no data issue
 *    kmckeen    10/16/06 - Add activity aggregation dropdown
 *    kmckeen    10/03/06 - Initial creation of module.
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rac.util.RacCustomization" %>

<uix:styleSheet/>

<script>
function scroll_timechart(direction)
{
  if (direction == 'prev'){
    document.foo.direction.value = '1';
  }
  else{
    document.foo.direction.value = '2';
  }
  submitForm('foo', true, {'event':'scrollChart'});
}
function my_goto_band(selIdx, startMS, endMS)
{
  submitForm('foo', true, {'event':'moveSlider','leftEdge':startMS,'rightEdge':endMS,'selectedBand':selIdx});
}
function switchsql()
{
  submitForm('foo', true, {'event':'doLoad','pageNum':'2', 'datasource':'SQL'});
}
function sliderOffLeft(param)
{
  location.href = param;
}
</script>

<%
response.setHeader("Pragma", "No-cache");
response.setHeader("Cache-Control", "no-cache");
%>

<uix:renderingContext id="renderingContext">

  <%-- For bundles used by waitDetailsSql.jspf --%>
  <uix:bundle name="DBObjectMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsg" class="oracle.sysman.db.rsc.inst.DBMsg"/>

<%--
  <uix:switcher childNameBinding="autoRefresh@servletRequest">
    <uix:case name="true">
      <uix:rawText rendered="true">
        <meta http-equiv="Cache-Control" content="max-age=0" >
        <meta http-equiv="Refresh" content="15; URL=<%=request.getAttribute("refreshDest") %>" >
      </uix:rawText> 
    </uix:case>  
  </uix:switcher>
--%>

  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form 
          name="foo"
          method="get"
          destination="/em/console/rac/racTopActivity"
          copyParams="target,type,datasource">

        <uix:formValue
            name="waitClass"
            valueBinding="waitClass@waitDetailsBean@servletRequest"/>
        <uix:formValue
            name="leftEdge"/>
        <uix:formValue
            name="rightEdge"/>
        <uix:formValue
            name="event"/>
        <uix:formValue
            name="direction"
            value=""/>
        <uix:formValue
            name="selectedBand"
            value=""/>

        <uix:pageLayout>

          <%@ include file="/database/global.jspf" %>

          <uix:header textBinding="ACTIVITY_DETAILS@DBMsgBundle@servletRequest">

            <uix:stackLayout>
            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" vAlign="top" wrappingDisabled="true">
                  <uix:flowLayout>
                  <uix:styledText
                      styleClass="OraInstructionText"
                      labeledNodeId="activityAggregationId"
                      textBinding="ACTIVITY_AGGREGATION@racMsgBundle@servletRequest"/>
                  <uix:spacer width="5"/>
                  <uix:choice
                      id="activityAggregationId"
                      name="aggregationChoice"
                      onChange="submitForm('foo', true, {'event':'updateAggregationChoice'})"
                      selectedValueBinding="aggregationChoiceSelected@servletRequest">
                    <uix:option
                        textBinding="INSTANCES@racMsgBundle@servletRequest"
                        value="<%= RacCustomization.AGGREGATION_BY_INSTANCES %>"/>
                    <uix:option
                        textBinding="SERVICES@DBMsgBundle@servletRequest"
                        value="<%= RacCustomization.AGGREGATION_BY_SERVICES %>"/>
                    <uix:option
                        textBinding="WAITS@DBMsgBundle@servletRequest"
                        value="<%= RacCustomization.AGGREGATION_BY_WAITS %>"/>
                  </uix:choice>
                  </uix:flowLayout>
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:flowLayout>
                  <uix:styledText
                      styleClass="OraInstructionText"
                      labeledNodeId="viewById"
                      textBinding="VIEW_DATA@DBMsgBundle@servletRequest"/>
                  <uix:spacer width="5"/>
                  <uix:choice
                      id="viewById"
                      name="refreshChoice"
                      onChange="submitForm('foo', true, {'event':'updateRefreshChoice'})"
                      selectedValueBinding="refreshChoiceSelected@servletRequest">
                    <uix:option
                        textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                        value="RT_15"/>
                    <uix:option
                        textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                        value="RT_MAN" />
                    <uix:option 
                        textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                        value="HIST_CUST"
                        renderedBinding="renderHistoricalOption@defaultBean@servletRequest"/>  
                  </uix:choice>
                  </uix:flowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>
            </uix:tableLayout>
            
            <uix:switcher childNameBinding="useSVG@waitDetailsBean@servletRequest">
              <uix:case name="true">
                <db:flexRegion
                    swfName="/rac/flex/topActivity.swf"
                    optionsBinding="aggregationChoice@servletRequest"
                    dataSrcKeyBinding="flexKey@servletRequest"
                    windowHeight="250"
                    windowWidth="100%"
                    idBase="flexRacTopActivityChart"/>
                </uix:case>
               <uix:case name="false">
                <oem:chart
                    chartType="timeSeriesChart" 
                    width="800" 
                    height="250" 
                    timeGranularity="SECOND"
                    orientation="vertical" 
                    fill="cumulative"
                    yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest" 
                    legendPosition="east" 
                    legendVisible="external"
                    titleBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                    titleVisible="false"
                    seriesColorsAutomatic="true"
                    format="svg" 
                    svgUpdateFrequencyBinding="svgUpdateRate@servletRequest"
                    xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest"
                    xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest"
                    yAxisWidth="30" 
                    yAxisNumberFormatBinding="waitChartYAxisFormat@servletRequest"
                    axisMin="0" 
                    axisMaxBinding="actualMaxValue@waitAreaChart@waitDetailsBean@servletRequest"
                    svgHighlightLegend="true"
                    svgTimebandTipBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest"
                    colorPaletteBinding="waitColorsTable@waitAreaChart@waitDetailsBean@servletRequest">
                  <uix:contents>
                    <oem:timeSelector 
                        xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest" 
                        xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest" 
                        intervalTimeSecBinding="intervalTimeSec@servletRequest" 
                        height="20" 
                        selectedMaxDateBinding="selectedMaxDate@servletRequest" 
                        selectedMinDateBinding="selectedMinDate@servletRequest" 
                        numBandsSelectedBinding="numBandsSelected@servletRequest" 
                        selectionDest="my_goto_band" 
                        selectionDestType="JavaScript" 
                        selectionAltTextBinding="SELECT_PERIOD_RANGE@DBMsgBundle@servletRequest" 
                        position="south" 
                        dynamicTimeSelector="true" 
                        xAxisScrollDest="scroll_timechart" 
                        xAxisScrollDestType="JavaScript" 
                        xAxisScrollPrevBinding="scrollButtonsAvailable@waitAreaChart@waitDetailsBean@servletRequest" 
                        xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsgBundle@servletRequest" 
                        xAxisScrollNextBinding="scrollButtonsAvailable@waitAreaChart@waitDetailsBean@servletRequest" 
                        xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsgBundle@servletRequest" 
                        selectionIndicator="shading" 
                        dynamicTimeSelectorColorBinding="sliderColor@waitAreaChart@waitDetailsBean@servletRequest" 
                        dynamicTimeSelectorEdgeColorBinding="sliderEdgeColor@waitAreaChart@waitDetailsBean@servletRequest"/>
                    <oem:boundChartDataSource 
                        dataClass="oracle.sysman.db.rac.RacTopActivityController" 
                        dataMethod="updateChartData"/>
                    <oem:imageMap 
                        imageMapDataSourceBinding="legendLinks@waitAreaChart@waitDetailsBean@servletRequest"/>
                    <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                    <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                    <oem:chartColumn displayLabel="" sourceIndex="2"/>
                  </uix:contents>
                </oem:chart>
            </uix:case>
           </uix:switcher>
<%--
            <uix:switcher childNameBinding="showWCLegend@waitAreaChart@waitDetailsBean@servletRequest">
              <uix:case name="false">
                    <oem:chart
                        chartType="timeSeriesChart" 
                        width="0" 
                        height="0" 
                        orientation="" 
                        yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest" 
                        legendPosition="east" 
                        legendVisible="external"
                        xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest"
                        xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest"
                        svgHighlightLegend="true"
                        externalLegendOrientation="horizontal"
                        colorPaletteBinding="waitClassColors@waitAreaChart@waitDetailsBean@servletRequest">
                      <uix:contents>
                        <oem:boundChartDataSource 
                            dataClass="oracle.sysman.db.rac.RacTopActivityController" 
                            dataMethod="updateChartData2"/>
                        <oem:imageMap 
                            imageMapDataSourceBinding="waitClassLegends@waitAreaChart@waitDetailsBean@servletRequest"/>
                        <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                        <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                        <oem:chartColumn displayLabel="" sourceIndex="2"/>
                      </uix:contents>
                    </oem:chart>
            </uix:case>
        </uix:switcher>
--%>             
            </uix:stackLayout>
          </uix:header>

            <uix:switcher childNameBinding="showDetails@servletRequest">
              <uix:case name="true">
                <uix:header size="1"
                    textBinding="detailIntervalHeader@waitDetailsBean@servletRequest"
                    renderedBinding="showChart@waitDetailsBean@servletRequest">

                  <uix:tableLayout width="100%">
                    <uix:rowLayout vAlign="top">
                      <uix:cellFormat hAlign="left">
                        <uix:messageStyledText
                            promptBinding="SPOT_SQL_DETAIL_TEXT@DBMsgBundle@servletRequest"
                            styleClass="OraDataText"
                            textBinding="detailStartTime@waitDetailsBean@servletRequest"/>
                        <%--<uix:cellFormat hAlign="right">
                          <uix:button
                              textBinding="ASH_REPORT@DBMsgBundle@servletRequest"
                              renderedBinding="showAshReportLink@servletRequest"
                              destinationBinding="ashReportLink@servletRequest"/>
                        </uix:cellFormat>--%>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <uix:tableLayout width="100%">
                    <uix:rowLayout vAlign="top">
                      <%-- Top SQL table --%>
                      <uix:cellFormat hAlign="right" vAlign="top">
                        <%@ include file="/database/instance/waitevent/waitDetailsSql.jspf" %>
                      </uix:cellFormat>
                      <%-- Top others table --%>
                      <uix:cellFormat hAlign="left" vAlign="top">
                        <uix:switcher childNameBinding="tabIndex@servletRequest" >
                          <uix:case name="0">
                            <%@ include file="/database/instance/waitevent/waitDetailsSession.jspf" %>
                          </uix:case>
                          <uix:case name="3">
                            <%@ include file="/database/instance/waitevent/waitDetailsFileTab.jspf" %>
                          </uix:case>
                          <uix:case name="4">
                            <%@ include file="/database/instance/waitevent/waitDetailsIOObjTab.jspf" %>
                          </uix:case>
                          <uix:case name="5">
                            <%@ include file="/database/instance/waitevent/waitDetailsModuleTab.jspf" %>
                          </uix:case>
                          <uix:case name="6">
                            <%@ include file="/database/instance/waitevent/waitDetailsActionTab.jspf" %>
                          </uix:case>
                          <uix:case name="7">
                            <%@ include file="/database/instance/waitevent/waitDetailsServiceTab.jspf" %>
                          </uix:case>
                          <uix:case name="8">
                            <%@ include file="/database/instance/waitevent/waitDetailsClientTab.jspf" %>
                          </uix:case>
                          <uix:case name="9">
                            <%@ include file="/database/instance/waitevent/waitDetailsPlsqlTab.jspf" %>
                          </uix:case>
                          <uix:case name="10">
                            <%@ include file="/database/instance/waitevent/clusterDetailsInstanceHGrid.jspf" %>
                          </uix:case>
                        </uix:switcher>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>

                </uix:header>
              </uix:case>
            </uix:switcher>

      <uix:header textBinding="ADDITIONAL_LINKS@racMsgBundle@servletRequest">
       <uix:rowLayout>
       <uix:link textBinding="TOP_SEGMENTS@racMsgBundle@servletRequest"
                 destinationBinding="topSegmentDest@servletRequest"
                 renderedBinding = "isNotHistorical@consDetailBean@servletRequest" />
       </uix:rowLayout>
       <uix:spacer height="3"/>
       <uix:rowLayout>
       <uix:link textBinding="CCC_PAGE_TITLE@racMsgBundle@servletRequest"
                 destinationBinding="cccDest@servletRequest"/>
       </uix:rowLayout>
       <uix:spacer height="3"/>
       <uix:rowLayout>
       <uix:link textBinding="IC_INTERCONNECTS@racMsgBundle@servletRequest"
                 destinationBinding="interConnectLink@servletRequest" 
                 renderedBinding = "isNotHistorical@consDetailBean@servletRequest" />
       </uix:rowLayout>       
      </uix:header>

        </uix:pageLayout> 
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
