<%-- 
 * Copyright (c) 2007, 2008, Oracle and/or its affiliates. All rights reserved.
 *
 *      NAME
 *        racCustPerfPage.jsp 
 *
 *      NOTES
 *        Page displayed after clicking Settings button.
 *       
 * MODIFIED
 *    gapadman   04/16/08 - bug 6506927
 *    kmckeen    07/19/07 - Add refreshChoice to copyParams
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/rac/racCustPerfPage"
      copyParams="target,type,refreshChoice">

    <uix:pageLayout titleBinding="header@customizeBean@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    

   <uix:messagePrompt promptBinding="PERF_PAGE_CUST_INSTR@RacMsgBundle@servletRequest" />


    <uix:header textBinding="DETAILED_CHART_SETTINGS@DBMsgBundle@servletRequest" >

      <uix:stackLayout>
        <uix:tableLayout> 
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="DEFAULT_TAB_SELECTION@DBMsgBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:spacer width="8"/>
            <uix:cellFormat hAlign="left" wrappingDisabled="true">
              <uix:radioButton name="tabSelection"
                selectedValueBinding="tabSelection@customizeBean@servletRequest"
                textBinding="THROUGHPUT_METRIC@DBMsgBundle@servletRequest"
                value="0"  />
              <uix:radioButton name="tabSelection"
                selectedValueBinding="tabSelection@customizeBean@servletRequest"
                textBinding="IO@DBMsgBundle@servletRequest"
                value="1"  />
              <uix:radioButton name="tabSelection"
                selectedValueBinding="tabSelection@customizeBean@servletRequest"
                textBinding="PARALLEL_EXECUTION@DBMsgBundle@servletRequest"
                value="2"  />
              <uix:radioButton name="tabSelection"
                selectedValueBinding="tabSelection@customizeBean@servletRequest"
                textBinding="SERVICES@DBMsgBundle@servletRequest"
                value="3"  />
              <uix:radioButton name="tabSelection"
                selectedValueBinding="tabSelection@customizeBean@servletRequest"
                textBinding="INSTANCES@RacMsgBundle@servletRequest"
                value="4"  />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="THROUGHPUT_TAB_SELECTION@DBMsgBundle@servletRequest"/>

            </uix:cellFormat>
            <uix:spacer width="8"/>
            <uix:cellFormat hAlign="left" wrappingDisabled="true">
              <uix:radioButton name="throughputTabSelection"
                selectedValueBinding="throughputTabSelection@customizeBean@servletRequest"
                textBinding="SP_PER_SECOND@DBMsgBundle@servletRequest"
                value="0"  />
              <uix:radioButton name="throughputTabSelection"
                selectedValueBinding="throughputTabSelection@customizeBean@servletRequest"
                textBinding="SP_PER_TRANSACTION@DBMsgBundle@servletRequest"
                value="1"  />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
                textBinding="IO_TAB_SELECTION@DBMsgBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:spacer width="8"/>
            <uix:cellFormat hAlign="left" wrappingDisabled="true">
              <uix:radioButton name="IOTabSelection"
                selectedValueBinding="IOTabSelection@customizeBean@servletRequest"
                textBinding="IO_FUNCTION@DBMsgBundle@servletRequest"
                value="0"  />
              <uix:radioButton name="IOTabSelection"
                selectedValueBinding="IOTabSelection@customizeBean@servletRequest"
                textBinding="IO_TYPE@DBMsgBundle@servletRequest"
                value="1"  />
              <uix:radioButton name="IOTabSelection"
                selectedValueBinding="IOTabSelection@customizeBean@servletRequest"
                textBinding="CONSUMER_GROUP2@DBMsgBundle@servletRequest"
                value="2"  />
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout> 
      </uix:stackLayout>
    </uix:header>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:submitButton textBinding="CANCEL@DBMsgBundle@servletRequest" 
                      name="event" 
                      value="cancel"/>
    <uix:submitButton textBinding="OK@DBMsgBundle@servletRequest" 
                      name="event" 
                      value="apply"/>
  </uix:pageButtonBar>
  </uix:pageButtons>
   
    </uix:pageLayout>
    </db:form> 
    </uix:body>

  </uix:document>
</uix:renderingContext>

