<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates. 
 * All rights reserved. 
 *
 *      NAME
 *        racDBProperties.jsp - To view RacDB properties page.
 *
 *      NOTES
 *          This jsp is to show the properties of rac database on 
 *          click of view properties from the rac home page.
 *       
 * MODIFIED
 *    pardutta    06/09/09 - Active Server count
 *    sksantha    04/24/09 - to hide wlm in 11.2
 *    sksantha    03/18/09 - To include QOS Status
 *    amahalin    01/28/09 - Database Vault xbranchMerge
 *    sksantha    12/22/08 - Bug 7655147 fix
 *    shasingh    08/21/08 - multiple server pool support
 *    vthondep    07/31/08 - 
 *    rsamaved    05/13/08 - 
 *    pboopath    05/05/08 - DBConfig type placed before masteragent
 *    pboopath    05/04/08 - Database configuration type changes
 *    gapadman    05/04/08 - enable wlm using emoms
 *    dchakumk    03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
 *                           st_emdbsa_11.1
 *    gapadman    02/18/08 - 
 *    shasingh    11/20/07 - XbranchMerge shasingh_11g_19509a_scan from main
 *    shasingh    07/15/07 - scan changes
 *    rsamaved    06/08/07 - bug 6121516
 *    gapadman    03/01/07 - Initial creation of module.
--%>
<%@ include file="/oemNoscript.jspf"%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="dvMsgs"
              class="oracle.sysman.db.rsc.sec.dv.DVMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    
    
    <uix:body>
<%--    
    <uix:switcher childNameBinding="changed@servletRequest">
      <uix:case name="true"> 
        <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                        errorTableBinding="msgBox@servletRequest"
                        destTableBinding="msgUrls@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>

      <uix:switcher childNameBinding="dbmsJobNotReady@servletRequest">
        <uix:case name="true">
          <oem:messageBox messageTypeBinding="DBMSJOBmessageType@servletRequest" 
                          errorTableBinding="DBMSJOBmsgBox@servletRequest"
                          destTableBinding="DBMSJOBmsgUrls@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:case>
      </uix:switcher>
--%>      
          
          <db:form name="alertsForm" method="post" destination="/console/rac/racDBProperties"
               copyParams="target,type">

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>

        <uix:header textBinding="header@racDBBean@servletRequest" 
                    icon="<%= request.getContextPath() + \"/images/database/rac/dbcluster.gif\" %>" >
        
      <uix:tableLayout width="100%" cellSpacing="5">
      <uix:rowLayout vAlign="top">
      <uix:stackLayout>
      <uix:rowLayout>
      <uix:cellFormat hAlign="center">
      <uix:borderLayout>
      <uix:tableLayout hAlign="left" width="100%">   
      
<uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" textBinding="CURRENT_STATUS@racMsgBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>

                              <%-- show availability as a link if the target is monitored
                                   and as normal text if it is not monitored --%>
                              <uix:cellFormat>
                                <uix:switcher childNameBinding="isTargetMonitored@servletRequest">
                                  <uix:case name="true">
                                    <oem:license>
                                    <uix:link destinationBinding="availDest@servletRequest"
                                              textBinding="trafficStatusStr@racDBBean@servletRequest"/>
                                    </oem:license>
                                  </uix:case>
                                  <uix:case name="false">
                                    <uix:styledText styleClass="OraDataText"
                                      textBinding="trafficStatusStr@racDBBean@servletRequest"/>
                                  </uix:case>
                                </uix:switcher>
                                <uix:spacer width="8"/>
                              </uix:cellFormat>                           
                            </uix:rowLayout>
                            
<uix:rowLayout>
                              <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
                                <uix:styledText styleClass="OraPromptText" 
                                                textBinding="INST_COMPONENTS@racMsgBundle@servletRequest" />
                              </uix:cellFormat>
                          <uix:switcher childNameBinding="isTargetMonitored@servletRequest">
                            <uix:case name="true">
                              <uix:spacer width="8"/>
                              <uix:cellFormat hAlign="left">
                                  <uix:link  renderedBinding="showInstanceCnt@racDBBean@servletRequest"
                                             textBinding="totalInstanceCount@racDBBean@servletRequest"
                                            destinationBinding="homePageURL@servletRequest"/>                              
                              <uix:spacer width="5"  renderedBinding="showInstanceCnt@racDBBean@servletRequest"/>
                              <uix:styledText styleClass="OraDataText" text="( "  renderedBinding="showInstanceCnt@racDBBean@servletRequest"/>
                                    
                              <uix:flowLayout renderedBinding="showUpInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="upInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="upStatusShortDesc@racDBBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="upInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showDownInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="downInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="downStatusShortDesc@racDBBean@servletRequest" />
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="downInstCount@racDBBean@servletRequest"/>
                                </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnreachableInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="unreachableInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="unreachableStatusShortDesc@racDBBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unreachableInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showErrorInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="errorInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="errorStatusShortDesc@racDBBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="errorInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showBlackoutInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="blackoutInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="blackoutStatusShortDesc@racDBBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="blackoutInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout>

                              
                              <uix:flowLayout renderedBinding="showAgentDownInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="agentDownInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="agentDownStatusShortDesc@racDBBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="agentDownInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout>

                              <uix:flowLayout renderedBinding="showUnknownInstCount@racDBBean@servletRequest">
                                <uix:image sourceBinding="unknownInstIconSource@racDBBean@servletRequest"
                                           shortDescBinding="unknownStatusShortDesc@racDBBean@servletRequest" />
                                <uix:spacer width="3"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="unknownInstCount@racDBBean@servletRequest"/>
                              </uix:flowLayout> 
                              <uix:styledText styleClass="OraDataText" text=" )"  renderedBinding="showInstanceCnt@racDBBean@servletRequest"/>
                              </uix:cellFormat>  
                             </uix:case>
                             <uix:case name="false">
                              <uix:spacer width="8"/>
                              <uix:cellFormat hAlign="left">
                              <uix:link  textBinding="totalInstanceCount@racDBBean@servletRequest"
                                         destination="#instances"/>
                              </uix:cellFormat>  
                             </uix:case>
                            </uix:switcher>
                            </uix:rowLayout>
                            
<%-- Availability cannot be shown if the target is not monitored --%>
<uix:switcher childNameBinding="isTargetMonitored@servletRequest">
  <uix:case name="true">
    <uix:rowLayout >
      <uix:cellFormat hAlign="right">
        <uix:styledText styleClass="OraPromptText"
          textBinding="AVAILABILITY@@DBMsgBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:spacer width="8"/>
        <uix:rowLayout>
          <oem:license>
          <uix:link textBinding="trafficAvailStr@racDBBean@servletRequest"
                    destinationBinding="availDest@servletRequest"/>
          </oem:license>
        </uix:rowLayout>
    </uix:rowLayout>
  </uix:case>
</uix:switcher>                            
                            
<uix:switcher childNameBinding="isTargetMonitored@servletRequest">
                              <uix:case name="true">
                                <uix:rowLayout>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:styledText styleClass="OraPromptText"
                                      text=""/>
                                  </uix:cellFormat>
                                  <uix:spacer width="8"/>
                                    <uix:rowLayout>
                                      <uix:styledText styleClass="OraInlineInfoText"
                                        text="(" />
                                      <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="LAST_DAY@SDKBundle@servletRequest" />
                                      <uix:styledText styleClass="OraInlineInfoText"
                                        text=")" />
                                    </uix:rowLayout>
                                </uix:rowLayout>
                              </uix:case>
                            </uix:switcher>                            
      
<%-- Cluster name, Timezone cannot be shown if the target is not monitored --%>
<uix:switcher childNameBinding="isTargetMonitored@servletRequest">
  <uix:case name="true">
    <uix:rowLayout >
      <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="CLUSTER_TYPE@racMsgBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:spacer width="8"/>
      <uix:link textBinding="clusterName@racDBBean@servletRequest" 
                destinationBinding="clusterDest@racDBBean@servletRequest" />
    </uix:rowLayout>
    </uix:case>
</uix:switcher>

<uix:rowLayout renderedBinding="isServiceCentric@racDBBean@servletRequest">
  <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
    <uix:styledText styleClass="OraPromptText" 
                    textBinding="SERVER_POOLS@racMsgBundle@servletRequest"/>
  </uix:cellFormat>
  <uix:spacer width="8"/>
  <uix:link textBinding="serverPoolsWithActiveServers@dbNPoolInfo@racDBBean@servletRequest"
            destinationBinding="serverPoolURL@racDBBean@servletRequest"
            shortDescBinding="SERVER_POOL_TOOL_TIP@racMsgBundle@servletRequest"/>
</uix:rowLayout>

<uix:rowLayout >
  <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
    <uix:styledText styleClass="OraPromptText" 
                    textBinding="DATABASE_NAME@racMsgBundle@servletRequest"/>
  </uix:cellFormat>
  <uix:spacer width="8"/>
  <uix:styledText styleClass="OraDataText" 
                  textBinding="dbName@racDBBean@servletRequest"/>
</uix:rowLayout>



<%-- OracleHome cannot be shown if the target is not monitored --%>
<uix:switcher childNameBinding="isTargetMonitored@servletRequest">
  <uix:case name="true">
    <uix:rowLayout >
      <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="ORACLE_HOME@DBMsgBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:spacer width="8"/>
      <uix:styledText styleClass="OraDataText" 
                      textBinding="oracleHome@racDBBean@servletRequest"/>
      <%-- 
      <uix:link destination="nowhere"
                textBinding="oracleHome@racDBBean@servletRequest"/>
        --%>
    </uix:rowLayout>
  </uix:case>
</uix:switcher>

<uix:rowLayout >
  <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
    <uix:styledText styleClass="OraPromptText" 
                    textBinding="VERSION@DBMsgBundle@servletRequest"/>
  </uix:cellFormat>
  <uix:spacer width="8"/>
  <uix:styledText styleClass="OraDataText" 
                  textBinding="dbVersion@racDBBean@servletRequest"/>
</uix:rowLayout>
<uix:switcher childNameBinding="isDisplayWLM@servletRequest">
<uix:case name="true">
<uix:rowLayout 
     renderedBinding="instanceVersion_gte11gR2@defaultBean@servletRequest">
  <uix:cellFormat hAlign="right">
    <uix:styledText styleClass="OraPromptText"
		textBinding="QOS_STATUS@racMsgBundle@servletRequest"/>
  </uix:cellFormat>
  <uix:spacer width="8"/>
	<uix:link textBinding="wlmQosStatus@defaultBean@servletRequest" 
		destinationBinding="qosStatusPage@servletRequest"/>
</uix:rowLayout> 
 </uix:case>
</uix:switcher>
<uix:rowLayout renderedBinding="databaseVaultNotInstalledOrNotConfigured@defaultBean@servletRequest">
        <uix:cellFormat hAlign="right" wrappingDisabled="true">
          <uix:styledText styleClass="OraPromptText"
                        textBinding="DATABASE_VAULT_STATUS_TEXT@dvMsgs"/>
    </uix:cellFormat>
        <uix:spacer width="8"/>
        <uix:switcher childNameBinding="dvstatus@defaultBean@servletRequest">
                 <uix:case name="-2">
                         <uix:link textBinding="STATUS_NOT_INSTALLED@dvMsgs"
                                destination="http://www.oracle.com/technology/deploy/security/database-security/database-vault/index.html"
                                targetFrame="_blank">
                        </uix:link>
                 </uix:case>
                 <uix:case name="-1">
                        <uix:link textBinding="STATUS_NOT_CONFIGURED@dvMsgs"
                        destination="http://www.oracle.com/technology/deploy/security/database-security/database-vault/index.html"
                        targetFrame="_blank">
                        </uix:link>
                 </uix:case>
     </uix:switcher>
     </uix:rowLayout>
         <uix:rowLayout renderedBinding="databaseVaultNotInstalledOrNotConfigured@defaultBean@servletRequest">
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraPromptText" text=""/>
                  </uix:cellFormat>
                  <uix:spacer width="8"/>
                  <uix:styledText styleClass="OraInlineInfoText"
                textBinding="NOT_INSTALLED_NOT_CONFIGURED_TIP@dvMsgs" />
      </uix:rowLayout>

<uix:rowLayout>
    <uix:styledText styleClass="OraPromptText" 
                    textBinding="DATABASE_CONFIG_TYPE@racMsgBundle@servletRequest"/>
  <uix:spacer width="8"/>
<uix:tableLayout>
  <uix:cellFormat hAlign="left" wrappingDisabled="true">
  <uix:switcher childNameBinding="isServiceCentric@racDBBean@servletRequest">
  <uix:case name="true"> 
      <uix:styledText styleClass="OraDataText" 
                      textBinding="SERVICE_CENTRIC@racMsgBundle@servletRequest"/>
  </uix:case> 
  <uix:case name="false"> 
      <uix:styledText styleClass="OraDataText" 
                      textBinding="DB_CENTRIC@racMsgBundle@servletRequest"/>
  </uix:case> 
  </uix:switcher>
  </uix:cellFormat>
  <%-- Refresh to trigger server pool config metric collection --%>
  <uix:cellFormat hAlign="left">
  	<uix:spacer width="8"/>
  	<uix:image shortDescBinding="REFRESH@SDKBundle@servletRequest"
            source="/em/images/refresh.gif" 
            destinationBinding="configMetricTriggerUrl@racDBBean@servletRequest"/>
  </uix:cellFormat>
</uix:tableLayout>
</uix:rowLayout>

<%-- WLM --%>
<%--
<uix:rowLayout renderedBinding="SHOW_WLM@servletRequest" >
  <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
    <uix:styledText styleClass="OraPromptText"
                    textBinding="APPQOS_PROP@racMsgBundle@servletRequest" />
  </uix:cellFormat>
  <uix:spacer width="8"/>
                                                                        
  <uix:cellFormat wrappingDisabled="true" hAlign="left"  >
    <db:link destination="/console/wlm/wlmRecommendation?event=doLoad"
              copyParams="target,type"
              textBinding="ARCHIVE_ENABLED@DBMsgBundle@servletRequest"/>
  </uix:cellFormat>
</uix:rowLayout>
--%>

<uix:switcher childNameBinding="isTargetMonitored@servletRequest">
  <uix:case name="true">
    <uix:rowLayout>
      <uix:cellFormat hAlign="right" wrappingDisabled="true">
        <uix:styledText styleClass="OraPromptText"
          textBinding="TIME_ZONE@@DBMsgBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:spacer width="8"/>
      <uix:rowLayout>
        <uix:styledText styleClass="OraDataText" textBinding="timeZone@racDBBean@servletRequest" />
      </uix:rowLayout>
    </uix:rowLayout>
  </uix:case>
</uix:switcher>
                            
<%--- SCAN INFO  
<uix:switcher childNameBinding="isTargetMonitored@servletRequest" renderedBinding="isScanDatabase@racDBBean@servletRequest">
  <uix:case name="true">
    <uix:rowLayout >
      <uix:cellFormat hAlign="right" wrappingDisabled="true">
	    <uix:styledText styleClass="OraPromptText"
	     textBinding="SCAN_NAME@racMsgBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:spacer width="8"/>
      <uix:rowLayout>
	   <uix:styledText styleClass="OraDataText" textBinding="scanName@scanInfo@racDBBean@servletRequest" />
      </uix:rowLayout>
    </uix:rowLayout>
  </uix:case>
</uix:switcher>
<uix:switcher childNameBinding="isTargetMonitored@servletRequest" renderedBinding="isScanDatabase@racDBBean@servletRequest">
  <uix:case name="true">
     <uix:rowLayout >
        <uix:cellFormat hAlign="right" wrappingDisabled="true">
	    <uix:styledText styleClass="OraPromptText"
	    textBinding="SCAN_PORT@racMsgBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:spacer width="8"/>
      <uix:rowLayout>
	    <uix:styledText styleClass="OraDataText" textBinding="scanPort@scanInfo@racDBBean@servletRequest" />
      </uix:rowLayout>
    </uix:rowLayout>
  </uix:case>
</uix:switcher>  
--%>

<uix:rowLayout >
  <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
    <uix:styledText styleClass="OraPromptText" 
                    textBinding="MASTER_AGENT_LABEL@racMsgBundle@servletRequest"/>
  </uix:cellFormat>
  <uix:spacer width="8"/>
    <uix:link destinationBinding="masterAgentURL@servletRequest"
              textBinding="masterAgentHost@servletRequest"/>  
              
</uix:rowLayout>

                            
                            
       </uix:tableLayout>             
      </uix:borderLayout>
      </uix:cellFormat>
      </uix:rowLayout>
      </uix:stackLayout>
      </uix:rowLayout>      
<uix:rowLayout >
  <uix:cellFormat hAlign="left"  vAlign="top"  wrappingDisabled="false">
<uix:tip  textBinding="MASTER_AGENT_TIP@racMsgBundle@servletRequest"/> 
    
  </uix:cellFormat>
</uix:rowLayout>  


                       
</uix:tableLayout>                    
         </uix:header> 
          
        </uix:pageLayout>
        
        </db:form>
    </uix:body>


  </uix:document>
</uix:renderingContext>
