<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates. 
 * All rights reserved. 
 *
 *      NAME
 *        racPerform.jsp 
 *
 *      NOTES
 *        Cluster database Performance tab.
 *       
 * MODIFIED
 *    ychan      03/10/09 - XbranchMerge ychan_bug-7646009 from
 *                          st_emdbgc_10.2.0.1.0
 *    ychan      01/03/09 - Add sql monitor link
 *    shasingh   12/22/08 - bug 7658666
 *    gapadman   09/26/08 - bug 7433768
 *    rsamaved   08/11/08 - 
 *    gapadman   07/17/08 - 
 *    pboopath   05/05/08 - swf path change from database/flex to rac/flex
 *    gapadman   04/16/08 - bug 6718384
 *    dchakumk   03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
 *                          st_emdbsa_11.1
 *    rsamaved   01/11/07 - XbranchMerge rsamaved_ui_review from main
 *    pboopath   02/23/08 - 
 *    kmckeen    03/02/07 - Implement Historical View Data option
 *    rsamaved   01/03/07 - change customize to settings
 *    rsamaved   12/28/06 - move tabs to a new jspf file
 *    kmckeen    12/28/06 - Remove Top Sessions link
 *    kmckeen    12/26/06 - Related links changes
 *    rsamaved   12/21/06 - add label for radio buttons
 *    rsamaved   12/19/06 - change io radio button positions
 *    rsamaved   12/11/06 - 
 *    kmckeen    11/30/06 - Fix oac/ui issues
 *    kmckeen    10/19/06 - Add Top Activity link
 *    pboopath   11/21/06 - SVG in IE(5663821)
 *    pboopath   11/16/06 - Bug 5663821
 *    kmckeen    10/12/06 - Remove space from windowHeight param
--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 
  
  <script>

function getMyApp(appName) {
        if (navigator.appName.indexOf ("Microsoft") !=-1) {
            return window[appName];
        } else {
            return document[appName];
        }
    }

 function resizeFlexHeight(height)
 {
   
   // getMyApp("flexracPerfChart").style.height=height;
document.getElementById('flexracPerfChartObjectId').style.height=height;
document.getElementById('flexracPerfChartEmbedId').style.height=height;

  //document.getElementById('flexPerfChartEmbedId').style.height=height;
  // window["flexPerChartObjectId"].style.height=height;
 }
</script>

     <uix:switcher childNameBinding ="useSVG@servletRequest">
          <uix:case name="false">
        <uix:switcher childNameBinding="manualSelected@servletRequest">
          <uix:case name="false">
              <uix:rawText>
              <meta http-equiv="Refresh" 
                  content="<%=request.getAttribute("refreshChoiceGIF")%>; URL=<%=request.getAttribute("RacPerformRefreshURL") %>" >
              </uix:rawText>
            </uix:case>
         </uix:switcher>
        </uix:case>
      </uix:switcher>

  <uix:document> 
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
          <uix:switcher childNameBinding="needConfigure@servletRequest">
            <uix:case name="true">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              destTableBinding="msgUrls@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
          </uix:switcher>

      <db:form name="perfForm" method="post" destination="/console/rac/racSitemap"
               copyParams="target,type">
        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>

        <uix:formValue name="pageNum" value="2" />
        <uix:formValue name="event"/>

          <uix:header textBinding="header@racDBBean@servletRequest"
                      iconBinding="dbImgPath@servletRequest" >

            <uix:contextSwitcher>
            <uix:switcher childNameBinding="showContextSwitcher@servletRequest">
              <uix:case name="true">
              <uix:flowLayout>
                  <uix:styledText styleClass="OraPromptText" 
                        textBinding="SWITCH_TOPOLOGY@racMsgBundle@servletRequest"/>  
                <oem:choice name="racdbChoice" id="racdbChoice"
                            shortDescBinding="SWITCH_TOPOLOGY@racMsgBundle@servletRequest"  
                            selectedValueBinding="racdb@servletRequest" 
                            optionsBinding="racdbList@servletRequest"
                            onChange="submitForm('perfForm', true, {'event':'switchRacDB','pageNum':'2'})"> 
                        </oem:choice>  
              </uix:flowLayout>        
              </uix:case>
            </uix:switcher>
          </uix:contextSwitcher>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndex="1">
                  <%@ include file="racTabs.jspf" %>
                </uix:subTabBar>
              </uix:subTabs>

              <uix:stackLayout>
              <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="left" vAlign="center"> 
                <uix:cellFormat hAlign="left">
                <uix:messagePrompt promptBinding="PERF_PAGE_INSTR@DBMsgBundle@servletRequest" />
                </uix:cellFormat>
                
                 <uix:cellFormat hAlign="right" vAlign="center">
                    
                 <uix:button textBinding="SETTINGS_WORD@DBMsgBundle@servletRequest"
                    renderedBinding="instanceVersion_gte11@defaultBean@servletRequest"
                    destinationBinding="customizeDest@servletRequest" 
                    shortDescBinding="SETTINGS_WORD@DBMsgBundle@servletRequest"/>  
                    
                    <uix:spacer width="20" />

                      <uix:styledText styleClass="OraFieldText" 
                                      textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                                      labeledNodeId="refreshChoice" />
                      <uix:choice name="refreshChoice" id="refreshChoice"
                                  shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                                  onChange="submitForm('perfForm', true, {'event':'doLoad','pageNum':'2'})"
                                  selectedValueBinding="refreshChoiceSelected@servletRequest"> 
                        <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                    value="RT_15"/>
                        <uix:option textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest"
                                    value="RT_60"/> 
                        <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                    value="RT_MAN"/>
                        <uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                                    value="HIST_CUST"
                                    renderedBinding="renderHistoricalOption@defaultBean@servletRequest"/>  
                      </uix:choice>
                  </uix:cellFormat>
              
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:tableLayout width="100%" renderedBinding="showCustomize@servletRequest"> 
                <uix:rowLayout>
	        </uix:rowLayout>
                <uix:rowLayout hAlign="right"> 
                     <uix:cellFormat>
                  <uix:submitButton textBinding="CUSTOMIZE_BUTTON@racMsgBundle@servletRequest" name="event" value="customize" />
	            </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
               </uix:stackLayout>
             <%--
                                --%>
              <uix:flowLayout>
              <uix:switcher childNameBinding ="useSVG@servletRequest">
                <uix:case name="true">
                  <uix:switcher childNameBinding = "repositoryMode@servletRequest">
                    <uix:case name="true">
                        <uix:switcher childNameBinding="isVersion112OrHigher@defaultBean@servletRequest">
                            <uix:case name="true">
                                        <db:flexRegion 
                                            swfName="/rac/flex/racPerf112.swf"
                                            dataSrcKeyBinding="flexKey@defaultBean@servletRequest"
                                            optionsBinding="performChartsFlex@servletRequest"
                                            windowWidth="100%"
                                            windowHeightBinding="flexWindowHeight11@defaultBean@servletRequest"
                                            idBase="flexracPerfChart"
                                            />     
                            </uix:case>
                            <uix:case name="false">
                                    <uix:switcher childNameBinding="instanceVersion_gte11Str@defaultBean@servletRequest">
                                        <uix:case name="true">
                                                <db:flexRegion 
                                                    swfName="/rac/flex/racPerf.swf"
                                                    dataSrcKeyBinding="flexKey@defaultBean@servletRequest"
                                                    optionsBinding="performChartsFlex@servletRequest"
                                                    windowWidth="100%"
                                                    windowHeightBinding="flexWindowHeight11@defaultBean@servletRequest"
                                                    idBase="flexracPerfChart"
                                                    />     
                                        </uix:case>
                                        <uix:case name="false">
                                                <db:flexRegion 
                                                    swfName="/rac/flex/racPerfPre11.swf"
                                                    dataSrcKeyBinding="flexKey@defaultBean@servletRequest"
                                                    optionsBinding="performChartsFlex@servletRequest"
                                                    windowWidth="100%"
                                                    windowHeightBinding="flexWindowHeight11@defaultBean@servletRequest"
                                                    idBase="flexracPerfChart"
                                                    />     
                                        </uix:case>    
                                    </uix:switcher>
                           </uix:case>   
        </uix:switcher>                          
                     </uix:case>
                    <uix:case name="false">
                      <db:lineGraph dataSrcKeyBinding="performCharts@servletRequest" 
                                           windowWidth="1000"
                                           windowHeight="130,250,130,120" 
                                           viewportWidth="100%" viewportHeight="630"
                                           stacked="true,true,false,false" 
                                           hideXLabels="false,false,true,false"
                                           updateIntervalBinding="refreshChoiceSVG@servletRequest" 
                                           preserveAspectRatio="false" 
                                           legendPos="east"/> 
                    </uix:case>
                  </uix:switcher>
                </uix:case>
                <uix:case name ="false"> 
                  <uix:stackLayout>
                    <uix:link renderedBinding="showSVGMsg@servletRequest"
                              styleClass="OraDataText"
                              textBinding="GET_SVG_PLUGIN@DBMsgBundle@servletRequest"
                              destinationBinding="svgPluginURL@servletRequest"/>
                    <uix:switcher childNameBinding = "repositoryMode@servletRequest">
                      <uix:case name="true">
                        <%@ include file="host.jspf" %> 
                      </uix:case>
                    </uix:switcher>
                    <uix:header textBinding="cccTimeHeader@servletRequest"> 
                      <oem:chart 
                        chartType="timeSeriesChart"
                        width="800" 
                        height="120"
                        orientation="vertical"
                        timeGranularity="SECOND"
                        titleBinding="cccTimeHeader@servletRequest"
                        titleVisible="false"                       
                        legendPosition="east" 
                        fill="cumulative"  
                        legendVisible="external"
                        yAxisWidth="30"
                        yAxisLabelBinding="cccTimeUnit@servletRequest" 
                        criticalThreshold="20"
                        noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest">   
                        <uix:contents>
                          <oem:boundChartDataSource 
                            chartDataSourceBinding="cccTimeChart@servletRequest"/>
                          <oem:chartColumn 
                            isKey="true" 
                            displayLabel="Target" 
                            sourceIndex="0"/> 
                          <oem:chartColumn
                            isTimeColumn="true"
                            displayLabel="Date" 
                            sourceIndex="1"  />
                          <oem:chartColumn
                            displayLabel=""
                            sourceIndex="2" />
                          <oem:imageMap imageMapDataSourceBinding="cccTimeImageMap@servletRequest"/> 
                        </uix:contents>
                      </oem:chart>
                    </uix:header>
                    <%@ include file="wait.jspf" %>
                    <uix:subTabLayout renderedBinding="instanceVersion_gte11@defaultBean@servletRequest" >
                      <uix:subTabs>
                        <uix:subTabBar selectedIndexBinding="perfTabSelection@servletRequest">
                          <uix:contents childDataBinding="tabsList@defaultBean@servletRequest">
                            <uix:link renderedBinding="render"
                                      textBinding="text"
                                      onClickBinding="onClick"/>
                          </uix:contents>
                        </uix:subTabBar>
                      </uix:subTabs>
                      <%@ include file="thruput.jspf" %>
                      <%@ include file="iogif.jspf" %>
                      <%@ include file="pqgif.jspf" %>
                      <%@ include file="servgif.jspf" %>
                      <%@ include file="instgif.jspf" %>
                    </uix:subTabLayout>

                  </uix:stackLayout>
                </uix:case>
              </uix:switcher>

            <uix:header textBinding="ADDITIONAL_MON_LINKS@DBMsgBundle@servletRequest">
              <uix:messagePrompt 
                  promptBinding="MON_LINKS_INSTR@DBMsgBundle@servletRequest"/>
              <uix:switcher childNameBinding="instanceVersion_gte10@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:bulletedList rows="2" >
                    <uix:link textBinding="ACTIVITY_DETAILS@DBMsgBundle@servletRequest"
                        destinationBinding="topActivityDest@racDBBean@servletRequest" />
                    <uix:link textBinding="TOP_CONSUMERS@racMsgBundle@servletRequest" 
                        destinationBinding="topConsumersDest@racDBBean@servletRequest" />
                    <uix:link textBinding="HEALTH_OVERVIEW@racMsgBundle@servletRequest" 
                        destinationBinding="racCCCDest@racDBBean@servletRequest" />
                    <uix:link textBinding="DATABASE_LOCKS@racMsgBundle@servletRequest" 
                        destinationBinding="locksDest@racDBBean@servletRequest" />
                    <uix:link textBinding="TOP_SEGMENTS@racMsgBundle@servletRequest"
                        destinationBinding="topSegmentsDest@racDBBean@servletRequest" />
                    <uix:link textBinding="SQL_MONITORING@DBMsgBundle@servletRequest"
                        renderedBinding="instanceVersion_gte11gR2@defaultBean@servletRequest"
                        destinationBinding="sqlMonitorDest@racDBBean@servletRequest" />

                  </uix:bulletedList>
                </uix:case>
                <uix:case name="false">
                  <uix:bulletedList rows="2" >
                    <uix:link textBinding="TOP_SESSIONS@racMsgBundle@servletRequest"
                              destinationBinding="topSessionsDest@racDBBean@servletRequest" />
                    <uix:link textBinding="HEALTH_OVERVIEW@racMsgBundle@servletRequest" 
                        destinationBinding="racCCCDest@racDBBean@servletRequest" />
                    <uix:link textBinding="DATABASE_LOCKS@racMsgBundle@servletRequest" 
                        destinationBinding="locksDest@racDBBean@servletRequest" />
                    <uix:link textBinding="TOP_SEGMENTS@racMsgBundle@servletRequest"
                        destinationBinding="topSegmentsDest@racDBBean@servletRequest" />
                  </uix:bulletedList>
                </uix:case> 
              </uix:switcher>
            </uix:header>

                <%@ include file="/database/instance/monitoringLinks.jspf" %>

                  </uix:flowLayout>

            </uix:subTabLayout>

          <uix:spacer height="5"/>

         </uix:header> 

          <%@ include file="comp.jspf" %>

        <oem:relatedLinks/> 

    </uix:pageLayout>
    </db:form>

    </uix:body>

    </uix:document> 
  </uix:renderingContext> 





  
