<%-- 
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
 * All rights reserved. 
 *
 *      NAME
 *        racPerformHist.jsp 
 *
 *      NOTES
 *        Cluster database Performance tab when View Data Historical
 *        option is selected.
 * 
 *        The <db:form> name must be "perfForm" because of RacDB.getTabsList()
 *        (accessed below) and RacDB.getTabOnClicks() (hardcodes form name).
 *       
 * MODIFIED
 *    gapadman   10/01/08 - oac fixes
 *    rsamaved   08/11/08 - 
 *    gapadman   07/17/08 - 
 *    pboopath   04/23/08 - flex pre11 changes
 *    kmckeen    04/21/08 - 
 *    pboopath   02/23/08 - remove historical link
 *    pboopath   02/06/08 - Flex changes
 *    kmckeen    01/30/08 - Add Top Activity link near Active Sessions chart
 *    kmckeen    12/11/07 - Decrease chart width
 *    kmckeen    03/02/07 - Initial creation
--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

<script>
  function scroll_timechart(direction)
  {
    if (direction == 'prev')
    {
      document.perfForm.direction.value = '1';
    }
    else
    {
      document.perfForm.direction.value = '2';
    }
    submitForm('perfForm', true, {'event':'scrollChart'});
  }

  function my_goto_band(selIdx, startMS, endMS)
  {
    document.perfForm.selectedBand.value  = selIdx;
    submitForm('perfForm', true, {'event':'sliderChanged','startLong':startMS,'endLong':endMS});
  }
  
  function resizeFlexHeight(height)
  {
   document.getElementById('flexRacHistPerfChartObjectId').style.height=height;
   document.getElementById('flexRacHistPerfChartEmbedId').style.height=height;
  }
</script>

  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:switcher childNameBinding="needConfigure@servletRequest">
        <uix:case name="true">
          <oem:messageBox 
              messageTypeBinding="messageType@servletRequest" 
              errorTableBinding="msgBox@servletRequest"
              destTableBinding="msgUrls@servletRequest"
              titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:case>
      </uix:switcher>

      <db:form 
          name="perfForm" 
          method="post" destination="/console/rac/racSitemap"
          copyParams="target,type">

        <uix:formValue name="pageNum" value="2"/>
        <uix:formValue name="event"/>
        <uix:formValue name="direction" value=""/>
        <uix:formValue name="selectedBand" value=""/>
        <uix:formParameter name="startLong"/>
        <uix:formParameter name="endLong"/>

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>

<%-- for debugging
<uix:messageStyledText styleClass="OraInstructionText" prompt="legendVisible:" textBinding="legendVisible@servletRequest"/>
<uix:messageStyledText styleClass="OraInstructionText" prompt="intervalTimeSec:" textBinding="intervalTimeSec@servletRequest"/>
<uix:messageStyledText styleClass="OraInstructionText" prompt="numBandsSelected:" textBinding="numBandsSelected@servletRequest"/>
<uix:messageStyledText styleClass="OraInstructionText" prompt="nonStaticPickerColors:" textBinding="nonStaticPickerColors@waitsChart@waitsBean@servletRequest"/>
<uix:messageStyledText styleClass="OraInstructionText" prompt="sliderColor:" textBinding="sliderColor@waitsChart@waitsBean@servletRequest"/>
<uix:messageStyledText styleClass="OraInstructionText" prompt="sliderEdgeColor:" textBinding="sliderEdgeColor@waitsChart@waitsBean@servletRequest"/>
<uix:messageStyledText styleClass="OraInstructionText" prompt="chartDataSource:" textBinding="chartDataSource@waitsBean@servletRequest"/>
<uix:labeledFieldLayout columns="2">
<uix:messageStyledText styleClass="OraInstructionText" prompt="beginDate:" textBinding="beginDate@waitsBean@servletRequest"/>
<uix:messageStyledText styleClass="OraInstructionText" prompt="selectedMinDate:" textBinding="selectedMinDate@servletRequest"/>
<uix:messageStyledText styleClass="OraInstructionText" prompt="endDate:" textBinding="endDate@waitsBean@servletRequest"/>
<uix:messageStyledText styleClass="OraInstructionText" prompt="selectedMaxDate:" textBinding="selectedMaxDate@servletRequest"/>
</uix:labeledFieldLayout>
--%>

          <oem:messageBox 
              messageTypeBinding="messageType@servletRequest" 
              errorTableBinding="errorTable@servletRequest"
              titleTextKey="titleText" 
              mainTextKey="mainText"/>

          <uix:header 
              textBinding="header@racDBBean@servletRequest"
              icon="<%= request.getContextPath() + \"/images/database/rac/dbcluster.gif\" %>">

<%-- ---------------------------------------------------------------------- --%>

            <uix:contextSwitcher>
              <uix:switcher childNameBinding="showContextSwitcher@servletRequest">
                <uix:case name="true">
                  <uix:flowLayout>
                    <uix:styledText 
                        styleClass="OraPromptText" 
                        textBinding="SWITCH_TOPOLOGY@racMsgBundle@servletRequest"/>
                    <oem:choice 
                        name="racdbChoice" 
                        id="racdbChoice"
                        shortDescBinding="SWITCH_TOPOLOGY@racMsgBundle@servletRequest"  
                        selectedValueBinding="racdb@servletRequest" 
                        optionsBinding="racdbList@servletRequest"
                        onChange="submitForm('perfForm', true, {'event':'switchRacDB','pageNum':'2'})">
                    </oem:choice>
                  </uix:flowLayout>
                </uix:case>
              </uix:switcher>
            </uix:contextSwitcher>

<%-- ---------------------------------------------------------------------- --%>

            <uix:subTabLayout>

<%-- ---------------------------------------------------------------------- --%>

              <uix:subTabs>
                <uix:subTabBar selectedIndex="1">
                  <uix:link 
                      textBinding="HOME@DBMsgBundle@servletRequest"
                      destinationBinding="sitemapDest@servletRequest"/>
                  <uix:link 
                      textBinding="PERFORMANCE_HEADER@DBMsgBundle@servletRequest"/>
                  <uix:link 
                      textBinding="TAB_AVAILABILITY@DBMsgBundle@servletRequest"
                      destinationBinding="tabAvailabilityDest@servletRequest"/>
                  <uix:link 
                      textBinding="TAB_SERVER@DBMsgBundle@servletRequest"
                      destinationBinding="tabServerDest@servletRequest"/>
                  <uix:link 
                      textBinding="TAB_SCHEMA@DBMsgBundle@servletRequest"
                      destinationBinding="tabSchemaDest@servletRequest"/>
                  <uix:link 
                      textBinding="TOPOLOGY@racMsgBundle@servletRequest"
                      destinationBinding="topologyDest@servletRequest"/>
                  <uix:link 
                      textBinding="TAB_DATA_MOVEMENT@DBMsgBundle@servletRequest"
                      destinationBinding="tabDataMovementDest@servletRequest"/>
                  <uix:link 
                      textBinding="TAB_SOFTWARE_SUPPORT@DBMsgBundle@servletRequest"
                      destinationBinding="tabSoftwareSupportDest@servletRequest"/>
                </uix:subTabBar>
              </uix:subTabs>

<%-- ---------------------------------------------------------------------- --%>

              <uix:stackLayout>
                <uix:tableLayout width="100%">
                  <uix:rowLayout hAlign="left"> 
                   <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
                    <uix:case name="false">
                    <uix:cellFormat vAlign="top" hAlign="left">
                      <uix:messageDateField
                          id="selectedDate"
                          shortDescBinding="DATE_LABEL@DBMsgBundle@servletRequest"
                          name="selectedDate"
                          valueBinding="selectedDate@historicBean@servletRequest"
                          maxValueBinding="lastAvailabelDate@waitsBean@servletRequest"
                          minValueBinding="firstAvailabelDate@waitsBean@servletRequest"
                          promptBinding="DATE_LABEL@DBMsgBundle@servletRequest"
                          tipBinding="dateTip@historicBean@servletRequest"
                          onChange="submitForm('perfForm', true, {event:'gotoSelectedDate'})"
                          columns="10"
                          required="no">
                        <uix:onSubmitValidater>
                          <uix:date dateStyle="medium"/>
                        </uix:onSubmitValidater>
                        <%--
                        <uix:end>
                          <uix:flowLayout>
                            <uix:spacer width="5"/>
                            <uix:submitButton
                                textBinding="GO@DBMsgBundle@servletRequest"
                                name="event"
                                value="gotoSelectedDate"/>
                          </uix:flowLayout>
                        </uix:end>
                        --%>
                      </uix:messageDateField>
                    </uix:cellFormat>
                    </uix:case>
                    </uix:switcher>
                    <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:rowLayout>
                        <uix:button
                            textBinding="SETTINGS_WORD@DBMsgBundle@servletRequest"
                            renderedBinding="instanceVersion_gte11@defaultBean@servletRequest"
                            destinationBinding="customizeDest@servletRequest"/>
                        <uix:spacer width="10"/>
                        <uix:messageChoice
                            promptBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                            name="refreshChoice" 
                            id="refreshChoice"
                            shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                            onChange="submitForm('perfForm', true, {'event':'doLoad','pageNum':'2'})"
                            selectedValueBinding="refreshChoiceSelected@servletRequest"> 
                          <uix:option 
                              textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                              value="RT_15"/>
                          <uix:option 
                              textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest"
                              value="RT_60"/> 
                          <uix:option 
                              textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                              value="RT_MAN"/>
                          <uix:option 
                              textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                              value="HIST_CUST" 
                              selected="true"/>
                        </uix:messageChoice>
                      </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:stackLayout>

  <%-- ---------------------------------------------------------------------- --%>
  
  <%-- Flex changes. Adding flexRegion tag. --%>
  <uix:switcher childNameBinding="showData@historicBean@servletRequest">
        <uix:case name="true">
         <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
          <uix:case name="true">
            <uix:switcher childNameBinding="version_gte11_2@historicBean@servletRequest">
                <uix:case name="true">
                  <db:flexRegion
                    swfName="/rac/flex/racPerfHist112.swf"
                    dataSrcKeyBinding="flexKey@historicBean@servletRequest"
                    windowWidth="100%"
                    windowHeightBinding="flexWindowHeight11@historicBean@servletRequest"
                    idBase="flexRacHistPerfChart" />
                </uix:case>
                <uix:case name="false">
                   <uix:switcher childNameBinding="version_gte11@historicBean@servletRequest">
                     <uix:case name="true">
                      <db:flexRegion
                        swfName="/rac/flex/racPerfHist.swf"
                        dataSrcKeyBinding="flexKey@historicBean@servletRequest"
                        windowWidth="100%"
                        windowHeightBinding="flexWindowHeight11@historicBean@servletRequest"
                        idBase="flexRacHistPerfChart" />
                     </uix:case>
                     <uix:case name="false">
                           <db:flexRegion
                        swfName="/rac/flex/racPerfPre11Hist.swf"
                        dataSrcKeyBinding="flexKey@historicBean@servletRequest"
                        windowWidth="100%"
                        windowHeightBinding="flexWindowHeightPre11@historicBean@servletRequest"
                        idBase="flexRacHistPerfChart" />
        
                      </uix:case>
                   </uix:switcher>
                </uix:case>
            </uix:switcher>                
          </uix:case>
          </uix:switcher>
         </uix:case>
</uix:switcher>
  
 <%-- ---------------------------------------------------------------------- --%>  
<%-- Display header and instruction text - works for both SVG and non-SVG. --%>
 <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
   <uix:case name="false">
  <uix:header textBinding="HIST_INTERVAL_SELECTION@DBMsgBundle@servletRequest" >
    <uix:tableLayout>
      <uix:rowLayout hAlign="left">
        <uix:messagePrompt promptBinding="HIST_PICKER_INSTR_1DAY@DBMsgBundle@servletRequest" />
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:header>
  </uix:case>
  </uix:switcher>

  <%-- ---------------------------------------------------------------------- --%>
  <%-- Historical Interval Selection chart - works for both SVG and non-SVG. --%>
  <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
   <uix:case name="false">
  <uix:tableLayout width="100%"> 
    <uix:rowLayout hAlign="left">
      <oem:chart 
          chartType="timeSeriesChart"
          width="750"
          height="100"
          timeGranularity="SECOND" 
          orientation="vertical"
          seriesColorsAutomatic="true"
          legendPosition="east" 
          legendVisibleBinding="legendVisible@servletRequest"
          fill="cumulative"
          yAxisLabelBinding="RC_SESSIONS@DBMsgBundle@servletRequest"
          titleBinding="RC_SESSIONS@DBMsgBundle@servletRequest"
          titleVisible="false"
          xAxisMinBinding="beginDate@waitsBean@servletRequest"
          xAxisMaxBinding="endDate@waitsBean@servletRequest"
          yAxisWidth="40"
          svgTimebandTipBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest"
          colorPaletteBinding="nonStaticPickerColors@waitsChart@waitsBean@servletRequest"
          svgHighlightLegend="true"
          >
        <uix:contents>
          <oem:timeSelector
              xAxisMinBinding="beginDate@waitsBean@servletRequest"
              xAxisMaxBinding="endDate@waitsBean@servletRequest"
              intervalTimeSecBinding="intervalTimeSec@servletRequest"
              height="20"
              selectedMaxDateBinding="selectedMaxDate@servletRequest"
              selectedMinDateBinding="selectedMinDate@servletRequest"
              numBandsSelectedBinding="numBandsSelected@servletRequest"
              selectionDest="my_goto_band"
              selectionDestType="JavaScript"
              selectionAltTextBinding="SELECT_PERIOD_RANGE@DBMsgBundle@servletRequest" 
              position="south"
              dynamicTimeSelector="true"
              xAxisScrollDest="scroll_timechart"
              xAxisScrollDestType="JavaScript"
              xAxisScrollPrev="true"
              xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsgBundle@servletRequest" 
              xAxisScrollNext="true"
              xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsgBundle@servletRequest" 
              selectionIndicator="shading"
              dynamicTimeSelectorColorBinding="sliderColor@waitsChart@waitsBean@servletRequest"
              dynamicTimeSelectorEdgeColorBinding="sliderEdgeColor@waitsChart@waitsBean@servletRequest"                      
              >
          </oem:timeSelector>
          <oem:boundChartDataSource chartDataSourceBinding="chartDataSource@waitsBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
        </uix:contents>
      </oem:chart>
    </uix:rowLayout>
  </uix:tableLayout>
  </uix:case>
  </uix:switcher>

  <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
   <uix:case name="false">
  <uix:tableLayout width="100%" renderedBinding="showData@historicBean@servletRequest">
    <uix:rowLayout>
      <uix:header textBinding="HIST_24HOUR_DETAIL_HDR@DBMsgBundle@servletRequest"/>
    </uix:rowLayout>
  </uix:tableLayout>
  </uix:case>
  </uix:switcher>
  

  <%-- ---------------------------------------------------------------------- --%>
  <%-- Adding svg check for all the other chars ---%>
  <%-- Cluster Host Load Average chart - works for non-SVG. --%>
  <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
   <uix:case name="false">
  <uix:switcher 
      childNameBinding="repositoryMode@servletRequest"
      renderedBinding="showData@historicBean@servletRequest">
    <uix:case name="true">
      <uix:tableLayout width="100%">
        <uix:rowLayout hAlign="left">
          <uix:header textBinding="clusterHostLoadAverageHeader@servletRequest" size="2">
            <oem:chart
                chartType="timeSeriesChart"
                width="750"
                height="120"
                orientation="vertical"
                timeGranularity="SECOND"
                titleBinding="clusterHostLoadAverageHeader@servletRequest"
                titleVisible="false"
                legendPosition="east"
                fill="none"
                legendVisibleBinding="legendVisible@servletRequest"
                yAxisWidth="40"
                yAxisLabelBinding="clusterHostLoadAverageYAxisLabel@servletRequest"
                svgHighlightLegend="true"
                noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
                >
              <uix:contents>
                <oem:boundChartDataSource chartDataSourceBinding="clusterHostLoadAverageChart@historicBean@servletRequest"/>
                <oem:imageMap imageMapDataSourceBinding="clusterHostLoadAverageImageMap@historicBean@servletRequest"/>
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>
              </uix:contents>
            </oem:chart>
          </uix:header>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:case>
  </uix:switcher>
  </uix:case>
  </uix:switcher>

  <%-- ---------------------------------------------------------------------- --%>
  <%-- Global Cache Block Access Latency chart - works non-SVG. --%>
  <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
   <uix:case name="false">
      <uix:tableLayout width="100%" renderedBinding="showData@historicBean@servletRequest">
        <uix:rowLayout hAlign="left">
          <uix:header textBinding="globalCacheLatencyHeader@servletRequest" size="2">
            <oem:chart
                chartType="timeSeriesChart"
                width="750" 
                height="120"
                orientation="vertical"
                timeGranularity="SECOND"
                titleBinding="globalCacheLatencyHeader@servletRequest"
                titleVisible="false"                       
                legendPosition="east" 
                fill="cumulative"  
                legendVisibleBinding="legendVisible@servletRequest"
                yAxisWidth="40"
                yAxisLabelBinding="globalCacheLatencyYAxisLabel@servletRequest" 
                svgHighlightLegend="true"
                noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
                >   
              <uix:contents>
                <oem:boundChartDataSource chartDataSourceBinding="globalCacheLatencyChart@historicBean@servletRequest"/>
                <oem:imageMap imageMapDataSourceBinding="globalCacheLatencyImageMap@historicBean@servletRequest"/>
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>
              </uix:contents>
            </oem:chart>
          </uix:header>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:case>
   </uix:switcher>


  <%-- ---------------------------------------------------------------------- --%>
  <%-- Average Active Sessions chart - works for non-SVG. --%>
  <uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
   <uix:case name="false">
      <uix:tableLayout width="100%" renderedBinding="showData@historicBean@servletRequest">
        <uix:rowLayout hAlign="left">
          <uix:header textBinding="averageActiveSessionsHeader@servletRequest" size="2">
           <uix:stackLayout>
            <uix:switcher childNameBinding="isVersion112OrHigher@defaultBean@servletRequest">
                    <uix:case name="true">
                        <uix:flowLayout>
                            <uix:contents childDataBinding="ashFGList@racDBBean@servletRequest">
                                <uix:radioButton name="includeBg"
                                         textBinding="text"
                                         valueBinding="val"
                                         onClickBinding="onclick"
                                         selectedValueBinding="selASHVal@racDBBean@servletRequest" />
                            </uix:contents>
                        </uix:flowLayout>
                    </uix:case>
            </uix:switcher>             
            <oem:chart 
                chartType="timeSeriesChart"
                width="750"
                height="220"
                timeGranularity="SECOND"
                orientation="vertical"
                fill="cumulative"  
                seriesColorsAutomatic="true"
                legendPosition="east"
                legendVisibleBinding="legendVisible@servletRequest"
                titleBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                titleVisible="false"
                yAxisLabelBinding="averageActiveSessionsYAxisLabel@servletRequest"
                yAxisWidth="40"
                colorPaletteBinding="waitsColor@racDBBean@servletRequest"
                svgHighlightLegend="true"
                noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
                >
              <uix:contents>
                <oem:boundChartDataSource chartDataSourceBinding="averageActiveSessionsChart@historicBean@servletRequest"/>
                <oem:imageMap imageMapDataSourceBinding="averageActiveSessionsImageMap@historicBean@servletRequest"/>
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>
              </uix:contents>
            </oem:chart>
            </uix:stackLayout>
          </uix:header>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:case>
  </uix:switcher>

<%-- Adding issvg check for whole of the subTabLayout ---%>
<uix:switcher childNameBinding="useSVG@historicBean@servletRequest">
<uix:case name="false">
 <uix:subTabLayout renderedBinding="showData@historicBean@servletRequest">

  <%-- ---------------------------------------------------------------------- --%>
  <%-- Subtabs are: Throughput, I/O, Parallel Execution, Services, Instances  --%>
  <%-- ---------------------------------------------------------------------- --%>
  <uix:subTabs>
    <uix:subTabBar selectedIndexBinding="perfTabSelection@servletRequest">
      <uix:contents childDataBinding="tabsList@defaultBean@servletRequest">
        <uix:link renderedBinding="render" textBinding="text" onClickBinding="onClick"/>
      </uix:contents>
    </uix:subTabBar>
  </uix:subTabs>

  <uix:stackLayout>

    <%-- ---------------------------------------------------------------------- --%>
    <%-- throughput charts --%>
    <%-- ---------------------------------------------------------------------- --%>

    <%-- throughput rate radio buttons --%>
    <uix:tableLayout renderedBinding="onThroughputTab@historicBean@servletRequest">
      <uix:rowLayout hAlign="left">
        <uix:spacer width="40" height="0"/>
        <uix:messagePrompt promptBinding="DATABASE_THROUGHPUT_RATE@racMsgBundle@servletRequest"/>
        <uix:flowLayout>
          <uix:contents childDataBinding="rateTypesList@racDBBean@servletRequest">
            <uix:radioButton
                name="rateType"
                textBinding="text"
                valueBinding="val"
                onClickBinding="onclick"
                selectedBinding="selected"/>
          </uix:contents>
        </uix:flowLayout>
      </uix:rowLayout>
    </uix:tableLayout>

    <%-- throughput chart --%>
    <uix:tableLayout width="100%" renderedBinding="onThroughputTab@historicBean@servletRequest">
      <uix:rowLayout hAlign="left" renderedBinding="showThroughputLogonsTransChart@historicBean@servletRequest">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="100"
            timeGranularity="SECOND" 
            orientation="vertical"
            fill="none"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="THROUGHPUT@DBMsgBundle@servletRequest"
            titleVisible="false"
            yAxisLabelBinding="throughputUnit@servletRequest"
            yAxisWidth="40"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="throughputLogonsTransChart@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="throughputLogonsTransImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>
    </uix:tableLayout>

    <%-- throughput blocks chart --%>
    <uix:tableLayout width="100%" renderedBinding="onThroughputTab@historicBean@servletRequest">
      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="100"
            timeGranularity="SECOND" 
            fill="none"
            orientation="vertical"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="BLOCKS@DBMsgBundle@servletRequest"
            titleVisible="false"
            yAxisLabelBinding="throughputUnit@servletRequest"
            yAxisWidth="40"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="throughputReadsRedoChart@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="throughputReadsRedoImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>
    </uix:tableLayout>

    <%-- ---------------------------------------------------------------------- --%>
    <%-- i/o charts --%>
    <%-- ---------------------------------------------------------------------- --%>
    <uix:tableLayout width="100%" renderedBinding="showIOTab@historicBean@servletRequest">     

      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="100"
            timeGranularity="SECOND"
            fill="none"
            orientation="vertical"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="LATENCY_SINGLE_BLOCK_READS@DBMsgBundle@servletRequest"
            titleVisible="true"         
            yAxisLabelBinding="MS@DBMsgBundle@servletRequest"
            yAxisWidth="40"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="IOLatencyGIF@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="IOLatencyImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>

      <uix:rowLayout hAlign="left">
      <uix:cellFormat hAlign="left" wrappingDisabled="true">
        <uix:spacer width="40" height="0"/>
        <uix:messagePrompt promptBinding="IO_BREAKDOWN@DBMsgBundle@servletRequest" styleClass="OraCopyright"/>
        <uix:flowLayout>
          <uix:contents childDataBinding="IOTypesList@racDBBean@servletRequest">
            <uix:radioButton
                name="rateType"
                textBinding="text"
                valueBinding="val"
                onClickBinding="onclick"
                selectedBinding="selected"/>
          </uix:contents>
        </uix:flowLayout>
      </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="250"
            timeGranularity="SECOND"
            fill="cumulative"
            orientation="vertical"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="IOThroughputChartHeader@defaultBean@servletRequest"
            titleVisible="true" 
            yAxisLabelBinding="MB_PER_SECOND@DBMsgBundle@servletRequest"
            yAxisWidth="40"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            colorPaletteBinding="ioColors@IOThroughputChart@historicBean@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="IOThroughputGIF@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="IOThroughputImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>

      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="250"
            timeGranularity="SECOND"
            fill="cumulative"
            orientation="vertical"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="IORateChartHeader@defaultBean@servletRequest"
            titleVisible="true" 
            yAxisLabelBinding="IO_PER_SECOND@DBMsgBundle@servletRequest"
            yAxisWidth="50"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            colorPaletteBinding="ioColors@IORateChart@historicBean@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="IORateGIF@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="IORateImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>

    </uix:tableLayout>


    <%-- ---------------------------------------------------------------------- --%>
    <%-- parallel execution charts --%>
    <%-- ---------------------------------------------------------------------- --%>
    <uix:tableLayout width="100%" renderedBinding="showPQTab@historicBean@servletRequest">

      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="100"
            timeGranularity="SECOND"
            fill="cumulative"
            orientation="vertical"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="PQ@DBMsgBundle@servletRequest"
            titleVisible="false"         
            yAxisLabelBinding="RC_SESSIONS@DBMsgBundle@servletRequest"
            yAxisWidth="40"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="PQSerialParallelGIF@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="PQSerialParallelImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>  

      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="100"
            timeGranularity="SECOND"
            fill="cumulative"
            orientation="vertical"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="PARALLEL_QC@DBMsgBundle@servletRequest"
            titleVisible="false"         
            yAxisLabelBinding="RC_SESSIONS@DBMsgBundle@servletRequest"
            yAxisWidth="40"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="PQ_QC_SlaveGIF@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="PQQCSlavesImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>  

      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="100"
            timeGranularity="SECOND"
            fill="cumulative"
            orientation="vertical"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="QUERIES_PARALLELIZED@DBMsgBundle@servletRequest"
            titleVisible="false"         
            yAxisLabelBinding="SP_PER_SECOND@DBMsgBundle@servletRequest"
            yAxisWidth="40"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="PQ_Ddl_DmlGIF@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="PQItemsParallelizedImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>  

      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="100"
            timeGranularity="SECOND"
            fill="cumulative"
            orientation="vertical"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="SERIALIZED@DBMsgBundle@servletRequest"
            titleVisible="false"         
            yAxisLabelBinding="SP_PER_SECOND@DBMsgBundle@servletRequest"
            yAxisWidth="40"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="PQDowngradesGIF@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="PQItemsDowngradedImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>  

    </uix:tableLayout>

    <%-- ---------------------------------------------------------------------- --%>
    <%-- services chart --%>
    <%-- ---------------------------------------------------------------------- --%>
    <uix:tableLayout width="100%" renderedBinding="showServicesTab@historicBean@servletRequest">
      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="200"
            timeGranularity="SECOND"
            fill="cumulative"
            orientation="vertical"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="SERVICES@DBMsgBundle@servletRequest"
            titleVisible="false"         
            yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
            yAxisWidth="50"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="serviceChartGIF@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="servicesImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>  
    </uix:tableLayout>

    <%-- ---------------------------------------------------------------------- --%>
    <%-- instances chart --%>
    <%-- ---------------------------------------------------------------------- --%>
    <uix:tableLayout width="100%" renderedBinding="onInstancesTab@historicBean@servletRequest">
      <uix:rowLayout hAlign="left">
        <oem:chart 
            chartType="timeSeriesChart"
            width="750"
            height="200"
            timeGranularity="SECOND"
            fill="cumulative"
            orientation="vertical"
            legendPosition="east" 
            legendVisibleBinding="legendVisible@servletRequest"
            titleBinding="INSTANCES@racMsgBundle@servletRequest"
            titleVisible="false"         
            yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
            yAxisWidth="40"
            svgHighlightLegend="true"
            noDataMessageBinding="NO_DATA_ALT@racMsgBundle@servletRequest"
            >
          <uix:contents>
            <oem:boundChartDataSource chartDataSourceBinding="instanceChartGIF@historicBean@servletRequest"/>
            <oem:imageMap imageMapDataSourceBinding="instancesImageMap@historicBean@servletRequest"/>
            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
            <oem:chartColumn displayLabel="" sourceIndex="2"/>
          </uix:contents>
        </oem:chart>
      </uix:rowLayout>  
    </uix:tableLayout>

  </uix:stackLayout>
</uix:subTabLayout>
</uix:case>
</uix:switcher>

<%-- ---------------------------------------------------------------------- --%>

              <%-- Additional Monitoring Links section (rac specific) --%>
              <uix:flowLayout>
                <uix:header textBinding="ADDITIONAL_MON_LINKS@DBMsgBundle@servletRequest">
                  <uix:messagePrompt 
                      promptBinding="MON_LINKS_INSTR@DBMsgBundle@servletRequest"/>
                  <uix:switcher childNameBinding="instanceVersion_gte10@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:bulletedList rows="2" >
                        <uix:link textBinding="ACTIVITY_DETAILS@DBMsgBundle@servletRequest"
                            destinationBinding="topActivityDest@racDBBean@servletRequest" />
                        <uix:link textBinding="TOP_CONSUMERS@racMsgBundle@servletRequest" 
                            destinationBinding="topConsumersDest@racDBBean@servletRequest" />
                        <uix:link textBinding="HEALTH_OVERVIEW@racMsgBundle@servletRequest" 
                            destinationBinding="racCCCDest@racDBBean@servletRequest" />
                        <uix:link textBinding="DATABASE_LOCKS@racMsgBundle@servletRequest" 
                            destinationBinding="locksDest@racDBBean@servletRequest" />
                        <uix:link textBinding="TOP_SEGMENTS@racMsgBundle@servletRequest"
                            destinationBinding="topSegmentsDest@racDBBean@servletRequest" />
                      </uix:bulletedList>
                    </uix:case>
                    <uix:case name="false">
                      <uix:bulletedList rows="2" >
                        <uix:link textBinding="TOP_SESSIONS@racMsgBundle@servletRequest"
                                  destinationBinding="topSessionsDest@racDBBean@servletRequest" />
                        <uix:link textBinding="HEALTH_OVERVIEW@racMsgBundle@servletRequest" 
                            destinationBinding="racCCCDest@racDBBean@servletRequest" />
                        <uix:link textBinding="DATABASE_LOCKS@racMsgBundle@servletRequest" 
                            destinationBinding="locksDest@racDBBean@servletRequest" />
                        <uix:link textBinding="TOP_SEGMENTS@racMsgBundle@servletRequest"
                            destinationBinding="topSegmentsDest@racDBBean@servletRequest" />
                      </uix:bulletedList>
                    </uix:case> 
                  </uix:switcher>
                </uix:header>
              </uix:flowLayout>

              <%-- Additional Instance Monitoring Links section (instance specific) --%>
              <%-- Links are enabled/disabled in BaseController.setupMonitoringLinks() --%>
              <%@ include file="/database/instance/monitoringLinks.jspf" %>

<%-- ---------------------------------------------------------------------- --%>

            </uix:subTabLayout>
          </uix:header>

          <%-- Table of instances, followed by Related Links section --%>
          <%@ include file="comp.jspf" %>
          <oem:relatedLinks/>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
