<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="racMsg" class="oracle.sysman.db.rsc.rac.RacCommonMsg"/>
  <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  
 
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <uix:form name="reconfigActivities" method="POST">
    
      <uix:pageLayout titleBinding = "RCONFIG_ACTVITIES_HEADER@racMsg">
        <%@ include file="/oemGlobal.jspf" %>

        <%-- Warning/Error display --%>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning" 
                        errorTableBinding="warnings@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
     
       
   <uix:pageStatus>
     <uix:rowLayout hAlign="right">
        <uix:styledText styleClass="OraTipText"
            textBinding="PAGE_REFRESHED_TIME@sdkMsg"/>
          <uix:spacer width="5" />
          <uix:styledText styleClass="OraTipLabel"
            textBinding="refreshTime@servletRequest"/>
       <uix:spacer width="10" />
        <uix:button textBinding="REFRESH@sdkMsg"  destinationBinding="refreshDest@servletRequest" shortDescBinding="REFRESH@sdkMsg"/>
   </uix:rowLayout>
   
  </uix:pageStatus>
  
  <uix:spacer height="4"/>
  <uix:styledText styleClass="OraPromptText"  textBinding="RECONFIG_PAGE_DESCRIPTION_TEXT@racMsg"/>
  <uix:spacer height="10"/>
  
  <uix:tableLayout width="100%" >
   <uix:rowLayout hAlign="right" >
    <uix:cellFormat hAlign="right">
     <uix:flowLayout> 
       <uix:styledText styleClass="OraFieldText" textBinding="ACTIVITY_STATUS@racMsg" labeledNodeId="activityStatusFilter"/>
       <uix:spacer width="3"/>
       <uix:choice name="activityStatusFilter" id="activityStatusFilter" onChange="submitForm('reconfigActivities', true,{'event':'filterActivities'})" selectedValueBinding="activityStatusFilter@BEAN@servletRequest">
        <uix:contents childDataBinding="statusList@BEAN@servletRequest">
          <uix:option textBinding="rtext" valueBinding="rval"/>
       </uix:contents>
       </uix:choice>
      
     <uix:spacer width="13"/>
       <uix:styledText styleClass="OraFieldText" textBinding="VIEWDATA_TEXT@sdkMsg" labeledNodeId="activityTimeInterval"/>
       <uix:spacer width="3"/>
       <uix:choice name="activityTimeInterval" id="activityTimeInterval" onChange="submitForm('reconfigActivities', true,{'event':'filterActivities'})" selectedValueBinding="activityTimeInterval@BEAN@servletRequest">
        <uix:option textBinding="LAST_DAY@sdkMsg" value="1"/>
        <uix:option textBinding="LAST_WEEK@sdkMsg" value="7"/>
        <uix:option textBinding="LAST_MONTH@sdkMsg" value="31"/>
        <uix:option textBinding="SHOW_ALL@racMsg" value="-1"/>
       </uix:choice>
      </uix:flowLayout>
     </uix:cellFormat>
    </uix:rowLayout>
  
  </uix:tableLayout> 
  
<uix:spacer height="15" />
         
   <uix:table name="EvtActivities" width="100%" tableDataBinding="activitiesList@DS_BEAN@servletRequest" alternateTextBinding="NO_DATA_ALT@racMsg"  summaryBinding="RCONFIG_ACTVITIES_HEADER@racMsg">
     <uix:tableSelection >
       <uix:singleSelection shortDescBinding="RCONFIG_ACTVITY_STOP_ALT@racMsg" renderedBinding="currentJobsExist@BEAN@servletRequest">
         <uix:submitButton textBinding="STOP@sdkMsg" shortDescBinding="STOP@sdkMsg"  name="event" value="stopDeleteJob"/>
       </uix:singleSelection>
      </uix:tableSelection>
     <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="RCONFIG_TYPE@racMsg"/>
      </uix:columnHeader>
      <uix:contents>
       <uix:styledText  textBinding="configMsg"/>
      </uix:contents>                      
     </uix:column>
     <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="RCONFIG_STATUS@racMsg"/>
      </uix:columnHeader>
      <uix:contents>
       <uix:link textBinding="status" destinationBinding="statusUrl"/>
      </uix:contents>
      </uix:column>
       <uix:column renderedBinding="isDatabaseWise@DS_BEAN@servletRequest">
       <uix:columnHeader>
        <uix:styledText textBinding="RCONFIG_INST_NAME@racMsg"/>
      </uix:columnHeader>
      <uix:contents>
      <uix:link textBinding="instanceName" destinationBinding="targetUrl"/> 
      </uix:contents>                      
     </uix:column>
 
     <uix:column renderedBinding="isClusterWise@DS_BEAN@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="RCONFIG_TARGET_NAME@racMsg"/>
      </uix:columnHeader>
      <uix:contents>
      <uix:link textBinding="target" destinationBinding="targetUrl"/>
      </uix:contents>                      
     </uix:column>
     <uix:column renderedBinding="isClusterWise@DS_BEAN@servletRequest">
      <uix:columnHeader>
        <uix:styledText textBinding="RCONFIG_TARGET_TYPE@racMsg"/>
      </uix:columnHeader>
      <uix:contents>
       <uix:styledText  textBinding="localeTargetTypeStr"/>
      </uix:contents>                      
     </uix:column>
         <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="RCONFIG_OCCUR_TIME@racMsg"/>
      </uix:columnHeader>
      <uix:contents>
       <uix:styledText  textBinding="timeStr"/>
      </uix:contents>                      
     </uix:column>
         <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="RCONFIG_DEST_HOST@racMsg"/>
      </uix:columnHeader>
      <uix:contents>
       <uix:styledText  textBinding="destHost"/>
      </uix:contents>                      
     </uix:column>
     <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="RCONFIG_SRC_HOST@racMsg"/>
      </uix:columnHeader>
      <uix:contents>
       <uix:styledText  textBinding="sourceHost"/>
      </uix:contents>                      
     </uix:column>
      
     <uix:formValue  name="jobId"        valueBinding="jobId"/>
  </uix:table>
  <uix:spacer height="3" />
  
  
  
  <uix:tip renderedBinding="currentJobsExist@BEAN@servletRequest">
   <uix:contents>
    <uix:text textBinding="RECONFIG_STOP_BUTTON_TIP@racMsg" />
   </uix:contents>
  </uix:tip>     
 
  <uix:contentFooter>
   <uix:pageButtonBar>           
    <uix:button textBinding="RETURN@racMsg" destinationBinding="returnUrl@DS_BEAN@servletRequest" shortDescBinding="RETURN@racMsg"/>         
   </uix:pageButtonBar>
  </uix:contentFooter>
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
