<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 
  
<uix:bundle name="racMsg" class="oracle.sysman.db.rsc.rac.RacCommonMsg"/>

<uix:document> 
  
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>  
   
    <uix:body>
    
 

    <db:form name="relocationHistory" method="post" destination="/console/rac/relocationHistory">
               
    <uix:pageLayout titleBinding="RECONFIGURATION_HISTORY@racMsg" >
    <%@ include file="/oemGlobal.jspf" %>
    <uix:pageStatus>
       <oem:pageRefreshed/>
    </uix:pageStatus>
    <uix:stackLayout>
       <uix:flowLayout>
        <uix:styledText styleClass="OraPromptText" 
                            textBinding="introText@servletRequest" />
      </uix:flowLayout>
      <uix:stackLayout>
         
                   <oem:table name="historyDataSource" 
                       width="100%" beanKey="relocationHistoryBean"  
                       dataSourceProp="historyDataSource"
                       partialRenderMode="self"
                       id="historyDataSourceTable"
                       formSubmitted="true"
                       blockSize="500"
                       alternateTextBinding="NO_DATA_ALT@racMsg"
                       summaryBinding="RECONFIGURATION_HISTORY@racMsg">
                 </oem:table>
                </uix:stackLayout>
          </uix:stackLayout>
         <uix:contentFooter>
         <uix:pageButtonBar>           
         <uix:button textBinding="RETURN@racMsg" shortDescBinding="RETURN@racMsg" destinationBinding="returnDest@servletRequest" />         
         </uix:pageButtonBar>
        </uix:contentFooter> 
        </uix:pageLayout>
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>



