<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>      
    <uix:body>  
     <db:form name="foo" method="POST" destination="racRsrcpln"
            copyParams="target,type,cancelURL,oname,otype">
     <uix:pageLayout>
      <%@ include file="/oemGlobal.jspf" %>     

    <uix:stackLayout>
     
      <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:header textBinding="RacRsrcplnPageTitle@servletRequest">        
      <uix:tableLayout>
       <uix:rowLayout>
        <uix:styledText styleClass="OraFieldText" textBinding="ACT_DESC@racRsrcPlanBundle@servletRequest"/>
       </uix:rowLayout> 
       <uix:rowLayout>
        <uix:spacer height="5"/>
       </uix:rowLayout>
       
       <uix:rowLayout> 
        <oem:shuttle name="activeInstanceList" 
            leadingHeaderBinding="AVAILABLEINSTS@racRsrcPlanBundle@servletRequest"
            trailingHeaderBinding="ACTIVEINSTS@racRsrcPlanBundle@servletRequest">
            <uix:leading>
                <oem:list name="notMatter" optionsBinding="inactiveInstances@servletRequest"
                    shortDescBinding="AVAILABLEINSTS@racRsrcPlanBundle@servletRequest"/>
            </uix:leading>
            <uix:trailing> 
                <oem:list name="notMatterToo" optionsBinding="activeInstances@servletRequest"
                    shortDescBinding="ACTIVEINSTS@racRsrcPlanBundle@servletRequest"/>
            </uix:trailing>
        </oem:shuttle>
       </uix:rowLayout>
       </uix:tableLayout>    
     </uix:header>
     </uix:stackLayout>      

      <uix:pageButtons>
          <uix:pageButtonBar>
                  <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                        name="event" value="cancelActiveInstance"/>
                  <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                    name="event" value="finishActiveInstance"/>
           </uix:pageButtonBar>
      </uix:pageButtons>
    
    </uix:pageLayout>
    
    <uix:formValue name="from" valueBinding="from@servletRequest"/>
    
    </db:form>
  </uix:body>      
  </uix:document> 
</uix:renderingContext> 
