<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

    <db:form name="services_add" method="POST" destination="racServices" copyParams="target,type,cancelEvent">
        <uix:formValue name="pageKey" valueBinding="RacServices.Title@servletRequest"/>      

      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %> 
          <uix:switcher childNameBinding="messageType@servletRequest">
            <uix:case name="error">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
            <uix:case name="info">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
            <uix:case name="warning">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
          </uix:switcher>

	<!-- ======== Main Content: Add/Modify Service Page ======== -->

          <uix:header textBinding="addModifyTitle@racServicesBean@servletRequest" >

	  <uix:stackLayout>

          <uix:styledText styleClass="OraInstructionText" textBinding="addModifyDesc@racServicesBean@servletRequest" />

	  <uix:spacer height="10" />

	  <!-------- service name ---------->
          <uix:flowLayout>
	    <uix:messageTextInput name="serviceName" promptBinding="SERVICENAME@racServicesMsgBundle@servletRequest"
               textBinding="serviceName@racServicesBean@servletRequest"
               shortDescBinding="serviceName@racServicesBean@servletRequest"
               renderedBinding="isAddPage@racServicesBean@servletRequest"
	       required="yes"/>
	  </uix:flowLayout>


          <!---------- start service after creation checkbox ----------->
          <uix:spacer height="10"/>
          <uix:checkBox name="startServiceAfterAdd" textBinding="START_SERVICE_AFTER_ADD@racServicesMsgBundle@servletRequest" shortDescBinding="START_SERVICE_AFTER_ADD@racServicesMsgBundle@servletRequest" checkedBinding="startServiceAfterAdd@racServicesBean@servletRequest" renderedBinding="isAddPage@racServicesBean@servletRequest"/>
          <!---------- update tnsnames.ora file with service alias  checkbox ----------->
          <uix:spacer height="5"/>
          <uix:checkBox name="doUpdateTNSFile" textBinding="UPDATE_TNSNAMES_FILE@racServicesMsgBundle@servletRequest" shortDescBinding="UPDATE_TNSNAMES_FILE@racServicesMsgBundle@servletRequest" checkedBinding="doUpdateTNSFile@racServicesBean@servletRequest" />
               

	  <uix:spacer height="10" />


	  <!----------------- Instance Configuration Table ------------------->

          <uix:header textBinding="INSTANCE_CONFIGURATION@racServicesMsgBundle@servletRequest">
           	      <uix:switcher childNameBinding="isPolicyManagedDB@racServicesBean@servletRequest">
               <uix:case name="true">
                <uix:stackLayout>
                   <uix:spacer height="5"/>
                   <uix:rowLayout>	
                  <uix:styledText styleClass="OraInstructionText" textBinding ="CARDINALITY@racServicesMsgBundle@servletRequest" />
                   <uix:radioButton name="singleOrUniform" textBinding="UNIFORM@racServicesMsgBundle@servletRequest" shortDescBinding="UNIFORM@racServicesMsgBundle@servletRequest" selectedValueBinding="singleOrUniform@racServicesBean@servletRequest" value="UNIFORM"/>
                   <uix:spacer width="10"/>
                   <uix:radioButton name="singleOrUniform" textBinding="SINGLETON@racServicesMsgBundle@servletRequest" shortDescBinding="SINGLETON@racServicesMsgBundle@servletRequest" selectedValueBinding="singleOrUniform@racServicesBean@servletRequest" value="SINGLETON"/>
                   </uix:rowLayout>
                   <uix:spacer height="15"/>
                   <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="SERVER_POOL@racServicesMsgBundle@servletRequest" />
                    <uix:spacer width="10"/>
                    <uix:switcher childNameBinding="isModifyPage@racServicesBean@servletRequest">
                     <uix:case name="false">
                      <uix:rowLayout>
                       <uix:choice name="selServerGroup" 
                            selectedValueBinding="selServerGroup@racServicesBean@servletRequest" shortDescBinding="SERVER_POOL@racServicesMsgBundle@servletRequest">
                        <uix:contents childDataBinding="serverGroupList@racServicesBean@servletRequest">
                          <uix:option textBinding="text" valueBinding="value"/>
                        </uix:contents>
                       </uix:choice>
                       <uix:spacer width="10"/>
                       <uix:link textBinding="EDIT@racServicesMsgBundle@servletRequest"
                                onClick="submitForm('services_add', false, {event:'editSvPool'})"/>
                      
                       <uix:spacer width="15"/>
                       <uix:link textBinding="ADD_SERVER_GROUPS@racCommonMsgBundle@servletRequest"
                                destinationBinding="addServerPoolURL@racServicesBean@servletRequest" />
                      </uix:rowLayout>
                     </uix:case>
                     <uix:case name="true">
                      <uix:spacer width="10"/> 
                       <uix:link textBinding="selServiceServerPoolName@racServicesBean@servletRequest"
                                destinationBinding="selServiceServerPoolURL@racServicesBean@servletRequest" />
                     </uix:case>
                    </uix:switcher>
                   </uix:rowLayout>
                   <uix:spacer height="5"/>
                   <uix:rowLayout>
                   <uix:styledText styleClass="OraInlineInfoText" textBinding="SERVICE_SERVER_POOL_TIP@racServicesMsgBundle@servletRequest" />
                   </uix:rowLayout>
                  </uix:stackLayout>
                </uix:case>
               <uix:case name="false">
               <uix:stackLayout>
               <uix:spacer height="10" />
                 <oem:table name="instConfigDataSource" width="50%" 
                       formSubmitted="true"                           
                       destination="/console/database/rac/racServices" 
                       beanKey="racServicesBean"     
                       dataSourceProp="instConfigDataSource"
                       alternateTextBinding="NO_INST_FOUND@racServicesMsgBundle@servletRequest"
                       summaryBinding="INSTANCE_CONFIGURATION@racServicesMsgBundle@servletRequest"
                       blockSizeBinding="blockSize@servletRequest"/> 
                   <uix:spacer height="5"/>
                   <uix:tip>
                    <uix:styledText styleClass="OraInstructionText" textBinding="INSTANCE_CONFIG_TABLE_TIP@racServicesMsgBundle@servletRequest" />
                   </uix:tip>
          
        
          </uix:stackLayout>
         </uix:case>
        </uix:switcher>
          </uix:header>

	  <uix:spacer height="10" />

	  <!----------------- Service Properties section ------------------->

          <uix:header textBinding="SERVICE_PROPERTIES@racServicesMsgBundle@servletRequest">
	  <uix:stackLayout>

	  <!------ TAF policy dropdown -------->
	  <uix:spacer height="10"/>
          
          <uix:flowLayout >
            <uix:rowLayout renderedBinding="isAdminManagedDB@racServicesBean@servletRequest"> 
             <uix:styledText styleClass="OraInstructionText" textBinding="TAF_POLICY@racServicesMsgBundle@servletRequest" />
              <uix:spacer width="10"/>
              <uix:choice name="tafPolicy" selectedValueBinding="tafPolicy@racServicesBean@servletRequest" shortDescBinding="TAF_POLICY@racServicesMsgBundle@servletRequest" disabledBinding="disableTAF@racServicesBean@servletRequest">
              <uix:option textBinding="TAF_NONE@racServicesMsgBundle@servletRequest" value="NONE"/>
              <uix:option textBinding="TAF_BASIC@racServicesMsgBundle@servletRequest" value="BASIC"/>
	      <uix:option textBinding="TAF_PRECONNECT@racServicesMsgBundle@servletRequest" value="PRECONNECT"/>
            </uix:choice>
            </uix:rowLayout>
            
            <uix:rowLayout renderedBinding="isPolicyManagedDB@racServicesBean@servletRequest"> 
             <uix:styledText styleClass="OraInstructionText" textBinding="FAILOVER_TYPE@racServicesMsgBundle@servletRequest" />
             <uix:spacer width="10"/>
             <uix:choice name="failOverType" selectedValueBinding="failOverType@racServicesBean@servletRequest" shortDescBinding="FAILOVER_TYPE@racServicesMsgBundle@servletRequest">
	      <uix:option textBinding="FAILOVER_TYPE_NONE@racServicesMsgBundle@servletRequest" value="NONE"/>
              <uix:option textBinding="FAILOVER_TYPE_SESSION@racServicesMsgBundle@servletRequest" value="SESSION"/>
              <uix:option textBinding="FAILOVER_TYPE_SELECT@racServicesMsgBundle@servletRequest" value="SELECT"/>
             </uix:choice>
            </uix:rowLayout>

            <uix:spacer height="12"/>
            
             <uix:rowLayout renderedBinding="isPolicyManagedDB@racServicesBean@servletRequest">
               <uix:styledText styleClass="OraInstructionText" textBinding="FAILOVER_DELAY@racServicesMsgBundle@servletRequest" />
               <uix:spacer width="10"/>
               <uix:textInput name="failOverDelay" textBinding="failOverDelay@racServicesBean@servletRequest" shortDescBinding="failOverDelay@racServicesBean@servletRequest" columns="6"/>
               <uix:spacer width="10"/>
               <uix:styledText styleClass="OraInstructionText" textBinding="FAILOVER_RETRIES@racServicesMsgBundle@servletRequest" />
               <uix:spacer width="10"/>
               <uix:textInput name="failOverRetries" textBinding="failOverRetries@racServicesBean@servletRequest" shortDescBinding="failOverRetries@racServicesBean@servletRequest" columns="2"/>
             </uix:rowLayout>
           
          </uix:flowLayout>  

          <!---------- enable DTP checkbox ----------->
          <uix:spacer height="12"/>	  

          <uix:checkBox name="dtpEnabled" textBinding="ENABLE_DTP@racServicesMsgBundle@servletRequest" shortDescBinding="ENABLE_DTP@racServicesMsgBundle@servletRequest" checkedBinding="dtpEnabled@racServicesBean@servletRequest" renderedBinding="is10gR2@racServicesBean@servletRequest"/>

          <uix:tableLayout cellPadding="5" renderedBinding="is10gR2@racServicesBean@servletRequest">
	    <uix:rowLayout>
	    <uix:cellFormat>
                <uix:styledText styleClass="OraInlineInfoText" textBinding="ENABLE_DTP_TIP@racServicesMsgBundle@servletRequest" />
	    </uix:cellFormat>
           </uix:rowLayout>
          </uix:tableLayout>

          <!---------- CLB_GOAL  ----------->
          <uix:spacer height="12"/>	  
	  <uix:tableLayout cellPadding="0" renderedBinding="is10gR2@racServicesBean@servletRequest">
          <uix:rowLayout> 
	  <uix:cellFormat>
             <uix:styledText styleClass="OraInstructionText" textBinding="CLB@racServicesMsgBundle@servletRequest" />


            <uix:flowLayout>
             <uix:spacer width="20"/>
             <uix:radioButton name="clbGoal" textBinding="CLB_SHORT@racServicesMsgBundle@servletRequest" shortDescBinding="CLB_SHORT@racServicesMsgBundle@servletRequest" selectedValueBinding="clbGoal@racServicesBean@servletRequest" value="SHORT"/>
             <uix:spacer width="10"/>
             <uix:radioButton name="clbGoal" textBinding="CLB_LONG@racServicesMsgBundle@servletRequest" shortDescBinding="CLB_LONG@racServicesMsgBundle@servletRequest" selectedValueBinding="clbGoal@racServicesBean@servletRequest" value="LONG"/>
            </uix:flowLayout>
          </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
          <uix:cellFormat>
                <uix:styledText styleClass="OraInlineInfoText" textBinding="CLB_TIP@racServicesMsgBundle@servletRequest" />
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>


          <uix:spacer height="10"/>	  

	  <uix:tableLayout width="100%" cellPadding="5" renderedBinding="is10gR2@racServicesBean@servletRequest">
          <uix:rowLayout vAlign="top">

          <!---------- enable metrics posting checkbox ----------->
          <!--- column 1 --->
          <uix:cellFormat width="50%">
          <uix:header textBinding="NOTIFICATION_PROPERTIES@racServicesMsgBundle@servletRequest">
          <uix:stackLayout>
<%--
          <uix:styledText styleClass="OraInstructionText" textBinding="NOTIFICATIONS_DESC@racServicesMsgBundle@servletRequest" />
          <uix:spacer height="10"/>
--%>

	  <uix:tableLayout cellPadding="0">
          <uix:rowLayout> 
	  <uix:cellFormat>
             <uix:checkBox name="metricsPostingEnabled" textBinding="ENABLE_METRICS_POSTING@racServicesMsgBundle@servletRequest" shortDescBinding="ENABLE_METRICS_POSTING@racServicesMsgBundle@servletRequest" checkedBinding="metricsPostingEnabled@racServicesBean@servletRequest" />
          </uix:cellFormat>
          </uix:rowLayout>

	  <uix:rowLayout>
          <uix:cellFormat>
            <uix:flowLayout>
             <uix:spacer width="20"/>
             <uix:radioButton name="metricsPostingGoal" textBinding="SERVICE_TIME@racServicesMsgBundle@servletRequest" shortDescBinding="SERVICE_TIME@racServicesMsgBundle@servletRequest" selectedValueBinding="metricsPostingGoal@racServicesBean@servletRequest" value="SERVICE_TIME"/>
             <uix:spacer width="10"/>
             <uix:radioButton name="metricsPostingGoal" textBinding="VELOCITY@racServicesMsgBundle@servletRequest" shortDescBinding="VELOCITY@racServicesMsgBundle@servletRequest" selectedValueBinding="metricsPostingGoal@racServicesBean@servletRequest" value="THROUGHPUT"/>
            </uix:flowLayout>
          </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
          <uix:cellFormat>
                <uix:styledText styleClass="OraInlineInfoText" textBinding="ENABLE_METRICS_POSTING_TIP@racServicesMsgBundle@servletRequest" />
          </uix:cellFormat>
          </uix:rowLayout>

          </uix:tableLayout>

          <!---------- enable aq ha notifications checkbox ----------->
          <uix:spacer height="7"/>	  
          <uix:checkBox name="aqHAEnabled" textBinding="ENABLE_AQ_HA_NOTIFICATIONS@racServicesMsgBundle@servletRequest" shortDescBinding="ENABLE_AQ_HA_NOTIFICATIONS@racServicesMsgBundle@servletRequest" checkedBinding="aqHAEnabled@racServicesBean@servletRequest" />
<%--
          <uix:styledText styleClass="OraInlineInfoText" textBinding="ENABLE_AQ_HA_NOTIFICATIONS_TIP@racServicesMsgBundle@servletRequest" />
--%>

          </uix:stackLayout>
          </uix:header>
          </uix:cellFormat>

          <!--- column 2 --->
          <uix:cellFormat width="50%">
          <uix:header textBinding="SERVICE_THRESHOLD_LEVELS@racServicesMsgBundle@servletRequest" >
          <uix:stackLayout>
          <uix:styledText styleClass="OraInstructionText" textBinding="THRESHOLDS_DESC@racServicesMsgBundle@servletRequest" />
          <uix:spacer height="10"/>

	  <!-------- service thresholds ---------->
	  <uix:tableLayout cellPadding="5">
           <uix:rowLayout>
           <uix:cellFormat>
	 	<uix:spacer width="10"/>
           </uix:cellFormat>
           <uix:cellFormat hAlign="center">
              <uix:styledText styleClass="OraDataText" textBinding="WARNING@racServicesMsgBundle@servletRequest" />
           </uix:cellFormat>
           <uix:cellFormat hAlign="center">
              <uix:styledText styleClass="OraDataText" textBinding="CRITICAL@racServicesMsgBundle@servletRequest" />
           </uix:cellFormat>
	   </uix:rowLayout>

           <uix:rowLayout>
           <uix:cellFormat>
              <uix:styledText styleClass="OraInstructionText" textBinding="ELAPSED_TIME@racServicesMsgBundle@servletRequest" />
           </uix:cellFormat>
	   <uix:cellFormat hAlign="left">
	      <uix:textInput name="elapsedTimeThreshWarn" textBinding="elapsedTimeThreshWarn@racServicesBean@servletRequest" shortDescBinding="ELAPSED_TIME_THRESH_WARNING@racServicesMsgBundle@servletRequest" columns="10"/>
           </uix:cellFormat>
	   <uix:cellFormat hAlign="left">
	      <uix:textInput name="elapsedTimeThreshCrit" textBinding="elapsedTimeThreshCrit@racServicesBean@servletRequest" shortDescBinding="ELAPSED_TIME_THRESH_CRITICAL@racServicesMsgBundle@servletRequest" columns="10"/>
           </uix:cellFormat>
           </uix:rowLayout>
<%--
           <uix:rowLayout>
             <uix:cellFormat>
             <uix:tip>
                <uix:styledText styleClass="OraInstructionText" textBinding="ELAPSED_TIME_TIP@racServicesMsgBundle@servletRequest" />
             </uix:tip>
             </uix:cellFormat>
           </uix:rowLayout>
--%>
           <uix:rowLayout>
           <uix:cellFormat>
              <uix:styledText styleClass="OraInstructionText" textBinding="CPU_TIME@racServicesMsgBundle@servletRequest"/>
           </uix:cellFormat>
	   <uix:cellFormat hAlign="left">
	      <uix:textInput name="cpuTimeThreshWarn" textBinding="cpuTimeThreshWarn@racServicesBean@servletRequest" shortDescBinding="CPU_TIME_THRESH_WARNING@racServicesMsgBundle@servletRequest" columns="10"/>
           </uix:cellFormat>
	   <uix:cellFormat hAlign="left">
	      <uix:textInput name="cpuTimeThreshCrit" textBinding="cpuTimeThreshCrit@racServicesBean@servletRequest" shortDescBinding="CPU_TIME_THRESH_CRITICAL@racServicesMsgBundle@servletRequest" columns="10"/>
           </uix:cellFormat>
           </uix:rowLayout>
<%--
           <uix:rowLayout>
             <uix:cellFormat columnSpan="2">
             <uix:tip>
                <uix:styledText styleClass="OraInstructionText" textBinding="CPU_TIME_TIP@racServicesMsgBundle@servletRequest" />
             </uix:tip>
             </uix:cellFormat>
           </uix:rowLayout>
--%>
          </uix:tableLayout>

          </uix:stackLayout>
          </uix:header>
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>
	  <uix:tableLayout width="100%">
          <uix:rowLayout vAlign="top">
          <uix:cellFormat width="50%">
          <uix:header textBinding="RESOURCE_MGMT_PROPERTIES@racServicesMsgBundle@servletRequest" >
          <uix:stackLayout>

          <uix:styledText styleClass="OraInstructionText" textBinding="RESOURCE_MGMT_DESC@racServicesMsgBundle@servletRequest" renderedBinding="isAddPage@racServicesBean@servletRequest"/>

	  <!----- links to cons group, job class pages (edit only) ----->
          <uix:rowLayout renderedBinding="isModifyPage@racServicesBean@servletRequest">
	    <uix:cellFormat>
            <uix:tip >
                  <uix:styledText styleClass="OraInstructionText" textBinding="CONS_GROUP_LINK_TIP@racServicesMsgBundle@servletRequest" />
            </uix:tip>
	    </uix:cellFormat>
	    <uix:cellFormat>
	    <uix:spacer width="5"/>
            <uix:link textBinding="CLICK_HERE@racServicesMsgBundle@servletRequest" destinationBinding="resourceMgmtURL@servletRequest" styleClass="OraInstructionText" />  
	    </uix:cellFormat>
          </uix:rowLayout>

	    <uix:spacer height="5"/>

          <uix:rowLayout renderedBinding="isModifyPage@racServicesBean@servletRequest">
	    <uix:cellFormat>
            <uix:tip >
                  <uix:styledText styleClass="OraInstructionText" textBinding="JOB_CLASS_LINK_TIP@racServicesMsgBundle@servletRequest" />
            </uix:tip>
	    </uix:cellFormat>
	    <uix:cellFormat>
	    <uix:spacer width="5"/>
            <uix:link textBinding="CLICK_HERE@racServicesMsgBundle@servletRequest" destinationBinding="jobClassURL@servletRequest" styleClass="OraInstructionText" />  
	    </uix:cellFormat>
          </uix:rowLayout>

          <uix:spacer height="5"/>

          <uix:tableLayout cellPadding="5">
	  <!------ consumer group dropdown -------->

	  <uix:rowLayout renderedBinding="isAddPage@racServicesBean@servletRequest">
          <uix:cellFormat>
            <uix:styledText styleClass="OraInstructionText" textBinding="CONSUMER_GROUP_MAPPING@racServicesMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:choice name="selConsumerGroup" selectedValueBinding="selConsumerGroup@racServicesBean@servletRequest" shortDescBinding="CONSUMER_GROUP_MAPPING@racServicesMsgBundle@servletRequest">
	      <uix:contents childDataBinding="consumerGroupList@racServicesBean@servletRequest">
                <uix:option textBinding="text" valueBinding="value"/>
              </uix:contents>
            </uix:choice>	
          </uix:cellFormat>  
          </uix:rowLayout>

	  <!------ job class dropdown -------->
	  <uix:rowLayout renderedBinding="isAddPage@racServicesBean@servletRequest">
          <uix:cellFormat>
            <uix:styledText styleClass="OraInstructionText" textBinding="JOB_SCHEDULER_MAPPING@racServicesMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:choice name="selJobClass" selectedValueBinding="selJobClass@racServicesBean@servletRequest" shortDescBinding="JOB_SCHEDULER_MAPPING@racServicesMsgBundle@servletRequest" >
	      <uix:contents childDataBinding="jobClassList@racServicesBean@servletRequest">
                <uix:option textBinding="text" valueBinding="value"/>
              </uix:contents>
            </uix:choice>	  
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>

          </uix:stackLayout>
          </uix:header>
  </uix:cellFormat>


  <!-- Service Roles -->
	<uix:cellFormat width="50%" renderedBinding="isDataGuardSetup@racServicesBean@servletRequest">
           <uix:header textBinding="SERVICE_ROLES@racServicesMsgBundle@servletRequest">
              <uix:styledText styleClass="OraInstructionText" 
			      textBinding="SERVICE_ROLES_DESC@racServicesMsgBundle@servletRequest" />
	      <uix:spacer width="10"/>
              <uix:stackLayout>
	          <uix:tableLayout cellPadding="10">
          	    <uix:cellFormat>
		       <uix:rowLayout>
                     	 <uix:checkBox name="isPrimary" 
			      textBinding="SERVICE_ROLES_PRIMARY@racServicesMsgBundle@servletRequest" 
                              checkedBinding="isPrimary@racServicesBean@servletRequest" /> 
		       </uix:rowLayout>
	 	       <uix:spacer width="5"/>
		       <uix:rowLayout>
                     	 <uix:checkBox name="isPhysicalStandby" 
			      textBinding="SERVICE_ROLES_PHYSICAL_STANDBY@racServicesMsgBundle@servletRequest"  
                              checkedBinding="isPhysicalStandby@racServicesBean@servletRequest" /> 
		       </uix:rowLayout>
		    </uix:cellFormat>
          	    <uix:cellFormat>
		       <uix:rowLayout>
                     	 <uix:checkBox name="isLogicalStandby" 
			      textBinding="SERVICE_ROLES_LOGICAL_STANDBY@racServicesMsgBundle@servletRequest"  
                              checkedBinding="isLogicalStandby@racServicesBean@servletRequest" /> 
		       </uix:rowLayout>
	 	       <uix:spacer width="5"/>
		       <uix:rowLayout>
                     	 <uix:checkBox name="isSnapshotStandby" 
			      textBinding="SERVICE_ROLES_SNAPSHOT_STANDBY@racServicesMsgBundle@servletRequest"  
                              checkedBinding="isSnapshotStandby@racServicesBean@servletRequest" /> 
		       </uix:rowLayout>
		    </uix:cellFormat>
	          </uix:tableLayout>
              </uix:stackLayout>
	      <uix:spacer width="10"/>
           </uix:header>
	</uix:cellFormat>
  <!-- Service Roles -->

        </uix:rowLayout>
        </uix:tableLayout>
	 </uix:stackLayout>
	 </uix:header>

	</uix:stackLayout>
        </uix:header>

	<!-- ===== OK/Cancel Buttons ====== -->

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:spacer width="10"/>
              <uix:submitButton textBinding="CANCEL_BUTTON@racServicesMsgBundle@servletRequest" shortDescBinding="CANCEL_BUTTON@racServicesMsgBundle@servletRequest" name="event" valueBinding="cancelEvent@servletRequest" unvalidated="true" />
              <uix:submitButton textBinding="OK_BUTTON@racServicesMsgBundle@servletRequest"  shortDescBinding="OK_BUTTON@racServicesMsgBundle@servletRequest"  name="event" valueBinding="addModifyEvent@servletRequest" /> 
            </uix:pageButtonBar>
          </uix:contentFooter>

      </uix:pageLayout>
     </db:form>
    </uix:body>

    </uix:document> 
</uix:renderingContext> 
