<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

     <db:form name="serviceDetails" method="POST" destination="racServices" copyParams="target,type">
    
        <uix:formValue name="pageKey" valueBinding="RacServices.Title@servletRequest"/>      
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %> 

          <uix:switcher childNameBinding="messageType@servletRequest">
            <uix:case name="error">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
            <uix:case name="info">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
            <uix:case name="warning">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
          </uix:switcher>


        <!-- ====================  Services Table ================== -->

        <uix:stackLayout>              

          <uix:header textBinding="detailHeaderText@racServicesBean@servletRequest" >

	   <uix:tableLayout>
	   <%-- <!-- instruction text --> --%>
	    <uix:cellFormat hAlign="left">
               <uix:styledText styleClass="OraInstructionText" textBinding="SERVICE_DETAILS_DESC@racServicesMsgBundle@servletRequest" />
	    </uix:cellFormat>

	    <%-- <!-- page refresh time/ refresh button --> --%>
  	    <uix:cellFormat hAlign="right" vAlign="top" width="30%">
              <uix:rowLayout>
	       <uix:cellFormat hAlign="right">
	         <uix:styledText styleClass="OraTipText" 
	              textBinding="PAGE_REFRESHED@racServicesMsgBundle@servletRequest"/>
	         <uix:spacer width="5" />  

	         <uix:styledText styleClass="OraTipLabel" 
	              textBinding="refreshTime@racServicesBean@servletRequest"/>

	         <uix:spacer width="5" />  
   	         <uix:button textBinding="REFRESH_BUTTON@racServicesMsgBundle@servletRequest" name="event" destinationBinding="refreshDetailsDest@servletRequest"/>
	       </uix:cellFormat>
	      </uix:rowLayout>
	    </uix:cellFormat> 
	  </uix:tableLayout>

	  <uix:spacer height="15" />



          <!-- Service Status rollup -->
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText" 
                              textBinding="SERVICE_STATUS@racServicesMsgBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:spacer width="5"/>

	    <uix:cellFormat hAlign="left">
	      <uix:image sourceBinding="selServiceAdviceRollupImage@racServicesBean@servletRequest"
			shortDescBinding="SERVICE_STATUS@racServicesMsgBundle@servletRequest"/>
	    </uix:cellFormat>

            <uix:spacer width="8"/>
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selServiceAdviceRollupText@racServicesBean@servletRequest"/>
          </uix:rowLayout>

	  <uix:spacer height="10" />
          <%-- % CPU Load --%>
<uix:rowLayout>
<uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
<uix:styledText styleClass="OraPromptText" textBinding="PERCENTAGE_CPU_LOAD@racServicesMsgBundle@servletRequest"/>
</uix:cellFormat>
            <uix:spacer width="5"/>
<uix:cellFormat hAlign="left">
<uix:image sourceBinding="selServicePerCPULoadAlertImage@racServicesBean@servletRequest"
	   shortDescBinding="PERCENTAGE_CPU_LOAD@racServicesMsgBundle@servletRequest"/>
</uix:cellFormat>
            <uix:spacer width="8"/>
            <uix:link textBinding="selServicePerCPULoad@racServicesBean@servletRequest" destinationBinding="selServicePerCPULoadLink@racServicesBean@servletRequest"/>
          </uix:rowLayout>

	  <uix:spacer height="10" />

          
	  <uix:rowLayout renderedBinding="adminManagedDb@racServicesBean@servletRequest">
            <uix:cellFormat hAlign="right" vAlign="top"  wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText" 
                              textBinding="TAF_POLICY@racServicesMsgBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:spacer width="8"/>
            <uix:styledText styleClass="OraDataText" 
                            textBinding="selServiceTafPolicy@racServicesBean@servletRequest"/>
          </uix:rowLayout>

          <uix:spacer height="10" renderedBinding="adminManagedDb@racServicesBean@servletRequest"/>
	  
	  
	  
          <uix:rowLayout renderedBinding="policyManagedDb@racServicesBean@servletRequest">
          <uix:styledText styleClass="OraPromptText"
                          textBinding="SERVER_POOL@racServicesMsgBundle@servletRequest"/>
          <uix:spacer width="8"/>

           <uix:link textBinding="selServiceServerPoolName@racServicesBean@servletRequest"
                     destinationBinding="selServiceServerPoolURL@racServicesBean@servletRequest"/>
          </uix:rowLayout>

          <uix:spacer height="10" renderedBinding="policyManagedDb@racServicesBean@servletRequest"/>
      
          <!-- Server pool Cardinality -->
          <uix:rowLayout renderedBinding="policyManagedDb@racServicesBean@servletRequest">
          <uix:styledText styleClass="OraPromptText"
                          textBinding="CARDINALITY@racServicesMsgBundle@servletRequest"/>
          <uix:spacer width="8"/>

           <uix:styledText styleClass="OraDataText" 
                           textBinding="selServiceSingleOrUnif@racServicesBean@servletRequest"/>
          </uix:rowLayout>
 
	  <uix:spacer height="10" renderedBinding="policyManagedDb@racServicesBean@servletRequest"/>
	  <!-- Fail Over Type -->
          <uix:rowLayout renderedBinding="policyManagedDb@racServicesBean@servletRequest">
          <uix:styledText styleClass="OraPromptText"
                          textBinding="FAILOVER_TYPE@racServicesMsgBundle@servletRequest"/>
          <uix:spacer width="8"/>

           <uix:styledText styleClass="OraDataText" 
                           textBinding="failOverType@racServicesBean@servletRequest"/>
          </uix:rowLayout>

	  <!-- Service Roles --> 
	  <uix:spacer height="10" renderedBinding="isDataGuardSetup@racServicesBean@servletRequest"/>
          <uix:rowLayout renderedBinding="isDataGuardSetup@racServicesBean@servletRequest">
          	<uix:styledText styleClass="OraPromptText"
                       	textBinding="SERVICE_ROLES@racServicesMsgBundle@servletRequest"/>
          	<uix:spacer width="8"/>
          	<uix:styledText styleClass="OraDataText" 
                       	textBinding="rolesForDisplay@racServicesBean@servletRequest"/>
          </uix:rowLayout>
	  <uix:spacer height="10"/>
      	  	


	  <!-- Link to top consumers page -->
	  <uix:rowLayout>
          <uix:styledText styleClass="OraPromptText" 
                          textBinding="TOP_CONSUMERS@racServicesMsgBundle@servletRequest"/>
          <uix:spacer width="8"/>
          <uix:link textBinding="DETAILS@racServicesMsgBundle@servletRequest"
                      destinationBinding="perfPageURL@servletRequest"/>
	  </uix:rowLayout>

	  <uix:spacer height="10" />

	  <!-- Link to edit properties page -->
	  <uix:rowLayout>
          <uix:styledText styleClass="OraPromptText" 
                          textBinding="SERVICE_PROPERTIES@racServicesMsgBundle@servletRequest"/>
          <uix:spacer width="8"/>
<%--
          <uix:submitButton textBinding="EDIT@racServicesMsgBundle@servletRequest" name="event" value="reloadModifyService" />
--%>
          <uix:link textBinding="EDIT@racServicesMsgBundle@servletRequest"
                      destinationBinding="modifyServiceURL@servletRequest"/>
	  </uix:rowLayout>
	  

	  <uix:spacer height="10"/>

	  <!-- All instance checkbox -->     
<%--  no doall for now...
          <uix:checkBox name="doAll_check"
	                value="true"
                        checkedBinding="doAllSelection@racServicesBean@pageContext"
                        textBinding="OPERATION_DOALL_TEXT@racServicesMsgBundle@servletRequest"/>
--%>

	  <!-- Service Detail data source -->     
          <uix:header textBinding="INSTANCE_HEADER@racServicesMsgBundle@servletRequest">
          <oem:table name="serviceDetailDataSource" width="90%"
                       formSubmitted="true"                           
                       destination="/console/database/rac/racServices" 
                       beanKey="racServicesBean"     
                       dataSourceProp="serviceDetailDataSource"
                       alternateTextBinding="NO_SERVICES_FOUND@racServicesMsgBundle@servletRequest"
                       summaryBinding="INSTANCE_HEADER@racServicesMsgBundle@servletRequest"
                       blockSizeBinding="blockSize@servletRequest"> 
        	       <uix:tableSelection>
		         <uix:singleSelection selectedIndexBinding="selectedInstIndexNormalized@racServicesBean@pageContext" shortDescBinding="SELECT@DBMsgBundle@servletRequest">

		<%--	 <!--------- Operation Buttons -----------> --%>
			   <uix:submitButton textBinding="ENABLE@racServicesMsgBundle@servletRequest" shortDescBinding="ENABLE@racServicesMsgBundle@servletRequest" name="event" value="doEnable"/>

			   <uix:submitButton textBinding="DISABLE@racServicesMsgBundle@servletRequest" shortDescBinding="DISABLE@racServicesMsgBundle@servletRequest" name="event" value="doDisable"/>

			   <uix:submitButton textBinding="START@racServicesMsgBundle@servletRequest" shortDescBinding="START@racServicesMsgBundle@servletRequest" name="event" value="doStart"/>

			   <uix:submitButton textBinding="STOP@racServicesMsgBundle@servletRequest" shortDescBinding="STOP@racServicesMsgBundle@servletRequest" name="event" value="doStop"/>

			   <uix:submitButton textBinding="RELOCATE@racServicesMsgBundle@servletRequest" shortDescBinding="RELOCATE@racServicesMsgBundle@servletRequest" name="event" value="beginRelocate"/>
			 </uix:singleSelection>      
                       </uix:tableSelection> 
          </oem:table>            
	  </uix:header>
        

<%--
          <uix:header textBinding="RELATED_LINKS@racCommonMsgBundle@servletRequest">
            <uix:link textBinding="PERF_PAGE_LINKTEXT@racServicesMsgBundle@servletRequest"
                      destinationBinding="perfPageURL@servletRequest"/>
          </uix:header>
--%>

        </uix:header>
        </uix:stackLayout>          

      </uix:pageLayout>

      <uix:formValue name="detailCallPage" value="operation"/>      
      </db:form>
    </uix:body>

    </uix:document> 
</uix:renderingContext> 


