<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

     <db:form name="servicesMain" method="POST" destination="racServices" copyParams="target,type">
    
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %> 

          <uix:switcher childNameBinding="messageType@servletRequest">
            <uix:case name="error">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
            <uix:case name="info">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
            <uix:case name="warning">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
          </uix:switcher>


        <!-- ====================  Services Table ================== -->

        <uix:stackLayout>              

          <uix:header textBinding="SERVICES_TITLE@racServicesMsgBundle@servletRequest" />

	   <uix:tableLayout width="100%" summary="tl">
	   <uix:rowLayout>
	    <!-- instruction text -->
	      <uix:cellFormat headers="">
               <uix:styledText styleClass="OraInstructionText" textBinding="SERVICES_DESC@racServicesMsgBundle@servletRequest" />
	      </uix:cellFormat>

	    <!-- page refresh time -->
  	    <uix:cellFormat hAlign="right" vAlign="top" headers="" wrappingDisabled="true">
	         <uix:spacer width="5" />  
	         <uix:styledText styleClass="OraTipText" 
	              textBinding="PAGE_REFRESHED@racServicesMsgBundle@servletRequest"/>
	         <uix:spacer width="5" />  

	         <uix:styledText styleClass="OraTipLabel" 
	              textBinding="refreshTime@racServicesBean@servletRequest"/>

	         <uix:spacer width="5" />  
   	         <uix:button textBinding="REFRESH_BUTTON@racServicesMsgBundle@servletRequest" shortDescBinding="REFRESH_BUTTON@racServicesMsgBundle@servletRequest" name="event" destinationBinding="refreshMainDest@servletRequest"/>
	    </uix:cellFormat> 
           </uix:rowLayout>
	  </uix:tableLayout>

	  <uix:spacer height="20" />

          <uix:tableLayout width="100%" summary="tl">
          <uix:rowLayout hAlign="right">
          <uix:cellFormat hAlign="right" headers="">
          <uix:submitButton textBinding="CREATE_SERVICE@racServicesMsgBundle@servletRequest" 
            name="event" 
            value="loadAddService"
            shortDescBinding="CREATE_SERVICE@racServicesMsgBundle@servletRequest" />
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>

	  <uix:spacer height="4" />

          <oem:table name="servicesDataSource" width="100%"
                       formSubmitted="true"                           
                       destination="/console/database/rac/racServices" 
                       beanKey="racServicesBean"     
                       dataSourceProp="servicesDataSource"
                       alternateTextBinding="NO_SERVICES_FOUND@racServicesMsgBundle@servletRequest"
                       summaryBinding="SERVICES_TITLE@racServicesMsgBundle@servletRequest"> 

		       <uix:tableSelection>
		         <uix:singleSelection selectedIndexBinding="selectedServiceIndex@racServicesBean@pageContext" shortDescBinding="SELECT@DBMsgBundle@servletRequest">

			 <!--------- Operation Buttons/drop-down list ----------->
			   <uix:submitButton textBinding="START_SERVICE@racServicesMsgBundle@servletRequest" shortDescBinding="START_SERVICE@racServicesMsgBundle@servletRequest" name="event" value="doStartService"/>

			   <uix:submitButton textBinding="STOP_SERVICE@racServicesMsgBundle@servletRequest" shortDescBinding="STOP_SERVICE@racServicesMsgBundle@servletRequest" name="event" value="doStopService"/>

			   <uix:submitButton textBinding="TEST_CONNECTION@racServicesMsgBundle@servletRequest" shortDescBinding="TEST_CONNECTION@racServicesMsgBundle@servletRequest" name="event" value="testConnection"/>
               <!--------- Show All services TNS alias String  ----------->
               <uix:submitButton textBinding="SHOW_TNS_STR@racServicesMsgBundle@servletRequest" shortDescBinding="SHOW_TNS_STR@racServicesMsgBundle@servletRequest" name="event" value="showAllServicesTNSString"/>
               
               <uix:spacer width="10"/>
               <uix:messagePrompt promptBinding="ACTIONS@racServicesMsgBundle@servletRequest" shortDescBinding="ACTIONS@racServicesMsgBundle@servletRequest" />
               <uix:choice name="selectedAction"    
               shortDescBinding="ACTIONS@racServicesMsgBundle@servletRequest">
			     <uix:option textBinding="MANAGE_SERVICE@racServicesMsgBundle@servletRequest" value="handleDetails"/>

  			     <uix:option textBinding="EDIT_SERVICE@racServicesMsgBundle@servletRequest" value="loadModifyService"/>

			     <uix:option textBinding="DELETE_SERVICE@racServicesMsgBundle@servletRequest" value="loadRemoveService"/>

			     <uix:option textBinding="ENABLE_SERVICE@racServicesMsgBundle@servletRequest" value="doEnableService"/>

			     <uix:option textBinding="DISABLE_SERVICE@racServicesMsgBundle@servletRequest" value="doDisableService"/>
               </uix:choice>

               <uix:submitButton textBinding="GO_BUTTON@racServicesMsgBundle@servletRequest"
                                 shortDescBinding="GO_BUTTON@racServicesMsgBundle@servletRequest"
                                 name="event" value="chooseAction"/>
			 </uix:singleSelection>      
                       </uix:tableSelection> 

          </oem:table>
          
          <uix:spacer height="10" />
          <uix:tip>                
            <uix:styledText styleClass="OraTipText" textBinding="RESPONSE_TIME_AND_CPU_LOAD_TOOLTIP@racServicesMsgBundle@servletRequest" />
          </uix:tip>
	  <uix:spacer height="10" />

          <uix:tableLayout width="100%" summary="tl">
          <uix:rowLayout hAlign="right">
          <uix:cellFormat hAlign="right" headers="">
          <uix:submitButton textBinding="RETURN@racCommonMsgBundle@servletRequest" shortDescBinding="RETURN@racCommonMsgBundle@servletRequest" name="event" value="cancel"/>
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>

	  <uix:spacer height="30" />

          <uix:tableLayout width="100%" renderedBinding="policyManagedDb@racServicesBean@servletRequest">
            <uix:rowLayout hAlign="left">
                 <uix:cellFormat hAlign="left">
                    <uix:header textBinding="RELATED_LINKS@racCommonMsgBundle@servletRequest">
                      <db:link textBinding="VIEW_SERVER_GROUPS@racMsgBundle@servletRequest"
                                    destination="/console/has/serverGroups?event=doLoad" copyParams="target,type,isRepDown"/>
                    </uix:header>
          	 </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:stackLayout>          

      </uix:pageLayout>

      <uix:formValue name="detailCallPage" value="main"/>      

      </db:form>
    </uix:body>

    </uix:document> 
</uix:renderingContext> 


