<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

    <db:form name="services_relocate" method="POST" destination="racServices" copyParams="target,type">
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %> 

          <uix:switcher childNameBinding="messageType@servletRequest">
            <uix:case name="error">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
          </uix:switcher>

	<!-- ======== Main Content: Relocate Service Page ======== -->
	<uix:stackLayout>

          <uix:header textBinding="relocateHeaderText@racServicesBean@servletRequest" />

	  <uix:rowLayout>
            <uix:styledText styleClass="OraInstructionText" textBinding="RELOCATE_TARGETTABLE_DESC@racServicesMsgBundle@servletRequest" />
	  </uix:rowLayout>

	  <uix:spacer height="10" />

	  <uix:stackLayout>

	  <!----------------- Target Table ------------------->

	  <uix:tableLayout width="60%">
	    <uix:rowLayout>
	    
	    <uix:cellFormat>
              <uix:spacer width="5" />
	    </uix:cellFormat>

	    <uix:cellFormat width="93%">
              <oem:table name="relocateTargetDataSource" width="100%" 
                       formSubmitted="true"                           
                       destination="/console/database/rac/racServices" 
                       beanKey="racServicesBean"     
                       dataSourceProp="relocateTargetDataSource"
                       alternateTextBinding="NO_INST_FOUND@racServicesMsgBundle@servletRequest"> 

	           <uix:tableSelection>
	             <uix:singleSelection selectedIndexBinding="selectedRelocateTargetIndex@racServicesBean@pageContext" shortDescBinding="SELECT@DBMsgBundle@servletRequest"> 
		     </uix:singleSelection>      
                   </uix:tableSelection> 

              </oem:table>
	    </uix:cellFormat>

	    </uix:rowLayout>
	  </uix:tableLayout>

	   </uix:stackLayout>

	</uix:stackLayout>

	<!-- ===== OK/Cancel Buttons ====== -->

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:spacer width="10"/>
              <uix:submitButton textBinding="CANCEL_BUTTON@racServicesMsgBundle@servletRequest" name="event" value="cancelDetails" />
<!--              <uix:spacer width="10"/>  -->
              <uix:submitButton textBinding="OK_BUTTON@racServicesMsgBundle@servletRequest"  name="event" value="finishRelocate" /> 
            </uix:pageButtonBar>
          </uix:contentFooter>

      </uix:pageLayout>
     </db:form>
    </uix:body>

    </uix:document> 
</uix:renderingContext> 
