<!-------- Shutdown: advanced options page ---------->

<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

      <db:form name="shutdown" method="POST" destination="/em/console/rac/racState" copyParams="target,type">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %> 
          
          <uix:stackLayout>
            <uix:contents>

              <oem:messageBox messageType="error" 
                              errorTableBinding="msgBox@servletRequest"
                              destTableBinding="msgUrls@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>  
              <uix:header textBinding="SHUTDOWN_DATABASE_HEADER@racCommonMsgBundle@servletRequest">                
  	       <uix:styledText styleClass="OraInstructionText" textBinding="SHUTDOWN_MODE_DESC@ChangeStateMsgBundle@servletRequest" />

                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
		     <uix:flowLayout>
                        <oem:radioButton name="shutdownMode" value="normal"
                                          selectedValueBinding="shutdownMode@racStateBean@servletRequest"
                                          textBinding="SHUTDOWN_NORMAL@ChangeStateMsgBundle@servletRequest" styleClass="OraInstructionText"/>
			<uix:spacer width="10"/>
		        <uix:link textBinding="BROWSE_SESSIONS@racCommonMsgBundle@servletRequest" destinationBinding="browseSessionsUrl@servletRequest" styleClass="OraInstructionText"/>  
		    </uix:flowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:spacer width="10"/>
		      <uix:messagePrompt messageType="warning" promptBinding="SHUTDOWN_NORMAL_DESC@ChangeStateMsgBundle@servletRequest" /> 
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <oem:radioButton name="shutdownMode" value="transactional"
                                          selectedValueBinding="shutdownMode@racStateBean@servletRequest"
                                          textBinding="SHUTDOWN_TRANSACTIONAL@ChangeStateMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="SHUTDOWN_TRANSACTIONAL_DESC@ChangeStateMsgBundle@servletRequest" /> 
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <oem:radioButton name="shutdownMode" value="immediate"
                                          selectedValueBinding="shutdownMode@racStateBean@servletRequest"
                                          textBinding="SHUTDOWN_IMMEDIATE@ChangeStateMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="SHUTDOWN_IMMEDIATE_DESC@ChangeStateMsgBundle@servletRequest" /> 
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <oem:radioButton name="shutdownMode" value="abort"
                                          selectedValueBinding="shutdownMode@racStateBean@servletRequest"
                                          textBinding="SHUTDOWN_ABORT@ChangeStateMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="SHUTDOWN_ABORT_DESC@ChangeStateMsgBundle@servletRequest" /> 
                    </uix:cellFormat>
                  </uix:rowLayout>



                </uix:tableLayout>
                <uix:spacer height="10"/>

            </uix:header>
          </uix:contents>
        </uix:stackLayout> 
        
        <uix:contentFooter>
          
          <uix:pageButtonBar>

            <uix:submitButton textBinding="CANCEL_BUTTON@racCommonMsgBundle@servletRequest" name="event" value="cancelAdvanced" />
            <uix:submitButton textBinding="OK_BUTTON@racCommonMsgBundle@servletRequest" name="event" value="setAdvOptions" />
          </uix:pageButtonBar>

        </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document> 

</uix:renderingContext> 
