<!-------- Startup: advanced options page ---------->

<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="startup" method="POST" destination="/em/console/rac/racState" copyParams="target,type">

        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %> 
          
          <uix:stackLayout>
            <uix:contents>

              <oem:messageBox messageType="error" 
                              errorTableBinding="msgBox@servletRequest"
                              destTableBinding="msgUrls@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>  
              <uix:header textBinding="STARTUP_DATABASE_HEADER@racCommonMsgBundle@servletRequest">                
<%--                <uix:styledText styleClass="OraInstructionText" textBinding="RAC_STARTUP_DESC@racCommonMsgBundle@servletRequest" />    --%>

		<!-- startup modes -->
		<uix:header textBinding="STARTUP_MODE_DESC@ChangeStateMsgBundle@servletRequest">     

                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <oem:radioButton name="startupMode" value="nomount"
                                       selectedValueBinding="startupMode@racStateBean@servletRequest"
                                       textBinding="START@ChangeStateMsgBundle@servletRequest" 
                                       styleClass="OraInstructionText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <oem:radioButton name="startupMode" value="mount"
                                       selectedValueBinding="startupMode@racStateBean@servletRequest"
                                       textBinding="MOUNT@ChangeStateMsgBundle@servletRequest" 
                                       styleClass="OraInstructionText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <oem:radioButton name="startupMode" value="open"
                                       selectedValueBinding="startupMode@racStateBean@servletRequest"
                                       textBinding="OPEN@ChangeStateMsgBundle@servletRequest" 
                                       styleClass="OraInstructionText" />
                    </uix:cellFormat>
                  </uix:rowLayout>
		  </uix:tableLayout>
		  </uix:header>

		  <!-- force/restricted options -->
		  <uix:spacer height="10"/>
		  <uix:header textBinding="STARTUP_OPTIONS_OTHERS@ChangeStateMsgBundle@servletRequest">

		  <uix:tableLayout cellSpacing = "5">
		  <!-- restricted -->
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:checkBox name="restricted" 
                                    checkedBinding="restricted@racStateBean@servletRequest"
                                    textBinding="RESTRICT_START@racCommonMsgBundle@servletRequest" />
                    </uix:cellFormat>
		   </uix:rowLayout>

		   <uix:rowLayout>
		    <uix:cellFormat hAlign="left">
		     <uix:flowLayout>
		      <uix:spacer width="10"/>
<%--		      <uix:styledText styleClass="OraInstructionText" textBinding="RAC_STARTUP_HINT_RADIO2@racCommonMsgBundle@servletRequest" />    --%>
                      <uix:tip>
		        <uix:styledText styleClass="OraInstructionText" textBinding="STARTUP_OPTIONS_RESTRICT_DESC@ChangeStateMsgBundle@servletRequest" /> 
		      </uix:tip>
		     </uix:flowLayout>
		    </uix:cellFormat>
                  </uix:rowLayout>

		  <!-- force -->
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                      <uix:flowLayout>
                        <uix:checkBox name="forced" 
                                      checkedBinding="forced@racStateBean@servletRequest"
                                      textBinding="FORCE_START@racCommonMsgBundle@servletRequest" />
                      </uix:flowLayout>
                    </uix:cellFormat>
		   </uix:rowLayout>

                  <uix:rowLayout>
		    <uix:cellFormat hAlign="left">
		     <uix:flowLayout>
		      <uix:spacer width="10"/>
		      <uix:messagePrompt messageType="warning" promptBinding="STARTUP_OPTIONS_FORCE_DESC@ChangeStateMsgBundle@servletRequest"/>

<%--		      <uix:tip>
		      <uix:styledText styleClass="OraInstructionText" textBinding="RAC_STARTUP_HINT_RADIO1@racCommonMsgBundle@servletRequest" />  
		      </uix:tip>
--%>
		     </uix:flowLayout>
		    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
                <uix:spacer height="10"/>

              </uix:header>
            </uix:header>
          </uix:contents>              
        </uix:stackLayout> 
        
        <uix:contentFooter>
          
          <uix:pageButtonBar>

            <uix:submitButton textBinding="CANCEL_BUTTON@racCommonMsgBundle@servletRequest" name="event" value="cancelAdvanced" />
            <uix:submitButton textBinding="OK_BUTTON@racCommonMsgBundle@servletRequest" name="event" value="setAdvOptions" />

          </uix:pageButtonBar>

        </uix:contentFooter>

      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document> 
</uix:renderingContext> 
