<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
     <uix:pageLayout>
      <%@ include file="/database/global.jspf" %> 

      <db:form name="status" method="POST" destination="/em/console/rac/racState" copyParams="target,type">

          <uix:switcher childNameBinding="messageType@servletRequest">
            <uix:case name="error">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
            <uix:case name="warning">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
            <uix:case name="info">
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:case>
          </uix:switcher>

          <!-- ===========================  Status Table ================== -->

          <uix:stackLayout>              

            <uix:header textBinding="RAC_INST_STATUS_HEADER@racCommonMsgBundle@servletRequest" />   

	    <uix:spacer height="5"/>

	    <!-- page refresh time / refresh button -->
	    <uix:tableLayout width="100%">
	    <uix:rowLayout>

	    <uix:cellFormat>
               <uix:styledText styleClass="OraInstructionText" textBinding="CHANGE_STATUS_DESC@racCommonMsgBundle@servletRequest" renderedBinding="racDBBool@racStateBean@servletRequest"/>   
               <uix:styledText styleClass="OraInstructionText" textBinding="CHANGE_STATUS_DESC_SIHA@racCommonMsgBundle@servletRequest" renderedBinding="sihaCaseBool@racStateBean@servletRequest"/>   
	    </uix:cellFormat>
  	    <uix:cellFormat hAlign="right" vAlign="top" width="35%">
	       <uix:flowLayout>
	         <uix:styledText styleClass="OraTipText" 
	              textBinding="PAGE_REFRESHED@racCommonMsgBundle@servletRequest"/>
	         <uix:spacer width="5" />  

	         <uix:styledText styleClass="OraTipLabel" 
	              textBinding="refreshTime@racStateBean@servletRequest"/>

	         <uix:spacer width="5" />  
   	         <uix:button textBinding="REFRESH_BUTTON@racCommonMsgBundle@servletRequest" name="event" destinationBinding="refreshDest@servletRequest"/>

	      </uix:flowLayout>
            </uix:cellFormat> 	    
	    </uix:rowLayout> 	    
	  </uix:tableLayout>	    

	    <uix:spacer height="20"/>

	    <!-- db level operations -->
	    <uix:tableLayout width="100%">
	    <uix:rowLayout hAlign="right">
	    <uix:cellFormat hAlign="right"> 

	    <uix:pageButtonBar>
              <uix:submitButton textBinding="STARTUP_ALL_BUTTON@racCommonMsgBundle@servletRequest" name="event" value="confirmStartupAll" renderedBinding="racDBBool@racStateBean@servletRequest"/>
              <uix:submitButton textBinding="SHUTDOWN_ALL_BUTTON@racCommonMsgBundle@servletRequest" name="event" value="confirmShutdownAll"  renderedBinding="racDBBool@racStateBean@servletRequest"/>
	    </uix:pageButtonBar>

	    </uix:cellFormat> 
	    </uix:rowLayout> 	    
	    </uix:tableLayout>	    

	    <uix:spacer height="10"/>

	    <!-- instance level operations: table -->
            <oem:table name="stateDataSource" width="100%"
                       formSubmitted="true"                           
                       destination="/console/datatbase/rac/racState"                            
                       beanKey="racStateBean"                           
                       dataSourceProp="stateDataSource"                           
                       alternateText="No components"
                       summaryBinding="RAC_INST_STATUS_HEADER@racCommonMsgBundle@servletRequest" 
                       blockSizeBinding="blockSize@servletRequest">                

		       <uix:tableSelection>
		         <uix:multipleSelection selectionBinding="selectedInstIndexes@racStateBean@pageContext" selectedBinding="isSelected" shortDescBinding="SELECT@DBMsgCommonBundle@servletRequest">
			   
                              <uix:submitButton textBinding="STARTUP_BUTTON@racCommonMsgBundle@servletRequest" name="event" value="confirmStartup"/>
			      <uix:spacer width="5"/>
                              <uix:submitButton textBinding="SHUTDOWN_BUTTON@racCommonMsgBundle@servletRequest" name="event" value="confirmShutdown"/>

<%--                              <uix:submitButton textBinding="RESTART_BUTTON@racCommonMsgBundle@servletRequest" name="event" value="confirmRestart"/>  --%>

			 </uix:multipleSelection>
		       </uix:tableSelection>

            </oem:table>            

	  <uix:spacer height="10" />

	  <!-- status clarify tip -->
	  <uix:flowLayout>
     	   <uix:spacer height="10"/>
	   <uix:tip>
	     <uix:styledText styleClass="OraInstructionText" textBinding="STARTSHUT_UPSTATUS_CLARIFY@racCommonMsgBundle@servletRequest" />
	   </uix:tip>
          </uix:flowLayout>

	  <uix:spacer height="20" />

          <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">
          <uix:cellFormat hAlign="right">
          <uix:submitButton textBinding="RETURN@racCommonMsgBundle@servletRequest" name="event" value="cancel"/>
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>

          </uix:stackLayout>          

      </db:form>
      </uix:pageLayout>

      </uix:body>

    </uix:document> 
  </uix:renderingContext> 








