<%-- 
 * Copyright (c) 2006, 2008, Oracle. All rights reserved.  
 *
 *      NAME
 *        topActHistDrill.jsp 
 *
 *      NOTES
 *        tbd
 *       
 * MODIFIED
 *    pboopath   05/05/08 - swf path change from database/flex to rac/flex
 *    pboopath   04/11/08 - Flex tilechart historical changes
 *    kmckeen    03/18/08 - Support historical tile chart
 *    kmckeen    03/22/08 - No min/max/avg chart for historical
 *    pboopath   03/20/08 - Flex conversion
 *    pboopath   02/24/08 - hist drill chart
 *                          
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.rac.RacConstants" %>



<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

    
<%-- For flex summary chart no full page refresh is required.
But for flex tile chart full page refresh is required. --%>

  <uix:document> 
  
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>  
    <%@ include file="/oemGlobal.jspf"%>
    <%@ include file="/oemNoscript.jspf"%>

    <uix:body>
    
 

             <db:form name="waitForm" method="post" destination="/console/rac/racTopActivityDrill"
               copyParams="target,type,drillDown,wait,instNum,startLong,endLong,service">
               
               
          <uix:pageLayout titleBinding = "waitTitle@servletRequest" >
          <%--
          <uix:header textBinding="svgUpdateRate@servletRequest" />
          --%>
            <%@ include file="/database/global.jspf" %> 
            
        <uix:messages>
          <uix:switcher childNameBinding="showWarning@servletRequest">
            <uix:case name="true">
            
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              destTableBinding="msgUrls@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                                      
            </uix:case>
          </uix:switcher>    
        </uix:messages>          

               
          <uix:stackLayout>
          
          
          
          
              <uix:tableLayout width="100%" >
                <uix:rowLayout hAlign="right">
                  
                <uix:cellFormat
                    hAlign="left" vAlign="top" wrappingDisabled="true"
                    renderedBinding="renderDetailsMetricsDropdown@servletRequest">
                  <uix:flowLayout>
                    <uix:styledText
                        styleClass="OraFieldText"
                        textBinding="detailsMetricsLabel@servletRequest"/>
                    <uix:choice
                        id="detailsMetric"
                        name="detailsMetric"
                        selectedValueBinding="detailsMetric@servletRequest"
                        shortDescBinding="detailsMetricsLabel@servletRequest"
                        onChange="submitForm(document.forms[0], true, {'event':'switchDetailsMetric'})">
                      <uix:contents
                          childDataBinding="detailsMetrics@servletRequest">
                        <uix:option 
                            textBinding="text"
                            valueBinding="value"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:flowLayout>
                </uix:cellFormat>
		
                  <uix:cellFormat>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraFieldText" 
                                      textBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                                      labeledNodeId="refreshChoice"/>
                      <uix:choice name="refreshChoice" id="refreshChoice"
                                  shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                                  onChange="submitForm('waitForm', true, {'event':'updateRefreshChoice'})"
                                  selectedValue="HIST_CUST"> 
                                  
                        <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                    value="RT_15"/>

                        <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                    value="RT_MAN"/>
                    <uix:option 
                        textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                        value="HIST_CUST"
                     />

                      </uix:choice>
                    </uix:flowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              
<%-- ---------------------------------------------------------------------- --%>
<%-- Summary Chart/Tile Chart radio buttons on the left.  --%>
<%-- Customize button on the right.                       --%>

<uix:tableLayout width="100%">
  <uix:rowLayout>
    <uix:spacer height="5"/>
  </uix:rowLayout>
  <uix:rowLayout>
    <uix:cellFormat 
        hAlign="left" vAlign="top" wrappingDisabled="true"
        renderedBinding="renderChartTypeRadioButtons@servletRequest">
      <uix:flowLayout>
        <uix:radioSet>
          <uix:radioButton
              name="chartType"
              value="topChart"
              selectedValueBinding="chartType@servletRequest"
              textBinding="TOP_CHART_VIEW@racMsgBundle@servletRequest"
              onClick="submitForm(document.forms[0], true, {'event':'switchChartType', 'chartType':'topChart'})"/>
          <uix:radioButton
              name="chartType"
              value="tileChart"
              selectedValueBinding="chartType@servletRequest"
              textBinding="TILE_CHART_VIEW@racMsgBundle@servletRequest"
              onClick="submitForm(document.forms[0], true, {'event':'switchChartType', 'chartType':'tileChart'})"/>
        </uix:radioSet>
      </uix:flowLayout>
    </uix:cellFormat>
    <uix:cellFormat 
        hAlign="right" vAlign="top" wrappingDisabled="true"
        renderedBinding="renderCustomizeButton@servletRequest">
      <uix:flowLayout>
        <uix:submitButton 
            textBinding="CUSTOMIZE_BUTTON@racMsgBundle@servletRequest"
            name="event" 
            value="customizeDetails"/>
      </uix:flowLayout>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>

<%-- -------------------------------------------------- --%>

             <uix:tableLayout width="100%">
		<uix:rowLayout>
		   <uix:spacer height="5"/>
		</uix:rowLayout>
	    </uix:tableLayout>	
              
	   <uix:switcher childNameBinding="useSVG@servletRequest">
       <uix:case name="true">

        <uix:switcher childNameBinding="chartType@servletRequest">
          <uix:case name="tileChart">
          <db:flexRegion
                    swfName="/rac/flex/topActivityDrillTileChart.swf"
                    dataSrcKeyBinding="flexKey@servletRequest"
                    optionsBinding="flexRacTopActivityHistDrill@servletRequest"
                    windowHeightBinding="flexWindowHeightForTileChart@flexTileRacTopActivityDrillBean@servletRequest" 
                    windowWidth="100%"
                    idBase="flexRacTopActivityHistDrillTileChart"/>
           </uix:case>
           <uix:case name="topChart">
               <db:flexRegion
                    swfName="/rac/flex/topActivityDrill.swf"
                    dataSrcKeyBinding="flexKey@servletRequest"
                    optionsBinding="flexRacTopActivityHistDrill@servletRequest"
                    windowHeight="150"
                    windowWidth="100%"
                    idBase="flexRacTopActivityHistDrillChart"/>
          </uix:case>
          </uix:switcher>
      </uix:case>
      <uix:case name="false">        
        <uix:switcher childNameBinding="chartType@servletRequest">
          <uix:case name="tileChart">
            <%@ include file="tileChart.jspf" %>
          </uix:case>
          <uix:case name="topChart">
            <uix:styledText
                styleClass="OraInstructionText"
                textBinding="topChartTip@servletRequest"/>            
            <oem:chart chartType="timeSeriesChart" width="825" height="175" timeGranularity="SECOND" orientation="vertical" fill="cumulative" yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest" legendPosition="east" legendVisible="external" titleBinding="ACTIVE_SESSIONS_BY_INST@racMsgBundle@servletRequest" titleVisible="false" seriesColorsAutomatic="true" format="svg" svgUpdateFrequencyBinding="svgUpdateRate@servletRequest" xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest" xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest" yAxisWidth="30" yAxisNumberFormatBinding="waitChartYAxisFormat@servletRequest" axisMin="0" axisMaxBinding="actualMaxValue@waitAreaChart@waitDetailsBean@servletRequest" svgHighlightLegend="true" colorPaletteBinding="waitColorsTable@waitAreaChart@waitDetailsBean@servletRequest">
                  <uix:contents>
                        <oem:boundChartDataSource dataClass="oracle.sysman.db.rac.RacTopActivityDrillController" dataMethod="updateChartData"/>
                        <oem:imageMap imageMapDataSourceBinding="legendLinks@waitAreaChart@waitDetailsBean@servletRequest"/>
                        <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                        <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                        <oem:chartColumn displayLabel="" sourceIndex="2"/>
                  </uix:contents>
            </oem:chart>
          </uix:case>
        </uix:switcher>
	  </uix:case>
    </uix:switcher>

    <uix:header textBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest">
      <oem:table
          name="racBaseTopNInstsDS"
          width="100%"
          beanKey="waitDetailsBean"
          dataSourceProp="racBaseTopNInstsDS"
          partialRenderMode="self"
          id="racTopNInstsTable"
          formSubmitted="true"
          blockSize="<%= RacConstants.BLOCKSIZE_UNLIMITED %>"
          summaryBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest"
          alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest"/>
    </uix:header>          

          </uix:stackLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
