<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        cccDrillDown.jsp 
 *
 *      NOTES
 *        tbd
 *       
 * MODIFIED
 *    pboopath   05/05/08 - swf path change from database/flex to rac/flex
 *    kmckeen    03/28/08 - Add form params
 *    pboopath   02/13/08 - Flex no refresh required for summarychart,as flex
 *                          already has a refresh
 *    pboopath   01/16/08 - flex tile chart changes
 *    kmckeen    11/13/07 - Bug 6499189 - fix breadcrumbs
 *    pboopath   11/12/07 - 
 *    rsamaved   04/06/07 - 
 *    pboopath   03/26/07 - Cleanup
 *    pboopath   03/22/07 - removing the switch for svg and non-svg for
 *                          min/max/avg
 *    pboopath   03/20/07 - Convert from db:lineGraph to oem:chart
 *    kmckeen    12/21/06 - UI review - switch tile/top radio buttons
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.rac.RacConstants" %>



<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

    
<%-- For flex summary chart no full page refresh is required.
But for flex tile chart full page refresh is required. --%>

      <uix:switcher childNameBinding="manualSelected@servletRequest">
        <uix:case name="false">
          <uix:rawText>
            <meta http-equiv="Refresh" 
             content="<%=request.getAttribute("refreshChoiceGIF")%>; URL=<%=request.getAttribute("refreshDest") %>" >
          </uix:rawText>
        </uix:case>
      </uix:switcher>

  

  <uix:document> 
  
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>  
    <%@ include file="/oemGlobal.jspf"%>
    <%@ include file="/oemNoscript.jspf"%>

    <uix:body>
    
 

             <db:form name="waitForm" method="post" destination="/console/rac/racTopActivityDrill"
               copyParams="target,type,drillDown,wait,instNum,startLong,endLong,service">
               
               
          <uix:pageLayout titleBinding = "waitTitle@servletRequest" >
          <%--
          <uix:header textBinding="svgUpdateRate@servletRequest" />
          --%>
            <%@ include file="/database/global.jspf" %> 
            
        <uix:messages>
          <uix:switcher childNameBinding="showWarning@servletRequest">
            <uix:case name="true">
            
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              destTableBinding="msgUrls@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
                                      
            </uix:case>
          </uix:switcher>    
        </uix:messages>          

               
          <uix:stackLayout>
          
          
          
          
              <uix:tableLayout width="100%" >
                <uix:rowLayout hAlign="right">
                  
                <uix:cellFormat
                    hAlign="left" vAlign="top" wrappingDisabled="true"
                    renderedBinding="renderDetailsMetricsDropdown@servletRequest">
                  <uix:flowLayout>
                    <uix:styledText
                        styleClass="OraFieldText"
                        textBinding="detailsMetricsLabel@servletRequest"/>
                    <uix:choice
                        id="detailsMetric"
                        name="detailsMetric"
                        selectedValueBinding="detailsMetric@servletRequest"
                        shortDescBinding="detailsMetricsLabel@servletRequest"
                        onChange="submitForm(document.forms[0], true, {'event':'switchDetailsMetric'})">
                      <uix:contents
                          childDataBinding="detailsMetrics@servletRequest">
                        <uix:option 
                            textBinding="text"
                            valueBinding="value"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:flowLayout>
                </uix:cellFormat>
		
                  <uix:cellFormat>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraFieldText" 
                                      textBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                                      labeledNodeId="refreshChoice"/>
                      <uix:choice name="refreshChoice" id="refreshChoice"
                                  shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest"
                                  onChange="submitForm('waitForm', true, {'event':'updateRefreshChoice'})"
                                  selectedValueBinding="refreshChoiceSelected@servletRequest"> 
                        <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                    value="RT_15"/>

                        <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                    value="RT_MAN"/>
                    <uix:option 
                        textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                        value="HIST_CUST"
                     />

                      </uix:choice>
                    </uix:flowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              
             <uix:tableLayout width="100%">
		<uix:rowLayout>
		   <uix:spacer height="5"/>
		</uix:rowLayout>
	    </uix:tableLayout>	
              
	    <uix:tableLayout width="100%">
		<uix:rowLayout>
		  <uix:cellFormat hAlign="left" vAlign="top" wrappingDisabled="true">
		   <uix:flowLayout>
		     <uix:radioSet>
			<uix:radioButton
			     name="chartType"
			     value="topChart"
			     selectedValueBinding="chartType@servletRequest"
			     textBinding="TOP_CHART_VIEW@racMsgBundle@servletRequest"
			     onClick="submitForm(document.forms[0],true,{'event':'switchChartType','chartType':'topChart'})"/>
		       <uix:radioButton
			     name="chartType"
			     value="tileChart"
			     selectedValueBinding="chartType@servletRequest"
			     textBinding="TILE_CHART_VIEW@racMsgBundle@servletRequest"
			     onClick="submitForm(document.forms[0],true,{'event':'switchChartType','chartType':'tileChart'})"/>
		  </uix:radioSet> 
        	 </uix:flowLayout>
		</uix:cellFormat>
                 <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                    <uix:flowLayout>
                      <uix:submitButton 
                          textBinding="CUSTOMIZE_BUTTON@racMsgBundle@servletRequest"
                          name="event" 
                          value="customizeDetails"/>
                    </uix:flowLayout>
                  </uix:cellFormat>
		</uix:rowLayout>
		</uix:tableLayout>
          

	<uix:switcher childNameBinding="chartType@servletRequest">
	 <uix:case name="tileChart">
	   <uix:switcher childNameBinding="useSVG@servletRequest">
                <uix:case name="false">
                    <%@ include file="tileChart.jspf" %>
                 </uix:case>
                  <uix:case name="true">
                      <uix:stackLayout>
                          <db:flexRegion
                            swfName="/rac/flex/topActivityDrillTileChart.swf"
                            dataSrcKeyBinding="flexKey@servletRequest"
                            windowHeightBinding="flexWindowHeightForTileChart@flexTileRacTopActivityDrillBean@servletRequest"                            
                            windowWidth="100%"
                           optionsBinding="racTopActivityDrill@servletRequest"
                          idBase="flexRacTopActivityDrillChart"/>
                       </uix:stackLayout>
                    </uix:case>
                 </uix:switcher>
	</uix:case>
        
	<uix:case name="topChart"> 
         <uix:switcher childNameBinding ="useSVG@servletRequest">
              <uix:case name="true">
               <db:flexRegion
                    swfName="/rac/flex/topActivityDrill.swf"
                    dataSrcKeyBinding="flexKey@servletRequest"
                    windowHeight="270"
                    windowWidth="100%"
                    optionsBinding="racTopActivityDrill@servletRequest"
                    idBase="flexRacTopActivityDrillChart"/>
            </uix:case>
            <uix:case name="false">
            <uix:stackLayout>
                  
          <uix:header textBinding="topChartHdr@servletRequest">
            <uix:stackLayout>
            
              <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="topChartTip@servletRequest"/>            
                  
                <oem:chart chartType="timeSeriesChart" width="825" height="175" timeGranularity="SECOND" orientation="vertical" fill="cumulative" yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest" legendPosition="east" legendVisible="external" titleBinding="ACTIVE_SESSIONS_BY_INST@racMsgBundle@servletRequest" titleVisible="false" seriesColorsAutomatic="true" format="svg" svgUpdateFrequencyBinding="svgUpdateRate@servletRequest" xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest" xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest" yAxisWidth="30" yAxisNumberFormatBinding="waitChartYAxisFormat@servletRequest" axisMin="0" axisMaxBinding="actualMaxValue@waitAreaChart@waitDetailsBean@servletRequest" svgHighlightLegend="true" colorPaletteBinding="waitColorsTable@waitAreaChart@waitDetailsBean@servletRequest">
                      <uix:contents>
                            <oem:boundChartDataSource dataClass="oracle.sysman.db.rac.RacTopActivityDrillController" dataMethod="updateChartData"/>
                            <oem:imageMap imageMapDataSourceBinding="legendLinks@waitAreaChart@waitDetailsBean@servletRequest"/>
                            <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                            <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                            <oem:chartColumn displayLabel="" sourceIndex="2"/>
                      </uix:contents>
                </oem:chart>
           
            </uix:stackLayout>
          </uix:header>                
          
        <uix:header textBinding="minMaxAvgHdr@servletRequest">          
            <uix:stackLayout>
             <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="minMaxAvgTip@servletRequest"/>            
          <oem:chart
                  titleVisible="false"
                  chartType="timeSeriesChart"
                  width="825"
                  height="175"
                  timeGranularity="SECOND"
                  orientation="vertical"
                  fill="none"
                  yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                  legendPosition="east"
                  legendVisible="external"
                  seriesColorsAutomatic="true" format="svg" svgUpdateFrequencyBinding="svgUpdateRate@servletRequest"
		  xAxisMinBinding="beginDate@waitAreaChart@waitDetailsBean@servletRequest" xAxisMaxBinding="endDate@waitAreaChart@waitDetailsBean@servletRequest" yAxisWidth="30" yAxisNumberFormatBinding="waitChartYAxisFormat@servletRequest" axisMin="0" axisMaxBinding="actualMaxValue@waitAreaChart@waitDetailsBean@servletRequest" svgHighlightLegend="true" colorPaletteBinding="waitColorsTable@waitAreaChart@waitDetailsBean@servletRequest"
                  >
                <oem:boundChartDataSource dataClass="oracle.sysman.db.rac.RacTopActivityDrillController" dataMethod="updateMinMaxAvgChart"/>
                
                <oem:chartColumn isKey="true" displayLabel="" sourceIndex="0"/>
                <oem:chartColumn isTimeColumn="true" displayLabel="Time" sourceIndex="1"/>
                <oem:chartColumn displayLabel="" sourceIndex="2"/>
              </oem:chart>
                </uix:stackLayout>
              
         </uix:header> 
          
          </uix:stackLayout>
</uix:case>
</uix:switcher>

	   </uix:case>
	  </uix:switcher>
          

        <uix:header textBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest">
        <oem:table
          name="racTopNInstsDS"
          width="100%"
          beanKey="waitDetailsBean"
          dataSourceProp="racTopNInstsDS"
          partialRenderMode="self"
          id="racTopNInstsTable"
          formSubmitted="true"
          blockSize="<%= RacConstants.BLOCKSIZE_UNLIMITED %>"
          summaryBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest"
          alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest"/>
                    </uix:header>          
          
          </uix:stackLayout>
        </uix:pageLayout>
               </db:form>
 
    </uix:body>
  </uix:document>
</uix:renderingContext>
