<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:switcher childNameBinding="manualSelected@servletRequest">
    <uix:case name="false">
      <uix:rawText>
        <meta http-equiv="Refresh" 
              content="<%=request.getAttribute("refreshChoice")%>; URL=<%=request.getAttribute("RacTopoRefreshURL") %>" >
        </uix:rawText>
      </uix:case>
    </uix:switcher>

  <uix:document> 
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="topoForm" method="post" destination="/console/rac/racSitemap"
               copyParams="target,type">
        <uix:formValue name="pageNum" value="6" />
        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>

          <uix:header textBinding="header@racDBBean@servletRequest"
                      icon="<%= request.getContextPath() + \"/images/database/rac/dbcluster.gif\" %>"  >

          <uix:contextSwitcher>
            <uix:switcher childNameBinding="showContextSwitcher@servletRequest">
              <uix:case name="true">
              <uix:flowLayout>
                  <uix:styledText styleClass="OraPromptText" 
                        textBinding="SWITCH_TOPOLOGY@racMsgBundle@servletRequest"/>  
                <oem:choice name="racdbChoice" id="racdbChoice"
			shortDescBinding="SWITCH_TOPOLOGY@racMsgBundle@servletRequest"  
                            selectedValueBinding="racdb@servletRequest" 
                            optionsBinding="racdbList@servletRequest"
                            onChange="submitForm('topoForm', true, {'event':'switchRacDB','pageNum':'6'})"> 
                        </oem:choice>  
              </uix:flowLayout>        
              </uix:case>
            </uix:switcher>
          </uix:contextSwitcher>

        <uix:formValue name="topoForm" value="6" />

            <!-- ============== show update time =========== -->
            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                  <%@ include file="refreshTime.jspf" %>
              </uix:rowLayout>
            </uix:tableLayout>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="7">
                <%@ include file="racTabs.jspf"%>
              </uix:subTabBar>
            </uix:subTabs>

            <jsp:include page="racdb_topo.jsp" /> 
            <uix:ref refID="racdbTopo" />        
            
          </uix:subTabLayout>

        </uix:header>

        <uix:rawText>
          <a name="instances">
       </uix:rawText>

          <%@ include file="comp.jspf" %>

      <oem:relatedLinks />

    </uix:pageLayout>
    </db:form>
    
    </uix:body>

    </uix:document> 
  </uix:renderingContext> 





  
