<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *        waitDetails.jsp 
 *
 *      NOTES
 *        tbd
 *       
 * MODIFIED
 *    pboopath   05/05/08 - swf path change from database/flex to rac/flex
 *    pboopath   03/17/08 - tilechart refresh fix
 *    pboopath   02/13/08 - Flex no refresh required for summarychart,as flex
 *                          already has a refresh
 *    dchakumk   03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
 *                          st_emdbsa_11.1
 *    pboopath   01/30/08 - Flex no refresh required ,as flex already has a
 *                          refresh
 *    pboopath   01/22/08 - XbranchMerge pboopath_bug-6759170 from main
 *    pboopath   01/21/08 - XbranchMerge pboopath_flex_rac_txn2 from main
 *    pboopath   01/19/08 - flex tilechart window height change
 *    pboopath   01/10/08 - tile chart flex changes
 *    kmckeen    11/20/07 - XbranchMerge kmckeen_bug-3857794 from main
 *    kmckeen    11/12/07 - Bug 6499189 - fix breadcrumbs
 *    pboopath   11/01/07 - flex chart changes
 *    kmckeen    08/24/07 - Support Historical mode
 *    rsamaved   01/11/07 - XbranchMerge rsamaved_ui_review from main
 *    kmckeen    12/29/06 - UI review - align graphs in SVG mode
 *    kmckeen    12/28/06 - UI review - remove Prev/Next table navigation info
 *    kmckeen    12/21/06 - UI review - switch tile/top radio buttons
 *    kmckeen    11/30/06 - Fix oac/ui issues
 *    pboopath   11/21/06 - SVG in IE(5663821)
 *    pboopath   11/16/06 - Bug 5663821
 *    kmckeen    09/14/06 - Make legends external
 *    ezeng      09/14/06 - Switch from oem:lineGraph to db:lineGraph
 *    kmckeen    04/25/06 - Updates to support tile charts
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.db.rac.RacConstants" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

  <%-- For flex summary chart no full page refresh is required.
But for flex tile chart full page refresh is required. --%>
      <uix:switcher childNameBinding="manualSelected@servletRequest">
        <uix:case name="false">
          <uix:rawText>
            <meta http-equiv="Refresh" 
             content="<%=request.getAttribute("refreshChoiceGIF")%>; URL=<%=request.getAttribute("refreshDest") %>" >
          </uix:rawText>
        </uix:case>
      </uix:switcher>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>  

    <uix:body>

      <uix:switcher childNameBinding="showWarning@servletRequest">
        <uix:case name="true">
          <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                          errorTableBinding="msgBox@servletRequest"
                          destTableBinding="msgUrls@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:case>
      </uix:switcher>

      <db:form name="waitForm" method="post" destination="/console/rac/racPerfDetails"
               copyParams="target,type,drillDown,wait,instNum">

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>
          <uix:header textBinding="detailsTitle@servletRequest">
            <uix:stackLayout>

<uix:tableLayout width="100%">
  <uix:rowLayout>
    <uix:cellFormat
        hAlign="left" vAlign="top" wrappingDisabled="true"
        renderedBinding="renderDetailsMetricsDropdown@servletRequest">
      <uix:flowLayout>
        <uix:styledText
            styleClass="OraFieldText"
            textBinding="detailsMetricsLabel@servletRequest"/>
        <uix:choice
            id="detailsMetric"
            name="detailsMetric"
            selectedValueBinding="detailsMetric@servletRequest"
            shortDescBinding="detailsMetricsLabel@servletRequest"
            onChange="submitForm(document.forms[0], true, {'event':'switchDetailsMetric'})">
          <uix:contents
              childDataBinding="detailsMetrics@servletRequest">
            <uix:option 
                textBinding="text"
                valueBinding="value"/>
          </uix:contents>
        </uix:choice>
      </uix:flowLayout>
    </uix:cellFormat>
    <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
      <uix:flowLayout>
        <uix:styledText
            styleClass="OraFieldText"
            textBinding="VIEW_DATA@DBMsgBundle@servletRequest"
            labeledNodeId="refreshChoice"/>
        <uix:choice
            name="refreshChoice"
            id="refreshChoice"
            shortDescBinding="VIEW_DATA@DBMsgBundle@servletRequest"
            onChange="submitForm(document.forms[0], true, {'event':'doLoad'})"
            selectedValueBinding="refreshChoiceSelected@servletRequest">
          <uix:option
              textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
              value="RT_15"/>
          <uix:option
              textBinding="REAL_TIME_1_MIN@DBMsgBundle@servletRequest"
              value="RT_60"/>
          <uix:option
              textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
              value="RT_MAN"/>
          <uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
              renderedBinding="renderHistoricalOption@defaultBean@servletRequest"
              value="HIST_CUST"/>  
        </uix:choice>
      </uix:flowLayout>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>

<uix:tableLayout width="100%">
  <uix:rowLayout>
    <uix:spacer height="5"/>
  </uix:rowLayout>
</uix:tableLayout>

<uix:tableLayout width="100%">
  <uix:rowLayout>
    <uix:cellFormat hAlign="left" vAlign="top" wrappingDisabled="true">
      <uix:flowLayout>
        <uix:radioSet>
          <uix:radioButton
              name="chartType"
              value="topChart"
              selectedValueBinding="chartType@servletRequest"
              textBinding="TOP_CHART_VIEW@racMsgBundle@servletRequest"
              onClick="submitForm(document.forms[0], true, {'event':'switchChartType', 'chartType':'topChart'})"/>
          <uix:radioButton
              name="chartType"
              value="tileChart"
              selectedValueBinding="chartType@servletRequest"
              textBinding="TILE_CHART_VIEW@racMsgBundle@servletRequest"
              onClick="submitForm(document.forms[0], true, {'event':'switchChartType', 'chartType':'tileChart'})"/>
        </uix:radioSet>
      </uix:flowLayout>
    </uix:cellFormat>
    <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
      <uix:flowLayout>
        <uix:submitButton 
            textBinding="CUSTOMIZE_BUTTON@racMsgBundle@servletRequest"
            name="event" 
            value="customizeDetails"/>
      </uix:flowLayout>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>

<uix:tableLayout width="100%">
  <uix:rowLayout>
    <uix:spacer height="5"/>
  </uix:rowLayout>
</uix:tableLayout>

<uix:switcher childNameBinding="chartType@servletRequest">

  <uix:case name="tileChart">
    <uix:switcher childNameBinding="useSVG@servletRequest">
        <uix:case name="false">
            <%@ include file="tileChart.jspf" %>
        </uix:case>
        <uix:case name="true">
            <uix:stackLayout>
                     <db:flexRegion
                            swfName="/rac/flex/racWaitDetailsTileChart.swf"
                            dataSrcKeyBinding="flexKey@racDBBean@servletRequest"
                            optionsBinding="flexracWaitDrillDownKeys@servletRequest"
                            windowHeightBinding="flexWindowHeightForTileChart@racDBBean@servletRequest"                            
                            windowWidth="100%"
                            idBase="flexRacWaitDetailsChart"/>
             </uix:stackLayout>
        </uix:case>
    </uix:switcher>
    
  </uix:case>

  <uix:case name="topChart">
    <uix:switcher childNameBinding="useSVG@servletRequest">
      <uix:case name="false">
        <uix:stackLayout>
          <uix:header textBinding="topChartHdr@servletRequest">
            <uix:stackLayout>
              <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="topChartTip@servletRequest"/>
              <oem:chart
                  titleBinding="detailsSummaryChartTitle@servletRequest"
                  titleVisible="false"
                  chartType="timeSeriesChart"
                  width="800"
                  height="150"
                  timeGranularity="SECOND"
                  orientation="vertical"
                  fill="cumulative"
                  legendPosition="east"
                  legendVisible="external"
                  yAxisLabelBinding="detailsYAxisLabel@servletRequest">
                <oem:boundChartDataSource
                    chartDataSourceBinding="waitDetailChart@servletRequest"/>
                <oem:chartColumn
                    isKey="true"
                    displayLabel="Target"
                    sourceIndex="0"/>
                <oem:chartColumn
                    isTimeColumn="true"
                    displayLabel="Date"
                    sourceIndex="1"/>
                <oem:chartColumn
                    displayLabel=""
                    sourceIndex="2"/>
                <oem:imageMap
                    imageMapDataSourceBinding="waitInstImageMap@servletRequest"/>
              </oem:chart>
            </uix:stackLayout>
          </uix:header>
          <uix:header textBinding="minMaxAvgHdr@servletRequest">
            <uix:stackLayout>
              <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="minMaxAvgTip@servletRequest"/>
              <oem:chart
                  titleBinding="detailsMinMaxAvgChartTitle@servletRequest"
                  titleVisible="false"
                  chartType="timeSeriesChart"
                  width="800"
                  height="150"
                  timeGranularity="SECOND"
                  orientation="vertical"
                  fill="none"
                  legendPosition="east"
                  legendVisible="external"
                  yAxisLabelBinding="detailsYAxisLabel@servletRequest">
                <oem:boundChartDataSource
                    chartDataSourceBinding="waitDetailChartMinMaxAvg@servletRequest"/>
                <oem:chartColumn
                    isKey="true"
                    displayLabel="Target"
                    sourceIndex="0"/>
                <oem:chartColumn
                    isTimeColumn="true"
                    displayLabel="Date"
                    sourceIndex="1"/>
                <oem:chartColumn
                    displayLabel=""
                    sourceIndex="2"/>
              </oem:chart>
            </uix:stackLayout>
          </uix:header>
        </uix:stackLayout>
      </uix:case>
    </uix:switcher>
  </uix:case>

</uix:switcher>

<uix:switcher childNameBinding="chartType@servletRequest">
  <uix:case name="topChart">
    <uix:switcher childNameBinding="useSVG@servletRequest">
      <uix:case name="true">
      <uix:stackLayout>
          <uix:styledText
              styleClass="OraInstructionText"
              textBinding="topChartTip@servletRequest"/>
    
         <db:flexRegion
                            swfName="/rac/flex/racWaitDetails.swf"
                            dataSrcKeyBinding="flexKey@racDBBean@servletRequest"
                            optionsBinding="flexracWaitDrillDownKeys@servletRequest"
                            windowHeight="270"
                            windowWidth="100%"
                            idBase="flexRacWaitDetailsChart"/>
          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:spacer width="15"/>
              <uix:styledText
                  styleClass="OraInlineInfoText"
                  textBinding="minMaxAvgTip@servletRequest"/>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:stackLayout>
      </uix:case>
    </uix:switcher>
  </uix:case>
</uix:switcher>

<uix:header textBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest">
  <oem:table
    name="racTopNInstsDS"
    width="100%"
    beanKey="racDBBean"
    dataSourceProp="racTopNInstsDS"
    partialRenderMode="self"
    id="racTopNInstsTable"
    formSubmitted="true"
    blockSize="<%= RacConstants.BLOCKSIZE_UNLIMITED %>"
    summaryBinding="INSTANCES_DATA_HDR@racMsgBundle@servletRequest"
    alternateTextBinding="NO_DATA_ALT@racMsgBundle@servletRequest"/>
</uix:header>

            </uix:stackLayout>
          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
