<%--
   Name:        em/swb/advsearch.jsp

   Description: This jsp is for the Support workbench advanced search page.

   Controller:  oracle.sysman.dbTarget.swb.console.advsearch.AdvSearchController

   Notes:

   Events:
       view : view problems
       package : package problems
       close : close problems

   MODIFIED     (MM/DD/YY)
     fagonzal    01/26/09 - bug 8199214
     balnaff     12/13/07 - Backport balnaff_bug-6634265_main from main
     jro         03/16/07 - fix for OAC violations
     jro         03/15/07 - oac violation fix
     jro         03/15/07 - fix bug 5926607 oac violations
     balnaff     11/29/06 - 
     hopark      10/18/06 - remove selection header
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>

<%
String multiSelWarning = (String) request.getAttribute("multiSelWarning");
String noSelWarning = (String) request.getAttribute("noSelWarning");
%>

<script language="JavaScript">

function checkMultiSelection(tbl,ev)
{
    var proxy = new TableProxy(tbl);
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    if (rows.length > 1) {
        alert('<%= multiSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}

function checkSelection(tbl,ev)
{
    var proxy = new TableProxy(tbl);
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}


</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="advSrchView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
    <uix:body>
       <uix:form name="foo"  method="POST" destinationBinding="myTarget">
        <uix:pageLayout titleBinding ="pageTitle">
<%--  global popups and bread crumbs  --%>
          <%@ include file="/database/global.jspf" %>

        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="ADVSRCH_BTN_SEARCH@SWBMsgs" disabledBinding ="enableSearch"
                        onClick="submitForm('foo', true, {event:'search'})" />
          </uix:pageButtonBar>
        </uix:pageButtons>

<%-- start Criteria section --%>
<uix:tableLayout width="100%">
   <uix:hideShowHeader textBinding="ADVSRCH_HEADER_CRITERIA@SWBMsgs" id="headerHS" disclosedBinding="headerHS">
   <uix:rowLayout width="100%">
     <uix:cellFormat>
            <uix:tableLayout width="80%">
              <uix:rowLayout width="100%">
                <uix:cellFormat>
                    <uix:spacer width="10"/>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top">
                    <uix:stackLayout>
                        <uix:rowLayout>
                            <uix:header textBinding="ADVSRCH_CRITERIA_SRCHTGT@SWBMsgs">
                            <uix:spacer width="10"/>
                            <uix:cellFormat>
                            <uix:stackLayout>
                                <uix:radioButton
                                     name="searchTarget"
                                     value="problem"
                                     selectedValueBinding="searchTarget"
                                     textBinding="ADVSRCH_CRITERIA_PRBSRCHTGT@SWBMsgs"
                                     shortDescBinding="ADVSRCH_CRITERIA_PRBSRCHTGT@SWBMsgs"
                                     styleClass="OraInstructionText"
                                     onClick="submitForm('foo', true, {event:'searchProblem'})"
                                />
                                <uix:radioButton
                                     name="searchTarget"
                                     value="incident"
                                     selectedValueBinding="searchTarget"
                                     textBinding="ADVSRCH_CRITERIA_INCSRCHTGT@SWBMsgs"
                                     shortDescBinding="ADVSRCH_CRITERIA_INCSRCHTGT@SWBMsgs"
                                     styleClass="OraInstructionText"
                                     onClick="submitForm('foo', true, {event:'searchIncident'})"
                                />
                            </uix:stackLayout>
                            </uix:cellFormat>
                            </uix:header>
                        </uix:rowLayout>
                    </uix:stackLayout>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:header textBinding="ADVSRCH_CRITERIA_DATERANGE@SWBMsgs">
                        <uix:stackLayout>
                          <uix:dataScope currentDataBinding="schedule">
                            <uix:tableLayout cellSpacing="5">
                                <uix:rowLayout>
                                    <%-- ALL RADIO BUTTON --%>
                                    <uix:radioButton
                                         name="scheduleTypeSB"
                                         value="all"
                                         selectedValueBinding="scheduleTypeSB"
                                         onClick="submitForm('foo', true, {event:'all'})"
                                         textBinding="ADVSRCH_CRITERIA_DATE_ALL@SWBMsgs"
                                         shortDescBinding="ADVSRCH_CRITERIA_DATE_ALL@SWBMsgs"
                                         styleClass="OraInstructionText"
                                    />
                                </uix:rowLayout>

                                <uix:rowLayout>
                                    <uix:rowLayout hAlign="left">
                                        <%-- LAST RADIO BUTTON --%>
                                        <uix:radioButton
                                             name="scheduleTypeSB"
                                             value="last"
                                             onClick="submitForm('foo', true, {event:'last'})"
                                             selectedValueBinding="scheduleTypeSB"
                                             textBinding="ADVSRCH_CRITERIA_DATE_LAST@SWBMsgs"
                                             shortDescBinding="ADVSRCH_CRITERIA_DATE_LAST@SWBMsgs"
                                             styleClass="OraInstructionText"
                                        />
                                        <uix:spacer width="5" />
                                      <uix:switcher childNameBinding="scheduleTypeSB">
                                        <uix:case name="last">
                                        <uix:messageTextInput name="scheduleLast" prompt=" "
                                            textBinding="scheduleLast@advSrchView@servletRequest" columns="6"
                                            anchorBinding="scheduleLast_anchor@errors@servletRequest"
                                            messageTypeBinding="scheduleLast_type@errors@servletRequest"
                                            messageBinding="scheduleLast_msg@errors@servletRequest"
                                            shortDescBinding="ADVSRCH_CRITERIA_DATE_LAST@SWBMsgs"
                                            />
                                      </uix:case>
                                    </uix:switcher>
                                        <uix:spacer width="5" />
                                      <uix:switcher childNameBinding="scheduleTypeSB">
                                        <uix:case name="last">
                                        <uix:choice name="scheduleLastUnit"
                                            selectedValueBinding="scheduleLastUnit@advSrchView@servletRequest"
                                            shortDescBinding="ADVSRCH_CRITERIA_DATE_LAST@SWBMsgs">
                                            <uix:contents>
                                                <uix:option textBinding="ADVSRCH_CRITERIA_DATE_LASTHOURS@SWBMsgs" value="hours"/>
                                                <uix:option textBinding="ADVSRCH_CRITERIA_DATE_LASTDAYS@SWBMsgs" value="days"/>
                                            </uix:contents>
                                        </uix:choice>
                                      </uix:case>
                                    </uix:switcher>
                                    </uix:rowLayout>
                                </uix:rowLayout>

                                <uix:rowLayout>
                                    <%-- TIME INTERNVAL RADIO BUTTON --%>
                                    <uix:radioButton
                                         name="scheduleTypeSB"
                                         value="interval"
                                         selectedValueBinding="scheduleTypeSB"
                                         onClick="submitForm('foo', true, {event:'interval'})"
                                         textBinding="ADVSRCH_CRITERIA_DATE_INTERVAL@SWBMsgs"
                                         shortDescBinding="ADVSRCH_CRITERIA_DATE_INTERVAL@SWBMsgs"
                                         styleClass="OraInstructionText"
                                    />
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <%-- START DATE --%>
                                    <uix:cellFormat  hAlign="right">
                                      <uix:switcher childNameBinding="scheduleTypeSB">
                                        <uix:case name="interval">
                                          <uix:messagePrompt
                                               labeledNodeId="startDateSB"
                                               promptBinding="ADVSRCH_CRITERIA_DATE_START@SWBMsgs"
                                               anchorBinding="startDateSB_anchor@errors@servletRequest"
                                               messageTypeBinding="startDateSB_type@errors@servletRequest"
                                          />
                                        </uix:case>
                                      </uix:switcher>
                                    </uix:cellFormat>
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <uix:messageDateField
                                             id="startDateSB"
                                             name="startDateSB"
                                             valueBinding="startDateSB"
                                             tipBinding="DateExampleKey@servletRequest"
                                             shortDescBinding="ADVSRCH_CRITERIA_DATE_START@SWBMsgs"
                                              messageBinding="startDateSB_msg@errors@servletRequest"
                                             columns="24">
                                            <uix:onSubmitValidater>
                                            <uix:date dateStyle="long" pattern="MM-dd-yyyy"/>
                                            </uix:onSubmitValidater>
                                        </uix:messageDateField>
                                      </uix:case>
                                    </uix:switcher>
                                </uix:rowLayout>

                                <uix:rowLayout hAlign="right">
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                    <%-- START HOUR --%>
                                        <uix:messagePrompt
                                             promptBinding="ADVSRCH_CRITERIA_DATE_STARTTIME@SWBMsgs"
                                            anchorBinding="startHourSB_anchor@errors@servletRequest"
                                            messageTypeBinding="startHourSB_type@errors@servletRequest"
                                        />
                                      </uix:case>
                                    </uix:switcher>
                                    <uix:rowLayout hAlign="left">
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <uix:choice
                                             name="startHourSB"
                                             id="startTimeID"
                                             shortDescBinding="HOURS@SDKMsgs"
                                             selectedValueBinding="startHourSB"
                                        >
                                          <uix:contents childDataBinding="hoursSB">
                                            <uix:option textBinding="Text"
                                                        valueBinding="Value"/>
                                          </uix:contents>
                                        </uix:choice>
                                      </uix:case>
                                    </uix:switcher>
                                        <uix:spacer width="5"
                                        />
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <%-- START MINUTE --%>
                                        <uix:choice
                                             name="startMinuteSB"
                                             id="startTimeIDMIN"
                                            shortDescBinding="MINUTES@SDKMsgs"
                                            selectedValueBinding="startMinuteSB"
                                        >
                                          <uix:contents childDataBinding="minutesSB">
                                            <uix:option textBinding="Text"
                                                        valueBinding="Value"/>
                                          </uix:contents>
                                        </uix:choice>
                                      </uix:case>
                                    </uix:switcher>
                                        <uix:spacer width="5"
                                        />
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <%-- START AM/PM --%>
                                        <oem:radioButton
                                             name="startAmPmSB"
                                             value="AM_VALUE"
                                             selectedValueBinding="startAmPmSB"
                                             textBinding="AM_LABEL@SDKMsgs"
                                             shortDescBinding="AM_LABEL@SDKMsgs"
                                             styleClass="OraInstructionText"
                                        />
                                      </uix:case>
                                    </uix:switcher>
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <oem:radioButton
                                             name="startAmPmSB"
                                             value="PM_VALUE"
                                             selectedValueBinding="startAmPmSB"
                                             textBinding="PM_LABEL@SDKMsgs"
                                             shortDescBinding="PM_LABEL@SDKMsgs"
                                             styleClass="OraInstructionText"
                                        />
                                      </uix:case>
                                    </uix:switcher>
                                    </uix:rowLayout>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <%-- END DATE --%>
                                    <uix:cellFormat  hAlign="right">
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <uix:messagePrompt
                                            labeledNodeId="endDateSB"
                                             promptBinding="ADVSRCH_CRITERIA_DATE_END@SWBMsgs"
                                            anchorBinding="endDateSB_anchor@errors@servletRequest"
                                            messageTypeBinding="endDateSB_type@errors@servletRequest"
                                        />
                                      </uix:case>
                                    </uix:switcher>
                                    </uix:cellFormat>
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                    <uix:messageDateField
                                         id="endDateSB"
                                         name="endDateSB"
                                         valueBinding="endDateSB"
                                         shortDescBinding="ADVSRCH_CRITERIA_DATE_END@SWBMsgs"
                                          messageBinding="endDateSB_msg@errors@servletRequest"
                                         columns="24">
                                        <uix:onSubmitValidater>
                                        <uix:date dateStyle="long" pattern="MM-dd-yyyy"/>
                                        </uix:onSubmitValidater>
                                    </uix:messageDateField>
                                      </uix:case>
                                    </uix:switcher>
                                </uix:rowLayout>

                                <uix:rowLayout hAlign="right">
                                    <%-- END HOUR --%>
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <uix:messagePrompt
                                             promptBinding="ADVSRCH_CRITERIA_DATE_ENDTIME@SWBMsgs"
                                            anchorBinding="endHourSB_anchor@errors@servletRequest"
                                            messageTypeBinding="endHourSB_type@errors@servletRequest"
                                        />
                                      </uix:case>
                                    </uix:switcher>
                                    <uix:rowLayout hAlign="left">
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <uix:choice
                                             name="endHourSB"
                                             id="endTimeID"
                                             shortDescBinding="HOURS@SDKMsgs"
                                             selectedValueBinding="endHourSB"
                                        >
                                          <uix:contents childDataBinding="hoursSB">
                                            <uix:option textBinding="Text"
                                                        valueBinding="Value"/>
                                          </uix:contents>
                                        </uix:choice>
                                      </uix:case>
                                    </uix:switcher>
                                        <uix:spacer width="5"
                                        />
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <%-- END MINUTE --%>
                                        <uix:choice
                                             name="endMinuteSB"
                                             id="endTimeIDMIN"
                                            shortDescBinding="MINUTES@SDKMsgs"
                                            selectedValueBinding="endMinuteSB"
                                        >
                                          <uix:contents childDataBinding="minutesSB">
                                            <uix:option textBinding="Text"
                                                        valueBinding="Value"/>
                                          </uix:contents>
                                        </uix:choice>
                                      </uix:case>
                                    </uix:switcher>
                                        <uix:spacer width="5"
                                        />
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <%-- END AM/PM --%>
                                        <oem:radioButton
                                             name="endAmPmSB"
                                             value="AM_VALUE"
                                             selectedValueBinding="endAmPmSB"
                                             textBinding="AM_LABEL@SDKMsgs"
                                             shortDescBinding="AM_LABEL@SDKMsgs"
                                             styleClass="OraInstructionText"
                                        />
                                      </uix:case>
                                    </uix:switcher>
                                    <uix:switcher childNameBinding="scheduleTypeSB">
                                      <uix:case name="interval">
                                        <oem:radioButton
                                             name="endAmPmSB"
                                             value="PM_VALUE"
                                             selectedValueBinding="endAmPmSB"
                                             textBinding="PM_LABEL@SDKMsgs"
                                             shortDescBinding="PM_LABEL@SDKMsgs"
                                             styleClass="OraInstructionText"
                                        />
                                      </uix:case>
                                    </uix:switcher>
                                    </uix:rowLayout>
                                </uix:rowLayout>
                                <uix:rowLayout hAlign="right">
                                  <uix:switcher childNameBinding="scheduleTypeSB">
                                    <uix:case name="interval">
                                  <uix:messagePrompt
                                       labeledNodeId="startTzSB"
                                       promptBinding="TIMEZONE@SWBMsgs"/>
                                      </uix:case>
                                    </uix:switcher>
                                  <uix:switcher childNameBinding="scheduleTypeSB">
                                    <uix:case name="interval">
                                  <uix:choice name="startTzSB"
                                             id="startTzSB"
                                             shortDescBinding="TIMEZONE@SDKMsgs"
                                             selectedValueBinding="startTzSB">
                                    <uix:contents childDataBinding="timezonesSB">
                                      <uix:option textBinding="Text"
                                                  valueBinding="Value"/>
                                    </uix:contents>
                                  </uix:choice>
                                      </uix:case>
                                    </uix:switcher>
                                </uix:rowLayout>
                            </uix:tableLayout>
                          </uix:dataScope>
                        </uix:stackLayout>
                    </uix:header>

                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer width="10"/>
                </uix:cellFormat>
                <uix:cellFormat columnSpan="2">
                    <uix:header textBinding="ADVSRCH_CRITERIA_FILTERS@SWBMsgs">
<%-- Start Filter table section --%>
                <uix:rowLayout>
                    <uix:styledText styleClass="OraFieldText" textBinding="ADVSRCH_FILTERS_COL_FIELD@SWBMsgs" />
                    <uix:spacer width="15"/>
                    <oem:choice
                         name="filter"
                         id="filter"
                         optionsBinding="fields@servletRequest"
                         shortDescBinding="ADVSRCH_CRITERIA_FILTERS@SWBMsgs"
                    />
                    <uix:spacer width="5"/>
                    <uix:button textBinding="ADVSRCH_FILTERS_BTN_ADD@SWBMsgs"
                        onClick="submitForm('foo', true, {event:'addFilter'})" />
                </uix:rowLayout>
                <uix:spacer height="5"/>
 <uix:rowLayout width="50%">
  <uix:dataScope currentDataBinding="tableBean">
    <uix:dataScope currentDataBinding="filterTbl">
        <uix:table name="filterTbl"
              id="filterTbl"
              showAll="yes"
              alternateTextBinding="ADVSRCH_FILTERS_ALT@SWBMsgs"
              minValue="1"
              destinationBinding="destination"
              maxValueBinding="maxValue"
              blockSizeBinding="blockSize"
              valueBinding="value"
              summaryBinding="ADVSRCH_FILTERS_SUMMARY@SWBMsgs"
              tableDataBinding="tableData"
              columnHeaderDataBinding="columnHeaderData"
              columnFormatsBinding="columnFormatsData"
              formSubmitted="true"
              width="100%">
            <uix:columnHeaderStamp>
               <uix:sortableHeader textBinding="text"
                                   valueBinding="value"
                                   sortableBinding="sortable"/>
            </uix:columnHeaderStamp>
            <uix:contents>
                <uix:styledText textBinding="field" />
                <uix:textInput name="value" textBinding="Value" columns="40" shortDescBinding="ADVSRCH_FILTERS_SUMMARY@SWBMsgs"/>
                <uix:image source="/em/images/remove_enabled.gif" shortDescBinding="REMOVE@SDKMsgs" destinationBinding="Remove" />
           </uix:contents>
           </uix:table>
        </uix:dataScope>
    </uix:dataScope>
 </uix:rowLayout>
 <uix:rowLayout>
           <uix:tip>
             <uix:contents>
               <uix:styledText textBinding="ADVSRCH_CRITERIA_FILTERS_TIP@SWBMsgs" />
             </uix:contents>
           </uix:tip>
</uix:rowLayout>
<%-- End Filter table section --%>
                    </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
             </uix:tableLayout>
     </uix:cellFormat>
   </uix:rowLayout>
   </uix:hideShowHeader>

        <uix:rowLayout>
          <uix:spacer height="5"/>
        </uix:rowLayout>
<%-- start Result section --%>
   <uix:switcher childNameBinding="searchPerformed">
     <uix:case name="true">
       <uix:separator/>
     </uix:case>
   </uix:switcher>
   <uix:rowLayout width = "100%">
     <uix:cellFormat>
        <uix:switcher childNameBinding="searchPerformed"> 
            <uix:case name="true">
              <uix:switcher childNameBinding="searchTarget">
                <uix:case name="problem">
                  <uix:header textBinding="ADVSRCH_HEADER_PRESULTS_PRB@SWBMsgs">
                    <%@ include file = "/swb/problemTbl.jspf" %>
                  </uix:header>
                </uix:case>
                <uix:case name="incident">
                  <uix:header textBinding="ADVSRCH_HEADER_PRESULTS_INC@SWBMsgs">
                    <%@ include file = "/swb/prbIncidents.jspf" %>
                  </uix:header>
                </uix:case>
              </uix:switcher>
        </uix:case>
      </uix:switcher>
    </uix:cellFormat>
  </uix:rowLayout>
<%-- end Result section --%>
</uix:tableLayout>
        </uix:pageLayout>
         </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

