<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.cabo.ui.data.MessageData" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMMsgID"%>
<%@ page import="oracle.sysman.dbTarget.swb.console.hm.HMUIConstants" %>

<jsp:useBean id="pageView"
             scope="request"
             type="oracle.sysman.dbTarget.swb.console.hm.CheckerCentralPageView"/>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="DBMsg"
	     class="oracle.sysman.db.rsc.inst.DBMsg"/>
 <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
 <uix:bundle name="HMMsg"
             class="oracle.sysman.dbTarget.swb.console.hm.HMMsg"/>
 <uix:bundle name="SWBMsgs"
             class="oracle.sysman.dbTarget.swb.console.hm.SwbMsg"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="pageView@servletRequest">
      <uix:body>
        <uix:form name="foo"
                  destination='<%= request.getContextPath()+"/console/"+HMUIConstants.CHECKER_CENTRAL_PAGE %>'>
          <uix:pageLayout titleBinding="pageTitle@pageView@servletRequest">
            <%@ include file="/database/global.jspf" %>

<uix:messages>
 <uix:dataScope currentDataBinding="results@pageView@servletRequest">
  <uix:switcher childNameBinding="<%= HMUIConstants.KEY_EXISTS %>">
   <uix:case name="<%= Boolean.TRUE.toString() %>">
    <uix:messageBox messageBinding="<%= MessageData.MESSAGE_DATA_MESSAGE %>"
                    messageTypeBinding="<%= MessageData.MESSAGE_DATA_TYPE_SELECT %>">
     <uix:contents childDataBinding="<%= MessageData.MESSAGE_DATA_MESSAGES_SELECT %>">
      <uix:link textBinding="<%= UIConstants.TEXT_ATTR.getAttributeName() %>"
                destinationBinding="<%= UIConstants.LONG_DESC_URL_ATTR.getAttributeName() %>"
                longDescBinding="<%= MessageData.MESSAGE_ATTR.getAttributeName() %>" />
     </uix:contents>
    </uix:messageBox>
   </uix:case>
  </uix:switcher>
 </uix:dataScope>
</uix:messages>
  
            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar>
                  <uix:contents>
<!--                  
                    <uix:switcher childNameBinding="hasAdvisorCentral@pageView@servletRequest">                     
                      <uix:case name="true">            
                        <uix:link
                          textBinding='<%=HMMsgID.TAB_ADVISOR_CENTRAL+"@HMMsg"%>'
                          destinationBinding = "advisorCentralLink@pageView@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
-->                    
                    <uix:link
                      textBinding='<%=HMMsgID.TAB_CHECKER_CENTRAL+"@HMMsg"%>'
                      selected="true"/>                    
                  </uix:contents>
                </uix:subTabBar>
               </uix:subTabs>
                            
              <%-- refresh --%>
              <%@ include file = "/swb/refresh.jspf" %>

              <%@ include file="checkerList.jspf" %>
              <uix:header textBinding='<%=HMMsgID.HEADER_CHECKER_RUNS+"@HMMsg"%>'>
                <uix:header textBinding='<%=HMMsgID.HEADER_SEARCH+"@HMMsg"%>'>
                  <uix:tableLayout cellSpacing="2">
                    <uix:rowLayout>
                      <uix:styledText styleClass="OraPromptText" labeledNodeId="checkerNameChoice"
                           textBinding='<%=HMMsgID.LABEL_CHECKER_NAME+"@HMMsg"%>'/>
                      <uix:styledText styleClass="OraPromptText" labeledNodeId="runName"
                           textBinding='<%=HMMsgID.LABEL_RUN_NAME+"@HMMsg"%>'/>
                      <uix:styledText styleClass="OraPromptText" labeledNodeId="interval"
                           textBinding='<%=HMMsgID.LABEL_RUNS_TIME+"@HMMsg"%>'/>
                      <uix:styledText styleClass="OraPromptText" labeledNodeId="statusChoice"
                           textBinding='<%=HMMsgID.LABEL_RUNNING_STATUS+"@HMMsg"%>'/>
                      <uix:styledText styleClass="OraPromptText" labeledNodeId="runType"
                           textBinding='<%=HMMsgID.LABEL_RUN_TYPE+"@HMMsg"%>'/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:choice name="<%= HMUIConstants.PARAM_CHECKER_NAME%>" 
                                  id="checkerNameChoice"
      		              selectedValueBinding="checkerName@pageView@servletRequest">
                        <uix:contents childDataBinding="checkerNameOptions@pageView@servletRequest">
                          <uix:option textBinding="<%= UIConstants.TEXT_KEY %>"
                                      valueBinding="<%= HMUIConstants.KEY_VALUE %>"/>
                        </uix:contents>
                      </uix:choice>
                      <uix:textInput id="runName" 
                           name="<%= HMUIConstants.PARAM_CHECKER_RUN_NAME %>"
                           textBinding="runName@pageView@servletRequest"/>
                      <uix:choice name="<%= HMUIConstants.PARAM_CHECKER_INTERVAL %>" 
                                  id="interval"
      		              selectedValueBinding="interval@pageView@servletRequest">
                        <uix:contents childDataBinding="timeOptions@pageView@servletRequest">
                          <uix:option textBinding="<%= UIConstants.TEXT_KEY %>"
                                      valueBinding="<%= HMUIConstants.KEY_VALUE %>"/>
                        </uix:contents>
                      </uix:choice>
                      <uix:choice name="<%= HMUIConstants.PARAM_CHECKER_STATUS%>" 
                                  id="statusChoice"
      		              selectedValueBinding="status@pageView@servletRequest">
                        <uix:contents childDataBinding="statusOptions@pageView@servletRequest">
                          <uix:option textBinding="<%= UIConstants.TEXT_KEY %>"
                                      valueBinding="<%= HMUIConstants.KEY_VALUE %>"/>
                        </uix:contents>
                      </uix:choice>
                      <uix:choice name="<%= HMUIConstants.PARAM_CHECKER_RUN_TYPE%>" 
                                  id="runType"
      		              selectedValueBinding="runType@pageView@servletRequest">
                        <uix:contents childDataBinding="runTypeOptions@pageView@servletRequest">
                          <uix:option textBinding="<%= UIConstants.TEXT_KEY %>"
                                      valueBinding="<%= HMUIConstants.KEY_VALUE %>"/>
                        </uix:contents>
                      </uix:choice>
                      <uix:submitButton textBinding='<%=HMMsgID.ACTION_GO+"@HMMsg"%>'
                          name="event"
                          value="doLoad" />
                    </uix:rowLayout>
                  </uix:tableLayout>
                <uix:separator/>
                </uix:header>
                <uix:header textBinding='<%=HMMsgID.HEADER_RESULTS+"@HMMsg"%>'>
                  <oem:table name="<%= HMUIConstants.ATTR_CHECKER_CENTRAL_TABLE%>"
                          partialRenderMode="self"
                          summaryBinding='<%=HMMsgID.SUMMARY_CHECKER_RUN_TABLE+"@HMMsg"%>'
    		       dataSourceBinding="checkerCentralTable@pageView@servletRequest"
                          width="100%" blockSize="25"
                          formSubmitted="true"
                          rendered = "true"
                          alternateTextBinding='<%=HMMsgID.MSG_NO_ITEMS+"@HMMsg"%>'>
                    <uix:tableSelection>
                        <uix:singleSelection 
                          shortDesc="SELECT@SWBMsgs"
                          selectedIndex="0">
                         <uix:submitButton 
                              textBinding='<%= HMMsgID.ACTION_VIEW_REPORT+"@HMMsg"%>' 
                              name="event" 
                              value="<%=HMUIConstants.EVENT_VIEW_REPORT%>"/>
                        </uix:singleSelection>
                      </uix:tableSelection>
                    </oem:table>
                </uix:header>
              </uix:header>
            </uix:subTabLayout>
            <uix:dataScope currentDataBinding="results@pageView@servletRequest">
              <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                             valueBinding="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"/>
              <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                             valueBinding="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"/>
            </uix:dataScope>
            
          </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
