<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<jsp:useBean id="renderDataKey"
             scope="request"
             type="oracle.sysman.eml.page.cfm.ConfirmationPageRenderData"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:form name="confirmForm"
              method="POST">

      <uix:pageLayout>
<%--  global popups and bread crumbs  --%>
          <%@ include file="/database/global.jspf" %>
          <%--a hack to enable us to show error messages  --%>

              <uix:header messageType="confirmation" rendered='<%=renderDataKey.getPostQuestionText()==null|| renderDataKey.getPostQuestionText().equals("")%>'
                          textBinding="CONFIRMATION@sdkUIBundle"/>

              <uix:header messageType="error" rendered='<%=renderDataKey.getPostQuestionText()!=null&& !renderDataKey.getPostQuestionText().equals("")%>'
                          textBinding="ERROR@sdkUIBundle"/>

            <uix:stackLayout>
              <uix:rowLayout>
                <uix:spacer width="10"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="questionText@renderDataKey@servletRequest" />
              </uix:rowLayout>
              <uix:spacer height="5"/>
              <uix:switcher childNameBinding="postQuestionText@renderDataKey@servletRequest">
                <uix:case name="" >
                </uix:case>

                <uix:default>
                  <uix:rowLayout>
                    <uix:spacer width="10" />
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="postQuestionText@renderDataKey@servletRequest" />
                  </uix:rowLayout>
                </uix:default>
              </uix:switcher>
            </uix:stackLayout>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:switcher childNameBinding="pageTypeStr@renderDataKey@servletRequest">
               <uix:case name="YESNO">
                  <uix:submitButton textBinding="NO@sdkUIBundle"
                                    name="event"
                                    value="cfm_no"/>
                  <uix:submitButton textBinding="YES@sdkUIBundle"
                                    name="event"
                                    value="cfm_yes"/>
              </uix:case>
              <uix:case name="OKCANCEL">
                  <uix:submitButton textBinding="OK@sdkUIBundle"
                                    name="event"
                                    value="cfm_yes"/>
                  <uix:submitButton textBinding="CANCEL@sdkUIBundle"
                                    name="event"
                                    value="cfm_no"/>
              </uix:case>
              <uix:default>
                  <uix:submitButton textBinding="OK@sdkUIBundle"
                                    name="event"
                                    value="cfm_yes"/>
              </uix:default>
             </uix:switcher>

            </uix:pageButtonBar>
          </uix:contentFooter>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

