<%--
   Name:        em/swb/home.jsp
   Description: This jsp is the Support workbench home page.

   Controller:  oracle.sysman.dbTarget.swb.console.swbhome.ProblemsController

   Notes:

   Events:
       checkersTab  : switch to checkers tab
       packagesTab  : switch to packages tab
       search       : search for problems, change view
       createURP    : create user-reported problem
       packageProblems : package problems
       closeProblems : close poroblems

   MODIFIED     (MM/DD/YY)
     hopark      12/19/06 - remove summary
     balnaff     08/17/06 - adding HMMsg
     balnaff     08/16/06 - adding HMMsg
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%
String multiSelWarning = (String) request.getAttribute("multiSelWarning");
String noSelWarning = (String) request.getAttribute("noSelWarning");
%>

<script language="JavaScript">
function checkMultiSelection(tbl,ev)
{
    var proxy = new TableProxy(tbl);
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    if (rows.length > 1) {
        alert('<%= multiSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}

function checkSelection(tbl,ev)
{
    var proxy = new TableProxy(tbl);
    var rows = proxy.getSelectedRows();
    if (rows.length == 0) {
        alert('<%= noSelWarning %>');
        return;
    }
    document.foo.event.value = ev;
    document.foo.submit();
}


</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>
  <uix:bundle name="HMMsg" class="oracle.sysman.dbTarget.swb.console.hm.HMMsg"/>
  <uix:bundle name="DBMsg" class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="homeView@servletRequest">
    <uix:body>
       <uix:form name="foo"  method="POST" destinationBinding="myTarget">
       <uix:formValue name="pageName" value="/swb/homeProblems"/>
       <uix:formValue name="event" value="" />
        <uix:pageLayout titleBinding ="pageTitle">
<%--  global popups and bread crumbs  --%>
          <%@ include file="/database/global.jspf" %>

        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

        <uix:pageStatus>
<%-- refresh --%>
             <%@ include file = "/swb/refresh.jspf" %>
<%-- error --%>
        </uix:pageStatus>

              <uix:rowLayout>
                <uix:spacer height="10"/>
              </uix:rowLayout>

<%-- start Tab section --%>
              <uix:subTabLayout>
                <uix:subTabs>
                  <uix:subTabBar selectedIndexBinding="selectedTab">
                    <uix:link textBinding="problemsTabTitle"
                              destinationBinding="problemsTab" />
                <uix:switcher childNameBinding="showCheckers@servletRequest">
                    <uix:case name="true">
                      <uix:link textBinding="checkersTabTitle"
                                destinationBinding="checkersTab" />
                    </uix:case>
                </uix:switcher>
                    <uix:link textBinding="packagesTabTitle"
                              destinationBinding="packagesTab" />
                  </uix:subTabBar>
                </uix:subTabs>

                <uix:rowLayout>
                  <uix:spacer height="5"/>
                </uix:rowLayout>
                <uix:switcher childNameBinding="selectedTab">
                    <uix:case name="0">
                        <jsp:include page="/swb/homeProblems.jsp" />
                        <uix:ref refID="homeProblemsTabInclude"/>
                    </uix:case>

                    <uix:case name="1">
                        <jsp:include page="/swb/homeCheckers.jsp" />
                        <uix:ref refID="homeCheckersTabInclude"/>
                    </uix:case>
                    
                    <uix:case name="2">
                        <jsp:include page="/swb/homePackages.jsp" />
                        <uix:ref refID="homePackagesTabInclude"/>
                    </uix:case>
                </uix:switcher>
              </uix:subTabLayout>
<%-- end Tab section --%>

<%-- start related links section --%>
            <%@ include file="/swb/homeRelatedLinks.jspf" %>
<%-- end related links section --%>

        </uix:pageLayout>
         </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

