<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="homeProblemsTabInclude">

        <uix:rowLayout width="100%">
            <uix:tableLayout width="100%">
              <uix:contents>

<uix:dataScope currentDataBinding="summaryBean">
        <uix:rowLayout width="100%">
                <uix:tableLayout cellSpacing="5" width="100%">
                  <uix:rowLayout vAlign="top" width="100%">
                    <uix:contents>
            <%-- Summary left area --%>
                    <uix:cellFormat width="25%" hAlign="left">
                      <uix:rowLayout>
                        <uix:tableLayout>
                            <uix:contents childDataBinding="problemLSummary">
                                <%@ include file="/swb/summaryLayout.jspf" %>
                            </uix:contents>
                        </uix:tableLayout>
                        <uix:spacer width="40"/>
                      </uix:rowLayout>
                    </uix:cellFormat>
            <%-- Summary center area --%>
                    <uix:cellFormat width="25%" hAlign="left">
                      <uix:rowLayout>
                        <uix:spacer width="40"/>
                        <uix:tableLayout>
                            <uix:contents childDataBinding="problemCSummary">
                               <%@ include file="/swb/summaryLayout.jspf" %>
                            </uix:contents>
                        </uix:tableLayout>
                      </uix:rowLayout>
                    </uix:cellFormat>
            <%-- Summary right area --%>
                    <uix:cellFormat width="25%" hAlign="left">
                      <uix:rowLayout>
                        <uix:spacer width="40"/>
                        <uix:tableLayout>
                            <uix:contents childDataBinding="problemRSummary">
                               <%@ include file="/swb/summaryLayout.jspf" %>
                            </uix:contents>
                        </uix:tableLayout>
                      </uix:rowLayout>
                    </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
              </uix:tableLayout>
        </uix:rowLayout>
</uix:dataScope>
        <uix:separator/>

                <%-- problem table header --%>
        <uix:rowLayout width="100%">
                <uix:tableLayout width="100%">
                <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                        <uix:rowLayout>
                        <uix:styledText textBinding="TITLE_VIEW_CHOICE@SWBMsgs" 
                             styleClass="OraPromptText" labeledNodeId="view"/>
                        <uix:spacer width="10"/>
                        <uix:choice name="view" id="view" selectedValueBinding="currentTimeRange@servletRequest"
                                    onChange="submitForm('foo', true, {event:'search'})">
                            <uix:contents>
                                <uix:option textBinding="TIME_CHOICE_24H@SWBMsgs" value="24h"/>
                                <uix:option textBinding="TIME_CHOICE_2D@SWBMsgs" value="2d"/>
                                <uix:option textBinding="TIME_CHOICE_1WH@SWBMsgs" value="1w"/>
                                <uix:option textBinding="ACTIVE_CHOICE@SWBMsgs" value="active"/>
                                <uix:option textBinding="TIME_CHOICE_ALL@SWBMsgs" value="all"/>
                            </uix:contents>
                        </uix:choice>
                        </uix:rowLayout>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                        <uix:rowLayout>
                        <uix:styledText textBinding="TITLE_SEARCH@SWBMsgs" 
                              styleClass="OraPromptText"
                              labeledNodeId="searchtext"/>
                        <uix:spacer width="10"/>
                        <uix:textInput id="searchtext" name="searchtext"
                            text=""/>
                        <uix:spacer width="5"/>
                        <uix:button
                            textBinding="BTN_GO@SWBMsgs"
                            onClick="submitForm('foo', true, {event:'search'})" />
                        <uix:spacer width="10"/>
                        <uix:link textBinding="LINK_ADV_SEARCH@SWBMsgs"
                            destinationBinding="advSearchurl" />
                        </uix:rowLayout>
                        <uix:spacer height="10"/>
                    </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>
        </uix:rowLayout>

        <uix:rowLayout>
                <uix:dataScope currentDataBinding="tableBean">
                    <uix:dataScope currentDataBinding="problemTbl">
                    <uix:table name="problemTbl"
                            id="problemTbl"
                            showAll="yes"
                            minValue="1"
                            alternateTextBinding="PTBL_ALT_TEXT@SWBMsgs"
                            destinationBinding="destination"
                            summaryBinding="PTBL_SUMMARY@SWBMsgs"

                            maxValueBinding="maxValue"
                            blockSizeBinding="blockSize"
                            valueBinding="value"

                            tableDataBinding="tableData"
                            columnHeaderDataBinding="columnHeaderData"
                            columnFormatsBinding="columnFormatsData"
                            detailDisclosureBinding="problemTbl_details@servletRequest"
                            allDetailsEnabled="true"
                            formSubmitted="true"
                            width="100%">
                            <uix:tableSelection>
                              <uix:multipleSelection shortDescBinding="SELECT@SWBMsgs"
                                                    disabledBinding="disabled">
                               <uix:contents>
                                 <uix:button textBinding="PTBL_BTN_VIEW_PROBLEM@SWBMsgs"
                                    destination="javascript:checkMultiSelection('problemTbl','view')" />
                                 <uix:button textBinding="PTBL_BTN_PACKAGE_PROBLEMS@SWBMsgs"
                                    destination="javascript:checkSelection('problemTbl','packageProblems')" />
                              </uix:contents>
                              </uix:multipleSelection>
                            </uix:tableSelection>

                            <uix:detail>
                                <uix:flowLayout>
                                  <uix:header textBinding="IncHeader">
                                  <uix:contents childDataBinding="detail">
                                    <uix:tableLayout width = "100%">
                                        <uix:rowLayout>
                                            <uix:cellFormat hAlign="center" width="10%">
                                                <uix:link textBinding="ID"
                                                          longDescBinding="IDLinkDesc"
                                                          destinationBinding="IDLinkUrl" />
                                            </uix:cellFormat>
                                            <uix:cellFormat hAlign="left" width="60%" wrappingDisabled="true" >
                                                <uix:styledText styleClass="OraInstructionText" textBinding="Desc" />
                                            </uix:cellFormat>
                                            <uix:cellFormat hAlign="right" width="30%">
                                                <uix:styledText styleClass="OraInstructionText" textBinding="Created" />
                                            </uix:cellFormat>
                                        </uix:rowLayout>
                                    </uix:tableLayout>
                                  </uix:contents>
                                  </uix:header>
                                </uix:flowLayout>
                            </uix:detail>
                            <uix:column renderedBinding="InstanceRendered">
                             <uix:columnHeader>
                              <uix:sortableHeader textBinding="text"
                                                  valueBinding="value"
                                                  sortableBinding="sortable"/>
                             </uix:columnHeader>
                              <uix:styledText textBinding="Instance" />
                            </uix:column>
                            <uix:column renderedBinding="IDRendered">
                             <uix:columnHeader>
                              <uix:sortableHeader textBinding="text"
                                                  valueBinding="value"
                                                  sortableBinding="sortable"/>
                             </uix:columnHeader>
                              <uix:link textBinding="ID" destinationBinding="ProblemLink" />
                            </uix:column>
                            <uix:column renderedBinding="DescRendered">
                             <uix:columnHeader>
                              <uix:sortableHeader textBinding="text"
                                                  valueBinding="value"
                                                  sortableBinding="sortable"/>
                             </uix:columnHeader>
                              <uix:styledText textBinding="Desc" />
                            </uix:column>
                            <uix:column renderedBinding="IncidentCountRendered">
                             <uix:columnHeader>
                              <uix:sortableHeader textBinding="text"
                                                  valueBinding="value"
                                                  sortableBinding="sortable"/>
                             </uix:columnHeader>
                              <uix:styledText textBinding="IncidentCount" />
                            </uix:column>
                            <uix:column renderedBinding="TimeRendered">
                             <uix:columnHeader>
                              <uix:sortableHeader textBinding="text"
                                                  valueBinding="value"
                                                  sortableBinding="sortable"/>
                             </uix:columnHeader>
                              <uix:styledText textBinding="Time" />
                            </uix:column>
                            <uix:column renderedBinding="LastCommentRendered">
                             <uix:columnHeader>
                              <uix:sortableHeader textBinding="text"
                                                  valueBinding="value"
                                                  sortableBinding="sortable"/>
                             </uix:columnHeader>
                              <uix:styledText textBinding="LastComment" />
                            </uix:column>
                            <uix:column renderedBinding="ActiveRendered">
                             <uix:columnHeader>
                              <uix:sortableHeader textBinding="text"
                                                  valueBinding="value"
                                                  sortableBinding="sortable"/>
                             </uix:columnHeader>
                              <uix:styledText textBinding="Active"/>
                            </uix:column>
                            <uix:column renderedBinding="PkgsRendered">
                             <uix:columnHeader>
                              <uix:sortableHeader textBinding="text"
                                                  valueBinding="value"
                                                  sortableBinding="sortable"/>
                             </uix:columnHeader>
                              <uix:link textBinding="Pkgs" destinationBinding="PkgLink" />
                            </uix:column>
                            <uix:column renderedBinding="SRRendered">
                             <uix:columnHeader>
                              <uix:sortableHeader textBinding="text"
                                                  valueBinding="value"
                                                  sortableBinding="sortable"/>
                             </uix:columnHeader>
                              <uix:styledText textBinding="SR" />
                            </uix:column>
                         </uix:table>
                        </uix:dataScope>
                    </uix:dataScope>
           </uix:rowLayout>
<%-- start performance chart --%>
                <uix:switcher childNameBinding="showChartSection@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                          <uix:spacer height="5"/>
                      </uix:rowLayout>
                      <uix:rowLayout width = "100%">
                         <%@ include file="/swb/pvsceChart.jspf" %>
                      </uix:rowLayout>
                    </uix:case>
               </uix:switcher>
<%-- end performance chart --%>

              </uix:contents>
            </uix:tableLayout>
        </uix:rowLayout>

</uix:buildTree>
