<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

        <uix:header textBinding="header@servletRequest" messageType="info">
         <uix:rowLayout>
           <uix:spacer width="15"/>
           <uix:styledText styleClass="OraInstructionTextStrong"
                           textBinding="legendInfo@servletRequest"/>
         </uix:rowLayout>

           <uix:tableLayout  cellSpacing="5">
             <uix:rowLayout vAlign="top">
               <uix:cellFormat hAlign="left">

                 <uix:header textBinding="status@servletRequest">
                  <uix:tableLayout cellSpacing="8">

                   <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="availUpImage@servletRequest"
                                shortDescBinding="availUpDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="availUpDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="availDownImage@servletRequest"
                                shortDescBinding="availDownDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="availDownDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="availBlackoutImage@servletRequest"
                                shortDescBinding="availBlackoutDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="availBlackoutDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="availAgentDownImage@servletRequest"
                                shortDescBinding="availAgentDownDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="availAgentDownDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="availAgentUnreachImage@servletRequest"
                                shortDescBinding="availAgentUnreachDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="availAgentUnreachDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="availUnknownImage@servletRequest"
                                shortDescBinding="availUnknownDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="availUnknownDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="availMetErrorImage@servletRequest"
                                shortDescBinding="availMetErrorDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="availMetErrorDesc@servletRequest"/>
                   </uix:rowLayout>

                  <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="metricCollectionErrImage@servletRequest"
                                shortDescBinding="metricCollectionErrDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="metricCollectionErrDesc@servletRequest"/>
                   </uix:rowLayout>


                  </uix:tableLayout>
                 </uix:header>

                 <spacer width="10"/>


                 <uix:header textBinding="alerts@servletRequest">
                  <uix:tableLayout cellSpacing="8">

                   <uix:rowLayout>
                     <uix:image sourceBinding="alertOkImage@servletRequest"
                                shortDescBinding="alertOkDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="alertOkDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout>
                     <uix:image sourceBinding="alertInformationalImage@servletRequest"
                                shortDescBinding="alertInformationalDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="alertInformationalDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout>
                     <uix:image sourceBinding="alertWarningImage@servletRequest"
                                shortDescBinding="alertWarningDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="alertWarningDesc@servletRequest"/>
                   </uix:rowLayout>
                   
                   <uix:rowLayout>
                     <uix:image sourceBinding="alertCriticalImage@servletRequest"
                                shortDescBinding="alertCriticalDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="alertCriticalDesc@servletRequest"/>
                   </uix:rowLayout>

                  </uix:tableLayout>
                 </uix:header>

                 <spacer width="10"/>

                 <uix:header textBinding="comparision@servletRequest">
                  <uix:tableLayout cellSpacing="8">

                   <uix:rowLayout>
                     <uix:image sourceBinding="compSameImage@servletRequest"
                                shortDescBinding="compSameDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="compSameDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout>
                     <uix:image  sourceBinding="compDiffImage@servletRequest"
                                shortDescBinding="compDiffDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="compDiffDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout>
                     <uix:image sourceBinding="compLeftImage@servletRequest"
                                shortDescBinding="compLeftDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="compLeftDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout>
                     <uix:image sourceBinding="compRightImage@servletRequest"
                                shortDescBinding="compRightDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="compRightDesc@servletRequest"/>
                   </uix:rowLayout>

                  </uix:tableLayout>
                 </uix:header>

               </uix:cellFormat>
             </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right">

                 <uix:header textBinding="others@servletRequest">
                  <uix:tableLayout   cellSpacing="8">

                   <uix:rowLayout>
                     <uix:styledText styleClass="OraHeaderSub"
                                   text="*"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="requiredDesc@servletRequest"/>
                   </uix:rowLayout>

                   <uix:rowLayout>
                     <uix:image sourceBinding="trueImage@servletRequest"
                                shortDescBinding="trueDesc@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="trueDesc@servletRequest"/>
                   </uix:rowLayout>
                  </uix:tableLayout>
                 </uix:header>

               </uix:cellFormat>
             </uix:rowLayout>


           </uix:tableLayout>

        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

