<%--
   Name:        em/swb/ipsConfig.jsp

   Description: This jsp is for the Support workbench/ IPS configuration

   Controller:  oracle.sysman.dbTarget.swb.console.swbhome.IPSConfigController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     jro         05/14/07 - fix for bug 5979273
     balnaff     12/21/06 - 
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="ipsConfigView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST"
            destinationBinding="myTarget">

         <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>

        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- page actions  --%>
            <uix:pageButtons>
              <uix:pageButtonBar>

                <uix:button renderedBinding="editIpsConfig"
                    textBinding="IPSCONFIG_BTN_RESET@SWBMsgs"
                    onClick="submitForm('foo', true, {event:'reset'})" />
                <uix:button renderedBinding="editIpsConfig"
                    textBinding="CANCEL@SDKMsgs"
                    destinationBinding="configReturnUrl" />
                <uix:button renderedBinding="viewIpsConfig"
                    textBinding="EDIT@SDKMsgs"
                    destinationBinding="editUrl" />
                <uix:button renderedBinding="editIpsConfig"
                    textBinding="OK@SDKMsgs" 
                    onClick="submitForm('foo', true, {event:'edit'})"/>
                <uix:button renderedBinding="viewIpsConfig"
                    textBinding="OK@SDKMsgs" 
                    destinationBinding="configReturnUrl"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

              <uix:rowLayout>
                  <uix:spacer height="10"/>
              </uix:rowLayout>

<%-- start retention settings --%>
                <uix:header textBinding="IPSCONFIG_RET_HEADER@SWBMsgs">
                <uix:rowLayout vAlign="top">
                  <uix:tableLayout>
                    <uix:contents childDataBinding="retentionSettings">
                        <%@ include file="/swb/summaryLayout.jspf" %>
                    </uix:contents>
                  </uix:tableLayout>
            </uix:rowLayout>
            </uix:header>
            <uix:rowLayout>
                <uix:spacer height="3"/>
            </uix:rowLayout>
<%-- end retention settings table section --%>

<%-- start packaging settings --%>
            <uix:header textBinding="IPSCONFIG_IPS_HEADER@SWBMsgs">
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="IPSCONFIG_IPS_INST@SWBMsgs" />
                    <uix:rowLayout>
                        <uix:spacer height="5"/>
                    </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                  <uix:rowLayout>
                  </uix:rowLayout>
                    <uix:rowLayout>
                        <uix:spacer height="5"/>
                    </uix:rowLayout>
                    <uix:tableLayout>
                    <uix:contents childDataBinding="ipsSettings">
                        <%@ include file="/swb/summaryLayout.jspf" %>
                    </uix:contents>
                  </uix:tableLayout>
              </uix:rowLayout>
            </uix:header>
<%-- end packaging settings --%>

            </uix:pageLayout>
         </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

