<%--
   Name:        em/swb/jobChgSchedule.jsp

   Description: This jsp is for the Support workbench/ Diag job detail

   Controller:  oracle.sysman.dbTarget.swb.console.swbhome.DiagJobScheduleController

   Notes:

   Events:

   MODIFIED     (MM/DD/YY)
     balnaff     12/13/07 - Backport balnaff_bug-6634265_main from main
     hopark      05/03/06 - Created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="SDKMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="SWBMsgs" class="oracle.sysman.dbTarget.swb.console.SwbMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:dataScope currentDataBinding="diagJobDetailView@servletRequest">
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle"/>
    </uix:metaContainer>
      <uix:body>
       <uix:form name="foo"  method="POST"
            destinationBinding="myTarget">

         <uix:pageLayout titleBinding ="pageTitle">
          <%@ include file="/database/global.jspf" %>

        <uix:messages>
             <%@ include file = "/swb/errors.jspf" %>
        </uix:messages>

<%-- page actions  --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button
                    textBinding="CANCEL@SDKMsgs"
                    destinationBinding="returnUrl" />
                <uix:button
                    textBinding="OK@SDKMsgs"
                    onClick="submitForm('foo', true, {event:'ok'})" />
              </uix:pageButtonBar>
            </uix:pageButtons>
<%-- start context information --%>
            <uix:labeledFieldLayout width="100%" labelWidth="15%">
               <uix:contents childDataBinding="settings">
                <uix:messageStyledText promptBinding="name"
                    textBinding="val"
                    messageType="none" styleClass="OraDataText" message="" vAlign="baseline"/>
               </uix:contents>
            </uix:labeledFieldLayout>
            <uix:separator/>
<%-- end context information --%>
              <uix:rowLayout>
                  <uix:spacer height="20"/>
              </uix:rowLayout>

<%-- start schedule --%>
            <uix:stackLayout>
              <uix:dataScope currentDataBinding="scheduleBean">
                <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                        <%-- START DATE --%>
                        <uix:cellFormat  hAlign="right">
                            <uix:messagePrompt
                                 labeledNodeId="startDateSB"
                                 promptBinding="DATE@SDKMsgs"
                            />
                        </uix:cellFormat>
                        <uix:messageDateField
                             id="startDateSB"
                             name="startDateSB"
                             valueBinding="startDateSB"
                             tipBinding="DATE_INPUT_TIP@SDKMsgs"
                             shortDescBinding="START_DATE@SDKMsgs"
                             columns="24">
                            <uix:onSubmitValidater>
                            <uix:date dateStyle="long" pattern="MM-dd-yyyy"/>
                            </uix:onSubmitValidater>
                        </uix:messageDateField>
                    </uix:rowLayout>

                    <uix:rowLayout hAlign="right">
                        <%-- START HOUR --%>
                            <uix:messagePrompt
                                 promptBinding="TIME@SDKMsgs"
                            />
                        <uix:rowLayout hAlign="left">
                            <oem:choice
                                 name="startHourSB"
                                 id="startTimeID"
                                 optionsBinding="hoursSB"
                                 shortDescBinding="HOURS@SDKMsgs"
                                 selectedValueBinding="startHourSB"
                            />

                            <uix:spacer width="5"
                            />

                            <%-- START MINUTE --%>
                            <oem:choice
                                 name="startMinuteSB"
                                 id="startTimeIDMIN"
                                 shortDescBinding="MINUTES@SDKMsgs"
                                 optionsBinding="minutesSB"
                                 selectedValueBinding="startMinuteSB"
                            />

                            <uix:spacer width="5"
                            />

                            <%-- START AM/PM --%>
                            <oem:radioButton
                                 name="startAmPmSB"
                                 value="AM_VALUE"
                                 selectedValueBinding="startAmPmSB"
                                 textBinding="AM_LABEL@SDKMsgs"
                                 shortDescBinding="AM_LABEL@SDKMsgs"
                                 styleClass="OraInstructionText"
                            />
                            <oem:radioButton
                                 name="startAmPmSB"
                                 value="PM_VALUE"
                                 selectedValueBinding="startAmPmSB"
                                 textBinding="PM_LABEL@SDKMsgs"
                                 shortDescBinding="PM_LABEL@SDKMsgs"
                                 styleClass="OraInstructionText"
                            />
                        </uix:rowLayout>
                    </uix:rowLayout>

                </uix:tableLayout>
              </uix:dataScope>
            </uix:stackLayout>
<%-- end schedule section --%>

            </uix:pageLayout>
         </uix:form>
      </uix:body>
    </uix:dataScope>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>

